//
//
// C++ Interface: Tags
//
// Description:
//
//
// Author: Cyril Bosselut <bosselut@b1project.com>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef TAGS_H
#define TAGS_H
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <taglib/id3v2tag.h>
#include <taglib/mpegfile.h>
#include <taglib/vorbisfile.h>
#include <taglib/flacfile.h>
#include <taglib/oggflacfile.h>
#include <taglib/attachedpictureframe.h>

#include <stdlib.h>
#include <stdio.h>

#include <qurl.h>
#include <qfile.h>
#include <qimage.h>
#include <qvariant.h>
#include <qbuffer.h>
#include <qthread.h>

#include <kstandarddirs.h>
#include <kio/netaccess.h>
#include <kio/jobclasses.h>
#include "kio/job.h"
#include <kmimemagic.h>
#include <kfilemetainfo.h>
#include <kdebug.h>
#include <kfileitem.h>

/**
* @author Cyril Bosselut <bosselut@b1project.com>
* @version 0.5
*/
namespace TagLib { class AttachedPictureFrame; }

class Cover{
public:
	Cover();
	~Cover();

	void setUrl(const KURL&);
	KURL getUrl();
	void setPixmap(QPixmap*);
	void setSize(const int);
	QPixmap* getPixmap();
	int getWidth();
	int getHeight();
	int getSize();
	void empty(void);

private:
	QPixmap* pixmap;
	KURL url;
	int width;
	int height;
	int size;
};

class Tags:public QObject
{
    Q_OBJECT

public slots:
	void slotCleanMime(KIO::Job *);

public:
	Tags( const QString & fn );
	Tags(  );

	~Tags();

	void setInfos(const int tr, const QString & ar, const QString & ti, const QString & al, const QString & ge, const int ye, const QString & ct, const QString & co = NULL);
	void setAlbum(const QString& al);
	void setArtist(const QString& ar);
	void ReadId3();
	void WriteId3();
	void ClearId3();
	void ReadVorbis();
	void WriteVorbis();
	void ClearVorbis();
	void ReadOggFlac();
	void WriteOggFlac();
	void ClearOggFlac();
	void ReadFlac();
	void WriteFlac();
	void ClearFlac();
	void correctMimeType();
	/**
	* audio file
	*/
	QString file;
	/**
	* mimetype of audio file
	*/
	QString getMimeType();
	/**
	* Return true if file is an mp3
	*/
	bool isMP3();
	/**
	* Return true if file is an ogg
	*/
	bool isOGG();
	/**
	* Return true if file is an oggflac
	*/
	bool isOGGFlac();
	/**
	* Return true if file is a flac
	*/
	bool isFLAC();
	/**
	* Temporary cover file
	*/
	QString fp;
	/**
	* artist + title + album or xmms output title
	*/
	QString title;
	/**
	* artist
	*/
	QString artist;
	/**
	* album
	*/
	QString album;
	/**
	* song title
	*/
	QString stitle;
	/**
	* track number
	*/
	uint track;
	/**
	* year
	*/
	uint year;
	/**
	* genre
	*/
	QString genre;
	/**
	* comments
	*/
	QString comment;
	/**
	* last position in playlist
	*/
	int current;
	/**
	* bitrate in bps
	*/
	int rate;
	/**
	* frequency in hz
	*/
	double freq;
	/**
	* number of channel (1 = mono, 2 = stereo)
	*/
	int channel;
	/**
	* album cover
	*/
	QImage cover;
	/**
	* location of new cover
	*/
	QString ncover;
	/**
	* true if id3 contains cover
	*/
	bool haveCover;
	/**
	* parse a string and replace keywords by song infos
	*/
	QString parsePattern(const QString& pattern);
	/**
	* Case upper the first letter of each words
	*/
	QString upFirst(const QString & str);
	static const int NB_GENRES;

private:
	QString mime;

};

/*static QString id3_genres[] =
{
    "Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal",
    "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial",
    "Alternative", "Ska", "Death Metal", "Pranks", "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk",
    "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise",
    "Altern Rock", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic",
    "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta",
    "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes",
    "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock",
    "Folk", "Folk/Rock", "National Folk", "Fast Fusion", "Swing", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass",
    "Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock",
    "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic",
    "Humour", "Speech", "Chanson", "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Bass", "Primus", "Porn Groove",
    "Satire", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle",
    "Duet", "Punk Rock", "Drum Solo", "A Capella", "Euro-House", "Dance Hall", "Goa", "Drum & Bass", "Club-House", "Hardcore",
    "Terror", "Indie", "BritPop", "Negerpunk", "Polsk Punk", "Beat", "Christian Gangsta Rap", "Heavy Metal", "Black Metal",
    "Crossover", "Contemporary Christian", "Christian Rock", "Merengue", "Salsa", "Thrash Metal", "Anime", "JPop", "Synthpop"
};*/
#endif
