/***************************************************************************
 *   Copyright (C) 2004 by Cyril Bosselut                                  *
 *   bosselut@b1project.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kdebug.h>
#include <dcopref.h>
#include <dcopclient.h>

#include "ktagmainwin.h"

/**
* @author Cyril Bosselut <bosselut@b1project.com>
* @version 0.5
*/

static const char description[] =
    I18N_NOOP("A KDE audio tag editor\nKtag aims to be the simpliest and quickest tool for editing MP3, OGG and FLAC meta tags.");

static const char version[] = "0.5";

static KCmdLineOptions options[] =
{
    { "s", 0, 0 },{ "setup", I18N_NOOP("Configure Ktag."), 0 }, { "+[URL]", I18N_NOOP( "Document to open." ), 0 }, KCmdLineLastOption
};

int main(int argc, char **argv)
{
    KAboutData about("ktag", I18N_NOOP("Ktag - The KDE meta tag editor"), version, description, KAboutData::License_GPL, "(C) 2004 Cyril Bosselut", 0, 0, "bosselut@b1project.com");
    about.addAuthor( "Cyril Bosselut", 0, "bosselut@b1project.com" );
    about.addCredit( "Marco Meijer", I18N_NOOP("Icon and suggestions"), "mcmeijer@zonnet.nl" );
    about.addCredit( "Scott Wheeler", I18N_NOOP("For the TagLib and his help\nhttp://developer.kde.org/~wheeler/taglib.html"), "wheeler@kde.org" );
    about.setTranslator(I18N_NOOP("INSERT YOUR NAME HERE"),I18N_NOOP("INSERT YOUR EMAIL ADDRESS"));
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );
    KUniqueApplication::addCmdLineOptions();
    // test if Ktag already running and use DCOP to open new file
    if (!KUniqueApplication::start()) {
	kdDebug("Main")<< "ktag is already running!" << endl;
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    	DCOPClient *client= new DCOPClient();
	if (!client->isAttached()){
		client->attach();
	}
	if(args->count() > 0){
		for (int i = 0; i < (args->count()); i++){
			DCOPRef m_ktagKTag("ktag","KTag");
			m_ktagKTag.call("openFile(KURL)", KURL(args->arg(i)));
		}

	}
    }
    else{
	KUniqueApplication app;
	KTagMainWin *mainWin;

		KCmdLineArgs *args = KCmdLineArgs::parsedArgs();


		mainWin = new KTagMainWin(0, "KTagMainWin");
		app.setMainWidget( mainWin );
		if(args->isSet("setup")){
			mainWin->config();
			exit(0);
		}
		if(args->count() > 0){
			for (int i = 0; i < (args->count()); i++){
				mainWin->openFile(KURL(args->arg(i)));
			}
		}
		else{
			if( !mainWin->chooseFile()){
				exit(0);
			}
		}
		mainWin->show();

		args->clear();

	// mainWin has WDestructiveClose flag by default, so it will delete itself.
	return app.exec();
    }
}

