/* ***************************************************************************   
   * KVideoEncoder - an easy-to-use Video Encoder for KDE                    *
   * Copyright (C) 2005-2006 Philipp Ludwig                                  *
   *                                                                         *
   * This program is free software; you can redistribute it and/or modify it *
   * under the terms of the GNU General Public License as published by the   *
   * Free Software Foundation; either version 2 of the License, or (at your  *
   * option) any later version.                                              *
   *                                                                         *
   * This program is distributed in the hope that it will be useful, but     *
   * WITHOUT ANY WARRANTY; without even the implied warranty of              *
   * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        *
   * General Public License for more details.                                *
   *                                                                         *
   * You should have received a copy of the GNU General Public License along *
   * with this program; if not, write to the Free Software Foundation, Inc., *
   * 59 Temple Place, Suite 330, Boston, MA 02111-1301, USA.                 *
   *************************************************************************** */

#ifndef _ENCODER_H_
#define _ENCODER_H_

#include <qstring.h>
#include <videofilter_struct.h>
#include <audiocodec_struct.h>
#include <videocodec_struct.h>

class Encoder
{
protected:
	QString cmd;
	QString pid;
	
	
public:
	FILE* handle;
	QString inputFile;
	QString outputFile;
	ushort inputType; // 0=file, 1=VCD, 2=DVD
	QString device;
	QString aid, firstCpt, lastCpt, sid;
	uint track;
	int previewStart, previewEnd;
	int errortype;
	
	VideoCodec selectedVideoCodec;
	AudioCodec selectedAudioCodec;
	
	// Filter
	VideoFilter *videoFilter;
	
	void BuildCommandLine( void );
	bool RunEncoder( void );
	int  GetProgress( void );
	int  GetFinalSize( void );
	void KillEncoder( void );
	FILE* getHandle( void ){ return handle; }
};

class Mencoder : public Encoder
{	
public:
	void BuildCommandLine( void );
	bool RunEncoder( void );
	int  GetProgress( void );
	int  GetFinalSize( void );
	void KillEncoder( void );
};

class Transcode : public Encoder
{	
protected:
	QString getWorkingMod( QString modpath, QString prefix, QString modules[]);
	
public:
	void BuildCommandLine( void );
	bool RunEncoder( void );
	int  GetProgress( void );
	int  GetFinalSize( void );
	void KillEncoder( void );
};

#endif
