/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

#include <qapplication.h>
#include <qfiledialog.h>
#include <kmessagebox.h>

#include "kvideoencoder_config.h"

QApplication *pApp_join;

void ExtractWnd::getApp( QApplication *a )
{
	pApp_join = a;
}


void ExtractWnd::pushButton5_clicked()
{	
	config *Config = new config();
	QString aFile = audioFile->url();
	QString iFile = inputFile->url();
	QString vFile = videoFile->url();
	
	if( iFile == "" )
	{
		KMessageBox::error( this, tr("Please select an input file!"), "KVideoEncoder" );
		return;
	}
	
	if( extractAudio->isChecked() )
	{
		if( aFile == "" ) 
		{
			KMessageBox::error( this, tr("Please select an audio output file!"), "KVideoEncoder" );
			return;
		}
		
		QString cmdline = Config->getMplayer() + " -dumpaudio -dumpfile '" + aFile + "' '" + iFile + "'";
		char buffer[10];
		FILE *read_fp = popen( cmdline.ascii(), "r" );

		this->setCursor( Qt::WaitCursor );
		while( fread( buffer, sizeof(char), 9, read_fp ) > 0 ) pApp_join->processEvents();
		this->setCursor( Qt::ArrowCursor );
				
		KMessageBox::information( this, tr("Finished!"), "KVideoEncoder" );
	}
	
	if( extractVideo->isChecked() )
	{
		if( vFile == "" )
		{
			KMessageBox::error( this, tr("Please select an video output file!"), "KVideoEncoder" );
			return;
		}
		
		QString cmdline = Config->getMplayer() + " -dumpvideo -dumpfile '" + vFile + "' '" + iFile + "'";
		char buffer[10];
		FILE *read_fp = popen( cmdline.ascii(), "r" );
		
		this->setCursor( Qt::WaitCursor );
		while( fread( buffer, sizeof(char), 9, read_fp ) > 0 ) pApp_join->processEvents();
		this->setCursor( Qt::ArrowCursor );
				
		KMessageBox::information( this, tr("Finished!"), "KVideoEncoder" );
	}
	delete Config;
}
