/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

#include <qapplication.h>
#include <kfiledialog.h>
#include <kmessagebox.h>

#include "kvideoencoder_config.h"

QApplication *pApp;
QString filter;

void JoinVideosWnd::getApp( QApplication *a )
{
	pApp = a;
}

void JoinVideosWnd::getFilter( QString fi )
{
	filter = fi;
}

void JoinVideosWnd::pushButton8_clicked()
{
	QString fn = KFileDialog::getOpenFileName( QString::null, filter, this, tr( "Add video file" ) );
	
	if( fn != "" ) videoList->insertItem( fn );
}


void JoinVideosWnd::pushButton10_clicked()
{
	char* buffer = (char*)malloc(120);
	QString cmdline = "cat ", outputFile = OutputEdit->url();
	config *Config = new config();
	
	for( int i=0; i<videoList->count(); i++ ) cmdline = cmdline + "'" + videoList->text(i) + "' ";
	cmdline += " | " + Config->getMencoder() + " -ovc copy -oac copy -forceidx";
	
	if( (outputFile.right(4) == "mpeg") || (outputFile.right(3) == "mpg") ) cmdline += " -of mpeg";
	
	cmdline += " -o '" + outputFile + "' -";
	
	// Calcuate size of the output file
	uint size = 0;
	for( uint i=0; i<videoList->count(); i++ ) 
	{
		QFileInfo *info = new QFileInfo( videoList->text(i) );
		size += info->size() / 1024;
		delete info;		
	}	
	progressBar->setTotalSteps(size);
	
	// Start joining	
	FILE *read_fp = popen( cmdline.ascii(), "r" );
	int n = 0;
	while( fgets( buffer, 120, read_fp ) != NULL )
	{
		n++;
		if( n == 100 )
		{
			n = 0;
			QFileInfo *info = new QFileInfo( outputFile );
			progressBar->setProgress(info->size() / 1024);
			delete info;
			pApp->processEvents();
		}
	}
	
	delete Config;
	progressBar->setProgress( 100 );
	KMessageBox::information( this, tr("Finished!"), "KVideoEncoder" );
}


