/* ***************************************************************************
   * KVideoEncoder - an easy-to-use Video Encoder for KDE                    *
   * Copyright (C) 2005-2006 Philipp Ludwig                                  *
   *                                                                         *
   * This program is free software; you can redistribute it and/or modify it *
   * under the terms of the GNU General Public License as published by the   *
   * Free Software Foundation; either version 2 of the License, or (at your  *
   * option) any later version.                                              *
   *                                                                         *
   * This program is distributed in the hope that it will be useful, but     *
   * WITHOUT ANY WARRANTY; without even the implied warranty of              *
   * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        *
   * General Public License for more details.                                *
   *                                                                         *
   * You should have received a copy of the GNU General Public License along *
   * with this program; if not, write to the Free Software Foundation, Inc., *
   * 59 Temple Place, Suite 330, Boston, MA 02111-1301, USA.                 *
   *************************************************************************** */

#include <qdir.h>
#include <qfile.h>
#include "kvideoencoder_config.h"

#include <qmessagebox.h>

config::config( void )
{
	userConfig   = new QSettings();
	userConfig->setPath( "kvideoencoder.sourceforge.net", "KVideoEncoder", QSettings::User );
	makeDefaultConfig();
	readSystemConfig();
}

config::~config( void )
{
	delete userConfig;
}

void config::makeDefaultConfig()
{	
	prefix   = "/usr";	
}

void config::readSystemConfig( void )
{
	QString newPrefix;
	QFile *cfg = new QFile( "/etc/kvideoencoder" );
	if( cfg->open( IO_Raw | IO_ReadOnly ) )
		if( cfg->readLine( newPrefix, 255 ) != -1 ) prefix = newPrefix.stripWhiteSpace();
	
	cfg->close();
	delete cfg;
}

QString config::getCommand( QString cmd )
{
	FILE* read_fp = popen( cmd.ascii(), "r" );
		
	// If read_fp was null, something went terribly wrong
	if( read_fp == NULL ) return "";
		
	char buffer[255];
	fread( buffer, sizeof(char), 255, read_fp );
	fclose( read_fp );
	
	QString ret = QString( (char*)&buffer );	
	int n;
	if( (n = ret.find( '\n', 0, FALSE )) > -1 ) ret = ret.left( n );
	return ret;
}

// ********************************************************
// Language
QString config::getLanguage( void )
{
	return userConfig->readEntry( "/kvideoencoder/gui/language", "kvideoencoder_en.qm" );
}
bool config::setLanguage( QString language )
{
	return userConfig->writeEntry( "/kvideoencoder/gui/language", language );
}

// ********************************************************
// Applications
QString config::getMplayer( void )
{
	return userConfig->readEntry( "/kvideoencoder/programs/mplayer", getCommand( "which mplayer" ) );
}
bool config::setMplayer( QString mplayer )
{
	return userConfig->writeEntry( "/kvideoencoder/programs/mplayer", mplayer );
}

QString config::getMencoder( void )
{
	return userConfig->readEntry( "/kvideoencoder/programs/mencoder", getCommand( "which mencoder" ) );
}
bool config::setMencoder( QString mencoder )
{
	return userConfig->writeEntry( "/kvideoencoder/programs/mencoder", mencoder );
}

QString config::getLsdvd( void )
{
	return userConfig->readEntry( "/kvideoencoder/programs/lsdvd", getCommand( "which lsdvd" ) );
}
bool config::setLsdvd( QString lsdvd )
{
	return userConfig->writeEntry( "/kvideoencoder/programs/lsdvd", lsdvd );
}

int config::getEncoderIndex( void )
{
	return userConfig->readNumEntry( "/kvideoencoder/programs/encoderindex", 0 );
}
bool config::setEncoderIndex( int n )
{
	return userConfig->writeEntry( "/kvideoencoder/programs/encoderindex", n );
}

// ********************************************************
// Devices
void config::findDevices( void )
{
	setDevicesCount(0);
	
	// Scan for CD/DVD devices in /proc/ide/ide?/hd?/model
	int devicesCount = 0;
	QString* devices[4096]; // The user must not have more than 4096 devices
	QString* names[4069];
	QDir *dir = new QDir( "/proc/ide" );
	if( !dir->exists() ) 
	{
		// No IDE devices
		return;
	}
	QFileInfoList *list = (QFileInfoList*)dir->entryInfoList();
	QFileInfoListIterator it( *list );
	QFileInfo *fi;
	
	while( (fi = it.current()) != 0 )
	{
		QString fName = fi->fileName();
		if( fName.left(3) == "ide" )
		{
			QDir *ideDir = new QDir( "/proc/ide/" + fName );
			QFileInfoList *list2 = (QFileInfoList*)ideDir->entryInfoList();
			QFileInfoListIterator it2( *list2 );
			QFileInfo *fi2;
			
			while( (fi2 = it2.current()) != 0 )
			{
				fName = fi2->fileName();				
				if( fName.left(2) == "hd" )
				{
					QFile temp( "/proc/ide/" + fi->fileName() + "/" + fName + "/media" );
					temp.open( IO_ReadOnly );
					QTextStream stream( &temp );
					QString line = stream.readLine();
					
					if( line == "cdrom" )
					{
						devices[devicesCount] = new QString( QString("/dev/" + fName) );						
						QFile temp2( "/proc/ide/" + fi->fileName() + "/" + fName + "/model" );
						temp2.open( IO_ReadOnly );
						QTextStream stream2( &temp2 );
						QString device = stream2.readLine();
						names[devicesCount] = new QString(device);
						temp2.close();						
						devicesCount++;
					}
					
					temp.close();				
				}				
				++it2;
			}
		}		
		++it;
	}
	
	delete list;
	
	// Now write the stuff to the config file
	setDevicesCount( devicesCount );
	for( int i=0; i<devicesCount; i++ )
	{			
		setDeviceName( i, QString( (char *)names[i]->latin1() ) );
		setDeviceAddress( i, QString( (char*)devices[i]->latin1() ) );
	}	
}
	
int config::getDevicesCount( void )
{
	return userConfig->readNumEntry( "/kvideoencoder/system/devices/devicecount", 0 );
}
bool config::setDevicesCount( int n )
{
	return userConfig->writeEntry( "/kvideoencoder/system/devices/devicecount", n );
}
	
QString config::getDeviceName( int n )
{
	return userConfig->readEntry( "/kvideoencoder/system/devices/" + QString::number(n) + "/name", "" );
}
bool config::setDeviceName( int n, QString name )
{
	return userConfig->writeEntry( "/kvideoencoder/system/devices/" + QString::number(n) + "/name", name );
}
	
QString config::getDeviceAddress( int n )
{
	return userConfig->readEntry( "/kvideoencoder/system/devices/" + QString::number(n) + "/address", "" );
}
bool config::setDeviceAddress( int n, QString address )
{
	return userConfig->writeEntry( "/kvideoencoder/system/devices/" + QString::number(n) + "/address", address );
}

QString config::getLastDir( void )
{
	return userConfig->readEntry( "/kvideoencoder/gui/lastDir", "~" );
}
bool config::setLastDir( QString last )
{
	return userConfig->writeEntry( "/kvideoencoder/gui/lastDir", last );
}
