/* ***************************************************************************
   * KVideoEncoder - an easy-to-use Video Encoder for KDE                    *
   * Copyright (C) 2005-2006 Philipp Ludwig                                  *
   *                                                                         *
   * This program is free software; you can redistribute it and/or modify it *
   * under the terms of the GNU General Public License as published by the   *
   * Free Software Foundation; either version 2 of the License, or (at your  *
   * option) any later version.                                              *
   *                                                                         *
   * This program is distributed in the hope that it will be useful, but     *
   * WITHOUT ANY WARRANTY; without even the implied warranty of              *
   * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        *
   * General Public License for more details.                                *
   *                                                                         *
   * You should have received a copy of the GNU General Public License along *
   * with this program; if not, write to the Free Software Foundation, Inc., *
   * 59 Temple Place, Suite 330, Boston, MA 02111-1301, USA.                 *
   *************************************************************************** */

#include <qsettings.h>
#include <qstring.h>
#include <stdio.h>

#define DEBUG(w) qDebug("DEBUG: "+QString(w));
#define FIXME(w) qWarning("FIXME: "+QString(w));

class config
{
private:
	QSettings *userConfig;
	QString prefix;
		
	void makeDefaultConfig( void );
	void readSystemConfig( void );
public:
	config( void );
	~config( void );
	
	// Useful tools
	QString getCommand( QString cmd );
	
	// Read only
	QString getPrefix( void ) { return prefix; }
	
	// Applications
	QString getLanguage( void );
	bool setLanguage( QString language );
	
	QString getMplayer( void );
	bool setMplayer( QString mplayer );
	
	QString getMencoder( void );
	bool setMencoder( QString mpencoder );
	
	QString getLsdvd( void );
	bool setLsdvd( QString lsdvd );
	
	int getEncoderIndex( void );
	bool setEncoderIndex( int n );
	
	// Devices
	void findDevices( void );
	
	int getDevicesCount( void );
	bool setDevicesCount( int n );
	
	QString getDeviceName( int n );
	bool setDeviceName( int n, QString name );
	
	QString getDeviceAddress( int n );
	bool setDeviceAddress( int n, QString address );
	
	// file dialog
	QString getLastDir( void );
	bool setLastDir( QString last );
};
