/* *************************************************************************** *
   * KVideoEncoder - an easy-to-use Video Encoder for KDE		       *
   * Copyright (C) 2005-2006 Philipp Ludwig				       *
   *									       *
   * This program is free software; you can redistribute it and/or modify it   *
   * under the terms of the GNU General Public License as published by the     *
   * Free Software Foundation; either version 2 of the License, or (at your    *
   * option) any later version.					               *
   *	        		                                               *
   * This program is distributed in the hope that it will be useful, but       *
   * WITHOUT ANY WARRANTY; without even the implied warranty of		       *
   * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU	       *
   * General Public License for more details.			               *
   *									       *
   * You should have received a copy of the GNU General Public License along   *
   * with this program; if not, write to the Free Software Foundation, Inc.,   *
   * 59 Temple Place, Suite 330, Boston, MA 02111-1301, USA.                   *
   *************************************************************************** */

#include <stdio.h>
#include <qapplication.h>
#include <qdir.h>
#include <qfile.h>
#include <qmessagebox.h>
#include <qtranslator.h>
#include <kapplication.h>
#include "mainform.h"
#include "kvideoencoder_config.h"

int main( int argc, char ** argv )
{
	printf( "%s\n", "KVideoEncoder, Copyright (C) 2005-2006 Philipp Ludwig" );
	printf( "%s\n", "KVideoEncoder comes with ABSOLUTELY NO WARRANTY. This is free software, and you are welcome to redistribute it under certain conditions. (for details see the file COPYING)" );

	// Init the application
	KApplication a( argc, argv, "KVideoEncoder" );
	
	// Load the prefix & the language
	config *Config = new config();
	QString lang   = Config->getLanguage();
	QString prefix = Config->getPrefix();
	delete Config;
  
	// Install the selected language		
	QTranslator *translator;
	translator = new QTranslator(0);
	  
	
	if( translator->load( prefix + "/share/apps/kvideoencoder/" + lang ) )
		a.installTranslator( translator );
	else
	{
		qWarning( "Could not install the translation file; maybe ~/.kvideoencoder is corrupted?" );
	}
	
	Form1 w;
	w.getApp( &a );
	w.show();
	a.connect( &a, SIGNAL( lastWindowClosed() ), &a, SLOT( quit() ) );
	return a.exec();
}
