/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

/* ***************************************************************************
   * KVideoEncoder - an easy-to-use Video Encoder for KDE                    *
   * Copyright (C) 2005-2006 Philipp Ludwig                                  *
   *                                                                         *
   * This program is free software; you can redistribute it and/or modify it *
   * under the terms of the GNU General Public License as published by the   *
   * Free Software Foundation; either version 2 of the License, or (at your  *
   * option) any later version.                                              *
   *                                                                         *
   * This program is distributed in the hope that it will be useful, but     *
   * WITHOUT ANY WARRANTY; without even the implied warranty of              *
   * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        *
   * General Public License for more details.                                *
   *                                                                         *
   * You should have received a copy of the GNU General Public License along *
   * with this program; if not, write to the Free Software Foundation, Inc., *
   * 59 Temple Place, Suite 330, Boston, MA 02111-1301, USA.		     *
   *************************************************************************** */

// Qt headers
#include <qapplication.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qdir.h>
#include <qfile.h>
#include <qgroupbox.h>
#include <qlistbox.h>
#include <qslider.h>
#include <qspinbox.h>

// KDE headers
#include <kmessagebox.h>

// System headers
#include <sys/types.h>
#include <unistd.h>

// KVideoEncoder window headers
#include "videocodec.h"
#include "videofilter.h"
#include "audiocodec.h"
#include "joinvideos.h"
#include "extract.h"
#include "chapters.h"
#include "subtitles.h"
#include "preferences.h"
#include "flv2mpeg.h"

// KVideoEncoder struct headers
#include "videocodec_struct.h"
#include "videofilter_struct.h"
#include "audiocodec_struct.h"

// KVideoEncoder class headers
#include "kvideoencoder_config.h"
#include "encoder.h"

#define BUFFER_SIZE 40

/*** It's ashame, but we need some global vars ;-) ***/
// A pointer to the application for answering the messages
QApplication *Application;

VideoCodec selectedVideoCodec;
AudioCodec selectedAudioCodec;
VideoFilter videoFilter;

void Form1::getApp( QApplication *a )
{
	Application = a;
}

void Form1::getSelectedVideoCodec( void *sc )
{
	sc = &selectedVideoCodec;
}

void Form1::getVideoInputInfos()
{
	frameRate->setText( "" );
	frameCount->setText( "" );
	
	int chars_read;
	QString temp;
	config *Config = new config();
	QString mplayer = Config->getMplayer();
	delete Config;
	temp = "sh -c \"" + mplayer + " -nosound -vo null -v '" + InputEdit->url() + "'\" 2>&1";
	FILE* read_fp = popen( temp.ascii(), "r" );
	
	// If read_fp was null, something went terribly wrong
	if( read_fp == NULL )
	{
		KMessageBox::error( this, tr("Running mplayer failed!"), "KVideoEncoder" );
		startBtn->setEnabled( true );
		cancelBtn->setEnabled( false );
		return;
	}
	
	char buffer[120];
	int n;	
	QString data;
	chars_read = fread( buffer, sizeof(char), 120, read_fp );
	temp = QString::fromLatin1( buffer );
	
	while( chars_read > 0 )
	{	
	// Framerate
	data = temp;
	if( (n = data.find( "fps:" )) != -1 )
	{
		data.remove( 0, n+4 );
		data.remove( data.find( " " ), data.length() );
		frameRate->setText( data );
	}
	
	// Frame count
	if( (n = data.find( "Len: ")) != -1 ) if( frameCount->text() == "" )
	{
		data.remove( 0, n+5 );
		data.remove( data.find( "\n" ), data.length() );
		frameCount->setText( data );
	}
	
	chars_read = fread( buffer, sizeof(char), 120, read_fp );
	temp = QString::fromLatin1( buffer );
	if( temp.find( "VO:" ) != -1 ) chars_read = 0;
	}
}

void Form1::encodeFile( QString preview, int frame, void* previewFilter )
{
	config *Config = new config(); 
	QString cpt = this->caption();
	QString inputFile = InputEdit->url();
	QString outputFile = OutputEdit->url();
	QListViewItem *item;
	int ret_value = 0;	
	int errortype = 0;
	
	if( preview != "" ) outputFile = preview;
	
	if( outputFile ==  "" ) 
	{
		KMessageBox::error( NULL, tr( "You did not select an output file!" ), "KVideoEncoder" );	
		tabWidget2->setCurrentPage(1);
		return;
	}
	
	// Output file exists already?
	if( QFile(outputFile).exists() ) if( preview == "" )
		if( KMessageBox::questionYesNo( NULL, QString(tr("The selected output file %s exists already. Do you want to overwrite it?")).replace( "%s", OutputEdit->url() ), "KVideoEncoder" ) == KMessageBox::No )
		return;
	
	startBtn->setEnabled( false );
	cancelBtn->setEnabled( true );
	
	switch( Config->getEncoderIndex() )
	{
	case 0: /* mencoder */
	{Mencoder *encoder = new Mencoder();
		encoder->selectedVideoCodec = selectedVideoCodec;
		encoder->selectedAudioCodec = selectedAudioCodec;		
		encoder->inputType 		= inputTypeBox->currentItem();
		encoder->outputFile		= outputFile;
		
		if( preview == "" ) encoder->videoFilter = &videoFilter;
		else
		{
		VideoFilter *vf = (VideoFilter*)previewFilter;
		encoder->videoFilter = vf;
		}
		
		switch( inputTypeBox->currentItem() )
		{
		case 0: // File
		if( inputFile == "" )
		{
			KMessageBox::error( this, tr("You did not select an input file"), "KVideoEncoder" );
			startBtn->setEnabled( true );
			cancelBtn->setEnabled( false );
			return;
		}
		encoder->inputFile = inputFile;
		break;
		
		case 1: // VCD
		encoder->device = QString(Config->getDeviceAddress(vcdBox->currentItem())).lower();
		encoder->track  = vcdTrack->value();
		break;
		
		case 2: // DVD
		encoder->device   = QString(Config->getDeviceAddress(dvdBox->currentItem())).lower();
		encoder->aid	  = QString::number( audioStreamBox->currentItem() + 128 );
		item = titleBox->selectedItem();
		encoder->track	= QString(item->text(0)).toInt();
		encoder->firstCpt = QString::number( selectedVideoCodec.firstCpt );
		encoder->lastCpt  = QString::number( selectedVideoCodec.lastCpt );
		encoder->sid	  = QString::number( selectedVideoCodec.sub );
		
		item = NULL;
		break;
		
		case 3: // Stream
		encoder->inputFile = streamEdit->text();
		break;
		}
		
		// Preview?
		if( preview != "" )
		{
		double f = frame;
		QString tmp;
		tmp.setNum( f / QString(frameRate->text()).toFloat() );
		tmp = tmp.left( tmp.find( "." ) );		
		encoder->previewStart = tmp.toInt();
		encoder->previewEnd = encoder->previewStart + 1;
		}
		else
		{
		encoder->previewStart = -1;
		encoder->previewEnd = -1;
		}
		
		// Build command
		encoder->BuildCommandLine();
		if( !encoder->RunEncoder() )
		{
			KMessageBox::error( this, tr( "Failed running encoder."), "KVideoEncoder" );
			startBtn->setEnabled( true );
			cancelBtn->setEnabled( false );
			return;
		}
		
		int mb_counter = 0;	
		int progress;
		progressStack->raiseWidget(0);
		
		do
		{			
		progress = encoder->GetProgress();
		if( progress != -1 ) if( preview == "" )
		{
			progressBar->setProgress(progress);
			this->setCaption( QString::number(progress) + " % - " + cpt );				
			mb_counter++;
		}
		
		if( mb_counter > 30 ) if( preview == "" )
		{
			MB->setText( tr("Final size:") + " " + QString::number( encoder->GetFinalSize()) + " MB" );
			mb_counter = 0;
		}
		
		Application->processEvents();
		
		if( cancelBtn->isEnabled() == false ) 
		{
			progress = -2;
			encoder->KillEncoder();
		}
		}while( progress != -2 );
		ret_value = pclose( encoder->handle );
		errortype = encoder->errortype;
		delete encoder;
		break;}
	
	case 1: /* transcode */
	Transcode *encoder = new Transcode();
	encoder->selectedVideoCodec = selectedVideoCodec;
	encoder->selectedAudioCodec = selectedAudioCodec;
	encoder->videoFilter 		= &videoFilter;
	encoder->inputType 		= inputTypeBox->currentItem();
	encoder->outputFile		= OutputEdit->url();
	switch( inputTypeBox->currentItem() )
	{
		case 0: // File
			if( inputFile == "" )
			{
			KMessageBox::error( this, tr("You did not select an input file"), "KVideoEncoder" );
			return;
			}
			encoder->inputFile = inputFile;
			break;
			
		case 1: // VCD
			encoder->device = QString(Config->getDeviceAddress(vcdBox->currentItem())).lower();
			encoder->track  = vcdTrack->value();
			break;
			
		case 2: // DVD
			encoder->device   = QString(Config->getDeviceAddress(dvdBox->currentItem())).lower();
			encoder->aid	  = QString::number( audioStreamBox->currentItem() + 128 );
			item = titleBox->selectedItem();			
			encoder->track	= QString(item->text(0)).toInt();
			encoder->firstCpt = QString::number( selectedVideoCodec.firstCpt );
			encoder->lastCpt  = QString::number( selectedVideoCodec.lastCpt );
			encoder->sid	  = QString::number( selectedVideoCodec.sub );
			
			item = NULL;
			break;
			
		case 3: // Stream
			encoder->inputFile = streamEdit->text();
			break;
		}
	
	encoder->BuildCommandLine();
	if( !encoder->RunEncoder() )
	{
		KMessageBox::error( this, tr( "Failed running encoder."), "KVideoEncoder" );
		return;
	}
		
	int progress;
	progressStack->raiseWidget(1);
	
	do
	{			
		progress = encoder->GetProgress();
		if( progress != -1 ) 
		{
			progressLabel->setText( tr("Frames encoded: ") + QString::number(progress) );			
		}
		
		Application->processEvents();
		
		if( cancelBtn->isEnabled() == false ) 
		{
		progress = -2;
		encoder->KillEncoder();
		}
	}while( progress != -2 );	
	delete encoder;
	break;
	}
	
	progressBar->setProgress( 100 );
	this->setCaption( cpt );
   
	if( preview == "" ) 
	{
		/* Error handling */
		if( ret_value == 0 || Config->getEncoderIndex() == 1 )
			KMessageBox::information( this, tr("Finish!"), "KVideoEncoder" );
		else
		{
			DEBUG( "mencoder said: " + QString::number( ret_value ) );
			switch( errortype )
			{
			case 1:
				KMessageBox::sorry( this, tr( "Sorry, but mencoder is not able to direct-copy the audio data of your source video. Please select an audio codec." ), "KVideoEncoder" );
				break;
			default:
				KMessageBox::error( this, tr( "Something went wrong :( please check the output file." ), "KVideoEncoder" );
			}
		}
	}
	startBtn->setEnabled( true );
	cancelBtn->setEnabled( false );
	delete Config;
}

void Form1::init()
{
	// Init the standard Video Codec
	selectedVideoCodec.Codec		= CODEC_NAME_DIVX4; 
	selectedVideoCodec.bitRate		= 800;
	selectedVideoCodec.bitRateMode		= BITRATE_MODE_CBR;
	selectedVideoCodec.constantQuantizer	= 2;
	selectedVideoCodec.keyframe_interval	= 100;
	selectedVideoCodec.vhq			= false;
	selectedVideoCodec.v4mv			= false;
	selectedVideoCodec.grayScale		= false;
	selectedVideoCodec.changeFrameRate	= false;
	selectedVideoCodec.newFrameRate		= 25;
	selectedVideoCodec.dia			= 1;
	selectedVideoCodec.vqmin		= 2;
	selectedVideoCodec.vqmax		= 31;
	selectedVideoCodec.vbstrategy		= 0;
	selectedVideoCodec.turbo		= 0;
	selectedVideoCodec.logfile		= "/tmp/pass.log";
	selectedVideoCodec.newIndex		= false;
	selectedVideoCodec.sub 			= -1;	
	
	// Init the Video Filter Class
	videoFilter.noFilter = true;
	
	// Init the standard Audio Codec
	selectedAudioCodec.Codec		 = AUDIO_CODEC_NAME_DIRECTCOPY;
	selectedAudioCodec.bitRate		 = 128;	
	selectedAudioCodec.newSampleRate	 = 44100;
	selectedAudioCodec.changeSampleRate  = false;
	
	// Scan for devices, if neccessary and add the devices to the boxes
	config *Config = new config();
	if( Config->getDevicesCount() == 0 ) Config->findDevices();
	for( int i=0; i<Config->getDevicesCount(); i++ )
	{
		vcdBox->insertItem( Config->getDeviceName(i) );
		dvdBox->insertItem( Config->getDeviceName(i) );
	}
	delete Config;
	
	// Set the filter
	InputEdit->setFilter( tr("*.avi *.mpg *.mpeg *.m2v *.vob *.dat *.asf *.rm *.ram *.wmv *.mov|All videos") 
				   + "\n" + tr("*.avi|AVI")
				   + "\n" + tr("*.mpg *.mpeg *.m2v *.vob *.dat|MPEG")
				   + "\n" + tr("*.asf *.wmv|Windows Media")
				   + "\n" + tr("*.rm *.ram|Real Media")
				   + "\n" + tr("*.mov|Quicktime")
				   + "\n" + tr("*|All files") );
	OutputEdit->setFilter( tr("*.avi *.mpg *.mpeg|Supported formats (*.avi *.mpeg)")
				   + "\n" + tr("*.avi|AVI")
				   + "\n" + tr("*.mpg *.mpeg|MPEG")
				   + "\n" + tr("*|All files") ); 
}


void Form1::pushButton3_clicked()
{	
	encodeFile( "", 0, NULL );
}


void Form1::VideoCodecBtn_clicked()
{
	VideoCodecWnd *VCodecWindow;
	VCodecWindow = new VideoCodecWnd(this);
	
	// Update the values of the input fields in the Window
	if( (selectedVideoCodec.Codec == CODEC_NAME_MPEG1 ) || (selectedVideoCodec.Codec == CODEC_NAME_MPEG2) )
	{
	int i;
	for( i=0; i<VCodecWindow->newMpegFrameRate->count(); i++ ) 
		if( VCodecWindow->newMpegFrameRate->text(i) == QString::number( selectedVideoCodec.newFrameRate ) ) VCodecWindow->newMpegFrameRate->setCurrentItem(i);
	}
	
	VCodecWindow->CodecBox->setCurrentItem( selectedVideoCodec.Codec );
	VCodecWindow->CodecBox_activated( selectedVideoCodec.Codec );
	VCodecWindow->divX4BitRate->setValue( selectedVideoCodec.bitRate );
	VCodecWindow->keyframeInterval->setValue( selectedVideoCodec.keyframe_interval );
	VCodecWindow->vhq->setChecked( selectedVideoCodec.vhq );
	VCodecWindow->v4mv->setChecked( selectedVideoCodec.v4mv );
	VCodecWindow->grayScale->setChecked( selectedVideoCodec.grayScale );
	VCodecWindow->changeFrameRate->setChecked( selectedVideoCodec.changeFrameRate );
	VCodecWindow->newFrameRate->setValue( selectedVideoCodec.newFrameRate );
	VCodecWindow->bitRateMode->setCurrentItem( selectedVideoCodec.bitRateMode );
	VCodecWindow->constantQuantizer->setValue( selectedVideoCodec.constantQuantizer );
	VCodecWindow->dia->setValue( selectedVideoCodec.dia );
	VCodecWindow->vqmin->setValue( selectedVideoCodec.vqmin );
	VCodecWindow->vqmax->setValue( selectedVideoCodec.vqmax );
	VCodecWindow->turbo->setChecked( selectedVideoCodec.turbo == 1 );
	VCodecWindow->vbstrategy->setChecked( selectedVideoCodec.vbstrategy == 1 );
	VCodecWindow->vbitRate->setValue( selectedVideoCodec.bitRate );
	VCodecWindow->secondLogFile->setText( selectedVideoCodec.logfile );
	VCodecWindow->secondBitRate->setValue( selectedVideoCodec.bitRate );
	VCodecWindow->newIndex->setChecked( selectedVideoCodec.newIndex );
	VCodecWindow->mpegType->setCurrentItem( selectedVideoCodec.mpegType );
	VCodecWindow->outputType->setCurrentItem( selectedVideoCodec.type );
	VCodecWindow->aspectBox->setChecked( selectedVideoCodec.changeAspect );	
	VCodecWindow->newAspect->setCurrentItem( selectedVideoCodec.newAspectRatio );
	VCodecWindow->aspectX->setValue( selectedVideoCodec.aspectX );
	VCodecWindow->aspectY->setValue( selectedVideoCodec.aspectY );
	VCodecWindow->harddup->setChecked( selectedVideoCodec.harddup );
	
	VCodecWindow->changeFrameRate_clicked();
	VCodecWindow->constantQuantizer_valueChanged( selectedVideoCodec.constantQuantizer );
	VCodecWindow->vqmin_valueChanged( selectedVideoCodec.vqmin );
	VCodecWindow->vqmax_valueChanged( selectedVideoCodec.vqmax );
	VCodecWindow->bitRateMode_activated( selectedVideoCodec.bitRateMode );
	VCodecWindow->aspectBox_toggled( TRUE );
	
	// Show the window
	if( VCodecWindow->exec() == QDialog::Accepted )
	{
	selectedVideoCodec.bitRate 		= VCodecWindow->divX4BitRate->value();
	selectedVideoCodec.Codec 		= VCodecWindow->CodecBox->currentItem();
	selectedVideoCodec.keyframe_interval 	= VCodecWindow->keyframeInterval->value();
	selectedVideoCodec.vhq			= VCodecWindow->vhq->isChecked();
	selectedVideoCodec.v4mv			= VCodecWindow->v4mv->isChecked();
	selectedVideoCodec.grayScale		= VCodecWindow->grayScale->isChecked();
	selectedVideoCodec.changeFrameRate 	= VCodecWindow->changeFrameRate->isChecked();
	selectedVideoCodec.newFrameRate		= VCodecWindow->newFrameRate->value();
	selectedVideoCodec.bitRateMode		= VCodecWindow->bitRateMode->currentItem();
	selectedVideoCodec.constantQuantizer	= VCodecWindow->constantQuantizer->value();
	selectedVideoCodec.dia			= VCodecWindow->dia->value();
	selectedVideoCodec.vqmin		= VCodecWindow->vqmin->value();
	selectedVideoCodec.vqmax		= VCodecWindow->vqmax->value();
	selectedVideoCodec.newIndex		= VCodecWindow->newIndex->isChecked();
	selectedVideoCodec.mpegType		= VCodecWindow->mpegType->currentItem();
	selectedVideoCodec.type			= VCodecWindow->outputType->currentItem();
	selectedVideoCodec.newAspectRatio	= VCodecWindow->newAspect->currentItem();
	selectedVideoCodec.aspectX		= VCodecWindow->aspectX->value();
	selectedVideoCodec.aspectY		= VCodecWindow->aspectY->value();
	selectedVideoCodec.changeAspect		= VCodecWindow->aspectBox->isChecked();
	selectedVideoCodec.harddup		= VCodecWindow->harddup->isChecked();
	
	if( VCodecWindow->bitRateMode->currentItem() == BITRATE_MODE_FIRSTPASS ) 
	{
		selectedVideoCodec.bitRate = VCodecWindow->vbitRate->value();
		selectedVideoCodec.logfile = VCodecWindow->logFile->text();
	}
	else if( VCodecWindow->bitRateMode->currentItem() == BITRATE_MODE_SECONDPASS ) 
	{
		selectedVideoCodec.bitRate = VCodecWindow->secondBitRate->value();
		selectedVideoCodec.logfile = VCodecWindow->secondLogFile->text();
	}
	
	if( VCodecWindow->turbo->isChecked() )	  selectedVideoCodec.turbo	  = 1; else selectedVideoCodec.turbo	  = 0;
	if( VCodecWindow->vbstrategy->isChecked() ) selectedVideoCodec.vbstrategy = 1; else selectedVideoCodec.vbstrategy = 1;
	
	if( selectedVideoCodec.Codec == CODEC_NAME_MPEG1 ) 
	{
		QString newFPS = VCodecWindow->newMpegFrameRate->text( VCodecWindow->newMpegFrameRate->currentItem() );
		selectedVideoCodec.newFrameRate = newFPS.toFloat();
	}
	
	if( (selectedVideoCodec.sub != -1) && (selectedVideoCodec.Codec == CODEC_NAME_DIRECTCOPY ) )
		KMessageBox::information( this, tr( "WARNING: The subtitles can't be ripped if you select direct stream copy as video codec." ), "KVideoEncoder" );
	}
	delete VCodecWindow;
}

void Form1::cancelBtn_clicked()
{
	if( KMessageBox::questionYesNo( this, "Do you really want to cancel the encoding process?", "KVideoEncoder" ) == KMessageBox::Yes )
	cancelBtn->setEnabled( false );
}

void Form1::videoFilterBtn_clicked()
{
	VideoFilterWindow *VFilterWnd;
	VFilterWnd = new VideoFilterWindow(this);
	
	// Add the preselected Filter to the window
	if( videoFilter.scale != NULL )
	{
		VFilterWnd->videoFilterBox->insertItem( tr("Scale Video") );
		VFilterWnd->scaleWidth->setValue( videoFilter.scale->width );
		VFilterWnd->scaleHeight->setValue( videoFilter.scale->height );
	
		// MPEG Limits
		if( selectedVideoCodec.Codec == CODEC_NAME_MPEG1 )
		{
			VFilterWnd->scaleWidth->setMaxValue( 4095 );
			VFilterWnd->scaleWidth->setMinValue(1);
			VFilterWnd->scaleHeight->setMaxValue( 4095 );
			VFilterWnd->scaleHeight->setMinValue(1);
		}
		else
		{
			VFilterWnd->scaleWidth->setMaxValue( 9999 );
			VFilterWnd->scaleWidth->setMinValue(0);
			VFilterWnd->scaleHeight->setMaxValue( 9999 );
			VFilterWnd->scaleHeight->setMinValue(0);
		}
	}
	
	if( videoFilter.spp != NULL )
	{
		VFilterWnd->videoFilterBox->insertItem( tr("Simple postprocessing") );
		VFilterWnd->sppQuality->setValue( videoFilter.spp->quality );
	}
	if( videoFilter.denoise3d != NULL )
	{
		VFilterWnd->videoFilterBox->insertItem( tr("Denoise 3D") );
		VFilterWnd->denoiseHQ->setChecked( videoFilter.denoise3d->hq );
		VFilterWnd->luma->setValue( videoFilter.denoise3d->luma );
		VFilterWnd->chroma->setValue( videoFilter.denoise3d->chroma );
		VFilterWnd->time->setValue( videoFilter.denoise3d->time );
	}
	if( videoFilter.eq != NULL )
	{
		VFilterWnd->videoFilterBox->insertItem( tr("Software Equalizer") );
		VFilterWnd->brightness->setValue( videoFilter.eq->brightness );
		VFilterWnd->contrast->setValue( videoFilter.eq->contrast );
	}
	if( videoFilter.filmdint != NULL )
	{
		VFilterWnd->videoFilterBox->insertItem( tr("Inverse telecine" ) );
		VFilterWnd->luma_copy->setChecked( videoFilter.filmdint->luma_copy );
		VFilterWnd->dint_thres->setValue( videoFilter.filmdint->dint_thres );
		VFilterWnd->fast->setValue( videoFilter.filmdint->fast );
	}
	if( videoFilter.crop != NULL )
	{
		VFilterWnd->videoFilterBox->insertItem( tr("Crop") );
		VFilterWnd->crop_width->setValue( videoFilter.crop->width );
		VFilterWnd->crop_height->setValue( videoFilter.crop->height );
		VFilterWnd->crop_x->setValue( videoFilter.crop->x );
		VFilterWnd->crop_y->setValue( videoFilter.crop->y );
	}
	
	// Show the window 	
	VFilterWnd->getFrames( QString(frameCount->text()).toInt() );
	VFilterWnd->show();
	while( VFilterWnd->isVisible() )
	{
		Application->processEvents();
	}
	if( VFilterWnd->result() == QDialog::Accepted )
	{
		videoFilter.destroyAllFilters();
		VFilterWnd->applyFilter( &videoFilter, &selectedVideoCodec );				
	}
	
	delete VFilterWnd;
}

void Form1::audioCodecBtn_clicked()
{
	AudioCodecWnd ACodecWnd;
	
	// Refresh the settings in the window
	ACodecWnd.CodecBox->setCurrentItem( selectedAudioCodec.Codec );
	ACodecWnd.BitRate->setValue( selectedAudioCodec.bitRate );
	ACodecWnd.changeSampleRate->setChecked( selectedAudioCodec.changeSampleRate );
	ACodecWnd.newSampleRate->setValue( selectedAudioCodec.newSampleRate );
	ACodecWnd.CodecBox_activated( selectedAudioCodec.Codec );
	ACodecWnd.changeSampleRate_clicked();
	
	if( ACodecWnd.exec() == QDialog::Accepted )
	{
		selectedAudioCodec.Codec 	    = ACodecWnd.CodecBox->currentItem();
		selectedAudioCodec.bitRate	    = ACodecWnd.BitRate->value();
		selectedAudioCodec.changeSampleRate = ACodecWnd.changeSampleRate->isChecked();
		selectedAudioCodec.newSampleRate    = ACodecWnd.newSampleRate->value();
	}
}


void Form1::comboBox1_activated( int n )
{
	inputTypeStack->raiseWidget(n);
}


void Form1::Scan_DVD_clicked()
{
	int n;
	char* buffer;
	config *Config = new config();
	QString temp, title, length, chapters;
	QString cmdline = "sh -c '" + Config->getLsdvd() + " " + QString(Config->getDeviceAddress(dvdBox->currentItem())).lower() + " 2>&1'";
	delete Config;
	
	FILE* read_fp = popen( cmdline.latin1() , "r" );
	
	// If read_fp was null, something had gone terribly wrong
	if( read_fp == NULL )
	{
		KMessageBox::error( this, tr( "Running lsdvd failed!" ), "KVideoEncoder" );
		return;
	}		
	
	buffer = (char*)malloc(120);
	
	titleBox->clear();
	while( fgets( buffer, 120, read_fp ) != NULL )
	{			
	temp = QString::fromLatin1(buffer);
	if( temp.find( "Can't open" ) != -1 )
	{
		KMessageBox::error( this, "Please insert a DVD!", "KVideoEncoder" );
		return;
	}
	if( temp.find( "Length: " ) != -1 )
	{
		n = temp.find( "Title: " );
		title = temp.mid( n + 7, temp.find( ", Length" ) - n - 7 );
		
		n = temp.find( "Length: " );
		length = temp.mid( n + 8, temp.find( " Chapters" ) - n - 8 );
		
		n = temp.find( "Chapters: " );
		chapters = temp.mid( n + 10, temp.find( ", Cells: " ) - n - 10 );
		
		new QListViewItem( titleBox, title, length, chapters );		
	}
	}
	titleBox->setSelected( titleBox->findItem( "1", 0, EndsWith ), true );
	titleBox_clicked( titleBox->findItem( "1", 0, EndsWith ) );
}


void Form1::titleBox_clicked( QListViewItem *item )
{
	char *buffer = (char*)malloc(200);	
	QString temp;	
	config *Config = new config();
	QString cmdline = Config->getLsdvd() + " -a -t " + item->text(0) + " " + QString(Config->getDeviceAddress(dvdBox->currentItem())).lower();
	delete Config;
	FILE *read_fp = popen( cmdline.latin1(), "r" );
	
	// Audio streams
	audioStreamBox->clear();
	while( fgets( buffer, 200, read_fp ) != NULL )
	{
		temp = QString::fromLatin1( buffer );
		if( temp.find( "Audio: " ) != -1 ) audioStreamBox->insertItem( temp.right( temp.length() - 8 ) );
	}
	
	audioStreamBox->setCurrentItem(0);
	
	// Chapters
	int max;
	QListViewItem *selected = titleBox->selectedItem();
	max = QString(selected->text(2)).toInt();
	selectedVideoCodec.lastCpt = max;
	selectedVideoCodec.firstCpt = 1;
}


void Form1::joinVideoItem_clicked()
{
	JoinVideosWnd *joinWnd;
	joinWnd = new JoinVideosWnd();
	joinWnd->getApp( Application );
	joinWnd->getFilter( InputEdit->filter() );
	joinWnd->exec();
	delete joinWnd;	
}


void Form1::languageEnglish_EnglishAction_activated()
{
	config *Config = new config();
	Config->setLanguage( "kvideoencoder_en.qm" );
	delete Config;
	KMessageBox::information( this, "Please restart KVideoEncoder to use the new language", "KVideoEncoder" );
}


void Form1::languageDeutsch_GermanAction_activated()
{
	config *Config = new config();
	Config->setLanguage( "kvideoencoder_de.qm" );
	delete Config;
	KMessageBox::information( this, "Please restart KVideoEncoder to use the new language", "KVideoEncoder" );
}


void Form1::toolsExtract_AudioVideoAction_activated()
{
	ExtractWnd *extractWnd;
	extractWnd = new ExtractWnd();
	extractWnd->getApp( Application );
	extractWnd->inputFile->setFilter( InputEdit->filter() );
	extractWnd->videoFile->setFilter( OutputEdit->filter() );
	extractWnd->exec();
	delete extractWnd;
}


void Form1::languageRussianAction_activated()
{
	config *Config = new config();
	Config->setLanguage( "kvideoencoder_ru.qm" );
	delete Config;
	KMessageBox::information( this, "Please restart KVideoEncoder to use the new language", "KVideoEncoder" );
}


void Form1::pushButton9_clicked()
{
	chaptersForm *cForm = new chaptersForm();
	
	// Chapters
	int max;	
	QListViewItem *selected = titleBox->selectedItem();
	if( selected == 0 ) 
	{
		KMessageBox::error( this, tr( "Please select a title." ), "KVideoEncoder" );
		return;
	}
	max = QString(selected->text(2)).toInt();
	
	cForm->first->setMaxValue(max);
	cForm->last->setMaxValue(max);
	
	cForm->first->setValue( selectedVideoCodec.firstCpt );
	cForm->last->setValue( selectedVideoCodec.lastCpt );
	
	// Show wnd
	if( cForm->exec() )
	{
		// Update
		selectedVideoCodec.firstCpt = cForm->first->value();
		selectedVideoCodec.lastCpt = cForm->last->value();
	}
	
	delete cForm;
}


void Form1::pushButton26_clicked()
{
	subtitlesForm *sForm = new subtitlesForm();
	
	QListViewItem *item = titleBox->selectedItem();
	 if( item == 0 ) 
	{
		KMessageBox::error( this, tr( "Please select a title." ), "KVideoEncoder" );
		return;
	}
	
	// Fill list
	char *buffer = (char*)malloc(200);	
	QString temp;	
	config *Config = new config();
	QString cmdline = Config->getLsdvd() + " -s -t " + item->text(0) + " " + QString(Config->getDeviceAddress(dvdBox->currentItem())).lower();
	delete Config;
	FILE *read_fp = popen( cmdline.latin1(), "r" );
	
	while( fgets( buffer, 200, read_fp ) != NULL )
	{
		temp = QString::fromLatin1( buffer );
		if( temp.find( "Subtitle: " ) != -1 ) sForm->subBox->insertItem( temp.right( temp.length() - 12 ) );
	}
	
	sForm->subBox->setSelected( selectedVideoCodec.sub+1, TRUE );
	if( sForm->exec() ) selectedVideoCodec.sub = sForm->subBox->currentItem() - 1;
	
	delete sForm;
	
	// Warning
	if( (selectedVideoCodec.sub != -1) && (selectedVideoCodec.Codec == CODEC_NAME_DIRECTCOPY ) )
	KMessageBox::information( this, tr( "WARNING: The subtitles can't be ripped if you select direct stream copy as video codec.", "KVideoEncoder" ) );
}


void Form1::toolsPreferencesAction_activated()
{
	preferencesWnd *prefDlg = new preferencesWnd();
	config *Config = new config();
	
	prefDlg->mplayer->setText( Config->getMplayer() );
	prefDlg->mencoder->setText( Config->getMencoder() );
	prefDlg->lsdvd->setText( Config->getLsdvd() );
	prefDlg->encoderBox->setCurrentItem( Config->getEncoderIndex() );
	
	for( int i=0; i<Config->getDevicesCount(); i++ ) prefDlg->deviceBox->insertItem( Config->getDeviceName(i) );
	prefDlg->deviceBox_highlighted(0);
	delete Config;
	
	prefDlg->exec();
	
	Config = new config();
	vcdBox->clear();
	dvdBox->clear();
	for( int i=0; i<Config->getDevicesCount(); i++ )
	{
		vcdBox->insertItem( Config->getDeviceName(i) );
		dvdBox->insertItem( Config->getDeviceName(i) );
	}
	delete Config;
	
	delete prefDlg;
}


void Form1::toolsFLV2MPEGAction_activated()
{
	FLV2MPEG *flv2mpeg = new FLV2MPEG();
	flv2mpeg->setApp( Application );
	flv2mpeg->exec();
	delete flv2mpeg;
}


void Form1::MenuBarEditor_activated( int )
{
	config *Config = new config();
	Config->setLanguage( "kvideoencoder_cs.qm" );
	delete Config;
	KMessageBox::information( this, "Please restart KVideoEncoder to use the new language", "KVideoEncoder" );
}
