/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

#include "kvideoencoder_config.h"

void preferencesWnd::listBox2_highlighted( int n )
{
	widgetStack->raiseWidget(n);
}


void preferencesWnd::pushButton5_clicked()
{
	config *Config = new config();
	Config->findDevices();
	deviceBox->clear();
	for( int i=0; i<Config->getDevicesCount(); i++ ) deviceBox->insertItem( Config->getDeviceName(i) );
	delete Config;
	
	deviceBox->setCurrentItem(0);
	deviceBox_highlighted(0);
}


void preferencesWnd::deviceBox_highlighted( int n )
{
	config *Config = new config();
	devName->setText( Config->getDeviceName(n) );
	devAddress->setText( Config->getDeviceAddress(n) );
	delete Config;
}


void preferencesWnd::devName_lostFocus()
{
	config *Config = new config();
	Config->setDeviceName( deviceBox->currentItem(), devName->text() );
	
	int n = deviceBox->currentItem();
	deviceBox->clear();
	for( int i=0; i<Config->getDevicesCount(); i++ ) deviceBox->insertItem( Config->getDeviceName(i) );
		
	delete Config;
	
	deviceBox->setCurrentItem(n);
}


void preferencesWnd::devAddress_lostFocus()
{
	config *Config = new config();
	Config->setDeviceAddress( deviceBox->currentItem(), devAddress->text() );
	delete Config;
}


void preferencesWnd::pushButton3_clicked()
{
	deviceBox->setFocus();
	deviceBox->insertItem( tr( "New device" ) );
	config *Config = new config();
	Config->setDeviceName( Config->getDevicesCount(), tr( "New device" )  );
	Config->setDeviceAddress( Config->getDevicesCount(), "/dev/null"  );
	Config->setDevicesCount( Config->getDevicesCount() + 1 );	
	
	deviceBox->clear();
	for( int i=0; i<Config->getDevicesCount(); i++ ) deviceBox->insertItem( Config->getDeviceName(i) );
	deviceBox->setCurrentItem( Config->getDevicesCount() - 1 );
	deviceBox_highlighted( Config->getDevicesCount() - 1 );
	
	delete Config;
}


void preferencesWnd::pushButton4_clicked()
{
	config *Config = new config();
	for( int i=0; i<Config->getDevicesCount()-1; i++ ) if( i>=deviceBox->currentItem() )
	{
		Config->setDeviceName( i, Config->getDeviceName(i+1) );
		Config->setDeviceAddress( i, Config->getDeviceAddress(i+1) );
	}
	Config->setDevicesCount( Config->getDevicesCount() - 1 );
	
	deviceBox->clear();
	for( int i=0; i<Config->getDevicesCount(); i++ ) deviceBox->insertItem( Config->getDeviceName(i) );
	delete Config;
	
	deviceBox->setCurrentItem(0);
	deviceBox_highlighted(0);
}


void preferencesWnd::mplayer_textChanged( const QString &txt )
{
	config *Config = new config();
	Config->setMplayer( txt );
	delete Config;
}


void preferencesWnd::mencoder_textChanged( const QString &txt )
{
	config *Config = new config();
	Config->setMencoder( txt );
	delete Config;
}


void preferencesWnd::lsdvd_textChanged( const QString &txt )
{
	config *Config = new config();
	Config->setLsdvd( txt );
	delete Config;
}


void preferencesWnd::encoderBox_highlighted( int n )
{
	config *Config = new config();
	Config->setEncoderIndex(n);
	delete Config;
}
