/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

#include <kmessagebox.h>
#include "kvideoencoder_config.h"
#include "videocodec_struct.h"
#include "videofilter_struct.h"
#include "videofilter.h"
#include "mainform.h"

VideoFilterWindow *filterWnd;

void SetBackgroundImage ( QWidget *fp_widget, const QPixmap *fp_image )
{
   QPalette newPalette = fp_widget->palette ( );
   newPalette.setBrush( QColorGroup::Base, QBrush ( QPalette::Active, *fp_image ) );
   newPalette.setBrush( QColorGroup::Background, QBrush ( QPalette::Active,*fp_image ) );
   fp_widget->setPalette ( newPalette );
} 

QString getTempFileName( void )
{
	
}

void previewWnd::getFilterWnd( QWidget *wnd )
{
	filterWnd = (VideoFilterWindow*)wnd;
}

void previewWnd::pushButton15_clicked()
{	
	// Encode preview
	config *Config = new config();
	if( Config->getEncoderIndex() == 1 ) 
	{
		KMessageBox::error( this, tr("Filter preview is for transcode not avaiable yet."), "KVideoEncoder" );
		return;
	}
	
	
	QString tmpFileName = "preview";
	Form1 *f = (Form1*)parentWidget();
	
	// Prepare preview
	VideoCodec *selectedVideoCodec;
	f->getSelectedVideoCodec( selectedVideoCodec );
	VideoFilter *previewFilter = new VideoFilter();
	filterWnd->applyFilter( previewFilter, selectedVideoCodec );
	
	// Build preview
	f->encodeFile( "/tmp/" + tmpFileName, previewFrame->value(), previewFilter );
	Config->getCommand( "sh -c 'cd /tmp/ && mplayer -nosound -vo png " + tmpFileName + "'" );
	
	// Load preview	
	QPixmap *img= new QPixmap();
	img->load( "/tmp/00000001.png" );
	Config->getCommand( "sh -c 'rm /tmp/000000??.png ; rm /tmp/" + tmpFileName + "'" );

	SetBackgroundImage(preview,img);
	
	// --->
	delete Config;
}
