/* ***************************************************************************   
   * KVideoEncoder - an easy-to-use Video Encoder for KDE                    *
   * Copyright (C) 2005-2006 Philipp Ludwig                                  *
   *                                                                         *
   * This program is free software; you can redistribute it and/or modify it *
   * under the terms of the GNU General Public License as published by the   *
   * Free Software Foundation; either version 2 of the License, or (at your  *
   * option) any later version.                                              *
   *                                                                         *
   * This program is distributed in the hope that it will be useful, but     *
   * WITHOUT ANY WARRANTY; without even the implied warranty of              *
   * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        *
   * General Public License for more details.                                *
   *                                                                         *
   * You should have received a copy of the GNU General Public License along *
   * with this program; if not, write to the Free Software Foundation, Inc., *
   * 59 cmdle Place, Suite 330, Boston, MA 02111-1301, USA.                  *
   ************************************************************************* */

#include "encoder.h"
#include "kvideoencoder_config.h"
#include <kmessagebox.h>
#include <qfile.h>

QString Transcode::getWorkingMod( QString modpath, QString prefix, QString modules[])
{
	for( int i=0; i<sizeof(modules); i++) 
	{
		if( QFile( modpath + "/" + prefix + "_" + modules[i] + ".so").exists() ) return modules[i];
	}
	return "";
}

void Transcode::BuildCommandLine( void )
{
	config *Config = new config();
	cmd = Config->getCommand( "which transcode" );
	QString modpath = Config->getCommand( "tcmodinfo -p" );
		
	// Output file
	qWarning( "DEBUG: Running transcode with `which transcode`" );
	cmd += " -o '" + outputFile + "'";
	
	// Audio Direct Stream Copy?
	if( selectedAudioCodec.Codec == AUDIO_CODEC_NAME_DIRECTCOPY ) cmd += " -A";
	
	// Add the multipass logfile to the command line
	if( selectedVideoCodec.bitRateMode == BITRATE_MODE_FIRSTPASS ) cmd += " -R 1,'" + selectedVideoCodec.logfile + "','" + selectedVideoCodec.logfile + ".pcm'";
	if( selectedVideoCodec.bitRateMode == BITRATE_MODE_SECONDPASS ) cmd += " -R 2,'" + selectedVideoCodec.logfile + "','" + selectedVideoCodec.logfile + ".pcm'";
	
	// Add the bitrate
	switch( selectedVideoCodec.bitRateMode )
	{
	case BITRATE_MODE_FIRSTPASS:
	case BITRATE_MODE_SECONDPASS:
	case BITRATE_MODE_CBR:
		cmd += " -w " + QString::number( selectedVideoCodec.bitRate );
		break;
	case BITRATE_MODE_CQ:
		cmd += " -R 3 -w " + QString::number( selectedVideoCodec.constantQuantizer );
		break;	
	}
	cmd += "," + QString::number( selectedVideoCodec.keyframe_interval );
	
	qWarning( "DEBUG: I hope that you don't select multi-pass encoding." );
	qWarning( "DEBUG: That would work, but things like turbo, min./max. quantizer and vbstrategy won't." );
	
	// Add the video codec
	switch( selectedVideoCodec.Codec )
	{
	case CODEC_NAME_DIRECTCOPY:
		cmd += " -P 3 -y ac3";
		break;
	case CODEC_NAME_DIVX4:
		cmd += " -F mpeg4 -y ffmpeg";
		break;
	case CODEC_NAME_MPEG1:
	case CODEC_NAME_MPEG2:
		// Which MPEG export module is installed?
		if( QString(Config->getCommand( "ls -l `tcmodinfo -p`/export_mpeg.so" )).find("export_mpeg.so") != -1 )
		{ 
			cmd += " -y mpeg";
			switch( selectedVideoCodec.mpegType )
			{
			case 0:
				if( selectedVideoCodec.Codec == CODEC_NAME_MPEG1 ) cmd += " -F 1";
				if( selectedVideoCodec.Codec == CODEC_NAME_MPEG2 ) cmd += " -F 2";
				break;
			case 1:
				cmd += " -F v --export_prof vcd";
				break;
			case 2:
				cmd += " -F s --export_prof svcd";
				break;
			case 3: cmd += " -F d --export dvd";
				break;
			}			
		}
		else /* Try ffmpeg */
		{
			cmd += " -y ffmpeg";
			switch( selectedVideoCodec.Codec )
			{
			case CODEC_NAME_MPEG1: 
				cmd += " -F mpeg1video";
				break;
			case CODEC_NAME_MPEG2:
				cmd += " -F mpeg2video";
				break;
			}
			
			switch( selectedVideoCodec.mpegType )
			{
			case 1:
				cmd += " --export_prof vcd";
				break;
			case 2:
				cmd += " --export_prof svcd";
				break;
			case 3: 
				cmd += " --export_prof dvd";
				break;
			}
		}
		break;
	case CODEC_NAME_MJPEG:
		cmd += " -y mjpeg";
		break;
	case CODEC_NAME_WMV1:
		cmd += " -F wmv1 -y ffmpeg";
		break;
	case CODEC_NAME_WMV2:
		cmd += " -F wmv2 -y ffmpeg";
		break;
	}
	
	// Add the audio codec
	switch( selectedAudioCodec.Codec )
	{
	case AUDIO_CODEC_NAME_MP2:
	{
		// Ok, which MP2 export modul is installed?
		// This piece of code is not very nice :|
		// I'd like sth like: bla[3] = ["mpeg","mp2enc","mp2"], but that doesn't work.	
		QString bla[3];
		bla[0] = "mpeg";
		bla[1] = "mp2enc";
		bla[2] = "mp2";
		cmd += "," + getWorkingMod( modpath, "export", bla );
		cmd += " -b " + QString::number( selectedAudioCodec.bitRate );
		break;
	}
	case AUDIO_CODEC_NAME_MP3:
		cmd += ",lame -b " + QString::number( selectedAudioCodec.bitRate );
		break; 
	case AUDIO_CODEC_NAME_IMA:
		KMessageBox::error( NULL, "FIXME: Sorry, but IMA ADPCM is not supported for transcode.", "KVideoEncoder" );
		break;
	case AUDIO_CODEC_NAME_PCM:
		cmd += ",wav ";
		break;
	}
	
	// aspect
	if( (selectedVideoCodec.Codec != CODEC_NAME_DIRECTCOPY) && (selectedVideoCodec.changeAspect) )
	{
		cmd += " --export_asr ";
		switch( selectedVideoCodec.newAspectRatio )
		{
		case ASPECT_RATIO_VGA11:
			cmd += "1:1";
			break;
		case ASPECT_RATIO_PAL43:
			cmd += "4:3";
			break;
		case ASPECT_RATIO_PAL69:
			cmd += "16:9";
			break;
		case ASPECT_RATIO_OTHER:
			cmd += QString::number( selectedVideoCodec.aspectX ) + ":" + QString::number( selectedVideoCodec.aspectY );
			break;
		}
	}
	
	// audio sample rate
	if( (selectedAudioCodec.Codec != AUDIO_CODEC_NAME_DIRECTCOPY ) && ( selectedAudioCodec.changeSampleRate ) )
		cmd += " -j resample -E " + QString::number( selectedAudioCodec.newSampleRate );
	
	// Change Framerate?
	if( (selectedVideoCodec.Codec != CODEC_NAME_DIRECTCOPY) && (selectedVideoCodec.changeFrameRate) ) 
		qWarning( "FIXME: change framerate" );
	
	
	FIXME( "mencoder option dia" );
	FIXME( "mencoder option mbd" );
	FIXME( "mencoder option v4mv" );
	FIXME( "mencoder option gray" );
	
	// Input file
	FIXME( "Input file stuff" );
	cmd += " -i '" + inputFile + "'";
	
	// Clean up
	delete Config;
}

bool Transcode::RunEncoder( void )
{
	DEBUG(cmd.ascii());
	handle = popen( cmd.ascii(), "r" );	
	if( handle == NULL ) return false;
	
	// Get the pid
	config *Config = new config();
	pid = Config->getCommand( "pidof transcode" );
	if( pid.find( " " ) != -1 ) pid = pid.left( pid.find( " " ) );
	pid = pid.stripWhiteSpace();
	delete Config;
	
	return true;
}

int Transcode::GetProgress( void )
{
	int n;
	QString temp;
	char buffer[255];
	int chars_read = fread( buffer, sizeof(char), 255, handle );
	if( chars_read == 0 ) return -2;
	
	buffer[chars_read - 1] = '\0';
	temp = QString::fromLatin1(buffer);				
	n = temp.find( "encoding frames" );
	if( n != -1 )
	{
		temp = temp.mid(temp.find( "-" ) + 1,10);
		temp = temp.left(temp.find( "]" ));
		n = temp.toInt();		
	}
	
	return n;
}

int Transcode::GetFinalSize( void )
{
	return 0;
}

void Transcode::KillEncoder( void )
{
	config *Config = new config();
	Config->getCommand( "kill -9 " + pid );
	delete Config;
}
