/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

/* ***************************************************************************
   * KVideoEncoder - an easy-to-use Video Encoder for KDE                    *
   * Copyright (C) 2005-2006 Philipp Ludwig                                  *
   *                                                                         *
   * This program is free software; you can redistribute it and/or modify it *
   * under the terms of the GNU General Public License as published by the   *
   * Free Software Foundation; either version 2 of the License, or (at your  *
   * option) any later version.                                              *
   *                                                                         *
   * This program is distributed in the hope that it will be useful, but     *
   * WITHOUT ANY WARRANTY; without even the implied warranty of              *
   * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        *
   * General Public License for more details.                                *
   *                                                                         *
   * You should have received a copy of the GNU General Public License along *
   * with this program; if not, write to the Free Software Foundation, Inc., *
   * 59 Temple Place, Suite 330, Boston, MA 02111-1301, USA.                 *
   *************************************************************************** */

#include <kmessagebox.h>
#include <qfiledialog.h>
#include <math.h>
#include "videocodec_struct.h"
#include "kvideoencoder_config.h"

void VideoCodecWnd::CodecBox_activated( int )
{
	config *Config = new config();
	
	stack->raiseWidget(0);
	mpegType->setEnabled( false );
	v4mv->setEnabled( true );
	bitRateMode->setEnabled(true);
	bitRateModeBox->setEnabled(true);
	turbo->setEnabled( true );
	
	// Not every option works with every codec
	switch( CodecBox->currentItem() )
	{
	case CODEC_NAME_DIRECTCOPY:
		stack->raiseWidget(1);
		break;			
	case CODEC_NAME_MPEG1:
	case CODEC_NAME_MPEG2:
	case CODEC_NAME_MJPEG:
	case CODEC_NAME_WMV1:
	case CODEC_NAME_WMV2:
		v4mv->setEnabled( false );
		v4mv->setChecked( false );
		
		if( (CodecBox->currentItem() == CODEC_NAME_WMV1) || (CodecBox->currentItem() == CODEC_NAME_WMV2 ) )  break;
		
		// Mpeg Type
		mpegType->setCurrentItem(0);
		mpegType->setEnabled( true );
		
		// Check frame rate
		frameRateSettings->raiseWidget(1);
		if( changeFrameRate->isChecked() )
		{
			int i;
			bool found = false;
			
			// Has the user a MPEG-1 compatible frame rate selected?
			for( i=0; i<newMpegFrameRate->count(); i++ ) if( (newMpegFrameRate->text(i)) == QString::number(newFrameRate->value()) )
			{
				found = true;
				newMpegFrameRate->setCurrentItem(i);
			}
			if( found == false )
			{
				KMessageBox::information( this, tr("You have selected the Codec MPEG-1, but the frame rate that you selected before is not compatible. The new frame rate will be set to 25."), "KVideoEncoder" );
				newMpegFrameRate->setCurrentItem(2);
			}
		}
		break;
	case CODEC_NAME_XVID:		
		if( QString(Config->getCommand( Config->getMencoder() + " -ovc help" )).find( "xvid" ) == 0 )
		{
			CodecBox->setCurrentItem(1);
			KMessageBox::error( this, tr( "Your version of mencoder does not support XVid. Use DivX instead or recompile mplayer with xvid installed." ), "KVideoEncoder" );
			delete Config;
			CodecBox_activated(1);
			return;
		}
		turbo->setChecked( false );
		turbo->setEnabled( false );
		break;
	default:		
		if( frameRateSettings->id( frameRateSettings->visibleWidget() ) == 1 )
		{
			QString newFPS = newMpegFrameRate->text( newMpegFrameRate->currentItem() );
			newFrameRate->setValue( ceil(newFPS.toFloat()) );
		}
		frameRateSettings->raiseWidget(0);
	} /* switch */
	delete Config;
}

void VideoCodecWnd::changeFrameRate_clicked()
{
	frameRateSettings->setEnabled( changeFrameRate->isChecked() );
}	


void VideoCodecWnd::bitRateMode_activated( int index )
{
	bitRateModeBox->raiseWidget(index);
}


void VideoCodecWnd::keyframeInterval_valueChanged( int newValue )
{
	if( (newValue > 132) && (CodecBox->currentItem() == 1) ) 
		KMessageBox::information( this, tr("You've set the keyframe interval higher than 132,\nbut you've selected the MPEG-1 Codec that does not support this good.\nI recommend that you choose a value below 133."), "KVideoEncoder" );
}


void VideoCodecWnd::toolButton3_clicked()
{
	QString s = QFileDialog::getSaveFileName( "", tr("Log Files (*.log)"), this, tr("Choose log file destination"), tr("Choose log file destination") );
	if( s != NULL ) logFile->setText(s);
}


void VideoCodecWnd::toolButton4_clicked()
{
	QString s = QFileDialog::getOpenFileName( "", tr("Log Files (*.log)"), this, tr("Choose log file"), tr("Choose log file") );
	if( s != NULL ) secondLogFile->setText(s);
}


void VideoCodecWnd::mpegType_activated( int n )
{
	// Check the bitrate if (X)VCD is selected
	if( n == 1 ) 
	{
		KMessageBox::information( this, tr( "A (X)VCD needs constant bitrate 1152 kbps. KVideoEncoder will select the right settings for you." ), tr( "KVideoEncoder" ) );
		bitRateMode->setCurrentItem(0);
		bitRateMode_activated(0);
		bitRateMode->setEnabled(false);
		bitRateModeBox->setEnabled(false);	
		divX4BitRate->setValue(1152);
	}
	else
	{
		bitRateMode->setEnabled(true);
		bitRateModeBox->setEnabled(true);
	}
	
	// Other stuff is not supported
	KMessageBox::information( this, tr("Please note:\n\nA DVD/(X)VCD/(X)SVCD compatible MPEG stream needs a\ncertain framerate, bitrate, resolution etc.\n\nIf you select one of these types, you have to select\nthe right settings in KVideoEncoder!"), tr("KVideoEncoder Alpha warning") );
}


void VideoCodecWnd::vhq_clicked()
{
	if( (CodecBox->currentItem() == CODEC_NAME_WMV1 ) && (vhq->isChecked()) )
		KMessageBox::information( this, tr("Please note:\n\nHigh Quality encoding and WMV seems to be incompatible; it is supported, but if you select WMV and high quality encoding,\nyou will probably get a video with horrible quality."), "KVideoEncoder" );	
}


void VideoCodecWnd::comboBox6_activated( const QString & )
{
	aspectX->setEnabled( newAspect->currentItem() == ASPECT_RATIO_OTHER );
	aspectY->setEnabled( newAspect->currentItem() == ASPECT_RATIO_OTHER );
}


void VideoCodecWnd::constantQuantizer_valueChanged( int value )
{
	quantizerLabel->setText( "Quantizer: " + QString::number(value) );
}


void VideoCodecWnd::vqmax_valueChanged( int value )
{
	vqMaxLabel->setText( tr("Max quantizer")+ QString("(") + QString::number(value) + QString("):") );
}


void VideoCodecWnd::vqmin_valueChanged( int value )
{
	vqMinLabel->setText( tr("Min quantizer")+" (" + QString::number(value) + "):" );
}


void VideoCodecWnd::aspectBox_toggled( bool )
{
	comboBox6_activated( "" );
}
