/* ***************************************************************************
   * KVideoEncoder - an easy-to-use Video Encoder for KDE                    *
   * Copyright (C) 2005-2006 Philipp Ludwig                                  *
   *                                                                         *
   * This program is free software; you can redistribute it and/or modify it *
   * under the terms of the GNU General Public License as published by the   *
   * Free Software Foundation; either version 2 of the License, or (at your  *
   * option) any later version.                                              *
   *                                                                         *
   * This program is distributed in the hope that it will be useful, but     *
   * WITHOUT ANY WARRANTY; without even the implied warranty of              *
   * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        *
   * General Public License for more details.                                *
   *                                                                         *
   * You should have received a copy of the GNU General Public License along *
   * with this program; if not, write to the Free Software Foundation, Inc., *
   * 59 Temple Place, Suite 330, Boston, MA 02111-1301, USA.                 *
   *************************************************************************** */

#ifndef VIDEO_CODEC_STRUCT_H
#define VIDEO_CODEC_STRUCT_H 

#define CODEC_NAME_DIRECTCOPY 0
#define CODEC_NAME_DIVX4 1
#define CODEC_NAME_MPEG1 2
#define CODEC_NAME_MPEG2 3
#define CODEC_NAME_MJPEG 4
#define CODEC_NAME_WMV1 5
#define CODEC_NAME_WMV2 6
#define CODEC_NAME_XVID 7

#define BITRATE_MODE_CBR 0
#define BITRATE_MODE_CQ 1
#define BITRATE_MODE_FIRSTPASS 2
#define BITRATE_MODE_SECONDPASS 3

#define ASPECT_RATIO_VGA11 0
#define ASPECT_RATIO_PAL43 1
#define ASPECT_RATIO_PAL69 2
#define ASPECT_RATIO_OTHER 3

#include <qstring.h>

struct VideoCodec
{
	int Codec;	
	int keyframe_interval;
	int dia;
	bool vhq;
	bool v4mv;
	bool grayScale;
	
	bool changeFrameRate;
	float newFrameRate;
	
	int bitRateMode;
	int bitRate;
	int constantQuantizer;
	
	// 2-Pass
	int vqmax;
	int vqmin;
	int vbstrategy;
	int turbo;
	QString logfile;
	
	// Direct Stream Copy
	bool newIndex;
	int type;
	
	// MPEG Type
	ushort mpegType;
	
	// Aspect ratio
	ushort newAspectRatio;
	ushort aspectX;
	ushort aspectY;
	bool changeAspect;
	
	// Force duplicate frames to be encoded
	bool harddup;
	
	// Chapters
	int firstCpt, lastCpt;
	
	// Subtitle
	int sub;
};

#endif
