/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

/* ***************************************************************************
   * KVideoEncoder - an easy-to-use Video Encoder for KDE                    *
   * Copyright (C) 2005-2006 Philipp Ludwig                                  *
   *                                                                         *
   * This program is free software; you can redistribute it and/or modify it *
   * under the terms of the GNU General Public License as published by the   *
   * Free Software Foundation; either version 2 of the License, or (at your  *
   * option) any later version.                                              *
   *                                                                         *
   * This program is distributed in the hope that it will be useful, but     *
   * WITHOUT ANY WARRANTY; without even the implied warranty of              *
   * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        *
   * General Public License for more details.                                *
   *                                                                         *
   * You should have received a copy of the GNU General Public License along *
   * with this program; if not, write to the Free Software Foundation, Inc., *
   * 59 Temple Place, Suite 330, Boston, MA 02111-1301, USA.                 *
   *************************************************************************** */

#include <kmessagebox.h>
#include "preview.h"
#include "videofilter_struct.h"
#include "videocodec_struct.h"

previewWnd *preview;
int frames;

void VideoFilterWindow::getFrames( int n )
{
	frames = n;	
}

void VideoFilterWindow::applyFilter( void *vf, void *sc )
{
	uint i;
	
	VideoFilter *videoFilter = (VideoFilter*)vf;
	VideoCodec *selectedVideoCodec = (VideoCodec*)sc;
			
	videoFilter->noFilter = videoFilterBox->count() == 0;		
	for( i=0; i<videoFilterBox->count(); i++ )
	{			
		// Apply the settings
		if( videoFilterBox->text(i) == tr("Scale Video") )
		{	
			videoFilter->scale = new VideoFilter_scale();
			videoFilter->scale->width  = scaleWidth->value();
			videoFilter->scale->height = scaleHeight->value();
				
			if( selectedVideoCodec->Codec == CODEC_NAME_MPEG1 )
			{
				if( videoFilter->scale->width  > 4095 ) videoFilter->scale->width  = 4095;
				if( videoFilter->scale->height > 4095 ) videoFilter->scale->height = 4095;
				if( videoFilter->scale->width  < 1    ) videoFilter->scale->width  = 1;
				if( videoFilter->scale->height < 1    ) videoFilter->scale->height = 1;
			}
		}			
		if( videoFilterBox->text(i) == tr("Simple postprocessing") )
		{
			videoFilter->spp = new VideoFilter_spp();
			videoFilter->spp->quality = sppQuality->value();
		}
		if( videoFilterBox->text(i) == tr("Denoise 3D") )
		{
			videoFilter->denoise3d = new VideoFilter_denoise3d();
			videoFilter->denoise3d->hq     = denoiseHQ->isChecked();
			videoFilter->denoise3d->time   = time->value();
			videoFilter->denoise3d->chroma = chroma->value();
			videoFilter->denoise3d->luma   = luma->value();
		}
		if( videoFilterBox->text(i) == tr("Software Equalizer") )
		{
			videoFilter->eq = new VideoFilter_eq();
			videoFilter->eq->brightness = brightness->value();
			videoFilter->eq->contrast   = contrast->value();
		}
		if( videoFilterBox->text(i) == tr("Inverse telecine") )
		{
			videoFilter->filmdint = new VideoFilter_filmdint();
			videoFilter->filmdint->luma_copy = luma_copy->isChecked();
			videoFilter->filmdint->dint_thres = dint_thres->value();
			videoFilter->filmdint->fast = fast->value();
		}
		if( videoFilterBox->text(i) == tr("Crop") )
		{
			videoFilter->crop = new VideoFilter_crop();
			videoFilter->crop->width  = crop_width->value();
			videoFilter->crop->height = crop_height->value();
			videoFilter->crop->x	  = crop_x->value();
			videoFilter->crop->y      = crop_y->value();
		}
	}	
}

void VideoFilterWindow::addVideoFilterBtn_clicked()
{
	uint i;
	for( i=0; i<videoFilterBox->count(); i++ ) if( videoFilterBox->text(i) == videoFilterSelectBox->text( videoFilterSelectBox->currentItem() ) )
	{
		KMessageBox::error( this, tr("You've already added this filter!"), "KVideoEncoder" );
		return;
	}
	videoFilterBox->insertItem( videoFilterSelectBox->text( videoFilterSelectBox->currentItem() ) );
}

void VideoFilterWindow::pushButton8_clicked()
{
	if( videoFilterBox->currentItem() > -1 ) if( KMessageBox::questionYesNo( this, tr("Are you sure?"), "KVideoEncoder" ) == KMessageBox::Yes )
	{
		videoFilterBox->removeItem( videoFilterBox->currentItem() );
		videoFilterBox_clicked( NULL );
	}
}

void VideoFilterWindow::videoFilterBox_clicked( QListBoxItem *Item )
{
	if( Item != NULL )
	{
		int i;
		for( i=0; i<videoFilterSelectBox->count(); i++ ) 
			if( videoFilterSelectBox->text(i) == Item->text() ) filterSettings->raiseWidget( i + 1 );
	}
	else filterSettings->raiseWidget(0);
}

void VideoFilterWindow::brightness_valueChanged( int n )
{
	brightnessLabel->setText( tr( "Brightness" ) +  " (" + QString::number(n) + "):" );
}

void VideoFilterWindow::contrast_valueChanged( int n )
{
	contrastLabel->setText( tr( "Contrast" ) +  " (" + QString::number(n) + "):" );
}


void VideoFilterWindow::previewBtn_clicked()
{
	if( preview == NULL ) preview = new previewWnd(parentWidget());
	preview->getFilterWnd( this );
	preview->show();
	preview->previewFrame->setMaxValue( frames );
}


void VideoFilterWindow::VideoFilterWindow_destroyed( QObject * )
{
	delete preview;
}
