/* ***************************************************************************
   * KVideoEncoder - an easy-to-use Video Encoder for KDE                    *
   * Copyright (C) 2005-2006 Philipp Ludwig                                  *
   *                                                                         *
   * This program is free software; you can redistribute it and/or modify it *
   * under the terms of the GNU General Public License as published by the   *
   * Free Software Foundation; either version 2 of the License, or (at your  *
   * option) any later version.                                              *
   *                                                                         *
   * This program is distributed in the hope that it will be useful, but     *
   * WITHOUT ANY WARRANTY; without even the implied warranty of              *
   * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        *
   * General Public License for more details.                                *
   *                                                                         *
   * You should have received a copy of the GNU General Public License along *
   * with this program; if not, write to the Free Software Foundation, Inc., *
   * 59 Temple Place, Suite 330, Boston, MA 02111-1301, USA.                 *
   *************************************************************************** */

#ifndef VIDEOFILTER_STRUCT_H
#define VIDEOFILTER_STRUCT_H

#include <qobject.h>

// The single filter classes
class VideoFilter_scale
{
public:
	int width;
	int height;
	VideoFilter_scale() {;}
	~VideoFilter_scale(){;}
};

class VideoFilter_spp
{
public:
	ushort quality;
};

class VideoFilter_denoise3d
{
public:
	bool hq;
	int luma;
	int chroma;
	int time;
};

class VideoFilter_eq
{
public:
	short brightness;
	short contrast;
};

class VideoFilter_filmdint
{
public:
	short fast;
	int dint_thres;
	bool luma_copy;
};

class VideoFilter_crop
{
public:
	int width,height,x,y;
};

// This class is a container for every filter
class VideoFilter
{
public:
	bool noFilter; 
	VideoFilter_scale     *scale;
	VideoFilter_spp       *spp;
	VideoFilter_denoise3d *denoise3d;
	VideoFilter_eq        *eq;
	VideoFilter_filmdint  *filmdint;
	VideoFilter_crop      *crop;
	void destroyAllFilters()
	{
		if( scale	!= NULL ) 
		{
			delete scale;
			scale = NULL;
		}
		if( spp		!= NULL ) 
		{
			delete spp;
			spp = NULL;
		}
		if( denoise3d	!= NULL ) 
		{
			delete denoise3d;
			denoise3d = NULL;
		}
		if( eq		!= NULL )
		{
			delete eq;
			eq = NULL;
		}
		if( filmdint	!= NULL )
		{
			delete filmdint;
			filmdint = NULL;
		}
		if( crop	!= NULL )
		{
			delete crop;
			crop = NULL;
		}
	}
};

#endif
