/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "fileselector.h"

/*Constructs a new fileselector, and sets it up to the size and info we want to have
 *All images needed for displaying the status of files are preloaded*/

fileselector::fileselector(QWidget *parent=0):QListView(parent)
{
    QSize listviewsize(300,200);
    this->setSelectionMode(QListView::Extended);
    this->setRootIsDecorated(TRUE);
    this->setResizeMode(QListView::AllColumns);
    this->addColumn(i18n("directory-tree"),-1);
    this->addColumn(i18n("changed"),-1);
    this->setMinimumSize(listviewsize);
    this->setMouseTracking(TRUE);
    KIconLoader *loader=new KIconLoader("KYamo");
    QString picname;
    picname="folder.png";
    folderpic=loader->loadIcon(picname,KIcon::NoGroup);
    folderpic=folderpic.smoothScale(16,16,QImage::ScaleFree);
    picname="mime_sound.png";
    filepic=loader->loadIcon(picname,KIcon::NoGroup);
    filepic=filepic.smoothScale(16,16,QImage::ScaleFree);
    picname="flag.png";
    editedpic=loader->loadIcon(picname,KIcon::NoGroup);
    editedpic=editedpic.smoothScale(16,16,QImage::ScaleFree);
    picname="filesave.png";
    savepic=loader->loadIcon(picname,KIcon::NoGroup);
    savepic=savepic.smoothScale(16,16,QImage::ScaleFree);
    picname="ok.png";
    okpic=loader->loadIcon(picname,KIcon::NoGroup);
    okpic=okpic.smoothScale(16,16,QImage::ScaleFree);
    delete loader;
}

fileselector::~fileselector()
{}

void fileselector::setedited(fileselectoritem *editeditem)
{
    editeditem->setPixmap(1,editedpic);
    editeditem->tagchanged=TRUE;
    modifiedlist.append(editeditem);
    //find motherfolders and store saveneeded in them also
    while (editeditem=static_cast<fileselectoritem *>(editeditem->parent())
          )
    {
        editeditem->setPixmap(1,editedpic);
        editeditem->tagchanged=TRUE;
    };
}

void fileselector::setsaved(fileselectoritem *saveditem)
{
    saveditem->setPixmap(1,savepic);
    saveditem->tagchanged=FALSE;
    //remove item from modifiedlist
    modifiedlist.remove(saveditem);
    //check if any other file in the motherfolders needs saving
    bool changedtags=FALSE;
    while ((saveditem=static_cast<fileselectoritem *>(saveditem->parent()))
            &&!changedtags)
    {
        //Check all items in this dir for tagschanged-flag
        fileselectoritem *childitem=static_cast<fileselectoritem *>(saveditem->firstChild());
        if (childitem)
        {
            if (childitem->tagchanged)
            {
                changedtags=TRUE;
            }
            while((childitem=static_cast<fileselectoritem *>(childitem->nextSibling()))
                    &&!changedtags)
            {
                if (childitem->tagchanged)
                    changedtags=TRUE;
            };
        }
        if (!changedtags)
        {
            saveditem->setPixmap(1,savepic);
            saveditem->tagchanged=FALSE;
        }
    };
}

void fileselector::contentsMouseReleaseEvent(QMouseEvent *e)
{
	emit mousereleased();
}

//This is only the first directory-holder, so it does not need to do anything else than just be there
fileselectoritem::fileselectoritem(fileselector *parent,QString filetext):QListViewItem(parent,filetext)
{
    motherwidget=parent;
    isdirectory=TRUE;
    tagloaded=FALSE;
    tagchanged=FALSE;
    itemfilename=filetext;
    this->setPixmap(0,motherwidget->folderpic);
    this->setPixmap(1,motherwidget->okpic);
}

fileselectoritem::fileselectoritem(fileselectoritem *parent,QString filetext,QString filename,bool dir,fileselector *mother) :QListViewItem(parent,filetext)
{
    itemfilename=filename;
    motherwidget=mother;
    //Check if file is a directory, and set everything up for that case
    if (dir)
    {
        isdirectory=TRUE;
        tagloaded=FALSE;
        tagchanged=FALSE;
        picturepossible=FALSE;
        this->setPixmap(0,motherwidget->folderpic);
        this->setPixmap(1,motherwidget->okpic);
    }
    else
    {
        isdirectory=FALSE;
        tagloaded=FALSE;
        tagchanged=FALSE;
        picturepossible=FALSE;
        //taginfo gets loaded on selection only
        this->setPixmap(0,motherwidget->filepic);
        this->setPixmap(1,motherwidget->okpic);
    }
}

fileselectoritem::~fileselectoritem()
{}
