/***************************************************************************
 *   Copyright (C) 2006 by Roland Weigert   *
 *   roweigert@users.sourceforge.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "genrehelper.h"

extern QString genrefield[GENRECOUNT+1];

/*get genretext and give back genrenumber*/
int genrehelper(QString genretext)
{
  int genrenumber=-1;
  int index=0;
  while (genrenumber==-1&&index<=GENRECOUNT)
  {
    if (!genretext.lower().compare(genrefield[index].lower()))
      genrenumber=index;//we found the right genrenumber, so leave this searchloop
    index++;
  }
  return genrenumber;
}

/*get genrenumber out of a tag, give back a QString containing the genretext*/
QString genrehelper(int genrenumber)
{
  QString genretext=genrefield[genrenumber];
  return genretext;
}

/*init the genrefield with defined genrenumbers and belonging genretext*/
void genrehelperinit()
{
  genrefield[0]="Blues";
  genrefield[1]="Classic Rock";
  genrefield[2]="Country";
  genrefield[3]="Dance";
  genrefield[4]="Disco";
  genrefield[5]="Funk";
  genrefield[6]="Grunge";
  genrefield[7]="Hip-Hop";
  genrefield[8]="Jazz";
  genrefield[9]="Metal";
  genrefield[10]="New Age";
  genrefield[11]="Oldies";
  genrefield[12]="Other";
  genrefield[13]="Pop";
  genrefield[14]="R&B";
  genrefield[15]="Rap";
  genrefield[16]="Reggae";
  genrefield[17]="Rock";
  genrefield[18]="Techno";
  genrefield[19]="Industrial";
  genrefield[20]="Alternative";
  genrefield[21]="Ska";
  genrefield[22]="Death Metal";
  genrefield[23]="Pranks";
  genrefield[24]="Soundtrack";
  genrefield[25]="Euro-Techno";
  genrefield[26]="Ambient";
  genrefield[27]="Trip-Hop";
  genrefield[28]="Vocal";
  genrefield[29]="Jazz+Funk";
  genrefield[30]="Fusion";
  genrefield[31]="Trance";
  genrefield[32]="Classical";
  genrefield[33]="Instrumental";
  genrefield[34]="Acid";
  genrefield[35]="House";
  genrefield[36]="Game";
  genrefield[37]="Sound Clip";
  genrefield[38]="Gospel";
  genrefield[39]="Noise";
  genrefield[40]="AlternRock";
  genrefield[41]="Bass";
  genrefield[42]="Soul";
  genrefield[43]="Punk";
  genrefield[44]="Space";
  genrefield[45]="Meditative";
  genrefield[46]="Instrumental Pop";
  genrefield[47]="Instrumental Rock";
  genrefield[48]="Ethnic";
  genrefield[49]="Gothic";
  genrefield[50]="Darkwave";
  genrefield[51]="Techno-Industrial";
  genrefield[52]="Electronic";
  genrefield[53]="Pop-Folk";
  genrefield[54]="Eurodance";
  genrefield[55]="Dream";
  genrefield[56]="Southern Rock";
  genrefield[57]="Comedy";
  genrefield[58]="Cult";
  genrefield[59]="Gangsta";
  genrefield[60]="Top 40";
  genrefield[61]="Christian Rap";
  genrefield[62]="Pop/Funk";
  genrefield[63]="Jungle";
  genrefield[64]="Native American";
  genrefield[65]="Cabaret";
  genrefield[66]="New Wave";
  genrefield[67]="Psychadelic";
  genrefield[68]="Rave";
  genrefield[69]="Showtunes";
  genrefield[70]="trailer";
  genrefield[71]="Lo-Fi";
  genrefield[72]="Tribal";
  genrefield[73]="Acid Punk";
  genrefield[74]="Acid Jazz";
  genrefield[75]="Polka";
  genrefield[76]="Retro";
  genrefield[77]="Musical";
  genrefield[78]="Rock & Roll";
  genrefield[79]="Hard Rock";
//all genres from here on are not element of id3-standard, but are pseudo-standard from winamp  
  genrefield[80]="Folk";
  genrefield[81]="Folk-Rock";
  genrefield[82]="National Folk";
  genrefield[83]="Swing";
  genrefield[84]="Fast Fusion";
  genrefield[85]="Bebob";
  genrefield[86]="Latin";
  genrefield[87]="Revival";
  genrefield[88]="Celtic";
  genrefield[89]="Bluegrass";
  genrefield[90]="Avantgarde";
  genrefield[91]="Gothic Rock";
  genrefield[92]="Progressive Rock";
  genrefield[93]="Psychedelic Rock";
  genrefield[94]="Symphonic Rock";
  genrefield[95]="Slow Rock";
  genrefield[96]="Big Band";
  genrefield[97]="Chorus";
  genrefield[98]="Easy Listening";
  genrefield[99]="Acoustic";
  genrefield[100]="Humour";
  genrefield[101]="Speech";
  genrefield[102]="Chanson";
  genrefield[103]="Opera";
  genrefield[104]="Chamber Music";
  genrefield[105]="Sonata";
  genrefield[106]="Symphony";
  genrefield[107]="Booty Bass";
  genrefield[108]="Primus";//Very,very important, cause i really like primus
  genrefield[109]="Porn Groove";
  genrefield[110]="Satire";
  genrefield[111]="Slow Jam";
  genrefield[112]="Club";
  genrefield[113]="Tango";
  genrefield[114]="Samba";
  genrefield[115]="Folklore";
  genrefield[116]="Ballad";
  genrefield[117]="Power Ballad";
  genrefield[118]="Rhythmic Soul";
  genrefield[119]="Freestyle";
  genrefield[120]="Duet";
  genrefield[121]="Punk Rock";
  genrefield[122]="Drum Solo";
  genrefield[123]="Acapella";
  genrefield[124]="Euro-House";
  genrefield[125]="Dance Hall";
  genrefield[126]="Goa";
  genrefield[127]="Drum & Bass";
  genrefield[128]="Club-House";
  genrefield[129]="Hardcore";
  genrefield[130]="Terror";
  genrefield[131]="Indie";
  genrefield[132]="BritPop";
  genrefield[133]="Negerpunk";
  genrefield[134]="Polsk Punk";
  genrefield[135]="Beat";
  genrefield[136]="Christian Gangsta Rap";//Makes no sense, but seems to be standard
  genrefield[137]="Heavy Metal";
  genrefield[138]="Black Metal";
  genrefield[139]="Crossover";
  genrefield[140]="Contemporary Christian";
  genrefield[141]="Christian Rock";
  genrefield[142]="Merengue";
  genrefield[143]="Salsa";
  genrefield[144]="Thrash Metal";
  genrefield[145]="Anime";
  genrefield[146]="JPop";
  genrefield[147]="Synthpop";
//Room for more, genres to come, when lame throws out a newer genrelist
/*
  genrefield[148]="";
  genrefield[149]="";
  genrefield[150]="";
  genrefield[151]="";
  genrefield[152]="";
  genrefield[153]="";
  genrefield[154]="";
  genrefield[155]="";
  genrefield[156]="";
  genrefield[157]="";
  genrefield[158]="";
  genrefield[159]="";
  genrefield[160]="";
  genrefield[161]="";
  genrefield[162]="";
  genrefield[163]="";
  genrefield[164]="";
  genrefield[165]="";
  genrefield[166]="";
  genrefield[167]="";
  genrefield[168]="";
  genrefield[169]="";
  genrefield[170]="";
  genrefield[171]="";
  genrefield[172]="";
  genrefield[173]="";
  genrefield[174]="";
  genrefield[175]="";
  genrefield[176]="";
  genrefield[177]="";
  genrefield[178]="";
  genrefield[179]="";
  genrefield[180]="";
  genrefield[181]="";
  genrefield[182]="";
  genrefield[183]="";
  genrefield[184]="";
  genrefield[185]="";
  genrefield[186]="";
  genrefield[187]="";
  genrefield[188]="";
  genrefield[189]="";
  genrefield[190]="";
  genrefield[191]="";
  genrefield[192]="";
  genrefield[193]="";
  genrefield[194]="";
  genrefield[195]="";
  genrefield[196]="";
  genrefield[197]="";
  genrefield[198]="";
  genrefield[199]="";
  genrefield[200]="";
  genrefield[201]="";
  genrefield[202]="";
  genrefield[203]="";
  genrefield[204]="";
  genrefield[205]="";
  genrefield[206]="";
  genrefield[207]="";
  genrefield[208]="";
  genrefield[209]="";
  genrefield[210]="";
  genrefield[211]="";
  genrefield[212]="";
  genrefield[213]="";
  genrefield[214]="";
  genrefield[215]="";
  genrefield[216]="";
  genrefield[217]="";
  genrefield[218]="";
  genrefield[219]="";
  genrefield[220]="";
  genrefield[221]="";
  genrefield[222]="";
  genrefield[223]="";
  genrefield[224]="";
  genrefield[225]="";
  genrefield[226]="";
  genrefield[227]="";
  genrefield[228]="";
  genrefield[229]="";
  genrefield[230]="";
  genrefield[231]="";
  genrefield[232]="";
  genrefield[233]="";
  genrefield[234]="";
  genrefield[235]="";
  genrefield[236]="";
  genrefield[237]="";
  genrefield[238]="";
  genrefield[239]="";
  genrefield[240]="";
  genrefield[241]="";
  genrefield[242]="";
  genrefield[243]="";
  genrefield[244]="";
  genrefield[245]="";
  genrefield[246]="";
  genrefield[247]="";
  genrefield[248]="";
  genrefield[249]="";
  genrefield[250]="";
  genrefield[251]="";
  genrefield[252]="";
  genrefield[253]="";
  genrefield[254]="";
  genrefield[255]="";
*/
}
