# This file was automatically generated by SWIG (http://www.swig.org).
# Version 1.3.31
#
# Don't modify this file, modify the SWIG interface instead.
# This file is compatible with both classic and new-style classes.

"""

Loris is an Open Source sound modeling and processing software package
based on the Reassigned Bandwidth-Enhanced Additive Sound Model. Loris
supports modified resynthesis and manipulations of the model data,
such as time- and frequency-scale modification and sound morphing.


Loris is developed by Kelly Fitz and Lippold Haken at the CERL Sound
Group, and is distributed under the GNU General Public License (GPL).
For more information, please visit

   http://www.cerlsoundgroup.org/Loris/

"""

import _loris
import new
new_instancemethod = new.instancemethod
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'PySwigObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static) or hasattr(self,name):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError,name

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

import types
try:
    _object = types.ObjectType
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0
del types


class PySwigIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PySwigIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PySwigIterator, name)
    def __init__(self): raise AttributeError, "No constructor defined"
    __repr__ = _swig_repr
    __swig_destroy__ = _loris.delete_PySwigIterator
    __del__ = lambda self : None;
    def value(*args): return _loris.PySwigIterator_value(*args)
    def incr(*args): return _loris.PySwigIterator_incr(*args)
    def decr(*args): return _loris.PySwigIterator_decr(*args)
    def distance(*args): return _loris.PySwigIterator_distance(*args)
    def equal(*args): return _loris.PySwigIterator_equal(*args)
    def copy(*args): return _loris.PySwigIterator_copy(*args)
    def next(*args): return _loris.PySwigIterator_next(*args)
    def previous(*args): return _loris.PySwigIterator_previous(*args)
    def advance(*args): return _loris.PySwigIterator_advance(*args)
    def __eq__(*args): return _loris.PySwigIterator___eq__(*args)
    def __ne__(*args): return _loris.PySwigIterator___ne__(*args)
    def __iadd__(*args): return _loris.PySwigIterator___iadd__(*args)
    def __isub__(*args): return _loris.PySwigIterator___isub__(*args)
    def __add__(*args): return _loris.PySwigIterator___add__(*args)
    def __sub__(*args): return _loris.PySwigIterator___sub__(*args)
    def __iter__(self): return self
PySwigIterator_swigregister = _loris.PySwigIterator_swigregister
PySwigIterator_swigregister(PySwigIterator)

class DoubleVector(_object):
    """Proxy of C++ DoubleVector class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DoubleVector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DoubleVector, name)
    __repr__ = _swig_repr
    def iterator(*args):
        """iterator(self, PYTHON_SELF) -> PySwigIterator"""
        return _loris.DoubleVector_iterator(*args)

    def __iter__(self): return self.iterator()
    def __nonzero__(*args):
        """__nonzero__(self) -> bool"""
        return _loris.DoubleVector___nonzero__(*args)

    def __len__(*args):
        """__len__(self) -> size_type"""
        return _loris.DoubleVector___len__(*args)

    def pop(*args):
        """pop(self) -> value_type"""
        return _loris.DoubleVector_pop(*args)

    def __getslice__(*args):
        """__getslice__(self, i, j) -> DoubleVector"""
        return _loris.DoubleVector___getslice__(*args)

    def __setslice__(*args):
        """__setslice__(self, i, j, v)"""
        return _loris.DoubleVector___setslice__(*args)

    def __delslice__(*args):
        """__delslice__(self, i, j)"""
        return _loris.DoubleVector___delslice__(*args)

    def __delitem__(*args):
        """__delitem__(self, i)"""
        return _loris.DoubleVector___delitem__(*args)

    def __getitem__(*args):
        """__getitem__(self, i) -> value_type"""
        return _loris.DoubleVector___getitem__(*args)

    def __setitem__(*args):
        """__setitem__(self, i, x)"""
        return _loris.DoubleVector___setitem__(*args)

    def append(*args):
        """append(self, x)"""
        return _loris.DoubleVector_append(*args)

    def empty(*args):
        """empty(self) -> bool"""
        return _loris.DoubleVector_empty(*args)

    def size(*args):
        """size(self) -> size_type"""
        return _loris.DoubleVector_size(*args)

    def clear(*args):
        """clear(self)"""
        return _loris.DoubleVector_clear(*args)

    def swap(*args):
        """swap(self, v)"""
        return _loris.DoubleVector_swap(*args)

    def get_allocator(*args):
        """get_allocator(self) -> allocator_type"""
        return _loris.DoubleVector_get_allocator(*args)

    def begin(*args):
        """
        begin(self) -> iterator
        begin(self) -> const_iterator
        """
        return _loris.DoubleVector_begin(*args)

    def end(*args):
        """
        end(self) -> iterator
        end(self) -> const_iterator
        """
        return _loris.DoubleVector_end(*args)

    def rbegin(*args):
        """
        rbegin(self) -> reverse_iterator
        rbegin(self) -> const_reverse_iterator
        """
        return _loris.DoubleVector_rbegin(*args)

    def rend(*args):
        """
        rend(self) -> reverse_iterator
        rend(self) -> const_reverse_iterator
        """
        return _loris.DoubleVector_rend(*args)

    def pop_back(*args):
        """pop_back(self)"""
        return _loris.DoubleVector_pop_back(*args)

    def erase(*args):
        """
        erase(self, pos) -> iterator
        erase(self, first, last) -> iterator
        """
        return _loris.DoubleVector_erase(*args)

    def __init__(self, *args): 
        """
        __init__(self) -> DoubleVector
        __init__(self, ?) -> DoubleVector
        __init__(self, size) -> DoubleVector
        __init__(self, size, value) -> DoubleVector
        """
        this = _loris.new_DoubleVector(*args)
        try: self.this.append(this)
        except: self.this = this
    def push_back(*args):
        """push_back(self, x)"""
        return _loris.DoubleVector_push_back(*args)

    def front(*args):
        """front(self) -> value_type"""
        return _loris.DoubleVector_front(*args)

    def back(*args):
        """back(self) -> value_type"""
        return _loris.DoubleVector_back(*args)

    def assign(*args):
        """assign(self, n, x)"""
        return _loris.DoubleVector_assign(*args)

    def resize(*args):
        """
        resize(self, new_size)
        resize(self, new_size, x)
        """
        return _loris.DoubleVector_resize(*args)

    def insert(*args):
        """
        insert(self, pos, x) -> iterator
        insert(self, pos, n, x)
        """
        return _loris.DoubleVector_insert(*args)

    def reserve(*args):
        """reserve(self, n)"""
        return _loris.DoubleVector_reserve(*args)

    def capacity(*args):
        """capacity(self) -> size_type"""
        return _loris.DoubleVector_capacity(*args)

    __swig_destroy__ = _loris.delete_DoubleVector
    __del__ = lambda self : None;
DoubleVector_swigregister = _loris.DoubleVector_swigregister
DoubleVector_swigregister(DoubleVector)

class MarkerVector(_object):
    """Proxy of C++ MarkerVector class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MarkerVector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MarkerVector, name)
    __repr__ = _swig_repr
    def iterator(*args):
        """iterator(self, PYTHON_SELF) -> PySwigIterator"""
        return _loris.MarkerVector_iterator(*args)

    def __iter__(self): return self.iterator()
    def __nonzero__(*args):
        """__nonzero__(self) -> bool"""
        return _loris.MarkerVector___nonzero__(*args)

    def __len__(*args):
        """__len__(self) -> size_type"""
        return _loris.MarkerVector___len__(*args)

    def pop(*args):
        """pop(self) -> value_type"""
        return _loris.MarkerVector_pop(*args)

    def __getslice__(*args):
        """__getslice__(self, i, j) -> MarkerVector"""
        return _loris.MarkerVector___getslice__(*args)

    def __setslice__(*args):
        """__setslice__(self, i, j, v)"""
        return _loris.MarkerVector___setslice__(*args)

    def __delslice__(*args):
        """__delslice__(self, i, j)"""
        return _loris.MarkerVector___delslice__(*args)

    def __delitem__(*args):
        """__delitem__(self, i)"""
        return _loris.MarkerVector___delitem__(*args)

    def __getitem__(*args):
        """__getitem__(self, i) -> value_type"""
        return _loris.MarkerVector___getitem__(*args)

    def __setitem__(*args):
        """__setitem__(self, i, x)"""
        return _loris.MarkerVector___setitem__(*args)

    def append(*args):
        """append(self, x)"""
        return _loris.MarkerVector_append(*args)

    def empty(*args):
        """empty(self) -> bool"""
        return _loris.MarkerVector_empty(*args)

    def size(*args):
        """size(self) -> size_type"""
        return _loris.MarkerVector_size(*args)

    def clear(*args):
        """clear(self)"""
        return _loris.MarkerVector_clear(*args)

    def swap(*args):
        """swap(self, v)"""
        return _loris.MarkerVector_swap(*args)

    def get_allocator(*args):
        """get_allocator(self) -> allocator_type"""
        return _loris.MarkerVector_get_allocator(*args)

    def begin(*args):
        """
        begin(self) -> iterator
        begin(self) -> const_iterator
        """
        return _loris.MarkerVector_begin(*args)

    def end(*args):
        """
        end(self) -> iterator
        end(self) -> const_iterator
        """
        return _loris.MarkerVector_end(*args)

    def rbegin(*args):
        """
        rbegin(self) -> reverse_iterator
        rbegin(self) -> const_reverse_iterator
        """
        return _loris.MarkerVector_rbegin(*args)

    def rend(*args):
        """
        rend(self) -> reverse_iterator
        rend(self) -> const_reverse_iterator
        """
        return _loris.MarkerVector_rend(*args)

    def pop_back(*args):
        """pop_back(self)"""
        return _loris.MarkerVector_pop_back(*args)

    def erase(*args):
        """
        erase(self, pos) -> iterator
        erase(self, first, last) -> iterator
        """
        return _loris.MarkerVector_erase(*args)

    def __init__(self, *args): 
        """
        __init__(self) -> MarkerVector
        __init__(self, ?) -> MarkerVector
        __init__(self, size) -> MarkerVector
        __init__(self, size, value) -> MarkerVector
        """
        this = _loris.new_MarkerVector(*args)
        try: self.this.append(this)
        except: self.this = this
    def push_back(*args):
        """push_back(self, x)"""
        return _loris.MarkerVector_push_back(*args)

    def front(*args):
        """front(self) -> value_type"""
        return _loris.MarkerVector_front(*args)

    def back(*args):
        """back(self) -> value_type"""
        return _loris.MarkerVector_back(*args)

    def assign(*args):
        """assign(self, n, x)"""
        return _loris.MarkerVector_assign(*args)

    def resize(*args):
        """
        resize(self, new_size)
        resize(self, new_size, x)
        """
        return _loris.MarkerVector_resize(*args)

    def insert(*args):
        """
        insert(self, pos, x) -> iterator
        insert(self, pos, n, x)
        """
        return _loris.MarkerVector_insert(*args)

    def reserve(*args):
        """reserve(self, n)"""
        return _loris.MarkerVector_reserve(*args)

    def capacity(*args):
        """capacity(self) -> size_type"""
        return _loris.MarkerVector_capacity(*args)

    __swig_destroy__ = _loris.delete_MarkerVector
    __del__ = lambda self : None;
MarkerVector_swigregister = _loris.MarkerVector_swigregister
MarkerVector_swigregister(MarkerVector)


def channelize(*args):
  """
    channelize(partials, refFreqEnvelope, refLabel)

    Label Partials in a PartialList with the integer nearest to the
    amplitude-weighted average ratio of their frequency envelope to a
    reference frequency envelope. The frequency spectrum is
    partitioned into non-overlapping channels whose time-varying
    center frequencies track the reference frequency envelope. The
    reference label indicates which channel's center frequency is
    exactly equal to the reference envelope frequency, and other
    channels' center frequencies are multiples of the reference
    envelope frequency divided by the reference label. Each Partial in
    the PartialList is labeled with the number of the channel that
    best fits its frequency envelope. The quality of the fit is
    evaluated at the breakpoints in the Partial envelope and weighted
    by the amplitude at each breakpoint, so that high- amplitude
    breakpoints contribute more to the channel decision. Partials are
    labeled, but otherwise unmodified. In particular, their
    frequencies are not modified in any way.
    """
  return _loris.channelize(*args)

def createF0Estimate(*args):
  """
    createF0Estimate(partials, minFreq, maxFreq, interval) -> LinearEnvelope

    Return a newly-constructed LinearEnvelope that estimates
    the time-varying fundamental frequency of the sound
    represented by the Partials in a PartialList. This uses
    the experimental Fundamental class to construct an estimator
    of fundamental frequency, and returns a LinearEnvelope that
    samples the estimator at the specified time interval (in 
    seconds). Only estimates in the specified frequency range will 
    be considered valid, estimates outside this range will be 
    ignored.
    """
  return _loris.createF0Estimate(*args)

def dilate(*args):
  """
    dilate(partials, ivec, tvec)

    Dilate Partials in a PartialList according to the given initial
    and target time points. Partial envelopes are stretched and
    compressed so that temporal features at the initial time points
    are aligned with the final time points. Time points are sorted, so
    Partial envelopes are are only stretched and compressed, but
    breakpoints are not reordered. Duplicate time points are allowed.
    There must be the same number of initial and target time points.
    """
  return _loris.dilate(*args)

def exportSdif(*args):
  """
    exportSdif(path, partials)

    Export Partials in a PartialList to a SDIF file at the specified
    file path (or name). SDIF data is written in the Loris RBEP
    format. For more information about SDIF, see the SDIF website at:
    	www.ircam.fr/equipes/analyse-synthese/sdif/  
    """
  return _loris.exportSdif(*args)

def importSdif(*args):
  """
    importSdif(path) -> PartialList

    Import Partials from an SDIF file at the given file path (or
    name), and return them in a PartialList. Loris can import
    SDIF data stored in 1TRC format or in the Loris RBEP format.
    For more information about SDIF, see the SDIF website at:
    	www.ircam.fr/equipes/analyse-synthese/sdif/
    """
  return _loris.importSdif(*args)

def importSpc(*args):
  """
    importSpc(path) -> PartialList

    Import Partials from an Spc file at the given file path (or
    name), and return them in a PartialList.
    """
  return _loris.importSpc(*args)

def setAmplitudeMorphShape(*args):
  """
    setAmplitudeMorphShape(shape)

    Set the shaping parameter for the amplitude morphing
    function. This shaping parameter controls the slope of
    the amplitude morphing function, for values greater than
    1, this function gets nearly linear (like the old
    amplitude morphing function), for values much less than
    1 (e.g. 1E-5) the slope is gently curved and sounds
    pretty 'linear', for very small values (e.g. 1E-12) the
    curve is very steep and sounds un-natural because of the
    huge jump from zero amplitude to very small amplitude.

    Use LORIS_DEFAULT_AMPMORPHSHAPE to obtain the default
    amplitude morphing shape for Loris, (equal to 1E-5,
    which works well for many musical instrument morphs,
    unless Loris was compiled with the symbol
    LINEAR_AMP_MORPHS defined, in which case
    LORIS_DEFAULT_AMPMORPHSHAPE is equal to
    LORIS_LINEAR_AMPMORPHSHAPE).

    Use LORIS_LINEAR_AMPMORPHSHAPE to approximate the linear
    amplitude morphs performed by older versions of Loris.

    The amplitude shape must be positive.
    """
  return _loris.setAmplitudeMorphShape(*args)

def crop(*args):
  """
    crop(partials, t1, t2)

    Trim Partials by removing Breakpoints outside a specified time span.
    Insert a Breakpoint at the boundary when cropping occurs.

    """
  return _loris.crop(*args)

def copyLabeled(*args):
  """
    copyLabeled(partials, label) -> PartialList

    Copy Partials in the source PartialList having the specified label
    into a new PartialList. The source PartialList is unmodified.

    """
  return _loris.copyLabeled(*args)

def extractLabeled(*args):
  """
    extractLabeled(partials, label) -> PartialList

    Extract Partials in the source PartialList having the specified
    label and return them in a new PartialList.
    """
  return _loris.extractLabeled(*args)

def removeLabeled(*args):
  """
    removeLabeled(partials, label)

    Remove from a PartialList all Partials having the specified label.
    """
  return _loris.removeLabeled(*args)

def shiftTime(*args):
  """
    shiftTime(partials, offset)

    Shift the time of all the Breakpoints in a Partial by a constant
    amount (in seconds).
    """
  return _loris.shiftTime(*args)

def sortByLabel(*args):
  """
    sortByLabel(partials)

    Sort the Partials in a PartialList in order of increasing label.
    The sort is stable; Partials having the same label are not
    reordered.
    """
  return _loris.sortByLabel(*args)

def avgAmplitude(*args):
  """
    avgAmplitude(p) -> double

    Return the average amplitude over all Breakpoints in this Partial.
    Return zero if the Partial has no Breakpoints.
    """
  return _loris.avgAmplitude(*args)

def avgFrequency(*args):
  """
    avgFrequency(p) -> double

    Return the average frequency over all Breakpoints in this Partial.
    Return zero if the Partial has no Breakpoints.
    """
  return _loris.avgFrequency(*args)

def peakAmplitude(*args):
  """
    peakAmplitude(p) -> double

    Return the maximum amplitude achieved by a Partial.
    """
  return _loris.peakAmplitude(*args)

def timeSpan(*args):
  """
    timeSpan(partials, tmin_out, tmax_out)

    Return the minimum start time and maximum end time
    of all Partials in this PartialList.
    """
  return _loris.timeSpan(*args)

def weightedAvgFrequency(*args):
  """
    weightedAvgFrequency(p) -> double

    Return the average frequency over all Breakpoints in this Partial, 
    weighted by the Breakpoint amplitudes. Return zero if the Partial 
    has no Breakpoints.
    """
  return _loris.weightedAvgFrequency(*args)

def fixPhaseAfter(*args):
  """
    fixPhaseAfter(partials, time)

    Recompute phases of all Breakpoints later than the specified 
    time so that the synthesized phases of those later Breakpoints 
    matches the stored phase, as long as the synthesized phase at 
    the specified time matches the stored (not recomputed) phase.

    Phase fixing is only applied to non-null (nonzero-amplitude) 
    Breakpoints, because null Breakpoints are interpreted as phase 
    reset points in Loris. If a null is encountered, its phase is 
    corrected from its non-Null successor, if it has one, otherwise 
    it is unmodified.
    """
  return _loris.fixPhaseAfter(*args)

def fixPhaseAt(*args):
  """
    fixPhaseAt(partials, time)

    Recompute phases of all Breakpoints in a Partial
    so that the synthesized phases match the stored phases, 
    and the synthesized phase at (nearest) the specified
    time matches the stored (not recomputed) phase.

    Backward phase-fixing stops if a null (zero-amplitude) 
    Breakpoint is encountered, because nulls are interpreted as 
    phase reset points in Loris. If a null is encountered, the 
    remainder of the Partial (the front part) is fixed in the 
    forward direction, beginning at the start of the Partial. 
    Forward phase fixing is only applied to non-null 
    (nonzero-amplitude) Breakpoints. If a null is encountered, 
    its phase is corrected from its non-Null successor, if 
    it has one, otherwise it is unmodified.
    """
  return _loris.fixPhaseAt(*args)

def fixPhaseBefore(*args):
  """
    fixPhaseBefore(partials, time)

    Recompute phases of all Breakpoints earlier than the specified 
    time so that the synthesized phases of those earlier Breakpoints 
    matches the stored phase, and the synthesized phase at the 
    specified time matches the stored (not recomputed) phase.

    Backward phase-fixing stops if a null (zero-amplitude) Breakpoint
    is encountered, because nulls are interpreted as phase reset 
    points in Loris. If a null is encountered, the remainder of the 
    Partial (the front part) is fixed in the forward direction, 
    beginning at the start of the Partial.
    """
  return _loris.fixPhaseBefore(*args)

def fixPhaseBetween(*args):
  """
    fixPhaseBetween(partials, tbeg, tend)

    Fix the phase travel between two times by adjusting the
    frequency and phase of Breakpoints between those two times.

    This algorithm assumes that there is nothing interesting 
    about the phases of the intervening Breakpoints, and modifies 
    their frequencies as little as possible to achieve the correct 
    amount of phase travel such that the frequencies and phases at 
    the specified times match the stored values. The phases of all 
    the Breakpoints between the specified times are recomputed.
    """
  return _loris.fixPhaseBetween(*args)

def fixPhaseForward(*args):
  """
    fixPhaseForward(partials, tbeg, tend)

    Recompute phases of all Breakpoints later than the specified 
    time so that the synthesized phases of those later Breakpoints 
    matches the stored phase, as long as the synthesized phase at 
    the specified time matches the stored (not recomputed) phase. 
    Breakpoints later than tend are unmodified.

    Phase fixing is only applied to non-null (nonzero-amplitude) 
    Breakpoints, because null Breakpoints are interpreted as phase 
    reset points in Loris. If a null is encountered, its phase is 
    corrected from its non-Null successor, if it has one, otherwise 
    it is unmodified.
    """
  return _loris.fixPhaseForward(*args)

def version(*args):
  """
    version() -> char

    Return a string describing the Loris version number.
    """
  return _loris.version(*args)
class Marker(_object):
    """
    Class Marker represents a labeled time point in a set of Partials
    or a vector of samples. Collections of Markers (see the MarkerContainer
    definition below) are held by the File I/O classes in Loris (AiffFile,
    SdifFile, and SpcFile) to identify temporal features in imported
    and exported data.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Marker, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Marker, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> Marker
        __init__(self, t, s) -> Marker
        __init__(self, other) -> Marker

        Initialize a Marker with the specified time (in seconds) and name,
        or copy the time and name from another Marker. If unspecified, time 
        is zero and the label is empty.
        """
        this = _loris.new_Marker(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _loris.delete_Marker
    __del__ = lambda self : None;
    def name(*args):
        """
        name(self) -> char

        Return the name of this Marker.
        """
        return _loris.Marker_name(*args)

    def time(*args):
        """
        time(self) -> double

        Return the time (in seconds) associated with this Marker.
        """
        return _loris.Marker_time(*args)

    def setName(*args):
        """
        setName(self, s)

        Set the name of the Marker.
        """
        return _loris.Marker_setName(*args)

    def setTime(*args):
        """
        setTime(self, t)

        Set the time (in seconds) associated with this Marker.
        """
        return _loris.Marker_setTime(*args)

Marker_swigregister = _loris.Marker_swigregister
Marker_swigregister(Marker)

def collate(*args):
  """
    collate(partials, fadeTime=Collator::DefaultFadeTime, gapTime=Collator::DefaultSilentTime)
    collate(partials, fadeTime=Collator::DefaultFadeTime)
    collate(partials)

    Collate unlabeled (zero-labeled) Partials into the smallest-possible 
    number of Partials that does not combine any overlapping Partials.
    Collated Partials assigned labels higher than any label in the original 
    list, and appear at the end of the sequence, after all previously-labeled
    Partials. Optionally specify the fade and gap times, else default values
    are used.
    """
  return _loris.collate(*args)

def createFreqReference(*args):
  """
    createFreqReference(partials, minFreq, maxFreq, numSamps) -> LinearEnvelope
    createFreqReference(partials, minFreq, maxFreq) -> LinearEnvelope

    Return a newly-constructed LinearEnvelope that estimates
    the time-varying fundamental frequency of the sound
    represented by the Partials in a PartialList. This uses
    the Fundamental class to construct an estimator
    of fundamental frequency, and returns a LinearEnvelope that
    samples the estimator at the specified time interval (in 
    seconds). Only estimates in the specified frequency range will 
    be considered valid, estimates outside this range will be 
    ignored. The envelope will have approximately the specified 
    number of samples. If the specified number of samples is 0 or
    unspecified, the fundamental is estimated every 5 ms.
    """
  return _loris.createFreqReference(*args)

def distill(*args):
  """
    distill(partials, fadeTime=Distiller::DefaultFadeTime, gapTime=Distiller::DefaultSilentTime)
    distill(partials, fadeTime=Distiller::DefaultFadeTime)
    distill(partials)

    Distill labeled (channelized) Partials in a PartialList into a 
    PartialList containing at most one Partial per label. Unlabeled 
    (zero-labeled) Partials are left unmodified at the end of the 
    distilled Partials. Optionally specify the fade and gap times, 
    defaults are 5ms and 1ms.

    """
  return _loris.distill(*args)

def exportAiff(*args):
  """
    exportAiff(path, samples, samplerate=44100, bitsPerSamp=16, nchansignored=1)
    exportAiff(path, samples, samplerate=44100, bitsPerSamp=16)
    exportAiff(path, samples, samplerate=44100)
    exportAiff(path, samples)
    exportAiff(path, partials, samplerate=44100, bitsPerSamp=16)
    exportAiff(path, partials, samplerate=44100)
    exportAiff(path, partials)

    Export audio samples stored in a vector to an AIFF file having the
    specified number of channels and sample rate at the given file
    path (or name). The floating point samples in the vector are
    clamped to the range (-1.,1.) and converted to integers having
    bitsPerSamp bits. The default values for the sample rate and
    sample size, if unspecified, are 44100 Hz (CD quality) and 16 bits
    per sample, respectively.

    If a PartialList is specified, the Partials are rendered at the
    specified sample rate and then exported.

    Only mono files can be exported, the last argument is ignored, 
    and is included only for backward compatability
    """
  return _loris.exportAiff(*args)

def exportSpc(*args):
  """
    exportSpc(path, partials, midiPitch, enhanced, endApproachTime)
    exportSpc(path, partials, midiPitch, enhanced)
    exportSpc(path, partials, midiPitch)

    Export Partials in a PartialList to a Spc file at the specified
    file path (or name). The fractional MIDI pitch must be specified.
    The optional enhanced parameter defaults to true (for
    bandwidth-enhanced spc files), but an be specified false for
    pure-sines spc files. The optional endApproachTime parameter is in
    seconds; its default value is zero (and has no effect). A nonzero
    endApproachTime indicates that the PartialList does not include a
    release, but rather ends in a static spectrum corresponding to the
    final breakpoint values of the partials. The endApproachTime
    specifies how long before the end of the sound the amplitude,
    frequency, and bandwidth values are to be modified to make a
    gradual transition to the static spectrum.
    """
  return _loris.exportSpc(*args)

def harmonify(*args):
  """
    harmonify(partials, refLabel, env, threshold_dB)
    harmonify(partials, refLabel, threshold_dB)

    Apply a reference Partial to fix the frequencies of Breakpoints
    whose amplitude is below threshold_dB. Threshold 0 harmonifies all
    Partials. To apply only to quiet Partials, specify a lower 
    threshold (like -90). The reference Partial is the first Partial
    in the PartialList labeled refLabel (usually 1). The Envelope,
    if specified, is a time-varying weighting on the harmonifing process. 
    When 1, harmonic frequencies are used, when 0, breakpoint frequencies are 
    unmodified. 
    """
  return _loris.harmonify(*args)

def morph(*args):
  """
    morph(src0, src1, ffreq, famp, fbw) -> PartialList
    morph(src0, src1, freqweight, ampweight, bwweight) -> PartialList
    morph(src0, src1, src0RefLabel, src1RefLabel, ffreq, famp, 
        fbw) -> PartialList
    morph(src0, src1, src0RefLabel, src1RefLabel, freqweight, 
        ampweight, bwweight) -> PartialList

    Morph labeled Partials in two PartialLists according to the
    given frequency, amplitude, and bandwidth (noisiness) morphing
    envelopes, and return the morphed Partials in a PartialList.

    Optionally specify the labels of the Partials to be used as 
    reference Partial for the two morph sources. The reference 
    partial is used to compute frequencies for very low-amplitude 
    Partials whose frequency estimates are not considered reliable. 
    The reference Partial is considered to have good frequency 
    estimates throughout. A reference label of 0 indicates that 
    no reference Partial should be used for the corresponding
    morph source.

    Loris morphs Partials by interpolating frequency, amplitude,
    and bandwidth envelopes of corresponding Partials in the
    source PartialLists. For more information about the Loris
    morphing algorithm, see the Loris website:
    	www.cerlsoundgroup.org/Loris/
    """
  return _loris.morph(*args)
cvar = _loris.cvar
LORIS_DEFAULT_AMPMORPHSHAPE = cvar.LORIS_DEFAULT_AMPMORPHSHAPE
LORIS_LINEAR_AMPMORPHSHAPE = cvar.LORIS_LINEAR_AMPMORPHSHAPE

def synthesize(*args):
  """
    synthesize(partials, srate=44100.0) -> DoubleVector
    synthesize(partials) -> DoubleVector

    Synthesize Partials in a PartialList at the given sample rate, and
    return the (floating point) samples in a vector. The vector is
    sized to hold as many samples as are needed for the complete
    synthesis of all the Partials in the PartialList. If the sample
    rate is unspecified, the deault value of 44100 Hz (CD quality) is
    used.
    """
  return _loris.synthesize(*args)

def resample(*args):
  """
    resample(partials, interval, denseResampling=False, phaseCorrect=True)
    resample(partials, interval, denseResampling=False)
    resample(partials, interval)

    Resample all Partials in a PartialList using the specified
    sampling interval, so that the Breakpoints in the Partial
    envelopes will all lie on a common temporal grid. The Breakpoint
    times in resampled Partials will comprise a contiguous sequence of
    integer multiples of the sampling interval, beginning with the
    multiple nearest to the Partial's start time and ending with the
    multiple nearest to the Partial's end time. Resampling is
    performed in-place.

    If dense resampling is selected, the Breakpoint times in densely
    resampled Partials will comprise a contiguous sequence of ALL
    integer multiples of the sampling interval (very large, but useful
    for some third-party tools, like the CNMAT sinusoids~ external for
    Max/MSP). Default is sparse (not dense) resampling.

    If phase correct resampling is selected, Partial frequencies are
    altered slightly to match, as nearly as possible, the Breakpoint
    phases after resampling. Phases are updated so that the Partial
    frequencies and phases are consistent after resampling. The
    default is phase correct resampling.
    """
  return _loris.resample(*args)

def scaleAmp(*args):
  """
    scaleAmp(partials, ampEnv)
    scaleAmp(partials, val)

    Bad old name for scaleAmplitude.
    """
  return _loris.scaleAmp(*args)

def scaleAmplitude(*args):
  """
    scaleAmplitude(partials, ampEnv)
    scaleAmplitude(partials, val)

    Scale the amplitude of the Partials in a PartialList according 
    to an envelope representing a time-varying amplitude scale value.
    """
  return _loris.scaleAmplitude(*args)

def scaleBandwidth(*args):
  """
    scaleBandwidth(partials, bwEnv)
    scaleBandwidth(partials, val)

    Scale the bandwidth of the Partials in a PartialList according 
    to an envelope representing a time-varying bandwidth scale value.
    """
  return _loris.scaleBandwidth(*args)

def scaleFrequency(*args):
  """
    scaleFrequency(partials, freqEnv)
    scaleFrequency(partials, val)

    Scale the frequency of the Partials in a PartialList according 
    to an envelope representing a time-varying frequency scale value.
    """
  return _loris.scaleFrequency(*args)

def scaleNoiseRatio(*args):
  """
    scaleNoiseRatio(partials, noiseEnv)
    scaleNoiseRatio(partials, val)

    Scale the relative noise content of the Partials in a PartialList 
    according to an envelope representing a (time-varying) noise energy 
    scale value.
    """
  return _loris.scaleNoiseRatio(*args)

def setBandwidth(*args):
  """
    setBandwidth(partials, bwEnv)
    setBandwidth(partials, val)

    Set the bandwidth of the Partials in a PartialList according 
    to an envelope representing a time-varying bandwidth value.
    """
  return _loris.setBandwidth(*args)

def shapeSpectrum(*args):
  """
    shapeSpectrum(partials, surface, stretchFreq, stretchTime)
    shapeSpectrum(partials, surface)

    Scale the amplitudes of a set of Partials by applying 
    a spectral suface constructed from another set.
    If frequency and time stretch factors are specified,
    then the spectral surface is stretched by those 
    factors before the surface is used to shape the 
    Partial amplitudes.
    """
  return _loris.shapeSpectrum(*args)

def shiftPitch(*args):
  """
    shiftPitch(partials, pitchEnv)
    shiftPitch(partials, val)

    Shift the pitch of all Partials in a PartialList according to 
    the given pitch envelope. The pitch envelope is assumed to have 
    units of cents (1/100 of a halfstep).
    """
  return _loris.shiftPitch(*args)

def sift(*args):
  """
    sift(partials, fadeTime=Sieve::DefaultFadeTime)
    sift(partials)

    Eliminate overlapping Partials having the same label
    (except zero). If any two partials with same label
    overlap in time, keep only the longer of the two.
    Set the label of the shorter duration partial to zero.
    Optionally specify the fade time, default is 1ms.
    """
  return _loris.sift(*args)

class AiffFile(_object):
    """
    An AiffFile represents a sample file (on disk) in the Audio Interchange
    File Format. The file is read from disk and the samples stored in memory
    upon construction of an AiffFile instance. The samples are accessed by 
    the samples() method, which converts them to double precision floats and
    returns them in a vector.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, AiffFile, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, AiffFile, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _loris.delete_AiffFile
    __del__ = lambda self : None;
    def sampleRate(*args):
        """
        sampleRate(self) -> double

        Return the sample rate in Hz for this AiffFile.
        """
        return _loris.AiffFile_sampleRate(*args)

    def midiNoteNumber(*args):
        """
        midiNoteNumber(self) -> double

        Return the MIDI note number for this AiffFile. The defaul
        note number is 60, corresponding to middle C.
        """
        return _loris.AiffFile_midiNoteNumber(*args)

    def sampleFrames(*args):
        """
        sampleFrames(self) -> unsigned long

        Return the number of sample frames (equal to the number of samples
        in a single channel file) stored by this AiffFile.
        """
        return _loris.AiffFile_sampleFrames(*args)

    def addPartial(*args):
        """
        addPartial(self, p, fadeTime=.001)
        addPartial(self, p)

        Render the specified Partial using the (optionally) specified
        Partial fade time, and accumulate the resulting samples into
        the sample vector for this AiffFile.
        """
        return _loris.AiffFile_addPartial(*args)

    def setMidiNoteNumber(*args):
        """
        setMidiNoteNumber(self, nn)

        Set the fractional MIDI note number assigned to this AiffFile. 
        If the sound has no definable pitch, use note number 60.0 
        (the default).
        """
        return _loris.AiffFile_setMidiNoteNumber(*args)

    def write(*args):
        """
        write(self, filename, bps=16)
        write(self, filename)

        Export the sample data represented by this AiffFile to
        the file having the specified filename or path. Export
        signed integer samples of the specified size, in bits
        (8, 16, 24, or 32).
        """
        return _loris.AiffFile_write(*args)

    def __init__(self, *args): 
        """
        __init__(self, filename) -> AiffFile
        __init__(self, vec, samplerate) -> AiffFile
        __init__(self, l, sampleRate=44100, fadeTime=.001) -> AiffFile
        __init__(self, l, sampleRate=44100) -> AiffFile
        __init__(self, l) -> AiffFile

        An AiffFile instance can be initialized in any of the following ways:

        Initialize a new AiffFile from a vector of samples and sample rate.

        Initialize a new AiffFile using data read from a named file.

        Initialize an instance of AiffFile having the specified sample 
        rate, accumulating samples rendered at that sample rate from
        all Partials on the specified half-open (STL-style) range with
        the (optionally) specified Partial fade time (see Synthesizer.h
        for an examplanation of fade time). 

        """
        this = _loris.new_AiffFile(*args)
        try: self.this.append(this)
        except: self.this = this
    def samples(*args):
        """
        samples(self) -> DoubleVector

        Return a copy of the samples (as floating point numbers
        on the range -1,1) stored in this AiffFile.
        """
        return _loris.AiffFile_samples(*args)

    def channels(*args):
        """
        channels(self) -> int

        The number of channels is always 1. 
        Loris only deals in mono AiffFiles
        """
        return _loris.AiffFile_channels(*args)

    def addPartials(*args):
        """
        addPartials(self, l, fadeTime=0.001)
        addPartials(self, l)

        Render all Partials on the specified half-open (STL-style) range
        with the (optionally) specified Partial fade time (see Synthesizer.h
        for an examplanation of fade time), and accumulate the resulting 
        samples.
        """
        return _loris.AiffFile_addPartials(*args)

    def markers(*args):
        """
        markers(self) -> MarkerVector

        Return the (possibly empty) collection of Markers for 
        this AiffFile.
        """
        return _loris.AiffFile_markers(*args)

    def addMarkers(*args):
        """
        addMarkers(self, markers)

        Append a collection of Markers for to the existing
        set of Markers for this AiffFile.
        """
        return _loris.AiffFile_addMarkers(*args)

    def setMarkers(*args):
        """
        setMarkers(self, markers)

        Specify a new (possibly empty) collection of Markers for
        this AiffFile.
        """
        return _loris.AiffFile_setMarkers(*args)

AiffFile_swigregister = _loris.AiffFile_swigregister
AiffFile_swigregister(AiffFile)

class Analyzer(_object):
    """
    An Analyzer represents a configuration of parameters for
    performing Reassigned Bandwidth-Enhanced Additive Analysis
    of sampled waveforms. This analysis process yields a collection 
    of Partials, each having a trio of synchronous, non-uniformly-
    sampled breakpoint envelopes representing the time-varying 
    frequency, amplitude, and noisiness of a single bandwidth-
    enhanced sinusoid. 

    For more information about Reassigned Bandwidth-Enhanced 
    Analysis and the Reassigned Bandwidth-Enhanced Additive Sound 
    Model, refer to the Loris website: 

    	http://www.cerlsoundgroup.org/Loris/

    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Analyzer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Analyzer, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, resolutionHz) -> Analyzer
        __init__(self, resolutionHz, windowWidthHz) -> Analyzer
        __init__(self, another) -> Analyzer

        Construct and return a new Analyzer configured with the given	
        frequency resolution (minimum instantaneous frequency	
        difference between Partials) and analysis window main 
        lobe width (between zeros). All other Analyzer parameters 	
        are computed from the specified resolution and window
        width. If the window width is not specified, 
        then it is set to twice the resolution.

        An Analyzer configuration can also be copied from another
        instance.
        """
        this = _loris.new_Analyzer(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _loris.delete_Analyzer
    __del__ = lambda self : None;
    def analyze(*args):
        """
        analyze(self, vec, srate) -> PartialList
        analyze(self, vec, srate, env) -> PartialList

        Analyze a vector of (mono) samples at the given sample rate 	  	
        (in Hz) and return the resulting Partials in a PartialList.
        If specified, use a frequency envelope as a fundamental reference for
        Partial formation.
        """
        return _loris.Analyzer_analyze(*args)

    def ampFloor(*args):
        """
        ampFloor(self) -> double

        Return the amplitude floor (lowest detected spectral amplitude),              
        in (negative) dB, for this Analyzer.
        """
        return _loris.Analyzer_ampFloor(*args)

    def cropTime(*args):
        """
        cropTime(self) -> double

        Return the crop time (maximum temporal displacement of a time-
        frequency data point from the time-domain center of the analysis
        window, beyond which data points are considered "unreliable")
        for this Analyzer.
        """
        return _loris.Analyzer_cropTime(*args)

    def freqDrift(*args):
        """
        freqDrift(self) -> double

        Return the maximum allowable frequency difference between                     
        consecutive Breakpoints in a Partial envelope for this Analyzer.
        """
        return _loris.Analyzer_freqDrift(*args)

    def freqFloor(*args):
        """
        freqFloor(self) -> double

        Return the frequency floor (minimum instantaneous Partial                  
        frequency), in Hz, for this Analyzer.
        """
        return _loris.Analyzer_freqFloor(*args)

    def freqResolution(*args):
        """
        freqResolution(self) -> double

        Return the frequency resolution (minimum instantaneous frequency          
        difference between Partials) for this Analyzer.
        """
        return _loris.Analyzer_freqResolution(*args)

    def hopTime(*args):
        """
        hopTime(self) -> double

        Return the hop time (which corresponds approximately to the 
        average density of Partial envelope Breakpoint data) for this 
        Analyzer.
        """
        return _loris.Analyzer_hopTime(*args)

    def sidelobeLevel(*args):
        """
        sidelobeLevel(self) -> double

        Return the sidelobe attenutation level for the Kaiser analysis window in
        positive dB. Higher numbers (e.g. 90) give very good sidelobe 
        rejection but cause the window to be longer in time. Smaller 
        numbers raise the level of the sidelobes, increasing the likelihood
        of frequency-domain interference, but allow the window to be shorter
        in time.
        """
        return _loris.Analyzer_sidelobeLevel(*args)

    def windowWidth(*args):
        """
        windowWidth(self) -> double

        Return the frequency-domain main lobe width (measured between 
        zero-crossings) of the analysis window used by this Analyzer.
        """
        return _loris.Analyzer_windowWidth(*args)

    def setAmpFloor(*args):
        """
        setAmpFloor(self, x)

        Set the amplitude floor (lowest detected spectral amplitude), in              
        (negative) dB, for this Analyzer.
        """
        return _loris.Analyzer_setAmpFloor(*args)

    def setBwRegionWidth(*args):
        """
        setBwRegionWidth(self, x)

        Deprecated, use storeResidueBandwidth instead.
        """
        return _loris.Analyzer_setBwRegionWidth(*args)

    def setCropTime(*args):
        """
        setCropTime(self, x)

        Set the crop time (maximum temporal displacement of a time-
        frequency data point from the time-domain center of the analysis
        window, beyond which data points are considered "unreliable")
        for this Analyzer.
        """
        return _loris.Analyzer_setCropTime(*args)

    def setFreqDrift(*args):
        """
        setFreqDrift(self, x)

        Set the maximum allowable frequency difference between                     
        consecutive Breakpoints in a Partial envelope for this Analyzer.
        """
        return _loris.Analyzer_setFreqDrift(*args)

    def setFreqFloor(*args):
        """
        setFreqFloor(self, x)

        Set the amplitude floor (minimum instantaneous Partial                  
        frequency), in Hz, for this Analyzer.
        """
        return _loris.Analyzer_setFreqFloor(*args)

    def setFreqResolution(*args):
        """
        setFreqResolution(self, x)

        Set the frequency resolution (minimum instantaneous frequency          
        difference between Partials) for this Analyzer. (Does not cause     
        other parameters to be recomputed.)
        """
        return _loris.Analyzer_setFreqResolution(*args)

    def setHopTime(*args):
        """
        setHopTime(self, x)

        Set the hop time (which corresponds approximately to the average
        density of Partial envelope Breakpoint data) for this Analyzer.
        """
        return _loris.Analyzer_setHopTime(*args)

    def setSidelobeLevel(*args):
        """
        setSidelobeLevel(self, x)

        Set the sidelobe attenutation level for the Kaiser analysis window in
        positive dB. Larger numbers (e.g. 90) give very good sidelobe 
        rejection but cause the window to be longer in time. Smaller 
        numbers raise the level of the sidelobes, increasing the likelihood
        of frequency-domain interference, but allow the window to be shorter
        in time.
        """
        return _loris.Analyzer_setSidelobeLevel(*args)

    def setWindowWidth(*args):
        """
        setWindowWidth(self, x)

        Set the frequency-domain main lobe width (measured between 
        zero-crossings) of the analysis window used by this Analyzer.
        """
        return _loris.Analyzer_setWindowWidth(*args)

    def storeResidueBandwidth(*args):
        """
        storeResidueBandwidth(self, regionWidth=Analyzer::Default_ResidueBandwidth_RegionWidth)
        storeResidueBandwidth(self)

        Construct Partial bandwidth envelopes during analysis
        by associating residual energy in the spectrum (after
        peak extraction) with the selected spectral peaks that
        are used to construct Partials. 

        regionWidth is the width (in Hz) of the bandwidth 
        association regions used by this process, must be positive.
        If unspecified, a default value is used.
        """
        return _loris.Analyzer_storeResidueBandwidth(*args)

    def storeConvergenceBandwidth(*args):
        """
        storeConvergenceBandwidth(self, tolerance=0.01*Analyzer::Default_ConvergenceBandwidth_TolerancePct)
        storeConvergenceBandwidth(self)

        Construct Partial bandwidth envelopes during analysis
        by storing the mixed derivative of short-time phase, 
        scaled and shifted so that a value of 0 corresponds
        to a pure sinusoid, and a value of 1 corresponds to a
        bandwidth-enhanced sinusoid with maximal energy spread
        (minimum sinusoidal convergence).

        tolerance is the amount of range over which the 
        mixed derivative indicator should be allowed to drift away 
        from a pure sinusoid before saturating. This range is mapped
        to bandwidth values on the range [0,1]. Must be positive and 
        not greater than 1. If unspecified, a default value is used.
        """
        return _loris.Analyzer_storeConvergenceBandwidth(*args)

    def storeNoBandwidth(*args):
        """
        storeNoBandwidth(self)

        Disable bandwidth envelope construction. Bandwidth 
        will be zero for all Breakpoints in all Partials.
        """
        return _loris.Analyzer_storeNoBandwidth(*args)

    def bandwidthIsResidue(*args):
        """
        bandwidthIsResidue(self) -> bool

        Return true if this Analyzer is configured to compute
        bandwidth envelopes using the spectral residue after
        peaks have been identified, and false otherwise.
        """
        return _loris.Analyzer_bandwidthIsResidue(*args)

    def bandwidthIsConvergence(*args):
        """
        bandwidthIsConvergence(self) -> bool

        Return true if this Analyzer is configured to compute
        bandwidth envelopes using the mixed derivative convergence
        indicator, and false otherwise.
        """
        return _loris.Analyzer_bandwidthIsConvergence(*args)

    def bwRegionWidth(*args):
        """
        bwRegionWidth(self) -> double

        Return the width (in Hz) of the Bandwidth Association regions
        used by this Analyzer, only if the spectral residue method is
        used to compute bandwidth envelopes. Return zero if the mixed
        derivative method is used, or if no bandwidth is computed.
        """
        return _loris.Analyzer_bwRegionWidth(*args)

    def bwConvergenceTolerance(*args):
        """
        bwConvergenceTolerance(self) -> double

        Return the mixed derivative convergence tolerance
        only if the convergence indicator is used to compute
        bandwidth envelopes. Return zero if the spectral residue
        method is used or if no bandwidth is computed.
        """
        return _loris.Analyzer_bwConvergenceTolerance(*args)

    def fundamentalEnv(*args):
        """
        fundamentalEnv(self) -> LinearEnvelope

        Return the fundamental frequency estimate envelope constructed
        during the most recent analysis performed by this Analyzer.
        Will be empty unless buildFundamentalEnv was invoked to enable the
        construction of this envelope during analysis.
        """
        return _loris.Analyzer_fundamentalEnv(*args)

    def buildFundamentalEnv(*args):
        """
        buildFundamentalEnv(self, TF=True)
        buildFundamentalEnv(self)
        buildFundamentalEnv(self, fmin, fmax, threshDb=-60, threshHz=8000)
        buildFundamentalEnv(self, fmin, fmax, threshDb=-60)
        buildFundamentalEnv(self, fmin, fmax)

        Configure the fundamental frequency estimator.

        fmin is the lower bound on the fundamental frequency estimate.
        fmax is the upper bound on the fundamental frequency estimate
        threshDb is the lower bound on the amplitude of a spectral peak
        that will constribute to the fundamental frequency estimate (very
        low amplitude peaks tend to have less reliable frequency estimates).
        Default is -60 dB.
        threshHz is the upper bound on the frequency of a spectral
        peak that will constribute to the fundamental frequency estimate.
        Default is 8 kHz.

        The fundamental frequency estimate can be accessed by
        fundamentalEnv() after the analysis is complete.

        """
        return _loris.Analyzer_buildFundamentalEnv(*args)

    def ampEnv(*args):
        """
        ampEnv(self) -> LinearEnvelope

        Return the overall amplitude estimate envelope constructed
        during the most recent analysis performed by this Analyzer.
        Will be empty unless buildAmpEnv was invoked to enable the
        construction of this envelope during analysis.
        """
        return _loris.Analyzer_ampEnv(*args)

    def buildAmpEnv(*args):
        """
        buildAmpEnv(self, TF=True)
        buildAmpEnv(self)

        Legacy support, do not use. The amplitude envelope
        is always estimated.
        """
        return _loris.Analyzer_buildAmpEnv(*args)

Analyzer_swigregister = _loris.Analyzer_swigregister
Analyzer_swigregister(Analyzer)

class Envelope(_object):
    """
    Envelope is an abstract base class for all time-varying envelopes
    and parameters, representing a single-valued funtion of one variable
    (usually time).
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Envelope, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Envelope, name)
    def __init__(self): raise AttributeError, "No constructor defined"
    __repr__ = _swig_repr
    def Envelope(*args):
        """
        Envelope(self, other) -> Envelope

        Envelope is an abstract base class for all time-varying envelopes
        and parameters, representing a single-valued funtion of one variable
        (usually time).
        """
        return _loris.Envelope_Envelope(*args)

    __swig_destroy__ = _loris.delete_Envelope
    __del__ = lambda self : None;
Envelope_swigregister = _loris.Envelope_swigregister
Envelope_swigregister(Envelope)

class LinearEnvelope(Envelope):
    """
    A LinearEnvelope represents a linear segment breakpoint 
    function with infinite extension at each end (that is, the 
    values past either end of the breakpoint function have the 
    values at the nearest end).
    """
    __swig_setmethods__ = {}
    for _s in [Envelope]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearEnvelope, name, value)
    __swig_getmethods__ = {}
    for _s in [Envelope]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearEnvelope, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> LinearEnvelope
        __init__(self, ?) -> LinearEnvelope
        __init__(self, initialValue) -> LinearEnvelope

        Construct and return a new LinearEnvelope, empty,
        or having a single breakpoint at time 0 with the 
        specified value.

        An LinearEnvelope can also be copied from another
        instance.
        """
        this = _loris.new_LinearEnvelope(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _loris.delete_LinearEnvelope
    __del__ = lambda self : None;
    def insertBreakpoint(*args):
        """
        insertBreakpoint(self, time, value)

        Insert a new breakpoint into the envelope at the specified
        time and value.
        """
        return _loris.LinearEnvelope_insertBreakpoint(*args)

    def insert(*args):
        """
        insert(self, time, value)

        Insert a new breakpoint into the envelope at the specified
        time and value.
        """
        return _loris.LinearEnvelope_insert(*args)

    def valueAt(*args):
        """
        valueAt(self, x) -> double

        Return the (linearly-interpolated) value of the envelope
        at the specified time.
        """
        return _loris.LinearEnvelope_valueAt(*args)

    def __iadd__(*args):
        """
        __iadd__(self, offset) -> LinearEnvelope

        Add a constant value to this LinearEnvelope and return a reference
        to self.
        """
        return _loris.LinearEnvelope___iadd__(*args)

    def __isub__(*args):
        """
        __isub__(self, offset) -> LinearEnvelope

        Subtract a constant value from this LinearEnvelope and return a reference
        to self.
        """
        return _loris.LinearEnvelope___isub__(*args)

    def __imul__(*args):
        """
        __imul__(self, scale) -> LinearEnvelope

        Scale this LinearEnvelope by a constant value and return a reference
        to self.
        """
        return _loris.LinearEnvelope___imul__(*args)

    def __idiv__(*args):
        """__idiv__(self, div) -> LinearEnvelope"""
        return _loris.LinearEnvelope___idiv__(*args)

    def __add__(*args):
        """
        __add__(self, offset) -> LinearEnvelope

        Add a constant value to a LinearEnvelope and return a new 
        LinearEnvelope.
        """
        return _loris.LinearEnvelope___add__(*args)

    def __sub__(*args):
        """
        __sub__(self, offset) -> LinearEnvelope

        Subtract a constant value from a LinearEnvelope and return a new 
        LinearEnvelope.
        """
        return _loris.LinearEnvelope___sub__(*args)

    def __mul__(*args):
        """
        __mul__(self, scale) -> LinearEnvelope

        Scale a LinearEnvelope by a constant value and return a new 
        LinearEnvelope.
        """
        return _loris.LinearEnvelope___mul__(*args)

    def __div__(*args):
        """
        __div__(self, div) -> LinearEnvelope

        Divide a LinearEnvelope by a constant value and return a new 
        LinearEnvelope.
        """
        return _loris.LinearEnvelope___div__(*args)

LinearEnvelope_swigregister = _loris.LinearEnvelope_swigregister
LinearEnvelope_swigregister(LinearEnvelope)


def BreakpointEnvelopeWithValue(*args):
  """
    BreakpointEnvelopeWithValue(initialValue) -> LinearEnvelope

    BreakpointEnvelopeWithValue is deprecated, use LinearEnvelope instead.
    """
  return _loris.BreakpointEnvelopeWithValue(*args)
class SdifFile(_object):
    """
    Class SdifFile represents reassigned bandwidth-enhanced Partial 
    data in a SDIF-format data file. Construction of an SdifFile 
    from a stream or filename automatically imports the Partial
    data.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SdifFile, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SdifFile, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _loris.delete_SdifFile
    __del__ = lambda self : None;
    def write(*args):
        """
        write(self, path)

        Export the Partials represented by this SdifFile to
        the file having the specified filename or path.
        """
        return _loris.SdifFile_write(*args)

    def write1TRC(*args):
        """
        write1TRC(self, path)

        Export the envelope Partials represented by this SdifFile to
        the file having the specified filename or path in the 1TRC
        format, resampled, and without phase or bandwidth information.
        """
        return _loris.SdifFile_write1TRC(*args)

    def __init__(self, *args): 
        """
        __init__(self, filename) -> SdifFile
        __init__(self) -> SdifFile
        __init__(self, l) -> SdifFile

        Initialize an instance of SdifFile by importing Partial data from
        the file having the specified filename or path, 
        or initialize an instance of SdifFile storing the Partials in
        the specified PartialList. If no PartialList is specified,
        construct an empty SdifFile.
        """
        this = _loris.new_SdifFile(*args)
        try: self.this.append(this)
        except: self.this = this
    def partials(*args):
        """
        partials(self) -> PartialList

        Return a copy of the Partials represented by this SdifFile.
        """
        return _loris.SdifFile_partials(*args)

    def addPartials(*args):
        """
        addPartials(self, l)

        Add all the Partials in a PartialList to this SdifFile.
        """
        return _loris.SdifFile_addPartials(*args)

    def markers(*args):
        """
        markers(self) -> MarkerVector

        Return the (possibly empty) collection of Markers for 
        this SdifFile.
        """
        return _loris.SdifFile_markers(*args)

    def addMarkers(*args):
        """
        addMarkers(self, markers)

        Append a collection of Markers for to the existing
        set of Markers for this SdifFile.
        """
        return _loris.SdifFile_addMarkers(*args)

    def setMarkers(*args):
        """
        setMarkers(self, markers)

        Specify a new (possibly empty) collection of Markers for
        this SdifFile.
        """
        return _loris.SdifFile_setMarkers(*args)

SdifFile_swigregister = _loris.SdifFile_swigregister
SdifFile_swigregister(SdifFile)

def BreakpointEnvelope(*args):
  """
    BreakpointEnvelope(?) -> LinearEnvelope
    BreakpointEnvelope(rhs) -> LinearEnvelope
    BreakpointEnvelope(initialValue) -> LinearEnvelope

    BreakpointEnvelope is deprecated, use LinearEnvelope instead.
    """
  return _loris.BreakpointEnvelope(*args)

class SpcFile(_object):
    """
    Class SpcFile represents a collection of reassigned bandwidth-enhanced
    Partial data in a SPC-format envelope stream data file, used by the
    real-time bandwidth-enhanced additive synthesizer implemented on the
    Symbolic Sound Kyma Sound Design Workstation. Class SpcFile manages 
    file I/O and conversion between Partials and envelope parameter streams.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpcFile, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SpcFile, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _loris.delete_SpcFile
    __del__ = lambda self : None;
    def sampleRate(*args):
        """
        sampleRate(self) -> double

        Return the sample rate for this SpcFile in Hz.
        """
        return _loris.SpcFile_sampleRate(*args)

    def midiNoteNumber(*args):
        """midiNoteNumber(self) -> double"""
        return _loris.SpcFile_midiNoteNumber(*args)

    def addPartial(*args):
        """
        addPartial(self, p)
        addPartial(self, p, label)

        Add the specified Partial to the enevelope parameter streams
        represented by this SpcFile. If a label is specified, use that
        label, instead of the Partial's label, for the Partial added to
        the SpcFile.

        A SpcFile can contain only one Partial having any given (non-zero) 
        label, so an added Partial will replace a Partial having the 
        same label, if such a Partial exists.

        This may throw an InvalidArgument exception if an attempt is made
        to add unlabeled Partials, or Partials labeled higher than the
        allowable maximum.   

        """
        return _loris.SpcFile_addPartial(*args)

    def setMidiNoteNumber(*args):
        """
        setMidiNoteNumber(self, nn)

        Set the fractional MIDI note number assigned to this SpcFile. 
        If the sound has no definable pitch, use note number 60.0 (the default).
        """
        return _loris.SpcFile_setMidiNoteNumber(*args)

    def setSampleRate(*args):
        """
        setSampleRate(self, rate)

        Set the sampling freqency in Hz for the spc data in this
        SpcFile. This is the rate at which Kyma must be running to ensure
        proper playback of bandwidth-enhanced Spc data.
        The default sample rate is 44100 Hz.
        """
        return _loris.SpcFile_setSampleRate(*args)

    def write(*args):
        """
        write(self, filename, enhanced=True, endApproachTime=0)
        write(self, filename, enhanced=True)
        write(self, filename)

        Export the envelope parameter streams represented by this SpcFile to
        the file having the specified filename or path. Export phase-correct 
        bandwidth-enhanced envelope parameter streams if enhanced is true 
        (the default), or pure sinsoidal streams otherwise.

        A nonzero endApproachTime indicates that the Partials do not include a
        release or decay, but rather end in a static spectrum corresponding to the
        final Breakpoint values of the partials. The endApproachTime specifies how
        long before the end of the sound the amplitude, frequency, and bandwidth
        values are to be modified to make a gradual transition to the static spectrum.

        If the endApproachTime is not specified, it is assumed to be zero, 
        corresponding to Partials that decay or release normally.
        """
        return _loris.SpcFile_write(*args)

    def __init__(self, *args): 
        """
        __init__(self, filename) -> SpcFile
        __init__(self, midiNoteNum=60) -> SpcFile
        __init__(self) -> SpcFile
        __init__(self, l, midiNoteNum=60) -> SpcFile
        __init__(self, l) -> SpcFile

        Construct and return a new SpcFile by importing envelope parameter 
        streams from the file having the specified filename or path, 
        or initialize an instance of SpcFile having the specified fractional
        MIDI note number. If a PartialList is specified, add those
        Partials to the file. Otherwise, the new SpcFile contains 
        no Partials (or envelope parameter streams).
        The default MIDI note number is 60 (middle C).
        """
        this = _loris.new_SpcFile(*args)
        try: self.this.append(this)
        except: self.this = this
    def partials(*args):
        """
        partials(self) -> PartialList

        Return a copy of the Partials represented by this SdifFile.
        """
        return _loris.SpcFile_partials(*args)

    def addPartials(*args):
        """
        addPartials(self, l)

        Add all the Partials in a PartialList to this SpcFile.
        			
        A SpcFile can contain only one Partial having any given (non-zero) 
        label, so an added Partial will replace a Partial having the 
        same label, if such a Partial exists.

        This may throw an InvalidArgument exception if an attempt is made
        to add unlabeled Partials, or Partials labeled higher than the
        allowable maximum.
        """
        return _loris.SpcFile_addPartials(*args)

    def markers(*args):
        """
        markers(self) -> MarkerVector

        Return the (possibly empty) collection of Markers for 
        this SpcFile.
        """
        return _loris.SpcFile_markers(*args)

    def addMarkers(*args):
        """
        addMarkers(self, markers)

        Append a collection of Markers for to the existing
        set of Markers for this SpcFile.
        """
        return _loris.SpcFile_addMarkers(*args)

    def setMarkers(*args):
        """
        setMarkers(self, markers)

        Specify a new (possibly empty) collection of Markers for
        this SpcFile.
        """
        return _loris.SpcFile_setMarkers(*args)

SpcFile_swigregister = _loris.SpcFile_swigregister
SpcFile_swigregister(SpcFile)

class PartialListIterator(_object):
    """
    An iterator over a PartialList. Access Partials
    in a PartialList by invoking next until atEnd 
    returns true.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PartialListIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PartialListIterator, name)
    def __init__(self): raise AttributeError, "No constructor defined"
    __repr__ = _swig_repr
    __swig_destroy__ = _loris.delete_PartialListIterator
    __del__ = lambda self : None;
    def atEnd(*args):
        """
        atEnd(self) -> bool

        Return true if there are no more Partials in the PartialList.
        """
        return _loris.PartialListIterator_atEnd(*args)

    def next(*args):
        """
        next(self) -> Partial

        Return the next Partial in the PartialList that has not yet
        been returned by this iterator.
        """
        return _loris.PartialListIterator_next(*args)

PartialListIterator_swigregister = _loris.PartialListIterator_swigregister
PartialListIterator_swigregister(PartialListIterator)

class PartialIterator(_object):
    """Proxy of C++ PartialIterator class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PartialIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PartialIterator, name)
    def __init__(self): raise AttributeError, "No constructor defined"
    __repr__ = _swig_repr
    __swig_destroy__ = _loris.delete_PartialIterator
    __del__ = lambda self : None;
    def atEnd(*args):
        """
        atEnd(self) -> bool

        Return true if there are no more Breakpoints in the Partial.
        """
        return _loris.PartialIterator_atEnd(*args)

    def next(*args):
        """
        next(self) -> BreakpointPosition

        Return the next Breakpoint in the Partial that has not yet
        been returned by this iterator.
        """
        return _loris.PartialIterator_next(*args)

PartialIterator_swigregister = _loris.PartialIterator_swigregister
PartialIterator_swigregister(PartialIterator)

class PartialList(_object):
    """
    A PartialList represents a collection of Bandwidth-Enhanced 
    Partials, each having a trio of synchronous, non-uniformly-
    sampled breakpoint envelopes representing the time-varying 
    frequency, amplitude, and noisiness of a single bandwidth-
    enhanced sinusoid.

    For more information about Bandwidth-Enhanced Partials and the  
    Reassigned Bandwidth-Enhanced Additive Sound Model, refer to
    the Loris website: www.cerlsoundgroup.org/Loris/
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PartialList, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PartialList, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> PartialList
        __init__(self, rhs) -> PartialList

        Construct a new empty PartialList, or a PartialList
        that is a copy of another (containing identical copies
        of the Partials in another).
        """
        this = _loris.new_PartialList(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _loris.delete_PartialList
    __del__ = lambda self : None;
    def clear(*args):
        """
        clear(self)

        Remove all the Partials from this PartialList.
        """
        return _loris.PartialList_clear(*args)

    def size(*args):
        """
        size(self) -> unsigned long

        Return the number of Partials in this PartialList.
        """
        return _loris.PartialList_size(*args)

    def iterator(*args):
        """
        iterator(self) -> PartialListIterator

        Return an iterator on the Partials in this PartialList.
        """
        return _loris.PartialList_iterator(*args)

    def __iter__(*args):
        """
        __iter__(self) -> PartialListIterator

        Return an iterator on the Partials in this PartialList.
        """
        return _loris.PartialList___iter__(*args)

    def __len__(*args):
        """
        __len__(self) -> unsigned long

        Return the number of Partials in this PartialList.
        """
        return _loris.PartialList___len__(*args)

    def append(*args):
        """
        append(self, partial)
        append(self, other)

        Append a copy of a Partial, or copies of all the Partials in
        another PartialList, to this PartialList.
        """
        return _loris.PartialList_append(*args)

    def remove(*args):
        """
        remove(self, partial)

        Remove the specified Partial from this PartialList. An
        exception is raised if the specified Partial is not a member
        of this PartialList. The Partial itself must be a member, not
        merely identical to a Partial in this PartialList.
        """
        return _loris.PartialList_remove(*args)

    def first(*args):
        """
        first(self) -> Partial

        Return the first Partial this PartialList, or 0 if this
        PartialList is empty.
        """
        return _loris.PartialList_first(*args)

    def last(*args):
        """
        last(self) -> Partial

        Return the last Partial this PartialList, or 0 if this
        PartialList is empty.
        """
        return _loris.PartialList_last(*args)

    def copy(*args):
        """
        copy(self) -> PartialList

        Construct a new a PartialList that is a copy of 
        another (containing identical copies of the Partials 
        in another). 

        This member is deprecated, use the normal copy constructor:
           plist_copy = PartialList( plist )

        """
        return _loris.PartialList_copy(*args)

PartialList_swigregister = _loris.PartialList_swigregister
PartialList_swigregister(PartialList)

class Partial(_object):
    """
    A Partial represents a single component in the
    reassigned bandwidth-enhanced additive model. A Partial
    consists of a chain of Breakpoints describing the
    time-varying frequency, amplitude, and bandwidth (or
    noisiness) envelopes of the component, and a 4-byte
    label. The Breakpoints are non-uniformly distributed in
    time. For more information about Reassigned
    Bandwidth-Enhanced Analysis and the Reassigned
    Bandwidth-Enhanced Additive Sound Model, refer to the
    Loris website: 
        www.cerlsoundgroup.org/Loris/

    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Partial, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Partial, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> Partial
        __init__(self, ?) -> Partial

        Construct a new empty Partial, having no Breakpoints,
        or a Partial that is a copy of another (containing
        identical of the Breakpoints in another).
        """
        this = _loris.new_Partial(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _loris.delete_Partial
    __del__ = lambda self : None;
    def label(*args):
        """
        label(self) -> int

        Return the label (an integer) for this Partial. The
        default label is 0.
        """
        return _loris.Partial_label(*args)

    def initialPhase(*args):
        """
        initialPhase(self) -> double

        Return the starting phase (in radians) for this
        Partial. An exception is raised if there are no
        Breakpoints in this Partial.
        """
        return _loris.Partial_initialPhase(*args)

    def startTime(*args):
        """
        startTime(self) -> double

        Return the time (in seconds) of the first Breakpoint in
        this Partial. An exception is raised if there are no
        Breakpoints in this Partial.
        """
        return _loris.Partial_startTime(*args)

    def endTime(*args):
        """
        endTime(self) -> double

        Return the time (in seconds) of the last Breakpoint in
        this Partial. An exception is raised if there are no
        Breakpoints in this Partial.
        """
        return _loris.Partial_endTime(*args)

    def duration(*args):
        """
        duration(self) -> double

        Return the difference in time (in seconds) between the 
        first and last Breakpoints in this Partial.
        """
        return _loris.Partial_duration(*args)

    def numBreakpoints(*args):
        """
        numBreakpoints(self) -> long

        Return the number of Breakpoints in this Partial.
        """
        return _loris.Partial_numBreakpoints(*args)

    def setLabel(*args):
        """
        setLabel(self, l)

        Set the label (an integer) for this Partial. Unlabeled
        Partials have the default label of 0.
        """
        return _loris.Partial_setLabel(*args)

    def frequencyAt(*args):
        """
        frequencyAt(self, time) -> double

        Return the interpolated frequency (in Hz) of this
        Partial at the specified time in seconds. The frequency
        at times earlier than the first Breakpoint is the
        frequency of the first Breakpoint. The frequency at
        times later than the last Breakpoint is the frequency of
        the last Breakpoint. An exception is raised if there are
        no Breakpoints in this Partial.
        """
        return _loris.Partial_frequencyAt(*args)

    def amplitudeAt(*args):
        """
        amplitudeAt(self, time) -> double

        Return the interpolated amplitude of this Partial at
        the specified time in seconds. The amplitude at times
        earlier than the first Breakpoint and at times later
        than the last Breakpoint is zero. An exception is raised
        if there are no Breakpoints in this Partial.
        """
        return _loris.Partial_amplitudeAt(*args)

    def bandwidthAt(*args):
        """
        bandwidthAt(self, time) -> double

        Return the interpolated bandwidth (between 0 and 1) of
        this Partial at the specified time in seconds. The
        bandwidth at times earlier than the first Breakpoint and
        at times later than the last Breakpoint is zero. An
        exception is raised if there are no Breakpoints in this
        Partial.
        """
        return _loris.Partial_bandwidthAt(*args)

    def phaseAt(*args):
        """
        phaseAt(self, time) -> double

        Return the interpolated phase (in radians) of this
        Partial at the specified time in seconds. The phase at
        times earlier than the first Breakpoint is extrapolated
        from phase of the first Breakpoint assuming constant
        frequency. The phase at times later than the last
        Breakpoint is the extrapolated from the phase of the
        last Breakpoint assuming constant frequency. An
        exception is raised if there are no Breakpoints in this
        Partial.
        """
        return _loris.Partial_phaseAt(*args)

    def iterator(*args):
        """
        iterator(self) -> PartialIterator
        iterator(self, startHere) -> PartialIterator

        Return an iterator on the BreakpointPositions in this
        Partial. Optionally, specify the initial BreakpointPosition
        for the new iterator.
        """
        return _loris.Partial_iterator(*args)

    def __iter__(*args):
        """
        __iter__(self) -> PartialIterator

        Return an iterator on the BreakpointPositions in this 
        Partial.
        """
        return _loris.Partial___iter__(*args)

    def remove(*args):
        """
        remove(self, pos)

        Remove the specified Breakpoint from this Partial. An
        exception is raised if the specified Breakpoint is not a
        member of this Partial. The Breakpoint itself must be a
        member, not merely identical to a Breakpoint in this
        Partial.
        """
        return _loris.Partial_remove(*args)

    def first(*args):
        """
        first(self) -> Breakpoint

        Return the first Breakpoint this Partial, or 0 if this
        Partial is empty.
        """
        return _loris.Partial_first(*args)

    def last(*args):
        """
        last(self) -> Breakpoint

        Return the last Breakpoint this Partial, or 0 if this
        Partial is empty.
        """
        return _loris.Partial_last(*args)

    def insert(*args):
        """
        insert(self, time, bp)

        Insert a copy of the Breakpoint bp into this Partial at
        the specified time in seconds. Return nothing.
        """
        return _loris.Partial_insert(*args)

    def findAfter(*args):
        """
        findAfter(self, time) -> BreakpointPosition

        Return a BreakpointPosition positioned at
        the first Breakpoint in this Partial that is later than
        the specified time. The iterator might be at its end
        (return no more Breakpoints) if there are no Breakpoints
        in this Partial later than the specified time.
        """
        return _loris.Partial_findAfter(*args)

    def findNearest(*args):
        """
        findNearest(self, time) -> BreakpointPosition

        Return a BreakpointPosition positioned at
        the Breakpoint in this Partial that is nearest to the
        specified time.
        """
        return _loris.Partial_findNearest(*args)

Partial_swigregister = _loris.Partial_swigregister
Partial_swigregister(Partial)

class Breakpoint(_object):
    """
    A Breakpoint represents a single breakpoint in the
    time-varying frequency, amplitude, and bandwidth
    envelope of a Reassigned Bandwidth-Enhanced Partial.

    Instantaneous phase is also stored, but is only used at
    the onset of a partial, or when it makes a transition
    from zero to nonzero amplitude.

    A Partial represents a Reassigned Bandwidth-Enhanced
    model component. For more information about
    Bandwidth-Enhanced Partials and the Reassigned
    Bandwidth-Enhanced Additive Sound Model, refer to the
    Loris website:
        www.cerlsoundgroup.org/Loris/

    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Breakpoint, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Breakpoint, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, f, a, b, p=0.) -> Breakpoint
        __init__(self, f, a, b) -> Breakpoint
        __init__(self, rhs) -> Breakpoint

        A Breakpoint represents a single breakpoint in the
        time-varying frequency, amplitude, and bandwidth
        envelope of a Reassigned Bandwidth-Enhanced Partial.

        Instantaneous phase is also stored, but is only used at
        the onset of a partial, or when it makes a transition
        from zero to nonzero amplitude.

        A Partial represents a Reassigned Bandwidth-Enhanced
        model component. For more information about
        Bandwidth-Enhanced Partials and the Reassigned
        Bandwidth-Enhanced Additive Sound Model, refer to the
        Loris website:
            www.cerlsoundgroup.org/Loris/

        """
        this = _loris.new_Breakpoint(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _loris.delete_Breakpoint
    __del__ = lambda self : None;
    def frequency(*args):
        """
        frequency(self) -> double

        Return the frequency (in Hz) of this Breakpoint.
        """
        return _loris.Breakpoint_frequency(*args)

    def amplitude(*args):
        """
        amplitude(self) -> double

        Return the amplitude (absolute) of this Breakpoint.
        """
        return _loris.Breakpoint_amplitude(*args)

    def bandwidth(*args):
        """
        bandwidth(self) -> double

        Return the bandwidth, or noisiness (0 to 1) of 
        this Breakpoint.
        """
        return _loris.Breakpoint_bandwidth(*args)

    def phase(*args):
        """
        phase(self) -> double

        Return the phase (in radians) of this Breakpoint.
        """
        return _loris.Breakpoint_phase(*args)

    def setFrequency(*args):
        """
        setFrequency(self, x)

        Set the frequency (in Hz) of this Breakpoint.
        """
        return _loris.Breakpoint_setFrequency(*args)

    def setAmplitude(*args):
        """
        setAmplitude(self, x)

        Set the amplitude (absolute) of this Breakpoint.
        """
        return _loris.Breakpoint_setAmplitude(*args)

    def setBandwidth(*args):
        """
        setBandwidth(self, x)

        Set the bandwidth, or noisiness (0 to 1) of 
        this Breakpoint.
        """
        return _loris.Breakpoint_setBandwidth(*args)

    def setPhase(*args):
        """
        setPhase(self, x)

        Set the phase (in radians) of this Breakpoint.
        """
        return _loris.Breakpoint_setPhase(*args)

Breakpoint_swigregister = _loris.Breakpoint_swigregister
Breakpoint_swigregister(Breakpoint)

class BreakpointPosition(_object):
    """
    A BreakpointPosition represents the position of a 
    Breakpoint within a Partial.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, BreakpointPosition, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, BreakpointPosition, name)
    def __init__(self): raise AttributeError, "No constructor defined"
    __repr__ = _swig_repr
    __swig_destroy__ = _loris.delete_BreakpointPosition
    __del__ = lambda self : None;
    def time(*args):
        """
        time(self) -> double

        Return the time (in seconds) of the Breakpoint at this
        BreakpointPosition.
        """
        return _loris.BreakpointPosition_time(*args)

    def breakpoint(*args):
        """
        breakpoint(self) -> Breakpoint

        Return the Breakpoint (not a copy!) at this
        BreakpointPosition.
        """
        return _loris.BreakpointPosition_breakpoint(*args)

    def frequency(*args):
        """
        frequency(self) -> double

        Return the frequency (in Hz) of the Breakpoint at this
        BreakpointPosition.
        """
        return _loris.BreakpointPosition_frequency(*args)

    def amplitude(*args):
        """
        amplitude(self) -> double

        Return the amplitude (absolute) of the Breakpoint at this
        BreakpointPosition.
        """
        return _loris.BreakpointPosition_amplitude(*args)

    def bandwidth(*args):
        """
        bandwidth(self) -> double

        Return the bandwidth, or noisiness (0 to 1) of the
        Breakpoint at this BreakpointPosition.
        """
        return _loris.BreakpointPosition_bandwidth(*args)

    def phase(*args):
        """
        phase(self) -> double

        Return the phase (in radians) of the Breakpoint at this
        BreakpointPosition.
        """
        return _loris.BreakpointPosition_phase(*args)

    def setFrequency(*args):
        """
        setFrequency(self, x)

        Set the frequency (in Hz) of the Breakpoint at this
        BreakpointPosition.
        """
        return _loris.BreakpointPosition_setFrequency(*args)

    def setAmplitude(*args):
        """
        setAmplitude(self, x)

        Set the amplitude (absolute) of the Breakpoint at this
        BreakpointPosition.
        """
        return _loris.BreakpointPosition_setAmplitude(*args)

    def setBandwidth(*args):
        """
        setBandwidth(self, x)

        Set the bandwidth, or noisiness (0 to 1) of the
        Breakpoint at this BreakpointPosition.
        """
        return _loris.BreakpointPosition_setBandwidth(*args)

    def setPhase(*args):
        """
        setPhase(self, x)

        Set the phase (in radians) of the Breakpoint at this
        BreakpointPosition.
        """
        return _loris.BreakpointPosition_setPhase(*args)

BreakpointPosition_swigregister = _loris.BreakpointPosition_swigregister
BreakpointPosition_swigregister(BreakpointPosition)

class Channelizer(_object):
    """Proxy of C++ Channelizer class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Channelizer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Channelizer, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, refChanFreq, refChanLabel, stretchFactor=0) -> Channelizer
        __init__(self, refChanFreq, refChanLabel) -> Channelizer
        __init__(self, refFreq, stretchFactor=0) -> Channelizer
        __init__(self, refFreq) -> Channelizer
        """
        this = _loris.new_Channelizer(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _loris.delete_Channelizer
    __del__ = lambda self : None;
    def channelize(*args):
        """
        channelize(self, partial)
        channelize(self, partials)
        """
        return _loris.Channelizer_channelize(*args)

    def channelFrequencyAt(*args):
        """channelFrequencyAt(self, time, channel) -> double"""
        return _loris.Channelizer_channelFrequencyAt(*args)

    def computeChannelNumber(*args):
        """computeChannelNumber(self, time, frequency) -> int"""
        return _loris.Channelizer_computeChannelNumber(*args)

    def computeFractionalChannelNumber(*args):
        """computeFractionalChannelNumber(self, time, frequency) -> double"""
        return _loris.Channelizer_computeFractionalChannelNumber(*args)

    def referenceFrequencyAt(*args):
        """referenceFrequencyAt(self, time) -> double"""
        return _loris.Channelizer_referenceFrequencyAt(*args)

    def amplitudeWeighting(*args):
        """amplitudeWeighting(self) -> double"""
        return _loris.Channelizer_amplitudeWeighting(*args)

    def setAmplitudeWeighting(*args):
        """setAmplitudeWeighting(self, expon)"""
        return _loris.Channelizer_setAmplitudeWeighting(*args)

    def stretchFactor(*args):
        """stretchFactor(self) -> double"""
        return _loris.Channelizer_stretchFactor(*args)

    def setStretchFactor(*args):
        """
        setStretchFactor(self, stretch)
        setStretchFactor(self, fm, m, fn, n)
        """
        return _loris.Channelizer_setStretchFactor(*args)

    def computeStretchFactor(*args):
        """
        computeStretchFactor(fm, m, fn, n) -> double
        computeStretchFactor(fref, fn, n) -> double
        """
        return _loris.Channelizer_computeStretchFactor(*args)

    if _newclass:computeStretchFactor = staticmethod(computeStretchFactor)
    __swig_getmethods__["computeStretchFactor"] = lambda x: computeStretchFactor
Channelizer_swigregister = _loris.Channelizer_swigregister
Channelizer_swigregister(Channelizer)

def Channelizer_computeStretchFactor(*args):
  """
    computeStretchFactor(fm, m, fn, n) -> double
    Channelizer_computeStretchFactor(fref, fn, n) -> double
    """
  return _loris.Channelizer_computeStretchFactor(*args)



