#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#include "config.h"
#include "split.h"
#include "merge.h"

void print_help(char *cmd)
{

	printf("LXSplit for Linux and Free-/OpenBSD version %s.\n"
			"By Richard Stellingwerff.\n\n"

			"Usage: %s [OPTION] [FILE] [SPLITSIZE]\n\n"

			"Available options are -s(plit) and -j(oin)\n"
			"Splitsize examples: 15M, 5000k, 30000000b\n\n"

			"Examples: %s -s hugefile.bin 15M\n"
			"          %s -j hugefile.bin.001\n\n",VERSION,cmd,cmd,cmd,cmd);
}

int main(int argc, char **argv)
{
	char			*filename,
				*usersize;
	unsigned long int	size;


	if (argc < 3)
	{
		print_help(argv[0]);
		return 1;
	}

	if (!strcmp(argv[1],"-s"))
	{
		if (argc < 4 || argc > 4)
		{
			print_help(argv[0]);
			return 1;
		}

		filename = (char*)strdup(argv[2]);

		if ((argv[3][strlen(argv[3])-1] == 'M') || (argv[3][strlen(argv[3])-1] == 'm'))
		{
			usersize = (char*)malloc(sizeof(char *) * strlen(argv[3]));
			strncpy(usersize,argv[3],strlen(argv[3])-1);
			size = strtol(usersize, NULL, 10);
			size *= 1024;
			size *= 1024;
		} else
		if ((argv[3][strlen(argv[3])-1] == 'K') || (argv[3][strlen(argv[3])-1] == 'k'))
        	{
                	usersize = (char*)malloc(sizeof(char *) * strlen(argv[3]));
                	strncpy(usersize,argv[3],strlen(argv[3])-1);
                	size = strtol(usersize, NULL, 10);
                	size *= 1024;
        	} else
        	if ((argv[3][strlen(argv[3])-1] == 'B' || argv[3][strlen(argv[3])-1] == 'b'))
        	{
                	usersize = (char*)malloc(sizeof(char *) * strlen(argv[3]));
                	strncpy(usersize,argv[3],strlen(argv[3])-1);
                	size = strtol(usersize, NULL, 10);
        	} else
		{
			printf("Please specify the size correctly!\n\n");
			print_help(argv[0]);
			return 1;
		}

		split_files(filename, size);

	} else	// if -split
	if (!strcmp(argv[1],"-j"))
	{

		if (argc < 3 || argc > 3)
		{
			print_help(argv[0]);
			exit(0);
		}


		filename = (char*)strdup(argv[2]);

		merge(filename);


	} else	// if -merge
	{
		printf("Whatcha wanna do?\n");
		print_help(argv[0]);
		return 1;
	}

	return 1;
}
