#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include "func.h"

int merge(char *filename)  // somefile.001
{
	FILE			*fp_split,
					*fp_merged;
	unsigned
		long int	merged_size,
					split_size;

	int				end,
					filenr,
					amount,
					startnr,
					i, n,
					notfound,
					split_pos,
					bytes_read;

	char			*merged_fname,
					*split_fname,
					*orig_fname,
					*missing_fname,
					*c_bytes,
					*split_sfname;

	struct stat		buf;

	c_bytes = (char*)malloc(sizeof(char*) * 5000);

	if (filename[strlen(filename)-4] != '.')
	{
		printf("Erroneous filename. Please supply the extension.\n"
			"Must end with .000 or .001\n");
		exit(0);
	}

	switch (filename[strlen(filename)-1])
	{
	case '0':
			startnr = 0;
			break;
	case '1':
			startnr = 1;
			break;
	default:
        printf("Erroneous filename. Please supply the extension.\n"
            "Must end with .000 or .001\n");
        exit(0);
	}

	orig_fname = (char*)malloc(sizeof(char*) * strlen(filename)-3);
	split_fname = (char*)malloc(sizeof(char*) * strlen(filename));

	strncpy(orig_fname,filename,strlen(filename)-4);
	orig_fname[strlen(filename)-4] = '\0';

	merged_fname = (char*)strdup(orig_fname);
    merged_fname = (char*)strip_path(merged_fname);


	amount = 0;
	notfound = 0;
	merged_size = 0;


	for (filenr = startnr; filenr < 1000; filenr++)
	{
        if (filenr < 10)
            sprintf(split_fname,"%s.00%d",orig_fname,filenr);
        else if (filenr < 100)
            sprintf(split_fname,"%s.0%d",orig_fname,filenr);
        else if (filenr < 1000)
            sprintf(split_fname,"%s.%d",orig_fname,filenr);

		if (stat(split_fname,&buf) == -1)
		{
			if (filenr == startnr)
			{
				printf("Can't open %s\n",split_fname);
				exit(0);
			} else {
				if (notfound == 0)
					missing_fname = (char*)strdup(split_fname);
				notfound = 1;
			}
		} else {
			if (!S_ISREG(buf.st_mode))
			{
				printf("Can't open `%s'\n",split_fname);
				exit(0);
			} else {
				if (notfound)
				{
					printf("Missing file `%s' !\n", missing_fname);
					exit(0);
				}
				merged_size += buf.st_size;
				amount++;
			}
				
		}
	}

	printf("Creating merged file `%s`.\nComplete size: %d in %d files.\n",
		merged_fname,merged_size, amount);


	if (stat(merged_fname,&buf) == 0)
	{
		printf("%s already exists! Aborting...\n",merged_fname);
		exit(0);
	}

	fp_merged = fopen(merged_fname,"w");


	for (filenr=startnr; filenr <= amount + (startnr - 1); filenr++)
	{
        if (filenr < 10)
            sprintf(split_fname,"%s.00%d",orig_fname,filenr);
        else if (filenr < 100)
            sprintf(split_fname,"%s.0%d",orig_fname,filenr);
        else if (filenr < 1000)
            sprintf(split_fname,"%s.%d",orig_fname,filenr);

		split_sfname = (char*)shorten_path(split_fname);

		printf("Processing file `%s'...\n",split_sfname);


		if (stat(split_fname,&buf) == -1)
		{
			perror("Unable to open input file");
			exit(0);
		}

		split_size = buf.st_size;

		fp_split = fopen(split_fname, "r");
		if (fp_split == NULL)
		{
			perror("Unable to open input file");
			exit(0);
		}
		
		split_pos = 0;

		while (split_pos < (int)split_size)
		{
			bytes_read = fread(c_bytes, 1, 4096, fp_split);
			fwrite(c_bytes, 1, bytes_read, fp_merged);
			split_pos += bytes_read;
		}

		fclose(fp_split);

	}

	printf("Done!\n");


	fclose(fp_merged);
}
