/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#include <klocale.h>
#include <kpopupmenu.h>
#include <qcursor.h>
#include <qspinbox.h>
#include <qpushbutton.h>
#include "mainwidget.h"
#include "favouritemaster.h"
//-----------------------------------------------------------------------------------------------------------------------
FavouriteMaster::FavouriteMaster(MainWidget *parent)
{
	m_parent = parent;
	loadFavourites();
	m_dialogs.setAutoDelete(true);
	
	connect(m_parent->lv_favourite, SIGNAL(contextMenu(KListView*, QListViewItem*, const QPoint&)), this, SLOT(showPopupMenu(KListView*, QListViewItem*, const QPoint&)));
	connect(m_parent->prefs()->pb_executenow, SIGNAL(clicked()), this, SLOT(executeCommand()));
}
//-----------------------------------------------------------------------------------------------------------------------
FavouriteMaster::~FavouriteMaster()
{
	saveFavourites();
	m_dialogs.clear();
}
//-----------------------------------------------------------------------------------------------------------------------
void FavouriteMaster::loadFavourites(KConfig *cfg)
{
	if(!cfg->hasGroup("Favourites"))
		return;
	cfg->setGroup("Favourites");
	m_favourites.clear();
	m_parent->lv_favourite->clear();
	m_favourites = cfg->readListEntry("favourites");
	for(QStringList::Iterator it = m_favourites.begin(); it != m_favourites.end(); ++it)
		new QListViewItem(m_parent->lv_favourite, *it);
}
//-----------------------------------------------------------------------------------------------------------------------
void FavouriteMaster::saveFavourites(KConfig *cfg)
{
	cfg->setGroup("Favourites");
	cfg->writeEntry("favourites", m_favourites);
	cfg->sync();
}
//-----------------------------------------------------------------------------------------------------------------------
bool FavouriteMaster::isFavourite(QString title)
{
	for(QStringList::Iterator it = m_favourites.begin(); it != m_favourites.end(); ++it)
		if(*it == title)
			return(true);
	return(false);
}
//-----------------------------------------------------------------------------------------------------------------------
void FavouriteMaster::addFavourite()
{
	QListViewItemIterator it(m_parent->activeView()->listView(), QListViewItemIterator::Selected);
	QString title;

	if(it.current()) {
		title = ((ProgramItem*)it.current())->program()->title();
		m_favourites.append(title);
		new QListViewItem(m_parent->lv_favourite, title);
	}
	m_parent->refresh();
}
//-----------------------------------------------------------------------------------------------------------------------
void FavouriteMaster::removeFavourite()
{
	QListViewItemIterator it(m_parent->activeView()->listView(), QListViewItemIterator::Selected);
	if(it.current()) {
		m_favourites.remove(((ProgramItem*)it.current())->program()->title());
		m_parent->lv_favourite->clear();
		for(uint i=0; i<m_favourites.count(); i++)
			new QListViewItem(m_parent->lv_favourite, *(m_favourites.at(i)));
	}
	m_parent->refresh();
}
//-----------------------------------------------------------------------------------------------------------------------
void FavouriteMaster::showPopupMenu(KListView*, QListViewItem*, const QPoint&)
{
	QListViewItemIterator it(m_parent->lv_favourite, QListViewItemIterator::Selected);
	
	if(!it.current()) return;
	KPopupMenu *favMenu = new KPopupMenu(m_parent);

	favMenu->insertItem(i18n("Remove Favourite"), this, SLOT(removeStringFavourite()));
	favMenu->exec(QCursor::pos());

	delete favMenu;
}
//-----------------------------------------------------------------------------------------------------------------------
void FavouriteMaster::removeStringFavourite()
{
	QListViewItemIterator it(m_parent->lv_favourite, QListViewItemIterator::Selected);
	while(it.current()) {
		m_favourites.remove(it.current()->text(0));
		m_parent->lv_favourite->takeItem(it.current());
		++it;
	}
	m_parent->refresh();
}
//-----------------------------------------------------------------------------------------------------------------------
void FavouriteMaster::showReminder(QPtrList<Program> *programs, bool showPopup, bool executeCmd)
{
	Program *program;

	for(uint i=0; i<programs->count(); i++) {
		program = programs->at(i);
		if(isFavourite(program->title()) && !ProgramMaster::hasEnded(program) && ProgramMaster::startsInXMinutes(program, m_parent->prefs()->sb_minbefore->value())) {
			if(showPopup)
				showPopupWindow(program);
			if(executeCmd)
				executeCommand();
		}
	}
}
//-----------------------------------------------------------------------------------------------------------------------
void FavouriteMaster::showPopupWindow(Program *program)
{
	RemindWindow *rwin;

	rwin = new RemindWindow(m_parent, program);
	m_dialogs.append(rwin);
}
//-----------------------------------------------------------------------------------------------------------------------
void FavouriteMaster::executeCommand()
{
	QString command = m_parent->prefs()->le_command->text();
	if(command.isEmpty()) return;

	KProcess *proc = new KProcess;
	*proc << command.section(' ', 0, 0);
	for(int i=1; i<=command.contains(' ', false); i++)
		*proc << command.section(' ', i, i);
	connect(proc, SIGNAL(processExited(KProcess*)), this, SLOT(processExited(KProcess*)));
	proc->start(KProcess::NotifyOnExit);
}
//-----------------------------------------------------------------------------------------------------------------------
void FavouriteMaster::toggleFavourite()
{
	QListViewItemIterator it(m_parent->activeView()->listView(), QListViewItemIterator::Selected);
	if(!it.current()) return;
	QString title = ((ProgramItem*)it.current())->program()->title();

	if(isFavourite(title))
		removeFavourite();
	else
		addFavourite();
	m_parent->refresh();
}
//-----------------------------------------------------------------------------------------------------------------------
