/***************************************************************************
 *   Copyright (C) 2005-2006 by Robert Maxe                                *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#include <klocale.h>
#include <kconfig.h>
#include <kglobal.h>
#include <qxml.h>
#include "parsemaster.h"
#include "parser.h"
//-----------------------------------------------------------------------------------------------------------------------
ParseMaster::ParseMaster(MainWidget *parent)
{
	m_parent = parent;
	m_channels.setAutoDelete(true);
	m_programs.setAutoDelete(true);
}
//-----------------------------------------------------------------------------------------------------------------------
bool ParseMaster::parse(QString file)
{
	saveCustomizedChannels();
	m_channels.clear();
	m_programs.clear();
	m_categories.clear();
	Parser handler(&m_channels, &m_programs, &m_categories);
	QFile xmlFile(file);
	if(!xmlFile.exists()) {
		m_errorMsg = i18n("XML TV-File does not exist, please check your settings.");
		m_error = FILE;
		return(false);
	}
	QXmlInputSource source(xmlFile);
	QXmlSimpleReader reader;
	reader.setContentHandler(&handler);
	reader.parse(source);
	if(m_channels.count() < 1 || m_programs.count() < 1) {
		m_errorMsg = i18n("There are no channels / programs in XML TV-File.");
		m_error = EMPTY;
		return(false);
	}
	// TODO: Handle return value int (number of programs without channel pointer)
	wireChannels();
	loadCustomizedChannels();

	m_error = NONE;
	return(true);
}
//-----------------------------------------------------------------------------------------------------------------------
int ParseMaster::futureDates()
{
	QDate today(QDate::currentDate()), high(today.addDays(-1)), pdate;
	Program *program;

	for(uint i=0; i<m_programs.count(); i++) {
		program = m_programs.at(i);
		pdate = (program->startDT()).date();
		if(pdate > high)
			high = pdate;
	}
	return(today.daysTo(high));
}
//-----------------------------------------------------------------------------------------------------------------------
int ParseMaster::wireChannels()
{
	Program *program;
	Channel *channel;
	int failCnt = 0;

	for(program = m_programs.first(); program; program = m_programs.next()) {
		for(channel = m_channels.first(); channel; channel = m_channels.next()) {
			if(program->channelId() == channel->id()) {
				program->setChannel(channel);
				break;
			}
		}
		if(program->channel() == NULL)
			failCnt++;
	}
	return(failCnt);
}
//-----------------------------------------------------------------------------------------------------------------------
void ParseMaster::loadCustomizedChannels()
{
	KConfig *cfg = KGlobal::config();
	Channel *channel;

	for(channel = m_channels.first(); channel; channel = m_channels.next()) {
		cfg->setGroup(channel->id());
		channel->setPrio(cfg->readNumEntry("prio", 0));
		channel->setCustomName(cfg->readEntry("customName", ""));
		if(channel->name() == channel->customName())
			channel->setCustomName("");
		channel->setCustomImage(cfg->readEntry("customImage", ""));
	}
}
//-----------------------------------------------------------------------------------------------------------------------
void ParseMaster::saveCustomizedChannels()
{
	KConfig *cfg = KGlobal::config();
	Channel *channel;

	if(m_channels.count() == 0) return;

	for(channel = m_channels.first(); channel; channel = m_channels.next()) {
		cfg->setGroup(channel->id());
		cfg->writeEntry("prio", channel->prio());
		cfg->deleteEntry("customName");
		cfg->deleteEntry("customImage");
		if(channel->hasCustomName())
			cfg->writeEntry("customName", channel->customName());
		if(channel->hasCustomImage())
			cfg->writeEntry("customImage", channel->customImage());
	}
	cfg->sync();
}
//-----------------------------------------------------------------------------------------------------------------------
