#V1.13
############################################################################
# tclmikmod interface
# initial design my Steve McIntytre
# Everything relating to integrating this with MikMod by
# Peter Amstutz
# 
# Revision History
# ----------------
# (??/??/96) v1.00 - Steve's version.  Didn't actually do _anything_
# (09/02/97) v1.10 * Integrated with MikMod. Initial devel release
# (27/03/97) v1.11 * Fixed some shit that was bothering me & added
#					some other stuff (random play, etc), removed dependence 
#					on Extended Tcl, released as tclmikmod-2.15-devel9
# (27/03/97) v1.12 - _FINALLY_ figured out how to store a bunch of images
#					into one file...  storage of images on disk is a lot
#					more efficient now...
# (22/04/97) v1.13 * added getcurrent{} procedure, also intruments list uses
#					a fixed width font now, so sample messages with graphics, 
#					along with the 8-to-7 bit translation, look slightly better.
#					Also, it stops reconignizing files with modlike substrings
#					in them (like FALL1.MTM.zip - should not be reconignized as
#					a uncompressed mtm file.)
#
# Note stared entries (with a *) indicate a change in the interface
# between MikMod and the Tcl script.  Non-starred ones are changes
# affecting only the Tcl script, so it is not necessary to change the
# first version line.
#
# Who to contact about this little piece of MikMod:
# 99% of the code of any significance was written by me (Peter Amstutz)
# so I am the guy to mail if something isn't quite right somewhere.  
# If you think the appearence is ugly but don't have any bugs to report 
# then Steve is the guy to call :)

#################################
# GLOBAL VARIABLES
#
global BPM; set BPM {100}
global VOL; set VOL {100}
global che1; set che1 {0}
global che107; set che107 {0}
global che108; set che108 {0}
global che2; set che2 {1}
global che3; set che3 {1}
global che4; set che4 {0}
global che44; set che44 {0}
global che45; set che45 {0}
global che5; set che5 {0}
global che6; set che6 {1}
global che63; set che63 {0}
global che64; set che64 {0}
global che65; set che65 {0}
global che66; set che66 {0}
global che67; set che67 {0}
global che68; set che68 {0}
global che69; set che69 {0}
global che7; set che7 {0}
global che72; set che72 {0}
global che73; set che73 {0}
global che74; set che74 {0}
global che75; set che75 {0}
global che78; set che78 {1}
global che79; set che79 {0}
global che8; set che8 {0}
global che80; set che80 {0}
global che81; set che81 {0}
global che93; set che93 {0}
global che94; set che94 {0}
global obj; set obj {163}
global playmode; set playmode {stop}
global paths, mainpaths, zips, tempdir, unzip, s_or_p, current
global lastvalue
set paths ""
set mainpaths ""
set tempdir /tmp
set unzipprog unzip
set unziparg -l
set totalpat ""
# 1 - last hit pause
# 2 - last hit stop
set s_or_p "2"

set current "-1"
set lastvalue [clock seconds]
set prevdirpoint "0"
set prevdirtemp "0"

uplevel #0 catch \{set vTcl(statglb) \{\}\}

#################################
# USER DEFINED PROCEDURES
#
proc init {argc argv} {
#option buttons
set imagefile [open "images" r]
image create bitmap 16-bit -data [read $imagefile 1006]
image create bitmap 8-bit -data [read $imagefile 1003]
image create bitmap extspeed-on -data [read $imagefile 1021]
image create bitmap interp -data [read $imagefile 1006]
image create bitmap mono -data [read $imagefile 1000]
image create bitmap normal -data [read $imagefile 1006]
image create bitmap panning-on -data [read $imagefile 1018]
image create bitmap random-on -data [read $imagefile 1015]
image create bitmap repeat-on -data [read $imagefile 1015]
image create bitmap stereo -data [read $imagefile 1006]
image create bitmap tolerant-on -data [read $imagefile 1021]

#control buttons
image create bitmap pause-on -data [read $imagefile 627]
image create bitmap play-on -data [read $imagefile 624] 
image create bitmap prevmod-on -data [read $imagefile 633]
image create bitmap prevpat-on -data [read $imagefile 633]
image create bitmap nextmod-on -data [read $imagefile 633]
image create bitmap nextpat-on -data [read $imagefile 633]
image create bitmap stop-on -data [read $imagefile 624]

#dialog box buttons
image create bitmap cross -data [read $imagefile 618]
image create bitmap tick -data [read $imagefile  615]
}

init $argc $argv

proc finish {} {
	puts "=QUIT"
}

proc dialog {mesg {options Ok} {root 0}} {
global vTcl
    if {$root == 0} {
        set base .vTcl.message
    } else {
        set base .vTcl:message
    }
    set sw [winfo screenwidth .]
    set sh [winfo screenheight .]
    toplevel $base -class vTcl
    frame $base.f -bd 2 -relief groove
    label $base.f.t -bd 0 -relief flat -text $mesg -justify left  -font -Adobe-Helvetica-Medium-R-Normal-*-*-180-*-*-*-*-*-*
    frame $base.o -bd 1 -relief sunken
    foreach i $options {
        set n [string tolower $i]
        button $base.o.$n -text $i -width 5 -highlightthickness 0  -command "
            set vTcl(x_mesg) $i
            destroy $base
        "
        pack $base.o.$n -side left -expand 1 -fill x -padx 2 -pady 2
    }
    pack $base.f.t -side top -expand 1 -fill both -ipadx 5 -ipady 5
    pack $base.f -side top -expand 1 -fill both -padx 2 -pady 2
    pack $base.o -side top -fill x -padx 2 -pady 2
    wm withdraw $base
    update idletasks
    set w [winfo reqwidth $base]
    set h [winfo reqheight $base]
    set x [expr ($sw - $w)/2]
    set y [expr ($sh - $h)/2]
    wm geometry $base ${w}x${h}+$x+$y
    wm deiconify $base
    grab $base
    tkwait window $base
    grab release $base
    return $vTcl(x_mesg)
}

proc Window {args} {
global vTcl
    set cmd [lindex $args 0]
    set name [lindex $args 1]
    set rest [lrange $args 2 end]
    if {$name == "" || $cmd == ""} {return}
    set exists [winfo exists $name]
    switch $cmd {
        show {
            if {[info procs vTclWindow(pre)$name] != ""} {
                vTclWindow(pre)$name $rest
            }
            if {[info procs vTclWindow$name] != ""} {
                vTclWindow$name
            }
            if {[info procs vTclWindow(post)$name] != ""} {
                vTclWindow(post)$name $rest
            }
        }
        hide    { if $exists {wm withdraw $name; return} }
        iconify { if $exists {wm iconify $name; return} }
        destroy { if $exists {destroy $name; return} }
    }
}

#
# File selector Stuff by Peter Amstutz (most other stuff by me, too :)
#
proc addfiles {} {
        global paths current
        set selected [.fs.filebox curselection]
        for {set n 0} {$n < [llength $selected]} {set n [expr $n + 1]} {
                .fs.playlist insert end [.fs.filebox get [lindex $selected $n]]
                .fs.filebox selection clear [lindex $selected $n]
                set paths [linsert $paths end [pwd]/]
        } 
	.fs.playlist selection clear 0 end
	.fs.playlist selection set $current
}

proc rmfiles {} { 
	global paths current 
	set selected [.fs.playlist curselection]
	while {[llength $selected] > 0} {
		.fs.playlist delete [lindex $selected 0]
		set paths [lreplace $paths [lindex $selected 0] [lindex $selected 0]]
		if {[lindex $selected 0] >= $current} {
			set current [expr $current - 1]        
		}
		set selected [.fs.playlist curselection] 
     } 
	.fs.playlist selection clear 0 end
	.fs.playlist selection set $current
}

proc listfiles {} {
        global unzipprog unziparg tempdir
        .fs.filebox delete 0 end
        .fs.dirbox delete 0 end
        set dirs ""
        set files ""
        set fl [glob -nocomplain *]

        for {set n 0} {$n < [llength $fl]} {set n [expr $n + 1]} {
                if {[file isdirectory [lindex $fl $n]]}  {
                        lappend dirs [lindex $fl $n]/
                }  
        }
        set dirs [lsort $dirs]
        .fs.dirbox insert end ../
        for {set n 0} {$n < [llength $dirs]} {set n [expr $n + 1]} {
                .fs.dirbox insert end [lindex $dirs $n]
        }
        for {set n 0} {$n < [llength $fl]} {set n [expr $n + 1]} {
                if {[file isfile [lindex $fl $n]]} {
                        if {[regexp -nocase .*\[.\]mod|.*\[.\]mtm|.*\[.\]xm|.*\[.\]uni|.*\[.\]s3m|.*\[.\]stm|.*\[.\]it [lindex $fl $n] foo] 
							&& ([string length [lindex $fl $n]]==[string length $foo])} {
							lappend files [lindex $fl $n]
						}
			set match .*\[\.\]zip
                        if {[regexp -nocase $match [lindex $fl $n]]} {
                                catch {exec $unzipprog $unziparg [pwd]/[lindex $fl $n] > $tempdir/mikzipdir}
                                set zipdir [open $tempdir/mikzipdir]
                                gets $zipdir
                                gets $zipdir
                                gets $zipdir
                                while {[eof $zipdir] != 1} {
                                        set line [gets $zipdir]
					if {[regexp -nocase .*\[.\]mod|.*\[.\]mtm|.*\[.\]xm|.*\[.\]uni|.*\[.\]s3m|.*\[.\]stm|.*\[.\]it [string range $line 27 end] foo] 
							&& ([string length [string range $line 27 end]]==[string length $foo])} {
							lappend files "[string range $line 27 end] (in) [lindex $fl $n]"
					}
                               }
                        }
                }
        }
        set files [lsort $files]
        for {set n 0} {$n < [llength $files]} {set n [expr $n + 1]} {
                .fs.filebox insert end [lindex $files $n]
        }
}

proc HighlightCurrent {} {
	global current mainpaths
	.top1.fra2.fra15.lis18 selection clear 0 end
	.top1.fra2.fra15.lis18 selection set $current
	.top1.fra2.fra15.lis18 see $current 
}

proc export2mainlist {} {
	global paths mainpaths

	set mainpaths $paths

	.top1.fra2.fra15.lis18 delete 0 end
	for {set n [expr [.fs.playlist size] - 1]} {$n > -1} {set n [expr $n - 1]} {
		.top1.fra2.fra15.lis18 insert 0 [.fs.playlist get $n]
	}
	destroy .fs
}

proc delcurrent {} {
	global mainpaths current 
	if { $current == -1 } { set current 0 }
	set mainpaths [lreplace $mainpaths $current $current]
	.top1.fra2.fra15.lis18 delete $current
	.top1.fra2.fra15.lis18 selection clear 0 end
	.top1.fra2.fra15.lis18 selection set $current
	if { $current == 0 } { set current -1 }
	HighlightCurrent
}

proc rawrand {} {
    global lastvalue
    set lastvalue [expr (65277*$lastvalue+13849)%65536]
    set lastvalue [expr ($lastvalue+65536)%65536]
    return $lastvalue
}
proc rand { base } {
    set rr [rawrand]
    return [expr ($rr*$base)/65536]
}

proc getnext {} {
	global current mainpaths

	if { [.top1.fra2.fra15.lis18 size] == 0 } { return }
		if {$current < [expr [.top1.fra2.fra15.lis18 size] - 1]} {
			set current [expr $current + 1]
		}
	if {$current > [expr [.top1.fra2.fra15.lis18 size] - 1]} {
		set current [expr [.top1.fra2.fra15.lis18 size] - 1]
	}
	if { $current < 0 } {
		set current 0
	}
	puts "*[lindex $mainpaths $current][.top1.fra2.fra15.lis18 get $current]"
	HighlightCurrent
    .top1.fra2.fra30.rad5 deselect
}

proc getcurrent {} {
	global current mainpaths
	puts "*[lindex $mainpaths $current][.top1.fra2.fra15.lis18 get $current]"
	HighlightCurrent
}


proc getprev {} {
	global current mainpaths

	if { $current > -1 } {
		set current [expr $current - 1]
	}
	if { $current < -1 } {
		set current -1
	}
	if { $current > [expr [.top1.fra2.fra15.lis18 size] - 1]} {
		set current [expr [.top1.fra2.fra15.lis18 size] - 1]
	}

	puts *[lindex $mainpaths $current][.top1.fra2.fra15.lis18 get $current]
;#	HighlightCurrent
    .top1.fra2.fra30.rad5 deselect
}

proc ShowFileSelector {} {
	global paths mainpaths
    if {[winfo exists .fs]} {
        wm deiconify .fs; return
    }
	toplevel .fs
	wm geometry .fs 600x400-20-40
	wm title .fs "File Selector - [pwd]"

	listbox .fs.dirbox -yscrollcommand {.fs.dirboxscroll set}
	listbox .fs.filebox -selectmode extended -yscrollcommand {.fs.fileboxscroll set }
	listbox .fs.playlist -selectmode extended -yscrollcommand {.fs.playlistscroll set }
	for {set n [expr [.top1.fra2.fra15.lis18 size] - 1]} {$n > -1} {set n [expr $n - 1]} {
		.fs.playlist insert 0 [.top1.fra2.fra15.lis18 get $n]
	}
	scrollbar .fs.dirboxscroll -command {.fs.dirbox yview}
	scrollbar .fs.fileboxscroll -command {.fs.filebox yview}
	scrollbar .fs.playlistscroll -command {.fs.playlist yview}
	button .fs.add -command {addfiles} -text "->"
	button .fs.del -command {rmfiles} -text "<-"
	button .fs.shake -command {export2mainlist} -text "ShAkE dA HoUsE!!!"
	button .fs.cancel -command {destroy .fs} -text "Cancel"

	place .fs.dirbox -x 0 -y 0 -relwidth .33 -relheight .33
	place .fs.dirboxscroll -relx .33 -y 0 -relheight .33
	place .fs.filebox  -x 0 -rely .33 -relwidth .33 -relheight .66
	place .fs.fileboxscroll -relx .33 -rely .33 -relheight .66
	place .fs.playlist -relx .66 -y 0 -relheight 1 -relwidth .33
	place .fs.playlistscroll -relx .623 -y 0 -relheight 1
	place .fs.add -relx .45 -rely .3
	place .fs.del -relx .45 -rely .4
	place .fs.shake -relx .38 -rely .5
	place .fs.cancel -relx .44 -rely .6

	bind .fs.dirbox <Double-Button-1> {
		if {[.fs.dirbox get @0,%y] == "../"} {
			set prevdirtemp $prevdirpoint
		} else {
			set prevdirpoint [expr [.fs.dirbox index @0,%y] + 3]
			set prevdirtemp 0
		}
        cd [.fs.dirbox get @0,%y]
        wm title .fs "File Selector - [pwd]"
		listfiles
		.fs.dirbox selection clear 0 end
		.fs.dirbox see $prevdirtemp
		.fs.dirbox selection set $prevdirtemp
	}
	bind .fs.filebox <Double-Button-1> {
		set paths [linsert $paths end [pwd]/]
		.fs.playlist insert end [.fs.filebox get @0,%y]
		.fs.playlist selection clear 0 end
		.fs.playlist selection set $current
	}
	bind .fs.playlist <Double-Button-1> {
		set paths [lreplace $paths [.fs.playlist index @0,%y] [.fs.playlist index @0,%y]]
		if {[.fs.playlist nearest %y] <= $current} {
			set current [expr $current - 1]        
		}
   	    .fs.playlist delete @0,%y  
		.fs.playlist selection clear 0 end
		.fs.playlist selection set $current
	}
	set paths $mainpaths
	listfiles
}

toplevel .inst
wm geometry .inst 300x400+20-40
wm title .inst "Instruments"
scrollbar .inst.scrl -command {.inst.lb yview}
listbox .inst.lb -selectmode single -font  \
	-misc-fixed-*-*-normal-*-*-120-*-*-*-*-*-* -yscrollcommand {.inst.scrl set }
place .inst.scrl -relx .92 -rely 0 -relheigh 1
place .inst.lb -relx 0 -rely 0 -relwidth .92 -relheight 1
bind .inst <Button-1> { HighlightCurrent }
bind .inst <Motion> { HighlightCurrent }
bind .inst <FocusIn> { HighlightCurrent }
bind .inst <Circulate> { HighlightCurrent }
bind .inst <Activate> { HighlightCurrent }


#################################
# VTCL GENERATED GUI PROCEDURES
#

proc vTclWindow. {args} {
    set base .
    wm focusmodel . passive
    wm geometry . 1x1+0+0
    wm maxsize . 613 289
    wm minsize . 613 289
    wm overrideredirect . 0
    wm withdraw .
    wm title . "vt.tcl"
}

proc vTclWindow.top1 {args} {
    global s_or_p
    set base .top1
    if {[winfo exists .top1]} {
        wm deiconify .top1; return
    }
    toplevel .top1 -class Toplevel \
        -background #a9a298 
    wm focusmodel .top1 passive
    wm geometry .top1 575x275-65+10
    wm maxsize .top1 1000 1000
    wm minsize .top1 575 275
    wm overrideredirect .top1 0
    wm deiconify .top1
    wm title .top1 "TclMikMod 3.0.3 by Peter Amstutz"
	bind MyButton <Button-1> {
		%W configure -relief sunken
		%W invoke
	}
	bind MyButton <ButtonRelease-1> {
		%W configure -relief raised
	}
    frame .top1.fra2 \
        -background #d9d6d9 -borderwidth 5 -height 30 -relief ridge -width 30 
    place .top1.fra2 \
        -x 0 -relx 0 -y 0 -rely 0 -width 575 -height 275 -anchor nw \
        -bordermode ignore 
    label .top1.fra2.lab10 \
        -background #2f2981 -borderwidth 5 \
        -font -Adobe-Helvetica-Bold-O-Normal-*-*-240-*-*-*-*-*-* \
        -foreground #fffb00 -highlightcolor #000000 -relief groove
    place .top1.fra2.lab10 \
        -x 70 -relx 0 -y 5 -rely 0 -width 433 -height 35 -anchor nw \
        -bordermode ignore 
    frame .top1.fra2.fra15 \
        -background #000000 -borderwidth 5 -height 30 -relief sunken \
        -width 30 
    place .top1.fra2.fra15 \
        -x 70 -relx 0 -y 150 -rely 0 -width 245 -height 120 -anchor nw \
        -bordermode ignore 
# This is the main listbox - booga!
    listbox .top1.fra2.fra15.lis18 \
        -background #2f2981 -borderwidth 0 \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-* \
        -foreground #ffff00 -relief flat -selectbackground #ffff00 \
        -takefocus yes -xscrollcommand {.top1.fra2.fra15.scr20 set} \
        -yscrollcommand {.top1.fra2.fra15.scr12 set} \
		-selectmode single
    place .top1.fra2.fra15.lis18 \
        -x 5 -relx 0 -y 5 -rely 0 -width 225 -height 98 -anchor nw \
        -bordermode ignore 
	bind .top1.fra2.fra15.lis18 <Button-2> { ShowFileSelector }
	bindtags .top1.fra2.fra15.lis18 {.top1.fra2.fra15.lis18 Blank . all}
	bind .top1.fra2.fra15.lis18 <Double-Button-1> {
		puts "=ORDERLY"
		puts "=NEXTMOD"
		set current [expr [.top1.fra2.fra15.lis18 nearest %y] - 1]
	}
    scrollbar .top1.fra2.fra15.scr20 \
        -activebackground #00ff00 -background #000000 -borderwidth 1 \
        -command {.top1.fra2.fra15.lis18 xview} -orient horizontal \
        -troughcolor #a5d5a5 -width 10 
    place .top1.fra2.fra15.scr20 \
        -x 5 -relx 0 -y 100 -rely 0 -width 220 -height 16 -anchor nw \
        -bordermode ignore 
    scrollbar .top1.fra2.fra15.scr12 \
        -activebackground #00ff00 -background #000000 -borderwidth 1 \
        -command {.top1.fra2.fra15.lis18 yview} -troughcolor #a5d5a5 \
        -width 10 
    place .top1.fra2.fra15.scr12 \
        -x 225 -relx 0 -y 5 -rely 0 -width 16 -height 95 -anchor nw \
        -bordermode ignore 
    frame .top1.fra2.fra30 \
        -background #a5d5a5 -borderwidth 5 -height 30 \
        -highlightbackground #000000 -relief sunken -width 30 
    place .top1.fra2.fra30 \
        -x 70 -relx 0 -y 110 -rely 0 -width 435 -height 40 -anchor nw \
        -bordermode ignore 
    button .top1.fra2.fra30.rad3 \
        -anchor w -background #00FF00 \
        -borderwidth 0 -relief raised \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-* \
        -highlightbackground #000000 -highlightthickness 3 -image prevmod-on \
        -padx 5 -pady 5 \
        -command {
        	puts "=PREVMOD"
		}
    place .top1.fra2.fra30.rad3 \
        -x 10 -relx 0 -y 6 -rely 0 -anchor nw -bordermode ignore 
	bindtags .top1.fra2.fra30.rad3 MyButton
    button .top1.fra2.fra30.rad4 \
        -bg #00FF00 -anchor w \
        -borderwidth 0 \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-* \
        -highlightbackground #000000 -highlightthickness 3 -image prevpat-on \
        -padx 0 -pady 0 -command { 
        	puts "=PREVPAT"
		}
    place .top1.fra2.fra30.rad4 \
        -x 60 -relx 0 -y 6 -rely 0 -anchor nw -bordermode ignore 
	bindtags .top1.fra2.fra30.rad4 MyButton
    checkbutton .top1.fra2.fra30.rad5 \
        -anchor w -borderwidth 0 -bg #008800 -selectcolor #00FF00 \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-* \
        -highlightbackground #000000 -highlightthickness 3 \
        -indicatoron 0 -padx 0 -pady 0 -image pause-on \
        -command { 
        	puts "=PAUSE"
        }
    place .top1.fra2.fra30.rad5 \
        -x 110 -relx 0 -y 6 -rely 0 -anchor nw -bordermode ignore 
	bindtags .top1.fra2.fra30.rad5 MyButton
    radiobutton .top1.fra2.fra30.rad6 \
        -bg #008800 -selectcolor #00FF00 -anchor w \
        -borderwidth 0 \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-* \
        -highlightbackground #000000 -highlightthickness 3 -image stop-on \
        -indicatoron 0 -padx 5 -pady 5 \
        -value stop -variable playmode -command { 
        	puts "=STOP"
        	set s_or_p "1"
	}
    place .top1.fra2.fra30.rad6 \
        -x 160 -relx 0 -y 6 -rely 0 -anchor nw -bordermode ignore 
	bindtags .top1.fra2.fra30.rad6 MyButton
    radiobutton .top1.fra2.fra30.rad7 \
        -selectcolor #00FF00 -anchor w -bg #008800 \
        -borderwidth 0 \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-* \
        -highlightbackground #000000 -highlightthickness 3 \
        -indicatoron 0 -padx 5 -pady 5 \
        -image play-on -value play -variable playmode -command { 
        	puts "=PLAY"
        	set s_or_p "0"
			.top1.fra2.fra15.lis18 selection clear 0 end
			.top1.fra2.fra15.lis18 selection set $current
			.top1.fra2.fra15.lis18 see $current
        }
    place .top1.fra2.fra30.rad7 \
        -x 210 -relx 0 -y 6 -rely 0 -anchor nw -bordermode ignore 
	bindtags .top1.fra2.fra30.rad7 MyButton
    button .top1.fra2.fra30.rad8 \
        -anchor w -background #00FF00 \
        -borderwidth 0 \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-* \
        -highlightbackground #000000 -highlightthickness 3 -image nextpat-on \
        -padx 5 -pady 5 \
        -command {
        	puts "=NEXTPAT"
		}
    place .top1.fra2.fra30.rad8 \
        -x 260 -relx 0 -y 6 -rely 0 -anchor nw -bordermode ignore 
	bindtags .top1.fra2.fra30.rad8 MyButton
    button .top1.fra2.fra30.rad9 \
        -anchor w -background #00FF00 \
        -borderwidth 0 \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-* \
        -highlightbackground #000000 -highlightthickness 3 -image nextmod-on \
        -padx 5 -pady 5 \
        -command {
        	puts "=NEXTMOD"
		}
    place .top1.fra2.fra30.rad9 \
        -x 310 -relx 0 -y 6 -rely 0 -anchor nw -bordermode ignore 
	bindtags .top1.fra2.fra30.rad9 MyButton
    button .top1.fra2.fra30.but2 \
        -activeforeground #ffff00 \
        -background #000000 -command {Window show .top2} \
        -disabledforeground #000000 \
        -font -Adobe-Helvetica-Bold-R-Normal-*-*-120-*-*-*-*-*-* \
        -foreground #ffff00 -highlightbackground #000000 -padx 9 -pady 3 \
        -relief raised -text Quit -width 5 
    place .top1.fra2.fra30.but2 \
        -x 370 -relx 0 -y 5 -rely 0 -anchor nw -bordermode ignore 
	bindtags .top1.fra2.fra30.but2 MyButton
    frame .top1.fra2.fra62 \
        -background #000000 -borderwidth 5 -height 30 -relief sunken \
        -width 30 
    place .top1.fra2.fra62 \
        -x 315 -relx 0 -y 150 -rely 0 -width 190 -height 120 -anchor nw \
        -bordermode ignore 
    frame .top1.fra2.fra62.fra77 \
        -background #000000 -height 30 -width 30 
    place .top1.fra2.fra62.fra77 \
        -x 5 -relx 0 -y 5 -rely 0 -width 85 -height 80 -anchor nw \
        -bordermode ignore 
    checkbutton .top1.fra2.fra62.fra77.che1 \
        -bg #008800 -selectcolor #00FF00 -borderwidth 0 \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-* \
        -highlightthickness 0 -indicatoron 0 \
        -image random-on \
        -variable che1 -command {
			if { $che1 == 1 } { 
				puts "=RANDOM" 
			} else {
				puts "=ORDERLY"
			}
		}
    pack .top1.fra2.fra62.fra77.che1 \
        -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 \
        -side top 
	bindtags .top1.fra2.fra62.fra77.che1 MyButton
    checkbutton .top1.fra2.fra62.fra77.che2 \
        -bg #008800 -selectcolor #00FF00 -borderwidth 0 \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-* \
        -highlightthickness 0 -indicatoron 0 \
        -image repeat-on -takefocus yes \
        -variable che2 
    pack .top1.fra2.fra62.fra77.che2 \
        -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 \
        -side top 
	bindtags .top1.fra2.fra62.fra77.che2 MyButton
    checkbutton .top1.fra2.fra62.fra77.che3 \
        -bg #008800 -selectcolor #00FF00 -borderwidth 0 \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-* \
        -highlightthickness 0 -indicatoron 0 \
        -image tolerant-on -takefocus yes \
        -variable che3 
    pack .top1.fra2.fra62.fra77.che3 \
        -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 \
        -side top 
	bindtags .top1.fra2.fra62.fra77.che3 MyButton
    checkbutton .top1.fra2.fra62.fra77.che4 \
        -bg #008800 -selectcolor #00FF00 -borderwidth 0 \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-* \
        -highlightthickness 0 -image extspeed-on -indicatoron 0 \
        -takefocus yes \
        -variable che4 
    pack .top1.fra2.fra62.fra77.che4 \
        -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 \
        -side top 
	bindtags .top1.fra2.fra62.fra77.che4 MyButton
    frame .top1.fra2.fra62.fra98 \
        -background #000000 -height 30 -highlightbackground #000000 -width 30 
    place .top1.fra2.fra62.fra98 \
        -x 90 -relx 0 -y 5 -rely 0 -width 85 -height 80 -anchor nw \
        -bordermode ignore 
    checkbutton .top1.fra2.fra62.fra98.che5 \
		-activebackground #00FF00 -bg #00FF00 \
		-selectcolor #00FF00 \
		-borderwidth 0 \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-* \
        -highlightthickness 0 -image 16-bit -indicatoron 0 -padx 0 -pady 0 \
        -selectimage 8-bit -variable che5 -command { \
		if {$che5 == "1"} {
			puts "=16BIT"
		} else {puts "=8BIT"}
        }
    pack .top1.fra2.fra62.fra98.che5 \
        -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 \
        -side top 
    checkbutton .top1.fra2.fra62.fra98.che6 \
        -activebackground #00FF00 -bg #00FF00 -borderwidth 0 \
		-selectcolor #00FF00 \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-* \
        -highlightthickness 0 -image normal -indicatoron 0 -padx 0 -pady 0 \
        -selectimage interp -variable che6 -command {
        	if {$che6 == "1"} {
        		puts "=INTERP"
        	} else {puts "=NOINTERP"}
        }
    pack .top1.fra2.fra62.fra98.che6 \
        -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 \
        -side top 
    checkbutton .top1.fra2.fra62.fra98.che7 \
        -activebackground #00FF00 -bg #00FF00 -borderwidth 0 \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-* \
        -highlightthickness 0 -image stereo -indicatoron 0 -padx 0 -pady 0 \
        -selectimage mono -variable che7 -command {
        	if {$che7 == "1"} { 
        		puts "=MONO" 
        	} else {puts "=STEREO"}
        }
    pack .top1.fra2.fra62.fra98.che7 \
        -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 \
        -side top 
    checkbutton .top1.fra2.fra62.fra98.che8 \
        -bg #008800 -selectcolor #00FF00 -borderwidth 0 \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-* \
        -highlightthickness 0 -image panning-on -indicatoron 0 -padx 0 \
        -pady 0 -variable che8 
    pack .top1.fra2.fra62.fra98.che8 \
        -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 \
        -side top 
	bindtags .top1.fra2.fra62.fra98.che8 MyButton
    frame .top1.fra2.fra62.fra16 \
        -background #00d600 -borderwidth 5 -height 30 -relief sunken \
        -width 30 
    place .top1.fra2.fra62.fra16 \
        -x 5 -relx 0 -y 85 -rely 0 -width 170 -height 30 -anchor nw \
        -bordermode ignore 
    label .top1.fra2.fra62.fra16.lab18 \
        -background #000000 -borderwidth 0 \
        -font -Adobe-Helvetica-Bold-R-Normal-*-*-120-*-*-*-*-*-* \
        -foreground #ffff00 -highlightcolor #00ff00 -text 44100 
    place .top1.fra2.fra62.fra16.lab18 \
        -x 0 -relx 0 -y 5 -rely 0 -width 88 -height 25 -anchor nw \
        -bordermode ignore 
    button .top1.fra2.fra62.fra16.but19 \
        -activebackground #000000 -activeforeground #ffffff \
        -background #000000 -borderwidth 0 \
        -font -Adobe-Helvetica-Bold-O-Normal-*-*-120-*-*-*-*-*-* \
        -foreground #ffffff -padx 9 -pady 3 -text Frequency 
    place .top1.fra2.fra62.fra16.but19 \
        -x 85 -relx 0 -y 5 -rely 0 -width 85 -height 28 -anchor nw \
        -bordermode ignore 
    frame .top1.fra2.fra20 \
        -background #000000 -borderwidth 3 -height 30 -relief groove -width 9 
    place .top1.fra2.fra20 \
        -x 5 -relx 0 -y 5 -rely 0 -width 65 -height 265 -anchor nw \
        -bordermode ignore 
    label .top1.fra2.fra20.01 \
        -background #000000 \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-* \
        -foreground #00ff00 -padx 3 -pady 0 -text {VOL %} -width 7 
    place .top1.fra2.fra20.01 \
        -x 5 -relx 0 -y 5 -rely 0 -anchor nw -bordermode ignore 
    scale .top1.fra2.fra20.02 \
        -activebackground #00ff00 -background #000000 \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-* \
        -foreground #00ff00 -from 250.0 -highlightbackground #00ff00 \
        -showvalue 0 -takefocus yes -tickinterval -50.0 \
        -to 0.0 -troughcolor #a5d5a5 -variable VOL 
    place .top1.fra2.fra20.02 \
        -x 5 -relx 0 -y 25 -rely 0 -width 55 -height 233 -anchor nw \
        -bordermode ignore 
    frame .top1.fra2.fra21 \
        -background #000000 -borderwidth 3 -height 30 -relief groove -width 9 
    place .top1.fra2.fra21 \
        -x 505 -relx 0 -y 5 -rely 0 -width 65 -height 265 -anchor nw \
        -bordermode ignore 
    label .top1.fra2.fra21.01 \
        -background #000000 \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-* \
        -foreground #00ff00 -padx 3 -pady 0 -text {BPM %} -width 7 
    place .top1.fra2.fra21.01 \
        -x 5 -relx 0 -y 5 -rely 0 -anchor nw -bordermode ignore 
    scale .top1.fra2.fra21.02 \
        -activebackground #00ff00 -background #000000 \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-* \
        -foreground #00ff00 -from 250.0 -highlightbackground #00ff00 \
        -showvalue 0 -takefocus yes -tickinterval -50.0 \
        -to 0.0 -troughcolor #a5d5a5 -variable BPM 
    place .top1.fra2.fra21.02 \
        -x 5 -relx 0 -y 25 -rely 0 -width 55 -height 233 -anchor nw \
        -bordermode ignore 
    frame .top1.fra2.fra22 \
        -borderwidth 1 -height 30 -relief sunken -width 30 
    place .top1.fra2.fra22 \
        -x 70 -relx 0 -y 40 -rely 0 -width 435 -height 65 -anchor nw \
        -bordermode ignore 
    label .top1.fra2.fra22.lab25 \
        -background #010000 -borderwidth 5 \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-160-*-*-*-*-*-* \
        -foreground #ffff00 -relief groove 
    place .top1.fra2.fra22.lab25 \
        -x 0 -relx 0 -y 0 -rely 0 -width 218 -height 35 -anchor nw \
        -bordermode ignore 
    label .top1.fra2.fra22.lab27 \
        -background #000000 -borderwidth 5 \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-* \
        -foreground #ffff00 -relief groove 
    place .top1.fra2.fra22.lab27 \
        -x 0 -relx 0 -y 35 -rely 0 -width 148 -height 30 -anchor nw \
        -bordermode ignore 
    label .top1.fra2.fra22.lab28 \
        -background #000000 -borderwidth 5 \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-* \
        -foreground #ffff00 -relief groove 
    place .top1.fra2.fra22.lab28 \
        -x 145 -relx 0 -y 35 -rely 0 -width 148 -height 30 -anchor nw \
        -bordermode ignore 
    label .top1.fra2.fra22.lab29 \
        -background #000000 -borderwidth 5 \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-* \
        -foreground #ffff00 -relief groove 
    place .top1.fra2.fra22.lab29 \
        -x 290 -relx 0 -y 35 -rely 0 -width 143 -height 30 -anchor nw \
        -bordermode ignore 
    label .top1.fra2.fra22.lab30 \
        -background #010000 -borderwidth 5 \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-160-*-*-*-*-*-* \
        -foreground #ffff00 -relief groove 
    place .top1.fra2.fra22.lab30 \
        -x 215 -relx 0 -y 0 -rely 0 -width 218 -height 35 -anchor nw \
        -bordermode ignore 
}

proc vTclWindow.top2 {args} {
    set base .top2
    if {[winfo exists .top2]} {
        wm deiconify .top2; return
    }
    toplevel .top2 -class Toplevel \
        -background #d7d7d7 
    wm focusmodel .top2 passive
    wm geometry .top2 368x85+200+200
    wm maxsize .top2 1137 870
    wm minsize .top2 1 1
    wm overrideredirect .top2 0
    wm deiconify .top2
    wm title .top2 "Confirm"
    frame .top2.fra7 \
        -height 30 -relief sunken -width 230 
    pack .top2.fra7 \
        -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 \
        -side top 
    label .top2.fra7.lab5 \
        -background #000000 -borderwidth 0 \
        -font -Adobe-Helvetica-Bold-O-Normal-*-*-240-*-*-*-*-*-* \
        -foreground #ffff00 -relief groove \
        -text {Are you sure you want to quit?} -width 103 
    pack .top2.fra7.lab5 \
        -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 \
        -side top 
    frame .top2.fra22 \
        -background #a5d5a5 -height 30 -relief sunken -width 30 
    place .top2.fra22 \
        -x 0 -relx 0 -y 30 -rely 0 -width 370 -height 60 -anchor nw \
        -bordermode ignore 
    button .top2.fra22.but23 \
        -bg #00FF00 -borderwidth 5 -command {finish} \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-* -height 21 \
        -highlightbackground #000000 -highlightthickness 0 -image tick -padx 9 -pady 3
    place .top2.fra22.but23 \
        -x 5 -relx 0 -y 12 -rely 0 -anchor nw -bordermode ignore 
	bindtags .top2.fra22.but23 MyButton
    button .top2.fra22.but24 \
        -background #FF0000 -borderwidth 5 \
        -command {destroy .top2} \
        -font -Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-* -height 21 \
        -highlightbackground #000000 -highlightthickness 0 -image cross \
        -padx 9 -pady 3
    place .top2.fra22.but24 \
        -x 230 -relx 0 -y 12 -rely 0 -anchor nw -bordermode ignore 
	bindtags .top2.fra22.but24 MyButton
    label .top2.fra22.lab25 \
        -background #000000 \
        -font -Adobe-Helvetica-Bold-O-Normal-*-*-240-*-*-*-*-*-* \
        -foreground #ffff00 -justify left -relief groove -text Yes! 
    place .top2.fra22.lab25 \
        -x 65 -relx 0 -y 12 -rely 0 -width 73 -height 33 -anchor nw \
        -bordermode ignore 
    label .top2.fra22.lab26 \
        -background #000000 \
        -font -Adobe-Helvetica-Bold-O-Normal-*-*-240-*-*-*-*-*-* \
        -foreground #ffff00 -highlightbackground #000000 -relief groove \
        -text No! 
    place .top2.fra22.lab26 \
        -x 290 -relx 0 -y 12 -rely 0 -width 73 -height 33 -anchor nw \
        -bordermode ignore 
}

Window show .
Window show .top1
.top1.fra2.fra30.rad6 select
ShowFileSelector
