/* 
	ui.h

	Defines macros for user interface commands

HISTORY
-------
v1.00 - added this history section
v1.01 - Added UI_PLAY and UI_STOP (Peter Amstutz)
v1.02 - Added UI_RANDOM, UI_ORDERLY, UI_DEL_AFTER_PLAY, UI_NO_DEL_AFTER_PLAY 
		(Peter Amstutz)

*/

#define BASE_UI 10
#define UI_NEXT_SONG    (BASE_UI)            /* load next song */

#define UI_RESTART (BASE_UI + 1)          /* restart current song. Not 
					     quite jump to 0 */
#define UI_PREVIOUS_SONG (BASE_UI + 2)    /* load previous song */

#define UI_LOAD_SONG (BASE_UI + 3)        /* load song. Name as value */
#define UI_SET_BPM (BASE_UI + 4)          /* set beat per minute to value */

#define UI_JUMP_TO_NEXT_PATTERN (BASE_UI + 5)  /* jump to pattern */
#define UI_RESTART_PATTERN (BASE_UI + 7)  /* jump to pattern */
#define UI_JUMP_TO_PREV_PATTERN (BASE_UI + 7)  /* jump to pattern */

#define UI_QUIT (BASE_UI + 6)             /* need I say more ? */
#define UI_DISPLAY (BASE_UI + 7)          /* status of scrolling window: 
					     true or false */
#define UI_PAUSE (BASE_UI + 8)             /* need I say more ? */

#define UI_SPEED_UP (BASE_UI + 9)             /* raise the speed */
#define UI_SLOW_DOWN (BASE_UI + 10)         /* slow down */
#define UI_NORMAL_SPEED (BASE_UI + 11)      /* return to normal */

#define UI_VOL_UP (BASE_UI + 12)             /* raise the volume */
#define UI_VOL_DOWN (BASE_UI + 13)         /* quieten down */
#define UI_NORMAL_VOL (BASE_UI + 14)      /* return to normal */

#define UI_MARK_DELETED (BASE_UI + 15) /* mark mod for deletion */
#define UI_DELETE_MARKED (BASE_UI + 16) /* delete MARKED mods, ignore otherwise */

#define UI_SELECT_MONO (BASE_UI + 17)	/* additions for changing of audio */
#define UI_SELECT_STEREO (BASE_UI + 18) /* paramaters on the fly */

#define UI_SELECT_INTERP (BASE_UI + 19)
#define UI_SELECT_NONINTERP (BASE_UI + 20)

#define UI_SELECT_8BIT (BASE_UI + 21)
#define UI_SELECT_16BIT (BASE_UI + 22)

#define UI_PLAY (BASE_UI + 23)
#define UI_STOP (BASE_UI + 24)

#define UI_RANDOM (BASE_UI + 25) /* play in random order */
#define UI_ORDERLY (BASE_UI + 26) /* play sequentially */

#define UI_DEL_AFTER_PLAY (BASE_UI + 27)
#define UI_NO_DEL_AFTER_PLAY (BASE_UI + 28)

#define SMALL_DELAY 15
