#!/bin/bash

export ARG0=$0

if [ "$1" = "" -o "$1" = "install" ] ; then
    CMD=install
elif [ "$1" = "uninstall" ] ; then
    CMD=uninstall
else
    echo
    echo "Usage: install_icon_on_desktop.sh [uninstall]"
    echo
    exit 1
fi


POSTINST_DIR=${ARG0%/*}  # Delete trailing file name.
POSTINST_DIR=$( cd $POSTINST_DIR; pwd )
export POSTINST_DIR
pushd $POSTINST_DIR  > /dev/null


. ./functions

# Install Desktop icon to the user's Desktop, instead of root 
# (unless root login directly).
echo ${CMD}ling desktop icon...
if [ "${CMD}" = "uninstall" ] ; then
    # Uninstall; no logging.
         $AS_USER "xdg-desktop-icon uninstall --novendor ${INSTDIR}/share/${PACKAGE}.desktop"
else
           $AS_USER "xdg-desktop-icon install --novendor ${INSTDIR}/share/${PACKAGE}.desktop"
    logcmd $AS_USER "xdg-desktop-icon install --novendor ${INSTDIR}/share/${PACKAGE}.desktop"
fi

# su always return success, even though xdg-desktop-icon failed.
#last_cmd_status_check

popd > /dev/null

