#!/bin/bash

export ARG0=$0

POSTINST_DIR=${ARG0%/*}  # Delete trailing file name.
POSTINST_DIR=$( cd $POSTINST_DIR; pwd )
export POSTINST_DIR
pushd $POSTINST_DIR  > /dev/null


. ./functions


if [ "$ID" != "0" ]; then
    mkdir -p $LOCALEPATH > /dev/null 2>&1
fi

if [ -n "$LOCALEPATH" -a -d "$LOCALEPATH" ] ; then

    echo Installing .mo locale files...
    for LANGUAGE in `ls $INSTDIR/share/locale` ; do
        DEST_DIR=$LOCALEPATH/$LANGUAGE/LC_MESSAGES
        if [ "$ID" != "0" ] ; then
            mkdir -p $DEST_DIR > /dev/null 2>&1
        fi
        if [ -f $INSTDIR/share/locale/$LANGUAGE/player.mo ] ; then
            eval_cmd rm -f "$DEST_DIR/$TARGET.mo"
            eval_cmd install -m 644 "$INSTDIR/share/locale/$LANGUAGE/player.mo" "$DEST_DIR/$TARGET.mo" 
        fi
        if [ -f $INSTDIR/share/locale/$LANGUAGE/widget.mo ] ; then
            eval_cmd rm -f "$DEST_DIR/libgtkhx.mo"
            eval_cmd install -m 644 "$INSTDIR/share/locale/$LANGUAGE/widget.mo" "$DEST_DIR/libgtkhx.mo" 
        fi
    done
fi

#last_cmd_status_check

popd > /dev/null

