#!/bin/bash

export ARG0=$0

POSTINST_DIR=${ARG0%/*}  # Delete trailing file name.
POSTINST_DIR=$( cd $POSTINST_DIR; pwd )
export POSTINST_DIR
pushd $POSTINST_DIR  > /dev/null


. ./functions

MOZFOUND=0

config_mozilla()
{
    local MOZDIR_LOCAL=
    MOZDIR_LOCAL=$1

    if [ $MOZFOUND -eq 0 ] ; then
        echo $"Configuring Mozilla..."
        MOZFOUND=1
    fi
    eval_cmd ln -sf "$INSTDIR/mozilla/nphelix.so" "$MOZDIR_LOCAL"
    eval_cmd ln -sf "$INSTDIR/mozilla/nphelix.xpt" "$MOZDIR_LOCAL"
}


# main()

# find user's plugins directory
USR_MOZDIR=
if [ -n "$HOME" -a -d "$HOME" ] ; then
    USR_MOZDIR=$HOME/.mozilla/plugins
fi

# $LOGNAME for real user (while su to root.)
REAL_USR_MOZDIR=
if [ -n "$LOGNAME" ] ; then
    if [ -d "/home/$LOGNAME" ] ; then
        REAL_USR_MOZDIR=/home/$LOGNAME/.mozilla/plugins
    elif [ -d "/export/home/$LOGNAME" ] ; then
        REAL_USR_MOZDIR=/export/home/$LOGNAME/.mozilla/plugins
    fi
fi

if [ "$USR_MOZDIR" = "" -a "$REAL_USR_MOZDIR" != "" ] ; then
    USR_MOZDIR=$REAL_USR_MOZDIR
fi

# Handle root user case
if [ "$ID" = "0" ] ; then
    # find system plugins directory
    for MOZDIR in "/usr/lib/mozilla/plugins"         \
                  "/usr/lib/browser-plugins"         \
                  "/opt/mozilla/lib/plugins"         \
                  "/usr/lib/firefox/plugins"         \
                  "/usr/lib/mozilla-firefox/plugins" \
                  "/usr/lib/netscape/plugins"        \
                  "/opt/mozilla/plugins"             \
                  "/opt/netscape/plugins"; do
        if [ -d "$MOZDIR" ] ; then
            config_mozilla "$MOZDIR"
        fi
    done
    unset MOZDIR

    if [ $MOZFOUND -eq 0 ] ; then
        echo $"No system-wide Mozilla plugin directory found."
        echo $"Please enter Mozilla's plugins directory to install the Mozilla plug-in,"
        echo $"or leave blank to skip plug-in installation;"
        echo $"for example, /usr/lib/mozilla/plugins :"
        read MOZDIR
    fi

    if [ -n "$MOZDIR" -a -d "$MOZDIR" ] ; then
        config_mozilla "$MOZDIR"
    fi

    # Remove local Mozilla plugin from current real user's home directory for consistency sake.
    if [ $MOZFOUND -eq 1 -a "$REAL_USR_MOZDIR" != "" ] ; then
        eval_cmd rm -f $REAL_USR_MOZDIR/nphelix.so  > /dev/null 2>&1
        eval_cmd rm -f $REAL_USR_MOZDIR/nphelix.xpt > /dev/null 2>&1
    fi

else

    if [ -n "$USR_MOZDIR" ] ; then
        # make sure it exists
        if [ ! -d $USR_MOZDIR ] ; then
            eval_cmd mkdir -p $USR_MOZDIR      > /dev/null 2>&1
        fi
        config_mozilla "$USR_MOZDIR"
    else
        echo $"Cannot find \$HOME."
        echo $"Set your \$HOME environment variable and re-run "
        echo $"postinst/inst_moz_plugins.sh to install the mozilla plugin."
        echo $"Or manually copying nphelix.so and nphelix.xpt into " 
        echo $"the Mozilla plugin directory to install it."
        echo $"If you think you've encountered this in error, please file a bug report at:"
        echo $"https://bugs.helixcommunity.org/enter_bug.cgi?product=player"
    fi
fi


popd > /dev/null

