#!/bin/bash

export ARG0=$0

POSTINST_DIR=${ARG0%/*}  # Delete trailing file name.
POSTINST_DIR=$( cd $POSTINST_DIR; pwd )
export POSTINST_DIR
pushd $POSTINST_DIR  > /dev/null


. ./functions

# Make sure /usr/share and /usr/bin are writable.
USR_SHARE_DIR=/usr/share
USR_BIN_DIR=/usr/bin

if ! ( dir_writable $USR_SHARE_DIR && dir_writable $USR_BIN_DIR ) ; then
    echo "$USR_SHARE_DIR" or "$USR_BIN_DIR" $"no write-permission...skip."
    exit 1;   # Abort.
fi



eval_cmd test -L /usr/share/${PACKAGE} && rm -f /usr/share/${PACKAGE}
eval_cmd ln -s ${INSTDIR}/share /usr/share/${PACKAGE}

eval_cmd test -L /usr/bin/${PACKAGE} && rm -f /usr/bin/${PACKAGE}
eval_cmd ln -s ${INSTDIR}/${PACKAGE} /usr/bin/${PACKAGE}

last_cmd_status_check

popd > /dev/null

