#! /bin/bash

VERSION=2.0.5
PKGNAME=ripdvd

usage() {
cat << END

Usage: $0 [OPTIONS]
	
	OPTIONS:
		DESTDIR=DESTDIR (fake /tmp directory)
		--prefix=PREFIX
		--mandir=MANDIR
		--docdir=DOCDIR
		--icondir=ICONDIR
		--deskdir=DESKDIR
		--localedir=LOCALEDIR

		--help|-h: this help message

END
}

print_log() {
cat >&1 <<EOR
    RipDVD will be installed according the the following settings:

    	Destination directory			[${DESTDIR}]
        Executables                             [$BINDIR]
        Libraries                               [$LIBDIR]
	Locale files                            [$LANGDIR]
	Desktop integration                     [$DESKDIR]
	Icon files                              [$ICONDIR]
        Man pages                               [$MANDIR]
	Documentation files                     [$DOCDIR]

EOR
}

install_pkg() {
	if [ ${UID} -ne 0 ]; then
		echo "You must be suid root to run this script !"
		exit 1
	fi
	echo "Installing RipDVD into ${DESTDIR}/${PREFIX} ..."
	mkdir -p "${DESTDIR}/${BINDIR}"
	mkdir -p "${DESTDIR}/${DOCDIR}"
	mkdir -p "${DESTDIR}/${LANGDIR}"
	mkdir -p "${DESTDIR}/${MANDIR}"
	mkdir -p "${DESTDIR}/${LIBDIR}"
	mkdir -p "${DESTDIR}/${DESKDIR}"
	mkdir -p "${DESTDIR}/${ICONDIR}"
	${INSTALL} -m 755 -o root -g bin ripdvd "${DESTDIR}/${BINDIR}/ripdvd"
	sed -i 's@PREFIX="/usr/local"@PREFIX='"${PREFIX}"'@' "${DESTDIR}/${BINDIR}/ripdvd"
	sed -i 's@LOCALE_DIR="${PREFIX}/share/locale"@LOCALE_DIR='"${LANGDIR}"'@' "${DESTDIR}/${BINDIR}/ripdvd"
	sed -i 's@LIB_DIR="${PREFIX}/lib/ripdvd"@LIB_DIR='"${LIBDIR}"'@' "${DESTDIR}/${BINDIR}/ripdvd"
	${INSTALL} -m 755 -o root -g bin xripdvd "${DESTDIR}/${BINDIR}/xripdvd"
	${INSTALL} -m 644 -o root -g root -t "${DESTDIR}/${DOCDIR}" AUTHORS Changelog COPYING INSTALL* README* TODO
	${INSTALL} -m 644 -o root -g root -t "${DESTDIR}/${MANDIR}" man/ripdvd.1
	ln -s "${DESTDIR}/${MANDIR}/ripdvd.1" "${DESTDIR}/${MANDIR}/xripdvd.1"
	${INSTALL} -m 644 -o root -g root -t "${DESTDIR}/${LIBDIR}" libs/*
	${INSTALL} -m 644 -o root -g root -t "${DESTDIR}/${DESKDIR}" desktop/*
	${INSTALL} -m 644 -o root -g root -t "${DESTDIR}/${ICONDIR}" imgs/*
	${INSTALL} -m 755 -o root -g root opt/ripdvd_completion "${DESTDIR}/etc/bash_completion.d/ripdvd"
	for lang in $(ls locale); do
		mkdir -p "${DESTDIR}/${LANGDIR}/${lang}"
		${INSTALL} -m 644 -o root -g root -t "${DESTDIR}/${LANGDIR}/${lang}" locale/${lang}/*
	done
	echo "Done !"
}

unset PREFIX DOCDIR MANDIR ICONDIR
while [ $# -gt 0 ]; do
	case $1 in
		DESTDIR=?*)
			DESTDIR=$(echo "$1" | cut -f2 -d=); shift ;;
		--prefix=?*)
			PREFIX=$(echo "$1" | cut -f2 -d=); shift ;;
		--mandir=?*)
			MANDIR=$(echo "$1" | cut -f2 -d=); shift ;;
		--docdir=?*)
			DOCDIR=$(echo "$1" | cut -f2 -d=); shift ;;
		--icondir=?*)
			ICONDIR=$(echo "$1" | cut -f2 -d=); shift ;;
		--deskdir=?*)
			DESKDIR=$(echo "$1" | cut -f2 -d=); shift ;;
		--localedir=?*)
			LANGDIR=$(echo "$1" | cut -f2 -d=); shift ;;
		--libdir=?*)
			LIBDIR=$(echo "$1" | cut -f2 -d=); shift ;;
		--help|-h)
			usage; exit 0 ;;
		*)
			usage; exit 1 ;;
	esac
done

DESTDIR=${DESTDIR:-"/"}
PREFIX=${PREFIX:-"/usr/local"}
BINDIR="${PREFIX}/bin"
LIBDIR=${LIBDIR:-"${PREFIX}/lib/ripdvd"}
LANGDIR=${LANGDIR:-"${PREFIX}/share/ripdvd/locale"}
DOCDIR=${DOCDIR:-"${PREFIX}/doc/ripdvd-${VERSION}"}
DESKDIR=${DESKDIR:-"${PREFIX}/share/applications"}
ICONDIR=${ICONDIR:-"${PREFIX}/share/icons"}
MANDIR=${MANDIR:-"${PREFIX}/man/man1"}


INSTALL=$(which install)

print_log
install_pkg
exit 0
