/***************************************************************************
 SocNetV: Social Networks Visualiser for Linux
 version: 0.43
 Written in Qt 3.0+ with KDevelop 3.1  

                        actor.cpp  -  description
                             -------------------
    copyright            : (C) 2005, 2006 by Dimitris B. Kalamaras
    email                : dimitris.kalamaras@compupress.gr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "actor.h"


Actor::Actor( QCanvas *canvas, int actorNum, int value, int size, QString aColor, QString aLabel, QString lColor, double x0, double y0, QString aShape , int ld, int nd):QCanvasPolygonalItem(canvas) {
	qDebug("Actor()");
	m_ld=ld;
	m_nd=nd;
	m_actorNumber=actorNum;
	m_Label=aLabel;
	m_actorColor=aColor;
	m_Value=value;
	m_labelColor=lColor;
	m_Shape=aShape;
	m_x0=x0;
	m_y0=y0;
	qDebug ("Actor() will be at x=%i and y=%d",(int) m_x0,(int) m_y0);
	m_Size=size; 
	/**
	*  boundPoints is pointarray used in areaPoints() to calculate 
	*  the bounding box of all kinds of shapes.	
	*/
	boundPoints.putPoints(0,4, -m_Size-3,-m_Size-3, +m_Size+3,-m_Size-3,  +m_Size+3, +m_Size+3,  -m_Size-3, +m_Size+3);
	/**
	* Points is a pointarray used to draw the shapes. 
	* It holds each shape's absolute points and it is centered at (0,0)
	*/
	if ( m_Shape == "circle") {
		points.resize(0);
		points.makeEllipse(-m_Size,-m_Size, 2*m_Size, 2*m_Size);
	}
	if ( m_Shape == "ellipse") {
		points.resize(0);
		points.makeEllipse(-m_Size,-m_Size,  2*m_Size, m_Size);
	}
	if ( m_Shape == "box")
		points.putPoints(0,4, -m_Size,-m_Size, +m_Size,-m_Size,  +m_Size, +m_Size,  -m_Size, +m_Size);
	if ( m_Shape == "triangle") {
		points.resize(0);
		points.putPoints(0,3,  0, -m_Size, -m_Size, +m_Size,+m_Size,+m_Size);
	}
	else if ( m_Shape == "diamond")
		points.putPoints(0,4,  0, -m_Size,  +m_Size, 0,  0, +m_Size, -m_Size, 0);

	this-> setBrush(QBrush(aColor));
	this-> setPen(QPen(black,1,Qt::SolidLine));
	
	qDebug("actor() calls translate()" );
	points.translate((int)m_x0,(int)m_y0);	//move the actual points of the actor's shape
	boundPoints.translate((int)m_x0,(int)m_y0);	//move the bounding points 
	qDebug("actor() translate() OK!");

	this-> setZ(254);
	qDebug("Calling actor show()");
	this-> show();  
	qDebug("actor show() OK!");
	qDebug("actor is at x = %f, y=%f", this->x(), this->y());
	
} 

void Actor::move(double x, double y){
	qDebug("move() ");
	this->moveBy(x-m_x0,y-m_y0);
}

void Actor::setX(double x) {
	qDebug("setX() ");
	this->moveBy(x-m_x0,0);
}

void Actor::setY(double y){
	qDebug("setY() ");
	this->moveBy(0,y-m_y0);
}




Actor::~Actor(){
	qDebug("~Actor() calling hide()");
	
	this->hide();
	qDebug("hide() ok!");
	
}


/** 
*  AreaPoints() returns a pointarray of points outside and not touching
*  the actual points to be drawed.
*  Overloaded by returning a whole QRect bounding the pointarray...
*/
QPointArray Actor::areaPoints() const{
	qDebug("areaPoints()");
	return boundPoints.boundingRect();
}





/**
*  SetShape() is called every time the user needs to change the shape of an actor.
*  It is also called from setSize() every time the user changes the actorSize.
*  - Invalidates the canvasItem, 
*  - Recalculates the  absolute points of the shape and of the bounding box
*  - Moves points and boundPoints to original place.
*/
void Actor::setShape(QString shape) {
	qDebug("setShape()");
	m_Shape=shape;
	m_x0=this->x();
	m_y0=this->y();
	qDebug ("actor is at x=%f and y=%f", m_x0, m_y0);
	qDebug("setShape invalidate()");
	this->invalidate();

	boundPoints.putPoints(0,4, -m_Size-3,-m_Size-3, +m_Size+3,-m_Size-3,  +m_Size+3, +m_Size+3,  -m_Size-3, +m_Size+3);
	if ( m_Shape == "circle") {
		points.resize(0);
		points.makeEllipse(-m_Size,-m_Size,  2*m_Size, 2*m_Size);
	}
	if ( m_Shape == "ellipse") {
		points.resize(0);
		points.makeEllipse(-m_Size,-m_Size,  2*m_Size,  m_Size);
	}
	if ( m_Shape == "box") {
		points.resize(4);
		points.putPoints(0,4, -m_Size,-m_Size, +m_Size,-m_Size,  +m_Size, +m_Size,  -m_Size, +m_Size);
	}
	if ( m_Shape == "triangle") {
		points.resize(3);
		points.putPoints(0,3,  0, -m_Size, -m_Size, +m_Size,+m_Size,+m_Size);
	}
	else if ( m_Shape == "diamond"){
		points.resize(4);
		points.putPoints(0,4,  0, -m_Size,  +m_Size, 0,  0, +m_Size, -m_Size, 0);
	}


	
 	qDebug("setShape() calling translations() ");
	boundPoints.translate((int)m_x0,(int)m_y0);	//move the bounding points of the shape
	points.translate((int)m_x0,(int)m_y0);		//move the actual points of the shape 
	qDebug("setShape() = translations() OK!");
	qDebug("setShape() calls update()");
	this-> update();
	qDebug("setShape() updated() OK!");

}

void Actor::drawShape( QPainter &painter){
	qDebug("drawShape()");
 	painter.drawPolygon(points);
// 	painter.setFont( QFont ("Courier", 8) );
// 	painter.drawText((int)m_x0-m_Size, (int)m_y0-m_Size , 2*m_Size,2*m_Size , AlignCenter, QString::number(m_actorNumber));
}



void Actor::setSize(int size){
	qDebug("setSize()");
	m_Size=size;
	this->setShape(m_Shape);
 
}


/**
*  Used by App::findActor()
*/
int Actor::width(){
	qDebug("width()");
	return m_Size;  
}

void Actor::setLabel ( QString label) {
	m_Label=label;   
	QPtrListIterator <ActorLabel> it3 (labelList);
	ActorLabel *canvasLabel;
	while (( canvasLabel = it3.current() ))	{
  	    ++it3;
	    if (canvasLabel->isVisible())
	      canvasLabel->setText(m_Label);
    	}
}


int Actor::outLink(int i){
	QPtrListIterator<Edge> it1( outList );
	Edge *edge;
	int index=0;

	while (( edge = it1.current() ))       {
		++it1;
		++index;
		if (index == i ) return edge->toActor();
	}
	return -1; //BUG if you remove it!
}


int Actor::countOutLinks() {
	QPtrListIterator<Edge> it1( outList );
	Edge *edge;
	int j=0;
	while (( edge = it1.current() ))       {
		++it1;
		j++;
	}
	return j;  
}

int Actor::countInLinks() {
	QPtrListIterator<Edge> it1( inList );
	Edge *edge;
	int j=0;
	while (( edge = it1.current() ))   {
		++it1;
		j++;
	}
	return j;  
}


bool Actor::isOutLinkedWith( int actorNum ) {
	QPtrListIterator<Edge> it1( outList );
	Edge *edge;
	while (( edge = it1.current() ))  {
		++it1;
		if (edge->toActor()==actorNum )
		return true;
	}
	return false;
}


bool Actor::isInLinkedWith( int actorNum ) {
	QPtrListIterator<Edge> it1( inList );
	Edge *edge;
	while (( edge = it1.current() ))  {
		++it1;
		if (edge->fromActor()==actorNum )
		return true;
	}
	return false;
}

bool Actor::deleteOutLink(Edge *link){
	if ( outList.removeRef(link) )
		return true;
	return false;
}

bool Actor::deleteInLink( Edge *link ){
	if ( inList.removeRef(link) )
		return true;
	return false;
}

bool Actor::deleteOutArrow(Arrow *outA){
	if ( outArrowList.removeRef(outA) )
		return true;
	return false;
}

bool Actor::deleteInArrow( Arrow *inA ){
	if ( inArrowList.removeRef(inA) )
		return true;
	return false;
}

bool Actor::deleteLabel(ActorLabel *label){
	if ( labelList.removeRef(label) )
		return true;
	return false;
}

void Actor::clearLabel(){
	labelList.clear();
}


bool Actor::deleteNumber( ActorNumber *number ){
	if ( numberList.removeRef(number) )
		return true;
	return false;
}

void Actor::clearNumber(){
	numberList.clear();

}



int Actor::outLinkWeight( int actorNum ) {
	QPtrListIterator<Edge> it1( outList );
	Edge *edge;
	while (( edge = it1.current() ))  {
		++it1;
		if (edge->toActor()==actorNum )
			return edge->weight();
	}
	return 0;  
}


int Actor::inLinkWeight( int actorNum ) {
	QPtrListIterator<Edge> it1( inList );
	Edge *edge;
	while (( edge = it1.current() ))  {
		++it1;
		if (edge->fromActor()==actorNum )
			return edge->weight();
	}
	return 0;
}


QString Actor::outLinkColor( int actorNum ) {
	QPtrListIterator<Edge> it1( outList );
	Edge *edge;
	while (( edge = it1.current() )) {
		++it1;
		if (edge->toActor()==actorNum )
			return edge->linkColor();
	}
	return 0; 
}


QString Actor::inLinkColor( int actorNum ) {
	QPtrListIterator<Edge> it1( inList );
	Edge *edge;
	while (( edge = it1.current() ))  {
		++it1;
		if (edge->fromActor()==actorNum )
			return edge->linkColor();
	}
	return 0;
}


void Actor::moveBy(double dx, double dy) {
	qDebug("actorMoveBy()");
	qDebug ("Actor is at x=%f and y=%f", m_x0, m_y0);
	qDebug("dx = %f , dy=%f ", dx, dy);
	m_x0=m_x0+dx;
	m_y0=m_y0+dy;
	qDebug ("new positions is at x=%f and y=%f", m_x0, m_y0);

	qDebug("actor is at x = %f, y=%f", x(), y());
	qDebug("actorMoveBy() calls invalidate()");
	this->invalidate();   /**invalidates the area covered by the actor so that we can update it.*/
	qDebug("actorMoveBy() invalidate() OK!");
	qDebug("actorMoveBy() calls translate()" );
	points.translate((int)dx,(int)dy);	/**move the actual points of the actor's shape*/
	boundPoints.translate((int)dx,(int)dy);	/**move the bounding points */
	qDebug("actorMoveBy() translate() OK!");
	
	this->update();

	/**
	*  Now every element (link etc) connected to the actor has to be moved as well.
	*/ 
	/**Move inLinks*/
	QPtrListIterator<Edge> it1( inList );
	Edge *edge;
	while (( edge = it1.current() ))    {
		++it1;
		if (edge->isVisible())
			edge->setToPoint( int(x()), int(y()) );
	}
	/**Move outLinks*/
	QPtrListIterator<Edge> it2( outList );
	while (( edge = it2.current() ))    {
		++it2;
		if (edge->isVisible())
			edge->setFromPoint( int(x()), int(y()) );
	}

	/**Move label*/
	QPtrListIterator <ActorLabel> it3 (labelList);
	ActorLabel *canvasLabel;
	while (( canvasLabel = it3.current() )) {
		++it3;
		if (canvasLabel->isVisible())
			canvasLabel->move( int(x()-m_ld), int(y()-m_ld) );
	}

	/**Move actor's number (the outer one)*/
	QPtrListIterator <ActorNumber> it4 (numberList);
	ActorNumber *canvasNumber;
	while (( canvasNumber = it4.current() )) {
		++it4;
		if (canvasNumber->isVisible())
			canvasNumber->move( int(x()+m_nd), int(y()+m_nd) );
	}

	/**move InLink Arrows*/
	QPtrListIterator<Arrow> ia ( inArrowList );
	Arrow *inArrow;
	while (( inArrow = ia.current() ))   {
		++ia;
		if (inArrow->isVisible())
			inArrow->setToPoint( int(x()), int(y()) );
	}

	/**move OutLink Arrows*/
	QPtrListIterator <Arrow> oa (outArrowList);
	Arrow *outArrow;
	while (( outArrow = oa.current() ))  	{
		++oa;
		if (outArrow->isVisible())
			outArrow->setFromPoint( int(x() ), int (y() ) );
	}
}

