/***************************************************************************
 SocNetV: Social Networks Visualiser for Linux
 version: 0.43
 Written in Qt 3.3.3 with KDevelop 3.1.0  
 
                         actor.h  -  description
                             -------------------
    copyright            : (C) 2005, 2006 by Dimitris B. Kalamaras
    email                : dimitris.kalamaras@compupress.gr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ACTOR_H
#define ACTOR_H

#include <qcanvas.h>
#include <qpainter.h>
#include <qvaluevector.h>
#include "edge.h"
#include "actorlabel.h"
#include "actornumber.h"
#include "arrow.h"

static int Actor_Rtti = 1001;

class Edge;
class ActorLabel;
class ActorNumber;
class Arrow;

/**ACTOR: The core of SocNetV actor-network approach
*  This is actually a container-class.
*  Contains the graphical objects called Actors,
*  which are displayed as triangles, boxes, circles, etc, on the canvas.
*  Each actor "knows" the other actors with which she is connected.
*/

class Actor : public QCanvasPolygonalItem {
	
public:
	Actor( QCanvas *canvas, int actorNum, int value, int size, QString aColor, QString aLabel, QString lColor, double x0, double y0, QString aShape, int ld, int nd ) ;
	
	~Actor();

	double x() const {return m_x0; } 
	double y() const {return m_y0; } 

	void setX(double);
	void setY(double);
	int actorNumber() {return m_actorNumber;}

	void move (double x, double y);
	void moveBy(double dx, double dy);

	void setSize(int);
	void setShape (QString);
	QString actorShape() {return m_Shape;}

	int width();

// 	void setDeleted (bool deleted) { m_deleted=deleted;}
// 	bool deleted () { return m_deleted;}

	void setLabel ( QString label) ;
	QString label ( ) { return m_Label; }

	
	int countInLinks () ;
	void addInLink( Edge *edge ) { inList.append( edge ); }
	QString inLinkColor (int actorNum);		//IS IT NEEDED?
	int inLinkWeight (int actorNum);
	bool deleteInLink(Edge*);
	bool isInLinkedWith (int actorNum);

	int outLink (int);	
	int countOutLinks () ;
	void addOutLink( Edge *edge ) { outList.append( edge ); }
	QString outLinkColor (int actorNum);		 //IS IT NEEDED?
	int outLinkWeight (int actorNum);
	bool deleteOutLink(Edge*);
	bool isOutLinkedWith (int actorNum);           // An den exw diagrapsei swsta ena edge, gamise ta

	void deleteAllLinks () {inList.clear(); outList.clear(); }

	void addOutArrow (Arrow *outA) {outArrowList.append(outA);}
	void addInArrow (Arrow *inA) {inArrowList.append(inA);}   

	bool deleteInArrow (Arrow*) ;
	bool deleteOutArrow(Arrow*) ;

	void addLabel (ActorLabel* canvasLabel  )  { labelList.append ( canvasLabel ); }
	bool deleteLabel (ActorLabel*);
	void clearLabel(); //clears labelList

	void addNumber (ActorNumber *canvasNumber ) { numberList.append (canvasNumber);}
	bool deleteNumber(ActorNumber*);
	void clearNumber(); //clears numberList
	
	void setActorColor(QString str) {m_actorColor=str;}
	QString actorColor () { return m_actorColor;}

	void setAODC (float c){ m_ODC=c;} 	/**sets actor Out-Degree Centrality*/
	void setSAODC (float c ) { m_SAODC=c;}	/**sets standard actor Out-Degree Centrality*/
	float AODC() { return m_ODC;}		/**Returns actor Out-Degree Centrality*/
	float SAODC() { return m_SAODC; }	/**Returns standard actor Out-Degree Centrality*/

	void setAIDC (float c){ m_IDC=c;} 	/**sets actor In-Degree Centrality*/
	void setSAIDC (float c ) { m_SAIDC=c;}	/**sets standard actor In-Degree Centrality*/
	float AIDC() { return m_IDC;}		/**Returns actor In-Degree Centrality*/
	float SAIDC() { return m_SAIDC; }	/**Returns standard actor In-Degree Centrality*/


	void setACC (float c){ m_CC=c;}		/**sets actor Closeness Centrality*/
	void setSACC (float c ) { m_SACC=c;}	/**sets standard actor Closeness Centrality*/
	float ACC() { return m_CC;}		/**Returns actor Closeness Centrality*/
	float SACC() { return m_SACC; }	/**Returns standard actor Closeness Centrality*/

	void setABC(float c){ m_BC=c;}		/**sets s actor Betweeness Centrality*/
	void setSABC (float c ) { m_SABC=c;}	/**sets standard actor Betweeness Centrality*/
	float ABC() { return m_BC;}		/**Returns actor Betweeness Centrality*/
	float SABC() { return m_SABC; }	/**Returns standard actor Betweeness Centrality*/

	void setAGC (float c){ m_GC=c;}		/**sets actor Graph Centrality*/
	void setSAGC (float c ) { m_SAGC=c;}	/**sets standard actor Graph Centrality*/
	float AGC() { return m_GC;}		/**Returns actor Graph Centrality*/
	float SAGC() { return m_SAGC; }	/**Returns standard actor Graph Centrality*/

	void setASC (float c){ m_SC=c;}  	/**sets actor Stress Centrality*/
	void setSASC (float c ) { m_SASC=c;}	/**sets standard actor Stress Centrality*/
	float ASC() { return m_SC;}		/**Returns actor Stress Centrality*/
	float SASC() { return m_SASC; }	/**Returns standard actor Stress Centrality*/

	int rtti () const { return   Actor_Rtti; }

protected:
	void drawShape( QPainter & );
	QPointArray areaPoints() const;


private:
	int m_actorNumber,m_Value,  m_Size, m_nd, m_ld;
	double m_x0, m_y0;
	/**actor centralities*/
	float  m_CC, m_BC, m_ODC, m_GC, m_SC, m_SASC, m_SACC, m_SABC,m_SAGC,m_SAODC, m_SAIDC, m_IDC;  
	bool m_deleted;
	QPointArray points, boundPoints;
	QString m_Label, m_actorColor, m_Shape, m_labelColor;
	/**List containing elements attached to the actor */
	QPtrList<Edge> inList;
	QPtrList<Edge> outList;
	QPtrList<ActorLabel> labelList;
	QPtrList<ActorNumber> numberList;
	QPtrList<Arrow> inArrowList;
	QPtrList<Arrow> outArrowList;

};

#endif
