/***************************************************************************
 SocNetV: Social Networks Visualiser for Linux
 version: 0.43.1
 Written in Qt 3.3.3 with KDevelop 3.1.0  

                           app.cpp  -  description
                             -------------------
    copyright            : (C) 2005, 2006 by Dimitris B. Kalamaras
    email                : dimitris.kalamaras@compupress.gr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "app.h"

#include "images/filesave.xpm"
#include "images/fileopen.xpm"
#include "images/filenew.xpm"
#include "images/snv.xpm"
#define PI 3.14159265

bool printDebug=FALSE;


void myMessageOutput( QtMsgType type, const char *msg )     {
	if (printDebug)	
            switch ( type ) {
                case QtDebugMsg:
                    fprintf( stderr, "Debug: %s\n", msg );
                    break;
                case QtWarningMsg:
                    fprintf( stderr, "Warning: %s\n", msg );
                    break;
                case QtFatalMsg:
                    fprintf( stderr, "Fatal: %s\n", msg );
                    abort();                    // deliberately core dump
            }
}


//Main App
App::App(const QString &fName) {
	fileName=fName;
	qInstallMsgHandler( myMessageOutput );
	QPixmap snail;
	//snail = QPixmap("src/images/snv.xpm");
	snail = QPixmap (snv);
	setIcon (snail);
	VERSION="0.43.1";
  //setCaption(tr("Social Networks Visualiser "+ VERSION));

  ///////////////////////////////////////////////////////////////////
  // inits that invoke all other construction parts
	initActions();  //register and construct Actions in the menu
	initMenuBar();  //construct menu
	initToolBar();  //build the toolbar
	initStatusBar();  //and now add the status bar.

	colorList = QColor::colorNames();  //fill a stringList with all X-supported color names

  // DEFAULTING HERE DOES NOT CHANGE BOOL VALUE
  // EVERY TIME INITNET IS CALLED

	bezier=FALSE; 
	firstTime=TRUE;
  //	linksArrows=FALSE;  //I keep this default here not to change every time a new network is loaded or created
	showProgressBar=FALSE;	
 	initView();
	connect( view, SIGNAL( selectedActor(Actor*) ), this, SLOT(actorInfoStatusBar(Actor*)) );
	connect( view, SIGNAL( selectedLink(Edge*) ), this, SLOT (linkInfoStatusBar(Edge*) ) );
	connect( view, SIGNAL( mouseCreateLink(Actor*,Actor*) ), this, SLOT(addLink(Actor*,Actor*)) );
	connect( view, SIGNAL( windowResized(int, int)) ,this, SLOT( windowInfoStatusBar(int, int) ) );  
	
	connect( view, SIGNAL( mouseCreateActor() ), this, SLOT(addActor () ) ) ;
	connect( view, SIGNAL( mouseIsAt(int, int) ), this, SLOT(mousePosition(int, int) ) ) ;
	initNet();

	 /**Load file one exec time*/
	if (!fileName.isEmpty())     {
                 fileNameNoPath=QStringList::split ("/", fileName );
                this->loadNetworkFile(fileName);
      	}

	if (firstTime) {
		createFortuneCookies();	
		createTips();
	}
}



App::~App() {
	delete printer;
	delete canvas;
	delete view;
}



/** initializes all QActions of the application */
void App::initActions(){
  printer = new QPrinter;

  QPixmap openIcon, saveIcon, newIcon;
  newIcon = QPixmap(filenew);
  openIcon = QPixmap(fileopen);
  saveIcon = QPixmap(filesave);


  fileNew = new QAction(tr("New"), newIcon, tr("&New"), QAccel::stringToKey(tr("Ctrl+N")), this);
  fileNew->setStatusTip(tr("Creates a new network"));
  fileNew->setWhatsThis(tr("New\n\nCreates a new network"));
  connect(fileNew, SIGNAL(activated()), this, SLOT(slotCreateNew()));

  fileOpen = new QAction(tr("Open File"), openIcon, tr("&Open..."), QAccel::stringToKey(tr("Ctrl+O")), this);

  fileOpen->setStatusTip(tr("Opens an existing network"));
  fileOpen->setWhatsThis(tr("Open\n\nOpens an existing network"));
  connect(fileOpen, SIGNAL(activated()), this, SLOT(slotChooseFile()));

  importSM = new QAction(tr("Sociomatrix"), openIcon, tr("&Sociomatrix..."), 0, this);
  importSM->setStatusTip(tr("Opens a sociomatrix-formatted network"));
  importSM->setWhatsThis(tr("Open\n\nOpens a Sociomatrix-formatted network"));
  connect(importSM, SIGNAL(activated()), this, SLOT(slotImportSM()));

  importPajek = new QAction(tr("Pajek"), openIcon, tr("&Pajek..."), 0, this);
  importPajek->setStatusTip(tr("Opens a Pajek-formatted network"));
  importPajek->setWhatsThis(tr("Open\n\nOpens a Pajek-formatted network"));
  connect(importPajek, SIGNAL(activated()), this, SLOT(slotImportPajek()));

  importList = new QAction(tr("List"), openIcon, tr("&List..."), 0, this);
  importList->setStatusTip(tr("Opens a List-formatted network"));
  importList->setWhatsThis(tr("Open\n\nOpens a List-formatted network"));
  connect(importList, SIGNAL(activated()), this, SLOT(slotImportList()));

  importDL = new QAction(tr("DL"), openIcon, tr("&DL..."), 0, this);
  importDL->setStatusTip(tr("Opens a DL network"));
  importDL->setWhatsThis(tr("Open\n\nOpens a DL network"));
  connect(importDL, SIGNAL(activated()), this, SLOT(slotImportDL()));

  importGW = new QAction(tr("GW"), openIcon, tr("&GW..."), 0, this);
  importGW->setStatusTip(tr("Opens a GW network"));
  importGW->setWhatsThis(tr("Open\n\nOpens a GW network"));
  connect(importSM, SIGNAL(activated()), this, SLOT(slotImportGW()));

  importDOT = new QAction(tr("dot"), openIcon, tr("&dot..."), 0, this);
  importDOT->setStatusTip(tr("Opens a dot formatted network"));
  importDOT->setWhatsThis(tr("Open\n\nOpens a dot network"));
  connect(importDOT, SIGNAL(activated()), this, SLOT(slotImportDOT()));
  
  fileSave = new QAction(tr("Save File"), saveIcon, tr("&Save"), QAccel::stringToKey(tr("Ctrl+S")), this);
  fileSave->setStatusTip(tr("Saves the actual network"));
  fileSave->setWhatsThis(tr("Save.\n\nSaves the actual network"));
  connect(fileSave, SIGNAL(activated()), this, SLOT(slotFileSave()));

  fileSaveAs = new QAction(tr("Save File As"), tr("Save &as..."), 0, this);
  fileSaveAs->setStatusTip(tr("Saves the actual network under a new filename"));
  fileSaveAs->setWhatsThis(tr("Save As\n\nSaves the actual network under a new filename"));
  connect(fileSaveAs, SIGNAL(activated()), this, SLOT(slotFileSave()));

  exportBMP = new QAction(tr("BMP"), saveIcon, tr("&BMP..."), 0, this);
  exportBMP->setStatusTip(tr("Export network to a BMP image"));
  exportBMP->setWhatsThis(tr("Export BMP \n\n Export network to a BMP image"));
  connect(exportBMP, SIGNAL(activated()), this, SLOT(slotExportBMP()));

  exportPNG = new QAction(tr("PNG"), saveIcon, tr("&PNG..."), 0, this);
  exportPNG->setStatusTip(tr("Export network to a PNG image"));
  exportPNG->setWhatsThis(tr("Export PNG \n\n Export network to a PNG image"));
  connect(exportPNG, SIGNAL(activated()), this, SLOT(slotExportPNG()));

  exportSM = new QAction(tr("Sociomatrix"), saveIcon, tr("&Sociomatrix..."), 0, this);
  exportSM->setStatusTip(tr("Export network to a sociomatrix"));
  exportSM->setWhatsThis(tr("Export Sociomatrix \n\n Export network to a sociomatrix-formatted file"));
  connect(exportSM, SIGNAL(activated()), this, SLOT(slotExportSM()));

  exportPajek = new QAction(tr("Pajek"), saveIcon, tr("&Pajek..."), 0, this);
  exportPajek->setStatusTip(tr("Export network to a Pajek-formatted file"));
  exportPajek->setWhatsThis(tr("Export Pajek \n\n Export network to a Pajek-formatted file"));
  connect(exportPajek, SIGNAL(activated()), this, SLOT(slotExportPajek()));

  exportList = new QAction(tr("List"), saveIcon, tr("&List..."), 0, this);
  exportList->setStatusTip(tr("Export network to a List-formatted file. "));
  exportList->setWhatsThis(tr("Export List\n\nExport network to a List-formatted file"));
  connect(exportList, SIGNAL(activated()), this, SLOT(slotExportList()));

  exportDL = new QAction(tr("DL"), saveIcon, tr("&DL..."), 0, this);
  exportDL->setStatusTip(tr("Export network to a DL-formatted file"));
  exportDL->setWhatsThis(tr("Export DL\n\nExport network to a DL-formatted"));
  connect(exportDL, SIGNAL(activated()), this, SLOT(slotExportDL()));

  exportGW = new QAction(tr("GW"), saveIcon, tr("&GW..."), 0, this);
  exportGW->setStatusTip(tr("Export network to a GW-formatted file"));
  exportGW->setWhatsThis(tr("Export\n\nExport network to a GW formatted file"));
  connect(exportSM, SIGNAL(activated()), this, SLOT(slotExportGW()));

  
  fileClose = new QAction(tr("Close File"), tr("&Close"), QAccel::stringToKey(tr("Ctrl+W")), this);
  fileClose->setStatusTip(tr("Closes the actual network"));
  fileClose->setWhatsThis(tr("Close \n\nCloses the actual network"));
  connect(fileClose, SIGNAL(activated()), this, SLOT(slotFileClose()));

  filePrint = new QAction(tr("Print File"), tr("&Print"), QAccel::stringToKey(tr("Ctrl+P")), this);
  filePrint->setStatusTip(tr("Prints out the actual network"));
  filePrint->setWhatsThis(tr("Print \n\nPrints out the actual network"));
  connect(filePrint, SIGNAL(activated()), this, SLOT(slotPrintView()));

  fileQuit = new QAction(tr("Exit"), tr("E&xit"), QAccel::stringToKey(tr("Ctrl+Q")), this);
  fileQuit->setStatusTip(tr("Quits the application"));
  fileQuit->setWhatsThis(tr("Exit\n\nQuits the application"));
  connect(fileQuit, SIGNAL(activated()), this, SLOT(close()));

  viewNetworkFileAct = new QAction(tr("View network file"), tr("View Network File"), Key_F5, this);
  viewNetworkFileAct->setStatusTip(tr("View loaded network file"));
  viewNetworkFileAct->setWhatsThis(tr("View Network file\n\nDisplays the file of the loaded network"));
  connect(viewNetworkFileAct, SIGNAL(activated()), this, SLOT(slotViewNetworkFile()));

  viewSociomatrixAct = new QAction(tr("View active Sociomatrix"), tr("Active Sociomatrix"), Key_F6, this);
  viewSociomatrixAct->setStatusTip(tr("View the sociomatrix of the active network"));
  viewSociomatrixAct->setWhatsThis(tr("View Network file\n\nDisplays the sociomatrix of the active network"));
  connect(viewSociomatrixAct, SIGNAL(activated()), this, SLOT(slotViewSociomatrix()));

  createUniformRandomNetworkAct = new QAction(tr("Create uniform random network"), tr("Uniform"), 0, this);
  createUniformRandomNetworkAct->setStatusTip(tr("Creates a uniformly distributed random network"));
  createUniformRandomNetworkAct->setWhatsThis(tr("Uniform \n\nCreates a random network of uniform distribution"));
  connect(createUniformRandomNetworkAct, SIGNAL(activated()), this, SLOT(slotCreateUniformRandomNetwork()));

  createConnectedRandomNetworkAct = new QAction(tr("Create connected random network"), tr("Connected"), 0, this);
  createConnectedRandomNetworkAct->setStatusTip(tr("Creates a connected random network"));
  createConnectedRandomNetworkAct->setWhatsThis(tr("Uniform Connected\n\nCreates a connected random network "));
  connect(createConnectedRandomNetworkAct, SIGNAL(activated()), this, SLOT(slotCreateConnectedRandomNetwork()));

  createSameDegreeRandomNetworkAct = new QAction(tr("Create a random network where all actors have the same degree"), tr("Same Degree"), 0, this);
  createSameDegreeRandomNetworkAct->setStatusTip(tr("Creates a random network where all actors have the same degree."));
  createSameDegreeRandomNetworkAct->setWhatsThis(tr("Same Degree \n\nCreates a random network where all actors have the same degree "));
  connect(createSameDegreeRandomNetworkAct, SIGNAL(activated()), this, SLOT(slotCreateSameDegreeRandomNetwork()));


  createGaussianRandomNetworkAct = new QAction(tr("Create Gaussian random network"), tr("Gaussian"), 0, this);
  createGaussianRandomNetworkAct->setStatusTip(tr("Creates a Gaussian distributed random network"));
  createGaussianRandomNetworkAct->setWhatsThis(tr("Gaussian \n\nCreates a random network of Gaussian distribution"));
  connect(createGaussianRandomNetworkAct, SIGNAL(activated()), this, SLOT(slotCreateGaussianRandomNetwork()));

  createLatticeNetworkAct = new QAction(tr("Create Lattice network"), tr("Lattice"), 0, this);
  createLatticeNetworkAct->setStatusTip(tr("Creates a Lattice network"));
  createLatticeNetworkAct->setWhatsThis(tr("Lattice \n\nCreates a Lattice"));
  connect(createLatticeNetworkAct, SIGNAL(activated()), this, SLOT(slotCreateLatticeNetwork()));

  powSociomatrixAct = new QAction(tr("Pow sociomatrix"), tr("Pow sociomatrix"), 0, this);
  powSociomatrixAct->setStatusTip(tr("Pows the sociomatrix to a given power"));
  powSociomatrixAct->setWhatsThis(tr("Pow Sosiomatrix \n\nPows the sociomatrix to a given power"));
  connect(powSociomatrixAct, SIGNAL(activated()), this, SLOT(slotMatrixPow()));

  dynamicNetworkAct = new QAction(tr("Dynamic/Plastic network extension"), tr("Dynamic/Plastic"),0, this);
  dynamicNetworkAct->setStatusTip(tr("Transform network by the plastic power of imagination"));
  dynamicNetworkAct->setWhatsThis(tr("Dynamic/Plastic\n\nTransform network by the plastic power of imagination"));
  connect(dynamicNetworkAct, SIGNAL(activated()),this, SLOT(slotDynamicNetwork() ));

  //EDIT
  
  findActorAct = new QAction(tr("Find"), tr("Find"), QAccel::stringToKey(tr("Ctrl+F")), this);
  findActorAct->setStatusTip(tr("Finds an actor by either its number or its label and doubles its size. Ctrl+F again resizes back the actor"));
  findActorAct->setWhatsThis(tr("Find Actor\n\nFinds an actor with a given number or label and doubles its size. Ctrl+F again resizes back the actor"));
  connect(findActorAct, SIGNAL(activated()), this, SLOT(slotFindActor()) );
    
  addActorAct = new QAction(tr("Add"), tr("Add"), QAccel::stringToKey(tr("Ctrl+A")), this);
  addActorAct->setStatusTip(tr("Adds an actor"));
  addActorAct->setWhatsThis(tr("Add Actor\n\nAdds an actor to the network"));
  connect(addActorAct, SIGNAL(activated()), this, SLOT(addActor()));

  removeActorAct = new QAction(tr("Remove"), tr("Remove"), QAccel::stringToKey(tr("Ctrl+R")), this);
  removeActorAct->setStatusTip(tr("Removes an actor"));
  removeActorAct->setWhatsThis(tr("Remove Actor\n\nRemoves an actor from the network"));
  connect(removeActorAct, SIGNAL(activated()), this, SLOT(slotRemoveActor()));

  changeActorLabelAct = new QAction(tr("Change Label"), tr("Change Label"), 0, this);
  changeActorLabelAct->setStatusTip(tr("Changes the Label of an actor"));
  changeActorLabelAct->setWhatsThis(tr("Change Label\n\nChanges the label of an actor"));
  connect(changeActorLabelAct, SIGNAL(activated()), this, SLOT(slotChangeActorLabel()));

  changeActorColorAct = new QAction(tr("Change Color"), tr("Change Color"), 0, this);
  changeActorColorAct->setStatusTip(tr("Changes the Color of an actor"));
  changeActorColorAct->setWhatsThis(tr("Change Color\n\nChanges the Color of an actor"));
  connect(changeActorColorAct, SIGNAL(activated()), this, SLOT(slotChangeActorColor()));

  changeActorValueAct = new QAction(tr("Change Value"), tr("Change Value"), 0, this);
  changeActorValueAct->setStatusTip(tr("Changes the Value of an actor"));
  changeActorValueAct->setWhatsThis(tr("Change Value\n\nChanges the Value of an actor"));
  connect(changeActorValueAct, SIGNAL(activated()), this, SLOT(slotChangeActorValue()));


  addLinkAct = new QAction(tr("Add"), tr("Add"), QAccel::stringToKey(tr("Ctrl+L")), this);
  addLinkAct->setStatusTip(tr("Adds a Link"));
  addLinkAct->setWhatsThis(tr("Add Link\n\nAdds a Link to the network"));
  connect(addLinkAct, SIGNAL(activated()), this, SLOT(slotAddLink()));
  
  removeLinkAct = new QAction(tr("Remove"), tr("Remove"), QAccel::stringToKey(tr("Ctrl+E")), this);
  removeLinkAct->setStatusTip(tr("Removes a Link"));
  removeLinkAct->setWhatsThis(tr("Remove Link\n\nRemoves a Link from the network"));
  connect(removeLinkAct, SIGNAL(activated()), this, SLOT(slotRemoveLink()));

  
  changeLinkLabelAct = new QAction(tr("Change Label"), tr("Change Label"), 0, this);
  changeLinkLabelAct->setStatusTip(tr("Changes the Label of a Link"));
  changeLinkLabelAct->setWhatsThis(tr("Change Label\n\nChanges the label of a Link"));
  connect(changeLinkLabelAct, SIGNAL(activated()), this, SLOT(slotChangeLinkLabel()));

  changeLinkColorAct = new QAction(tr("Change Color"), tr("Change Color"), 0, this);
  changeLinkColorAct->setStatusTip(tr("Changes the Color of a Link"));
  changeLinkColorAct->setWhatsThis(tr("Change Color\n\nChanges the Color of a Link"));
  connect(changeLinkColorAct, SIGNAL(activated()), this, SLOT(slotChangeLinkColor()));

  changeLinkWeightAct = new QAction(tr("Change Weight"), tr("Change Weight"), 0, this);
  changeLinkWeightAct->setStatusTip(tr("Changes the Weight of a Link"));
  changeLinkWeightAct->setWhatsThis(tr("Change Value\n\nChanges the Weight of a Link"));
  connect(changeLinkWeightAct, SIGNAL(activated()), this, SLOT(slotChangeLinkWeight()));

  filterActorsAct = new QAction(tr("Filter Actors"), tr("Actors"), 0, this);
  filterActorsAct->setStatusTip(tr("Filters Actors of some value out of the network"));
  filterActorsAct->setWhatsThis(tr("Filter Actors\n\nFilters Actors of some value out of the network."));
  connect(filterActorsAct, SIGNAL(activated()), this, SLOT(slotFilterActors()));

  filterLinksAct = new QAction(tr("Filter Links"), tr("Links"), 0, this);
  filterLinksAct->setStatusTip(tr("Filters Links of some weight out of the network"));
  filterLinksAct->setWhatsThis(tr("Filter Links\n\nFilters Link of some weight out of the network."));
  connect(filterLinksAct, SIGNAL(activated()), this, SLOT(slotFilterLinks()));

  transformActors2LinksAct = new QAction(tr("Transform Actors to Links"), tr("Transform Actors to Links"), 0, this);
  transformActors2LinksAct->setStatusTip(tr("Transforms network so that actors become links and vice versa"));
  transformActors2LinksAct->setWhatsThis(tr("Transform Actors LinksAct\n\nTransforms network so that actors become links and vice versa"));
  connect(transformActors2LinksAct, SIGNAL(activated()), this, SLOT(slotTransformActors2Links()));

  symmetriseLinksAct = new QAction(tr("Transform all arcs to double links"), tr("Transform all arcs to double links"), 0, this);
  symmetriseLinksAct->setStatusTip(tr("Transforms all arcs to double links. The result is a symmetric network"));
  symmetriseLinksAct->setWhatsThis(tr("All arcs to double links\n\nTransforms all arcs to double links. The resulat is a symmetric network"));
  connect(symmetriseLinksAct, SIGNAL(activated()), this, SLOT(slotSymmetriseLinks()));  
    

  // LAYOUT
  
  strongColorationAct = new QAction (tr("Strong Structural Coloration"), tr("Strong Structural"),0, this);
  strongColorationAct -> setStatusTip( tr("Actors are assigned the same color if they have identical in and out neighborhoods") );
  strongColorationAct -> setWhatsThis( tr("Click this to colorize actors; Actors are assigned the same color if they have identical in and out neighborhoods"));
  connect(strongColorationAct, SIGNAL(activated() ), this, SLOT(slotColorationStrongStructural()) );
  
  
  regularColorationAct = new QAction (tr("Regular Coloration"), tr("Regular"),0, this);
  regularColorationAct -> setStatusTip( tr("Actors are assigned the same color if they have neighborhoods of the same set of colors") );
  regularColorationAct -> setWhatsThis( tr("Click this to colorize actors; Actors are assigned the same color if they have neighborhoods of the same set of colors"));
  connect(regularColorationAct, SIGNAL(activated() ), this, SLOT(slotColorationRegular()) );
  
  randLayoutAct = new QAction(tr("Random Layout"), tr("Random"),0,  this);
  randLayoutAct ->setStatusTip(tr("Repositions the actors in random places"));
  randLayoutAct->setWhatsThis(tr("Random Layout\n\n Repositions the actors in random places"));
  connect(randLayoutAct, SIGNAL(activated()), this, SLOT(slotLayoutRandom()));

  randCircleLayoutAct = new QAction(tr("Random Circle"), tr("Random Circle"),0,  this);
  randCircleLayoutAct ->setStatusTip(tr("Repositions the actors randomly on a circle"));
  randCircleLayoutAct->setWhatsThis(tr("Random Circle Layout\n\n Repositions the actors randomly on a circle"));
  connect(randCircleLayoutAct, SIGNAL(activated()), this, SLOT(slotLayoutRandomCircle()));
	
  circleOutDegreeLayoutAct = new QAction(tr("Out-Degree Centrality"), tr("Out-Degree Centrality"),0,  this);
  circleOutDegreeLayoutAct ->setStatusTip(tr("Repositions the actors on circles of different radius. More Out-Degree Central Actors are situated towards the centre."));
  circleOutDegreeLayoutAct->setWhatsThis(tr("Circle Out-Degree Centrality Layout\n\n Repositions the actors on circles of different radius. More Out-Degree Central Actors are situated towards the centre."));
  connect(circleOutDegreeLayoutAct, SIGNAL(activated()), this, SLOT(slotLayoutCircleCentralityOutDegree()));

  circleInDegreeLayoutAct = new QAction(tr("In-Degree Centrality"), tr("In-Degree Centrality"),0,  this);
  circleInDegreeLayoutAct ->setStatusTip(tr("Repositions the actors on circles of different radius. More In-Degree Central Actors are situated towards the centre."));
  circleInDegreeLayoutAct->setWhatsThis(tr("Circle In-Degree Centrality Layout\n\n Repositions the actors on circles of different radius. More In-Degree Central Actors are situated towards the centre."));
  connect(circleInDegreeLayoutAct, SIGNAL(activated()), this, SLOT(slotLayoutCircleCentralityInDegree()));


  circleClosenessLayoutAct = new QAction(tr("Closeness Centrality"), tr("Closeness Centrality"),0,  this);
  circleClosenessLayoutAct ->setStatusTip(tr("Repositions the actors on circles of different radius. More Closeness Central Actors are situated towards the centre."));
  circleClosenessLayoutAct->setWhatsThis(tr("Circle Closeness Centrality Layout\n\n Repositions the actors on circles of different radius. More Closeness Central Actors are situated towards the centre."));
  connect(circleClosenessLayoutAct, SIGNAL(activated()), this, SLOT(slotLayoutCircleCentralityCloseness()));

  circleBetweenessLayoutAct = new QAction(tr("Betweeness Centrality"), tr("Betweeness Centrality"),0,  this);
  circleBetweenessLayoutAct ->setStatusTip(tr("Repositions the actors on circles of different radius. More Betweeness Central Actors are situated towards the centre."));
  circleBetweenessLayoutAct->setWhatsThis(tr("Circle Betweeness Centrality Layout\n\n Repositions the actors on circles of different radius. More Betweeness Central Actors are situated towards the centre."));
  connect(circleBetweenessLayoutAct, SIGNAL(activated()), this, SLOT(slotLayoutCircleCentralityBetweeness()));





  circleInformationalLayoutAct = new QAction(tr("Informational Centrality"), tr("Informational Centrality"), 0, this);
  circleInformationalLayoutAct ->setStatusTip(tr("Repositions the actors on circles of different radius. More Informational Central Actors are situated towards the centre."));
  circleInformationalLayoutAct->setWhatsThis(tr("Circle Informational Centrality Layout\n\n Repositions the actors on circles of different radius. More Informational Central Actors are situated towards the centre."));
  connect(circleInformationalLayoutAct, SIGNAL(activated()), this, SLOT(slotLayoutCircleCentralityInformational()));


  circleStressLayoutAct = new QAction(tr("Stress Centrality"), tr("Stress Centrality"),0,  this);
  circleStressLayoutAct ->setStatusTip(tr("Repositions the actors on circles of different radius. More Stressed Central Actors are situated towards the centre."));
  circleStressLayoutAct->setWhatsThis(tr("Circle Stress Centrality Layout\n\n Repositions the actors on circles of different radius. Actors having greater Stress Centrality are situated towards the centre."));
  connect(circleStressLayoutAct, SIGNAL(activated()), this, SLOT(slotLayoutCircleCentralityStress() ) );
	
  circleGraphLayoutAct = new QAction(tr("Graph Centrality"), tr("Graph Centrality"),0,  this);
  circleGraphLayoutAct ->setStatusTip(tr("Repositions the actors on circles of different radius. More Graphed Central Actors are situated towards the centre."));
  circleGraphLayoutAct->setWhatsThis(tr("Circle Graph Centrality Layout\n\n Repositions the actors on circles of different radius. Actors having greater Graph Centrality are situated towards the centre."));
  connect(circleGraphLayoutAct, SIGNAL(activated()), this, SLOT(slotLayoutCircleCentralityGraph() ) );

  circleClearBackgrCirclesAct = new QAction(tr("Remove Layout Circles"), tr("Remove Layout Circles"),0,  this);
  circleClearBackgrCirclesAct ->setStatusTip(tr("Removes circles of circular layout."));
  circleClearBackgrCirclesAct->setWhatsThis(tr("Remove Circles\n\n Removes any circles created for the circular layout of the network."));
  connect(circleClearBackgrCirclesAct, SIGNAL(activated()), this, SLOT(slotClearBackgrCircles()));


  levelDegreeLayoutAct = new QAction(tr("Degree Centrality"), tr("Degree Centrality"),0,  this);
  levelDegreeLayoutAct ->setStatusTip(tr("Repositions the actors on levels of different height. More Degree Central Actors are situated on higher levels."));
  levelDegreeLayoutAct->setWhatsThis(tr("level Degree Centrality Layout\n\n Repositions the actors on levels of different height. More Degree Central Actors are situated on higher levels."));
  connect(levelDegreeLayoutAct, SIGNAL(activated()), this, SLOT(slotLayoutLevelCentralityDegree()));

  levelClosenessLayoutAct = new QAction(tr("Closeness Centrality"), tr("Closeness Centrality"), 0, this);
  levelClosenessLayoutAct ->setStatusTip(tr("Repositions the actors on levels of different height. More Closeness Central Actors are situated on higher levels."));
  levelClosenessLayoutAct->setWhatsThis(tr("level Closeness Centrality Layout\n\n Repositions the actors on levels of different height. More Closeness Central Actors are situated on higher levels."));
  connect(levelClosenessLayoutAct, SIGNAL(activated()), this, SLOT(slotLayoutLevelCentralityCloseness()));

  levelBetweenessLayoutAct = new QAction(tr("Betweeness Centrality"), tr("Betweeness Centrality"),0,  this);
  levelBetweenessLayoutAct ->setStatusTip(tr("Repositions the actors on levels of different height. More Betweeness Central Actors are situated on higher levels."));
  levelBetweenessLayoutAct->setWhatsThis(tr("level Betweeness Centrality Layout\n\n Repositions the actors on levels of different height. More Betweeness Central Actors are situated on higher levels."));
  connect(levelBetweenessLayoutAct, SIGNAL(activated()), this, SLOT(slotLayoutLevelCentralityBetweeness()));

  levelInformationalLayoutAct = new QAction(tr("Informational Centrality"), tr("Informational Centrality"), 0, this);
  levelInformationalLayoutAct ->setStatusTip(tr("Repositions the actors on levels of different height. More Informational Central Actors are situated on higher levels."));
  levelInformationalLayoutAct->setWhatsThis(tr("Level Informational Centrality Layout\n\n Repositions the actors on levels of different height. More Informational Central Actors are situated on higher levels."));
  connect(levelInformationalLayoutAct, SIGNAL(activated()), this, SLOT(slotLayoutLevelCentralityInformational()));

  springLayoutAct= new QAction(tr("Spring Embedder"), tr("Spring Embedder"), 0, this);
  springLayoutAct->setStatusTip(tr("This model substitutes actors and edges with charged balls and connecting springs, respectively.  The algorithm continues until the system retains an equilibrium state in which all forces cancel each other."));
  springLayoutAct->setWhatsThis(tr("Spring Embedder Layout\n\n Repositions all actors according to a model that substitutes actors and edges with charged balls and connecting springs, respectively. The algorithm continues until the system retains its equilibrium state where all forces cancel each other."));
  connect(springLayoutAct, SIGNAL(activated()), this, SLOT(slotLayoutSpringEmbedder()));

  FRLayoutAct= new QAction(tr("Fruchterman-Reingold"), tr("Fruchterman-Reingold"), 0, this);
  FRLayoutAct->setStatusTip(tr("In this model, repelling forces are used between every pair of actors, while attracting forces are used only between adjacent actors.  The algorithm continues until the system retains an equilibrium state in which all forces cancel each other."));
  FRLayoutAct->setWhatsThis(tr("Fruchterman-Reingold Layout\n\n Repositions all actors according to a model in which  repelling forces are used between every pair of actors, while attracting forces are used only between adjacent actors. The algorithm continues until the system retains its equilibrium state where all forces cancel each other."));
  connect(FRLayoutAct, SIGNAL(activated()), this, SLOT(slotLayoutFR()));


  //STATISTICS
  countActors = new QAction(tr("Active Actors"), tr("&Active Actors"), QAccel::stringToKey(tr("Ctrl+A")), this);
  countActors->setStatusTip(tr("How many actors are active"));
  countActors->setWhatsThis(tr("Actors\n\n Shows how many actors are active"));
  connect(countActors, SIGNAL(activated()), this, SLOT(slotActiveActors()));

  countLinks = new QAction(tr("Active In-Out Links"), tr("Active In-Out &Links"), QAccel::stringToKey(tr("Ctrl+L")), this);
  countLinks->setStatusTip(tr("How many in and out links are active"));
  countLinks->setWhatsThis(tr("Links\n\n Shows how many in and out links are active"));
  connect(countLinks, SIGNAL(activated()), this, SLOT(slotActiveLinks()));

  
  netDensity = new QAction(tr("Density"), tr("&Density"), QAccel::stringToKey(tr("Ctrl+D")), this);
  netDensity->setStatusTip(tr("Calculate network density"));
  netDensity->setWhatsThis(tr("Density\n\n Calculate network density"));
  connect(netDensity, SIGNAL(activated()), this, SLOT(slotNetworkDensity()));

  distanceAct = new QAction(tr("Geodesic Distance"), tr("Geodesic Distance"), QAccel::stringToKey(tr("Ctrl+G")), this);
  distanceAct->setStatusTip(tr("Calculates and displays the geodesic distance between two actors."));
  distanceAct->setWhatsThis(tr("Distance\n\n Calculates and displays the distance between two actors."));
  connect(distanceAct, SIGNAL(activated()), this, SLOT(slotDistance()));

  distanceMatrixAct = new QAction(tr("Distance Matrix"), tr("Distance Matrix"), QAccel::stringToKey(tr("Ctrl+M")), this);
  distanceMatrixAct->setStatusTip(tr("Calculates and displays the matrix of geodesic distances "));
  distanceMatrixAct->setWhatsThis(tr("Distance Matrix\n\n Calculates and displays the matrix of geodesic distances."));
  connect(distanceMatrixAct, SIGNAL(activated()), this, SLOT( slotDistanceMatrix() ) );
  
  diameterAct = new QAction(tr("Diameter"), tr("Diameter"), QAccel::stringToKey(tr("Ctrl+J")), this);
  diameterAct->setStatusTip(tr("Calculates and displays the diameter of the active network."));
  diameterAct->setWhatsThis(tr("Distance\n\n Calculates and displays the diameter of the active network."));
  connect(diameterAct, SIGNAL(activated()), this, SLOT(slotDiameter()));
    
  cOutDegreeAct = new QAction(tr("OutDegree Centrality"), tr("OutDegree Centrality"),0,  this);
  cOutDegreeAct->setStatusTip(tr("Calculate and display OutDegree Centrality"));
  cOutDegreeAct->setWhatsThis(tr("OutDegree Centrality\n\n Calculate and display OutDegree Centrality"));
  connect(cOutDegreeAct, SIGNAL(activated()), this, SLOT(slotCentralityOutDegree()));

  cInDegreeAct = new QAction(tr("InDegree Centrality"), tr("InDegree Centrality"),0,  this);
  cInDegreeAct->setStatusTip(tr("Calculate and display InDegree Centrality"));
  cInDegreeAct->setWhatsThis(tr("InDegree Centrality\n\n Calculate and display InDegree Centrality"));
  connect(cInDegreeAct, SIGNAL(activated()), this, SLOT(slotCentralityInDegree()));


  cClosenessAct = new QAction(tr("Closeness Centrality"), tr("Closeness Centrality"),0,  this);
  cClosenessAct->setStatusTip(tr("Calculate and display Closeness Centrality"));
  cClosenessAct->setWhatsThis(tr("Closeness Centrality\n\n Calculate and display Closeness Centrality"));
  connect(cClosenessAct, SIGNAL(activated()), this, SLOT(slotCentralityCloseness()));

  cBetweenessAct = new QAction(tr("Betweeness Centrality"), tr("Betweeness Centrality"),0,  this);
  cBetweenessAct->setStatusTip(tr("Calculate and display Betweeness Centrality"));
  cBetweenessAct->setWhatsThis(tr("Betweeness Centrality\n\n Calculate and display Betweeness Centrality"));
  connect(cBetweenessAct, SIGNAL(activated()), this, SLOT(slotCentralityBetweeness()));

  cGraphAct = new QAction(tr("Graph Centrality"), tr("Graph Centrality"),0,  this);
  cGraphAct->setStatusTip(tr("Calculate and display Graph Centrality"));
  cGraphAct->setWhatsThis(tr("Graph Centrality\n\n Calculate and display Graph Centrality"));
  connect(cGraphAct, SIGNAL(activated()), this, SLOT(slotCentralityGraph()));

  cStressAct = new QAction(tr("Stress Centrality"), tr("Stress Centrality"),0,  this);
  cStressAct->setStatusTip(tr("Calculate and display Stress Centrality"));
  cStressAct->setWhatsThis(tr("Stress Centrality\n\n Calculate and display Stress Centrality"));
  connect(cStressAct, SIGNAL(activated()), this, SLOT(slotCentralityStress()));

  cInformationalAct = new QAction(tr("Informational Centrality"), tr("Informational Centrality"),0,  this);
  cInformationalAct->setStatusTip(tr("Calculate and display Informational Centrality"));
  cInformationalAct->setWhatsThis(tr("Informational Centrality\n\n Calculate and display Informational Centrality"));
  connect(cInformationalAct, SIGNAL(activated()), this, SLOT(slotCentralityInformational()));

  
  
  
  //OPTIONS
    
  showNumbersAct = new QAction(tr("Display Numbers"), tr("Display Num&bers Out Of Shapes"), 0, this, 0, true);
  showNumbersAct->setStatusTip(tr("Click to enable/disable displaying of actor numbers outside shapes"));
  showNumbersAct->setWhatsThis(tr("Display Numbers\n\nEnables/disables actor numbers outside shapes"));
  showNumbersAct->setOn(true);
  connect(showNumbersAct, SIGNAL(toggled(bool)), this, SLOT(slotShowNumbers(bool)));
    
  showLabelsAct = new QAction(tr("Display Labels"), tr("Display Lab&els"), 0, this, 0, true);
  showLabelsAct->setStatusTip(tr("Click to enable/disable displaying of actor labels"));
  showLabelsAct->setWhatsThis(tr("Display Labels\n\nEnables/disables actor labels"));
  showLabelsAct->setOn(false);
  connect(showLabelsAct, SIGNAL(toggled(bool)), this, SLOT(slotShowLabels(bool)));

  paintActorsOwnColorAct = new QAction(tr("Paint actors with their own colors"), tr("Paint Actors With Own Colors"), 0, this, 0, true);
  paintActorsOwnColorAct->setStatusTip(tr("If enabled, all actors will be painted with their own color (default=red). "));
  paintActorsOwnColorAct->setWhatsThis(tr("Actors own Colors\n\nPaints all actors with their own color (if specified)"));
  paintActorsOwnColorAct->setOn(false);
  connect(paintActorsOwnColorAct, SIGNAL(toggled(bool)), this, SLOT(slotActorsOwnColor()) );

  changeAllActorsSizeAct = new QAction(tr("Change All Actors Size"), tr("Change All Actors Size"), 0, this);
  changeAllActorsSizeAct->setStatusTip(tr("This option lets you change the size of all actors"));
  changeAllActorsSizeAct->setWhatsThis(tr("Actors Size\n\nThis option lets you change the size of all actors"));
  connect(changeAllActorsSizeAct, SIGNAL(activated()), this, SLOT(slotChangeAllActorsSize()) );
  

  changeAllActorsShapeAct = new QAction(tr("Change All Actors Shape"), tr("Change All Actors Shape"), 0, this);
  changeAllActorsShapeAct->setStatusTip(tr("This option lets you change the size of all actors"));
  changeAllActorsShapeAct->setWhatsThis(tr("Actors Shape\n\nThis option lets you change the size of all actors"));
  connect(changeAllActorsShapeAct, SIGNAL(activated()), this, SLOT(slotChangeAllActorsShape()) );


  changeNumbersSizeAct = new QAction(tr("Change Actors Numbers Size"), tr("Change All Numbers Size"), 0, this);
  changeNumbersSizeAct->setStatusTip(tr("It lets you change the font size of the numbers of all actors"));
  changeNumbersSizeAct->setWhatsThis(tr("Numbers Size\n\nChanges the size of the numbers of all actors"));
  connect(changeNumbersSizeAct, SIGNAL(activated()), this, SLOT(slotChangeNumbersSize()) );

  changeLabelsSizeAct = new QAction(tr("Change Actors Labels Size"), tr("Change All Labels Size"), 0, this);
  changeLabelsSizeAct->setStatusTip(tr("You can change the font size of the labels of all actors"));
  changeLabelsSizeAct->setWhatsThis(tr("Labels Size\n\nChange the fontsize of the labels of all actors"));
  connect(changeLabelsSizeAct, SIGNAL(activated()), this, SLOT(slotChangeLabelsSize()) );
  
  paintLinksOwnColorAct = new QAction(tr("Paint Links with their own Color"), tr("Paint With Own Colors"), 0, this,0, true);
  paintLinksOwnColorAct->setStatusTip(tr("Click to toggle painting of each link with its own color (if specified)"));
  paintLinksOwnColorAct->setWhatsThis(tr("Links own Colors\n\nPaints all links with their own color (if specified)"));
  paintLinksOwnColorAct->setOn(false);
  connect(paintLinksOwnColorAct, SIGNAL(toggled(bool)), this, SLOT(slotLinksOwnColor()) );

  drawLinksWeightsAct = new QAction(tr("Draw Links as thick as their weight"), tr("Draw As Thick As Weights"), 0, this,0, true);
  drawLinksWeightsAct->setStatusTip(tr("Click to toggle having all links as thick as their weight (if specified)"));
  drawLinksWeightsAct->setWhatsThis(tr("Links Weights\n\nDraw Links as thick as their weights (if specified)"));
  drawLinksWeightsAct->setOn(false);
  connect(drawLinksWeightsAct, SIGNAL(toggled(bool)), this, SLOT(slotLinksThickWeights()) );

  showNumbersLinksWeightsAct = new QAction(tr("Show  weight numbers"), tr("Show Weight Numbers"), 0, this,0, true);
  showNumbersLinksWeightsAct->setStatusTip(tr("Click to enable/disable displaying of numbers of links weights"));
  showNumbersLinksWeightsAct->setWhatsThis(tr("Show Weights\n\nShows numbers of links weight"));
  showNumbersLinksWeightsAct->setOn(false);
  connect(showNumbersLinksWeightsAct, SIGNAL(toggled(bool)), this, SLOT(slotNumbersLinksWeights(bool)) );

  
  drawLinksArrowsAct = new QAction(tr("Draw Links arrows"), tr("Draw Arrows"), 0, this,0, true);
  drawLinksArrowsAct->setStatusTip(tr("Click to enable/disable displaying of arrows in the end of links"));
  drawLinksArrowsAct->setWhatsThis(tr("Links Arrows\n\nEnable/disable displaying of arrows in the end of links"));
  drawLinksArrowsAct->setOn(true);
  connect(drawLinksArrowsAct, SIGNAL(toggled(bool)), this, SLOT(slotLinksArrows(bool)) );

  drawLinksBezier = new QAction(tr("Draw Links as Bezier Curves"), tr("Draw As Bezier Curves"), 0, this, 0, true);
  drawLinksBezier->setStatusTip(tr("Enables/Disables drawing links as Bezier curves"));
  drawLinksBezier->setWhatsThis(tr("Links Bezier\n\nEnables/Disables drawing Links as Bezier curves."));
  drawLinksBezier->setOn (false);
  connect(drawLinksBezier, SIGNAL(toggled(bool)), this, SLOT(slotLinksBezier(bool)) );

  changeBackColorAct = new QAction(tr("Change Background Color"), tr("Change Background Color"), 0, this);
  changeBackColorAct->setStatusTip(tr("Click to change the background color"));
  changeBackColorAct->setWhatsThis(tr("Background\n\nChanges background color"));
  connect(changeBackColorAct, SIGNAL(activated()), this, SLOT(slotBackgroundColor()));

  changeAllActorsColorAct = new QAction(tr("Change all actors color"), tr("Change All Actors Colors"), 0, this);
  changeAllActorsColorAct->setStatusTip(tr("Click to choose a new color for all actors."));
  changeAllActorsColorAct->setWhatsThis(tr("All Actors\n\nChanges all actors color at once."));
  connect(changeAllActorsColorAct, SIGNAL(activated()), this, SLOT(slotAllActorsColor()) );

  changeNumbersColorAct = new QAction(tr("Change Numbers Color"), tr("Change All Numbers Colors"), 0, this);
  changeNumbersColorAct->setStatusTip(tr("Click to change the color of all numbers."));
  changeNumbersColorAct->setWhatsThis(tr("Numbers\n\nChanges the color of all numbers."));
  connect(changeNumbersColorAct, SIGNAL(activated()), this, SLOT(slotNumbersColor()));

  changeAllLinksColorAct = new QAction(tr("Change all links Color"), tr("Change All Links Colors"), 0, this);
  changeAllLinksColorAct->setStatusTip(tr("Click to change the color of all links."));
  changeAllLinksColorAct->setWhatsThis(tr("Background\n\nChanges all links color"));
  connect(changeAllLinksColorAct, SIGNAL(activated()), this, SLOT(slotAllLinksColor()));

  
  //TOOLBARS
  showProgressBarAct = new QAction(tr("ProgressBar"), tr("Show ProgressBar"), 0, this, 0, true);
  showProgressBarAct->setStatusTip(tr("Enables/disables Progress Bars"));
  showProgressBarAct->setWhatsThis(tr("ProgressBar\n\nEnables/disables progress bar during time-cost operations. Enabling progressBar has a significant cpu cost but lets you know about the progress of a given operation."));
  showProgressBarAct->setOn (false);
  connect(showProgressBarAct, SIGNAL(toggled(bool)), this, SLOT(slotShowProgressBar(bool)));

  printDebugAct = new QAction(tr("Print Debug Messages"), tr("Print Debug Messages"), 0, this, 0, true);
  printDebugAct->setStatusTip(tr("Enables/disables printing debug messages to stdout"));
  printDebugAct->setWhatsThis(tr("Debug Messages\n\nEnables/disables printing debug messages to strerr. Enabling has a significant cpu cost but lets you know what SocNetV is actually doing."));
  printDebugAct->setOn (false);
  connect(printDebugAct, SIGNAL(toggled(bool)), this, SLOT(slotPrintDebug(bool)));

  
  viewToolBar = new QAction(tr("Toolbar"), tr("Tool&bar"), 0, this, 0, true);
  viewToolBar->setStatusTip(tr("Enables/disables the toolbar"));
  viewToolBar->setWhatsThis(tr("Toolbar\n\nEnables/disables the toolbar"));
  viewToolBar->setOn(true);
  connect(viewToolBar, SIGNAL(toggled(bool)), this, SLOT(slotViewToolBar(bool)));


  viewStatusBar = new QAction(tr("Statusbar"), tr("&Statusbar"), 0, this, 0, true);
  viewStatusBar->setStatusTip(tr("Enables/disables the statusbar"));
  viewStatusBar->setWhatsThis(tr("Statusbar\n\nEnables/disables the statusbar"));
  viewStatusBar->setOn(true);
  connect(viewStatusBar, SIGNAL(toggled(bool)), this, SLOT(slotViewStatusBar(bool)));

  
  //HELP
  helpApp = new QAction(tr("Help"), tr("Help"), Key_F1, this);
  helpApp->setStatusTip(tr("Displays Help"));
  helpApp->setWhatsThis(tr("Help\n\nDisplays help"));
  connect(helpApp, SIGNAL(activated()), this, SLOT(slotHelp()));


  tipsApp = new QAction(tr("Quick Tips"), tr("Quick Tips"), Key_F2, this);
  tipsApp->setStatusTip(tr("Displays some useful and quick tips"));
  tipsApp->setWhatsThis(tr("Quick Tips\n\nDisplays some useful and quick tips"));
  connect(tipsApp, SIGNAL(activated()), this, SLOT(slotTips()));



  helpAboutApp = new QAction(tr("About"), tr("&About..."), 0, this);
  helpAboutApp->setStatusTip(tr("About SocNetV"));
  helpAboutApp->setWhatsThis(tr("About\n\nAbout SocNetV"));
  connect(helpAboutApp, SIGNAL(activated()), this, SLOT(slotHelpAbout()));

  helpAboutQt = new QAction(tr("About Qt"), tr("&About Qt"), 0, this);
  helpAboutQt->setStatusTip(tr("About Qt"));
  helpAboutQt->setWhatsThis(tr("About\n\nAbout Qt"));
  connect(helpAboutQt, SIGNAL(activated()), this, SLOT(slotAboutQt() ) );

}

void App::initMenuBar()
{
  ///////////////////////////////////////////////////////////////////
  // MENUBAR

  ///////////////////////////////////////////////////////////////////
  // menuBar entry fileMenu
	fileMenu=new QPopupMenu();
	fileNew->addTo(fileMenu);
	fileOpen->addTo(fileMenu);
	fileMenu->insertSeparator();
	importSubMenu=new QPopupMenu();
	fileMenu->insertItem(tr("Import..."),importSubMenu);
	importSM->addTo(importSubMenu);
	importPajek->addTo(importSubMenu);
//   importList->addTo(importSubMenu);
//   importDL->addTo(importSubMenu);
//   importGW->addTo(importSubMenu);
	importDOT->addTo(importSubMenu);
	fileMenu->insertSeparator();
	fileSave->addTo(fileMenu);
	fileSaveAs->addTo(fileMenu);
	fileMenu->insertSeparator();
	exportSubMenu=new QPopupMenu();
	fileMenu->insertItem(tr("Export..."),exportSubMenu);
	exportBMP->addTo(exportSubMenu);
	exportPNG->addTo(exportSubMenu);
	exportSubMenu->insertSeparator();
	exportSM->addTo(exportSubMenu);
	exportPajek->addTo(exportSubMenu);
//   exportList->addTo(exportSubMenu);
//   exportDL->addTo(exportSubMenu);
//   exportGW->addTo(exportSubMenu);
	fileMenu->insertSeparator();
	filePrint->addTo(fileMenu);
	fileMenu->insertSeparator();
	fileClose->addTo(fileMenu);
	fileQuit->addTo(fileMenu);


  ///////////////////////////////////////////////////////////////////
  // menuBar entry networkMenu
	networkMenu=new QPopupMenu();
	viewNetworkFileAct -> addTo (networkMenu);
	networkMenu ->insertSeparator();
	viewSociomatrixAct ->addTo( networkMenu);
	networkMenu ->insertSeparator();
	randomNetworkMenu = new QPopupMenu();
	networkMenu ->insertItem (tr("Create Random Network"),randomNetworkMenu);
	createUniformRandomNetworkAct ->addTo (randomNetworkMenu);
//  createConnectedRandomNetworkAct -> addTo(randomNetworkMenu);
// createGaussianRandomNetworkAct -> addTo(randomNetworkMenu);
	createLatticeNetworkAct -> addTo(randomNetworkMenu );
	createSameDegreeRandomNetworkAct -> addTo(randomNetworkMenu);
	networkMenu->insertSeparator();
	matrixAlgebraMenu = new QPopupMenu();
	networkMenu -> insertItem ( tr("Matrix Algebra"), matrixAlgebraMenu );
	powSociomatrixAct -> addTo (matrixAlgebraMenu);
	networkMenu->insertSeparator();
//  dynamicNetworkAct->addTo(networkMenu); 


  ///////////////////////////////////////////////////////////////////
  // menuBar entry editMenu
	editMenu=new QPopupMenu();
	editActorMenu = new QPopupMenu();
	editMenu -> insertItem (tr("Actor..."), editActorMenu );
	findActorAct-> addTo(editActorMenu);
	addActorAct -> addTo ( editActorMenu);
	removeActorAct->addTo(editActorMenu);
	changeActorLabelAct->addTo(editActorMenu);
	changeActorColorAct->addTo(editActorMenu);
	changeActorValueAct->addTo(editActorMenu);
	editLinkMenu = new QPopupMenu();
	editMenu-> insertItem (tr("Link..."), editLinkMenu);
	addLinkAct -> addTo ( editLinkMenu);
	removeLinkAct->addTo(editLinkMenu);
	changeLinkLabelAct->addTo(editLinkMenu);
	changeLinkColorAct->addTo(editLinkMenu);
	changeLinkWeightAct->addTo(editLinkMenu);
	editMenu ->insertSeparator();
	filterMenu = new QPopupMenu ();
	editMenu ->insertItem( tr("Filter..."), filterMenu);
//   filterActorsAct -> addTo(filterMenu);
	filterLinksAct -> addTo(filterMenu);
	editMenu ->insertSeparator();
//   transformActors2LinksAct -> addTo (editMenu);
	symmetriseLinksAct-> addTo (editMenu);




  ///////////////////////////////////////////////////////////////////
  // menuBar entry layoutMenu
	layoutMenu=new QPopupMenu();
//   colorationMenu = new QPopupMenu();
//   layoutMenu -> insertItem (tr("Colorization"), colorationMenu);
//   strongColorationAct -> addTo(colorationMenu);
//   regularColorationAct-> addTo(colorationMenu);
//   layoutMenu->insertSeparator();
//   randomLayoutMenu = new QPopupMenu();
//   layoutMenu -> insertItem (tr("Random"), randomLayoutMenu );
//   randLayoutAct -> addTo (randomLayoutMenu);
//   randCircleLayoutAct -> addTo( randomLayoutMenu);
	circleLayoutMenu = new QPopupMenu();
	layoutMenu -> insertItem (tr("In circles by centrality..."), circleLayoutMenu );
	circleOutDegreeLayoutAct ->addTo(circleLayoutMenu);
	circleInDegreeLayoutAct ->addTo(circleLayoutMenu);
	circleClosenessLayoutAct -> addTo(circleLayoutMenu);
	circleBetweenessLayoutAct -> addTo(circleLayoutMenu);
	circleInformationalLayoutAct -> addTo(circleLayoutMenu);
	circleStressLayoutAct -> addTo(circleLayoutMenu);
	circleGraphLayoutAct -> addTo(circleLayoutMenu);


	
	layoutMenu -> insertItem (tr("In levels by centrality...") );
//   levelLayoutMenu = new QPopupMenu ();
//   layoutMenu ->insertItem (tr("Levels by..."), levelLayoutMenu);
//   levelDegreeLayoutAct ->addTo(levelLayoutMenu);
//   levelClosenessLayoutAct -> addTo(levelLayoutMenu);
//   levelBetweenessLayoutAct -> addTo(levelLayoutMenu);
//   levelInformationalLayoutAct -> addTo(levelLayoutMenu);
	layoutMenu->insertSeparator();
	physicalLayoutMenu = new QPopupMenu ();
	layoutMenu -> insertItem (tr("Physical..."), physicalLayoutMenu );
	springLayoutAct->addTo(physicalLayoutMenu );
	FRLayoutAct->addTo(physicalLayoutMenu );

	layoutMenu->insertSeparator();
	circleClearBackgrCirclesAct -> addTo (layoutMenu);
	

  ///////////////////////////////////////////////////////////////////
  // menuBar ent statistics Menu
	statMenu=new QPopupMenu();
	countActors->addTo(statMenu);
	countLinks->addTo(statMenu);
	netDensity->addTo(statMenu);
	statMenu->insertSeparator();
	distanceAct -> addTo(statMenu );
	distanceMatrixAct -> addTo(statMenu );
	diameterAct -> addTo(statMenu);

	statMenu->insertSeparator();
	centrlMenu = new QPopupMenu();
	statMenu->insertItem(tr("Centralities"), centrlMenu); 
	cOutDegreeAct -> addTo(centrlMenu);
	cInDegreeAct -> addTo(centrlMenu);
	cClosenessAct -> addTo(centrlMenu);
	cBetweenessAct -> addTo(centrlMenu);
//   cInformationalAct -> addTo(centrlMenu);
	cGraphAct -> addTo(centrlMenu);
	cStressAct -> addTo(centrlMenu);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry optionsMenu
	optionsMenu=new QPopupMenu();
	actorOptionsMenu=new QPopupMenu();
	actorOptionsMenu->setCheckable(true);
	optionsMenu->insertItem( tr("Actors"), actorOptionsMenu);
	showLabelsAct->addTo(actorOptionsMenu);
	showNumbersAct->addTo(actorOptionsMenu);
	paintActorsOwnColorAct -> addTo (actorOptionsMenu);
	actorOptionsMenu->insertSeparator();
	changeAllActorsSizeAct -> addTo (actorOptionsMenu);
	changeAllActorsShapeAct -> addTo (actorOptionsMenu);
	changeNumbersSizeAct -> addTo( actorOptionsMenu);
	changeLabelsSizeAct -> addTo(actorOptionsMenu);
 
	linkOptionsMenu=new QPopupMenu();
	linkOptionsMenu->setCheckable(true);
	optionsMenu->insertItem( tr("Links"), linkOptionsMenu);
	paintLinksOwnColorAct -> addTo(linkOptionsMenu);
	drawLinksWeightsAct -> addTo (linkOptionsMenu);
	showNumbersLinksWeightsAct -> addTo(linkOptionsMenu);
	drawLinksArrowsAct -> addTo (linkOptionsMenu);
	drawLinksBezier -> addTo(linkOptionsMenu);
	colorOptionsMenu=new QPopupMenu();
	optionsMenu->insertItem( tr("Colors"), colorOptionsMenu);
	changeBackColorAct -> addTo (colorOptionsMenu);
	changeAllActorsColorAct -> addTo (colorOptionsMenu);
	changeAllLinksColorAct -> addTo (colorOptionsMenu);
	changeNumbersColorAct -> addTo (colorOptionsMenu);
  ///////////////////////////////////////////////////////////////////
  // menuBar entry viewMenu
	viewMenu=new QPopupMenu();
	viewMenu->setCheckable(true);
	showProgressBarAct->addTo(viewMenu);
	printDebugAct ->addTo(viewMenu);
	viewToolBar->addTo(viewMenu);
	viewStatusBar->addTo(viewMenu);
 
  ///////////////////////////////////////////////////////////////////
  // menuBar entry helpMenu
	helpMenu=new QPopupMenu();
	helpApp -> addTo(helpMenu);
	tipsApp -> addTo(helpMenu);
	helpMenu ->insertSeparator();
	helpAboutApp->addTo(helpMenu);
	helpAboutQt->addTo(helpMenu);

  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
	menuBar()->insertItem(tr("&File"), fileMenu);
	menuBar()->insertItem(tr("&Network"), networkMenu);
	menuBar()->insertItem(tr("&Edit"), editMenu);

	menuBar()->insertItem(tr("&Layout"), layoutMenu);
	menuBar()->insertItem(tr("&Statistics"), statMenu);

	menuBar()->insertSeparator();
	menuBar()->insertItem(tr("&Options"), optionsMenu);
	menuBar()->insertItem(tr("&View"), viewMenu);
	menuBar()->insertItem(tr("&Help"), helpMenu);

}



/**
	Initializes the toolbar
*/
void App::initToolBar(){
	fileToolbar = new QToolBar(this, "file operations");
	fileNew->addTo(fileToolbar);
	fileOpen->addTo(fileToolbar);
	fileSave->addTo(fileToolbar);
	fileToolbar->addSeparator();
	QWhatsThis::whatsThisButton(fileToolbar);

}



/**
	Initializes the status bar
*/
void App::initStatusBar() {
	statusBarDuration=2000;
	statusBar()->message(tr("Ready."), statusBarDuration);
}







/**
	Initializes the canvas, the main widget of SocNetV
*/
void App::initView() {
	canvas=new QCanvas( width(), height() ) ;
	canvas->setAdvancePeriod(30);
	backgroundColor="gainsboro";
	canvas->setBackgroundColor(backgroundColor);
  //canvas->setBackgroundColor(QColor("gainsboro"));
	view=new CanvasView(*canvas, this);
	this->setCentralWidget(view);
	this->resize(800,600);
	view->clear();
	view ->setFocus();
}





/**
	Initializes the default network parameters. 
	Also used when erasing a network to start a new one
*/
void App::initNet(){
	QApplication::setOverrideCursor( QCursor(Qt::WaitCursor) );
	
// 	fileName="";  //Left out because of a bug.
	initActorSize=4;
	initActorColor="red";
	initLinkColor="black";
	initLabelColor="black";
	initNumberColor=black;
	initActorShape="circle";
	actorShape="circle";
	minDuration=2000;
	labelDistance=15;
	numberDistance=5;
	totalLinks=0;
	Actors=0;

	pajekFile=FALSE;
	sociomatrixFile=FALSE;
	symmetricSociomatrix=FALSE;
	fileLoaded=FALSE;
	fileSaved=FALSE;
	networkModified=FALSE;

	fileContainsNodesCoords=false;
	fileContainsNodeColors=false;
	fileContainsLinksColors=false;

	markedActorExists=FALSE;
	sociomatrixCreated=FALSE;
	distanceMatrixCreated=FALSE;
	calculatedCC=FALSE;
	calculatedODC=FALSE;
	calculatedIDC=FALSE;
	calculatedBC=FALSE;
	calculatedIC=FALSE;
	calculatedSC=FALSE;
	calculatedGC=FALSE;
	if (! aVector.empty() )
		aVector.clear();

	listDummiesPajek.clear();

	if (!fileLines.empty() )
		fileLines.clear();  //Clear saved elements
// 	QCanvasItemList list=canvas->allItems();
// 	int preElem=list.count();
// 	if (preElem!=0) {
// 		view->clear();
//          	QMessageBox::information (this, "SocNetV","Cleared "+QString::number(preElem ) + " elements.", "OK",0 ) ;
// 	}
	view->clear();
//	QMessageBox::information (this, "SocNetV","Hello!", "OK",0 ) ;
	mousePos=QPoint(-1,-1);
	clickedJimNumber=-1;
	linkClicked=FALSE;

	SM.resize(0);  //Every time a new network is created, these are defaulted
	TM.resize(0);  // so that every previous matrix value is deleted.
	PM.resize(0);
	DM.resize(0);

	TSM.setNumRows(0);
	TSM.setNumCols(0);
	TPM.setNumRows(0);
	TPM.setNumCols(0);
	TDM.setNumRows(0);
	TDM.setNumCols(0);
	qDebug("Allowing %i rows for SM",TSM.numRows());
	qDebug("Allowing %i cols for SM",TSM.numCols());

	setCaption(tr("Social Network Visualiser "+ VERSION));
	QApplication::restoreOverrideCursor();
}



/**
	Resizes the canvas when the windows is resized.
*/
void App::resizeEvent( QResizeEvent * ){
	canvas -> resize( (width()-4), (height()-84) );
}



/**
	Closes the application. 
	Asks to write any unsaved network data.
*/
void App::closeEvent( QCloseEvent* ce ) {
	if ( !networkModified )       {
		ce->accept();
		return;
	}
	switch( QMessageBox::information( this, "-SocNetV-",
				      tr("Do you want to save the changes") +
				      tr(" to the network file?"),
				      tr("Yes"), tr("No"), tr("Cancel"),
				      0, 1 ) )
	{
		case 0:
			slotFileSave();
			ce->accept();
			break;
		case 1:
			ce->accept();
			break;
		case 2:
		default: // just for sanity
			ce->ignore();
			break;
	}
}




/**
	Creates a new network
*/
void App::slotCreateNew() {
	slotFileClose();  
}




/**
	Prompts the user a directory dialogue to choose a file from.
	Loads the specified file, calling loadNetworkFile()
*/
void App::slotChooseFile() {
	qDebug("slotChooseFile()");
	statusBar()->message(tr("Opening network file..."));
	fileName = QFileDialog::getOpenFileName(0,0,this);
	qDebug(fileName);
	if (!fileName.isEmpty()) {
		fileNameNoPath=QStringList::split ("/", fileName );
		if ( loadNetworkFile ( fileName ) == 1 ) {
			setCaption("SocNetV "+ VERSION +" - "+fileNameNoPath.last());
			QString message=tr("Loaded network: ")+fileNameNoPath.last();
			statusBar()->message(message, statusBarDuration);
		}
		else
			statusBar()->message(tr("Error loading requested file. Aborted."), statusBarDuration);
	}
	else  {
		statusBar()->message(tr("Opening aborted"), statusBarDuration);
  	}

	qDebug("FILENAME IS NOW:" +fileName);
}



/**
	Saves the network in the same file
*/
void App::slotFileSave() {
	statusBar()->message(tr("Saving file..."));
	if (!fileLoaded && !networkModified ) {
		statusBar()->message( QString(tr("No network loaded.")), statusBarDuration );
		return;
	}
	if ( fileName.isEmpty() )    {
		slotFileSaveAs();
		return;
	}
	if ( QFile::exists( fileName ) )   {
		if ( QMessageBox::warning(
                                this, "-SocNetV-",
                                QString( tr("Overwrite")+"\n\'%1\'?" ).arg( fileName ),
                                tr("&Yes"), tr("&No"), QString::null, 1, 1 )  == 1)
                                {
                                  slotFileSaveAs();
                                  return;
                                }
	}
	fileNameNoPath=QStringList::split ("/", fileName );
	switch( QMessageBox::information( this, "-SocNetV-",
				      tr("Do you want to save")+
				      tr("in Pajek-formatted or SocioMatrix - formatted file?"),
				      tr("Pajek"), tr("Sociomatrix"), tr("Cancel"),
				      0, 1 ) )
	{
		case 0:
			if ( slotExportPajek() ) { fileSaved=TRUE; fileLoaded=TRUE; networkModified=FALSE; }
			else { fileSaved=FALSE; networkModified=TRUE; }
			break;
		case 1:
			if (slotExportSM() ) {fileSaved=TRUE; fileLoaded=TRUE; networkModified=FALSE;}
			else { fileSaved=FALSE; networkModified=TRUE; }
			break;
	}
	setCaption( fileNameNoPath.last() );
	networkModified=FALSE;
	statusBar()->message(tr("Ready."));
}



/**
	Saves the network under a user specified filename
*/
void App::slotFileSaveAs() {
	statusBar()->message(tr("Saving network under new filename..."));
	QString fn = QFileDialog::getSaveFileName(0, 0, this);
	if (!fn.isEmpty())  {
		fileName=fn;
		slotFileSave();
	}
	else  {
	statusBar()->message(tr("Saving aborted"), statusBarDuration);
	}
	statusBar()->message(tr("Ready."));
}




/**
	Closes the network. Saves it if necessary. 
	Used by createNew.
*/
void App::slotFileClose() {
	statusBar()->message(tr("Closing file..."));
	if (networkModified) {
		switch ( QMessageBox::information (this, "-SocNetV-",tr("Network has not been saved. Do you want to save before closing it?"), "Yes", "No",0,1))
		{
			case 0: slotFileSave(); break;
			case 1: break;
		}
	}
	statusBar()->message(tr("Erasing old network data...."), statusBarDuration);
	initNet();	
	statusBar()->message(tr("Ready."));
}



/**
	Prints whatever is one the canvas.
*/
void App::slotPrintView() {
	statusBar()->message(tr("Printing..."));
	if (printer->setup(this))   {
		QPainter painter;
		painter.begin(printer);
		painter.end();
	};
	statusBar()->message(tr("Ready."));
}




/**
	Almost universal network loader.
	Actually calls other functions for each format.
*/
int App::loadNetworkFile(QString fileName){
	initNet(); //HERE OR IN THE CHOOSE NETWORK?
	QApplication::setOverrideCursor( QCursor(Qt::WaitCursor) );
	if ( loadSociomatrixNetwork(fileName) ==1 ) {
		QApplication::restoreOverrideCursor();
		if (symmetricSociomatrix) 
			QMessageBox::information (this, "-SocNetV-", "A symmetric Sociomatrix formatted file of \n"+QString::number(Actors)+" actors and \n"+QString::number(totalLinks)+ " links \nhas been loaded.", "OK",0);
		else 
			QMessageBox::information (this, "-SocNetV-", "A non-symmetric Sociomatrix formatted file of \n"+QString::number(Actors)+" actors and \n"+QString::number(totalLinks)+ " links \nhas been loaded.", "OK",0);
	}
	else if (loadPajekNetwork(fileName)==1 ) {
		QApplication::restoreOverrideCursor();
		if (symmetricSociomatrix) 
			QMessageBox::information (this, "-SocNetV-", "A symmetric Pajek formatted file of \n"+QString::number(Actors)+" actors and \n"+QString::number(totalLinks)+ " links \nhas been loaded.", "OK",0);
		else 
			QMessageBox::information (this, "-SocNetV-", "A non-symmetric Pajek formatted file of \n"+QString::number(Actors)+" actors and \n"+QString::number(totalLinks)+ " links \nhas been loaded.", "OK",0);
	}  
	else if (loadListNetwork(fileName)==1)
		if (symmetricSociomatrix)
			QMessageBox::information (this, "-SocNetV-", "A symmetric List formatted file of \n"+QString::number(Actors)+" actors and \n"+QString::number(totalLinks)+ " links \nhas been loaded.", "OK",0);
		else
			QMessageBox::information (this, "-SocNetV-", "A non-symmetric List formatted file of \n"+QString::number(Actors)+" actors and \n"+QString::number(totalLinks)+ " links \nhas been loaded.", "OK",0);
	else if (loadDLNetwork(fileName)==1)
		if (symmetricSociomatrix)
			QMessageBox::information (this, "-SocNetV-", "A symmetric DL formatted file of \n"+QString::number(Actors)+" actors and \n"+QString::number(totalLinks)+ " links \nhas been loaded.", "OK",0);
		else
			QMessageBox::information (this, "-SocNetV-", "A non-symmetric DL formatted file of \n"+QString::number(Actors)+" actors and \n"+QString::number(totalLinks)+ " links \nhas been loaded.", "OK",0);	  
	else if (loadDotNetwork(fileName)==1) {
		QApplication::restoreOverrideCursor();
		if (symmetricSociomatrix)
			QMessageBox::information (this, "-SocNetV-", "A symmetric dot formatted file of \n"+QString::number(Actors)+" actors and \n"+QString::number(totalLinks)+ " links \nhas been loaded.", "OK",0);
		else
			QMessageBox::information (this, "-SocNetV-", "A non-symmetric dot formatted file of \n"+QString::number(Actors)+" actors and \n"+QString::number(totalLinks)+ " links \nhas been loaded.", "OK",0);	  
	}
	else {
		QApplication::restoreOverrideCursor();
		QMessageBox::information(this, "-SocNetV-","Unrecognized format. \nPlease specify"
		" which is the file-format using Import Menu.","OK",0);
		//print some data
		return -1;
	}

  statusBar()->message(tr("Ready."));
  return 1; 

}



/**
	Tries to load the file as adjacency sociomatrix-formatted. If not it returns -1
*/
int App::loadSociomatrixNetwork(QString fileName){
	qDebug("loadSociomatrixNetwork()");
	int i=0, j=0, weight=1;
	bool intOK=FALSE;
	QFile file ( fileName );
	if ( ! file.open(IO_ReadOnly )) return -1;
	QTextStream ts( &file );
	QString str;
	symmetricSociomatrix=TRUE; // TRUE only when links are double
	while ( !ts.atEnd() )   {
		str= ts.readLine() ;
		str=str.simplifyWhiteSpace();  // transforms "/t", "  ", etc to plain " ".
		if (str.isEmpty() ) continue;
		if ( ( str.contains("0", FALSE) || str.contains("1",FALSE) ) && !str.contains("vertices",FALSE) && (!str.contains("network",FALSE) && !str.contains("graph",FALSE)  &&  !str.contains("digraph",FALSE) && !str.contains("DL",FALSE) && !str.contains("list",FALSE)) ) {
			sociomatrixFile=true;
			pajekFile=false;
		}
		else      return -1;    //  this is not a sociomatrix file
		singleLine=QStringList::split(" ",str);
		if (i == 0 ) {
			Actors=singleLine.count();
			for (j=0; j<Actors; j++) {
				qDebug("Calling DrawActor for Actor %i", j+1);
				drawActor(j+1, initActorSize,initActorColor,QString::number(j+1), "black", -1,-1, initActorShape );  
			}
		}
		if ( Actors != (int) singleLine.count() ) return -1;	
		j=0;
		for (QStringList::Iterator it1 = singleLine.begin(); it1!=singleLine.end(); ++it1)   {
			if ( (*it1)!="0"){
				if ( aVector[i]->actorNumber() == i+1 && aVector[j]->actorNumber()==j+1) {
					weight=(*it1).toInt(&intOK, 10);
					drawLink(i, j, weight, initLinkColor, bezier);
					qDebug("Link from Actor i=%i to j=%i", i+1, j+1);
	// 				totalLinks++; //Links are calculated in drawlink().
					qDebug("TotalLinks= %i", totalLinks);
					//TODO isOutLinkedWith is buggie
				
					if (i>j && !aVector[j]->isOutLinkedWith(i+1) ) { 
						qDebug("Actor j=%i not linked with i=%i, but the opposite. Non-Symmetric Sociomatrix.", j+1, i+1);
						symmetricSociomatrix=FALSE;
					}
				}
			}
			else if (i>j && aVector[j]->isOutLinkedWith(i+1) ) { 
					qDebug("Actor i=%i not linked with j=%i, but the opposite. Non-Symmetric Sociomatrix.", i+1, j+1);
					symmetricSociomatrix=FALSE;
				}
						
			
				
			j++;
		}
		i++;
		
	}

	file.close();
	fileContainsNodeColors=FALSE;
	fileContainsLinksColors=FALSE;
	fileContainsNodesCoords=FALSE;
	fileLoaded=TRUE;

	
	return 1;
}





/**
	Tries to load the file as Pajek-formatted network. If not it returns -1
*/
int App::loadPajekNetwork(QString fileName){
	qDebug ("LoadPajekNetwork");
	QFile file ( fileName );
	if ( ! file.open(IO_ReadOnly )) return -1;
	QTextStream ts( &file );
	QString str, label;
	double coordX=0, coordY=0;
	bool ok=FALSE, intOk=FALSE, edges_flag=FALSE, arcs_flag=FALSE, check1=FALSE, check2=FALSE;
	int  j,miss, fromA = -1, toA=-1, weight=1, actorNum;
	QString linkColor;
	symmetricSociomatrix=TRUE;
	j=0;  //controls real actors' occurences
	miss=0; //controls for missing actorNumbers. if j + miss < actorNum, it creates actorNum-miss dummy actors which are deleted in the end.
	QValueList <int> toBeDeleted;
	while ( !ts.atEnd() )   {
		str= ts.readLine() ;
		str=str.simplifyWhiteSpace();  // transforms "/t", "  ", etc to plain " ".
		if (str.isEmpty() ) continue;
		if (str.contains ("digraph", FALSE)) {
			file.close();
			return -1;
		}
   		if (str.contains( "network",FALSE) )  { //NETWORK NAME
			singleLine=QStringList::split(" ",str);
			networkName=singleLine[1];
			continue;   
		}
		if (str.contains( "vertices", FALSE ) )  {   
			singleLine=QStringList::split(" ",str);
			if (!singleLine[1].isEmpty()) 	Actors=singleLine[1].toInt(&intOk,10);   
			qDebug ("Pajek-formatted file declares %i actors.",Actors);
			continue;
		}
		if ( !str.isEmpty() )  	{
			singleLine=QStringList::split(" ",str);
			if ( str.contains( "edges", FALSE ) ) {
			 	edges_flag=true; arcs_flag=false; 
				continue;
			}
			else if ( str.contains( "arcs", FALSE ) ) { 
				arcs_flag=true; edges_flag=false;
				continue;
			}
			if (!edges_flag && !arcs_flag) {
				qDebug("Reading actors...");
				if (singleLine[0].toInt(&intOk, 10)==0) { // BUG: ACTOR MAY BE NUMBERED > ONE!!!
					qDebug ("BUG IN PAJEK FILE! AN ACTOR DECLARES HIMSELF AS ZERO NUMBERED! ABORT!");
					QMessageBox::critical(this,"-SocNetV-", tr("Pajek file declares an actor with actorNumber 0. Aborting!"),"OK",0);
					return -1; //ERROR IN THE PAJEK FILE: ACTOR NUMBERED ZERO
				}
				actorNum=singleLine[0].toInt(&intOk, 10);
				label=singleLine[1];
				if (label.contains('"', FALSE) )
					label=label.remove('"');
				if (label.contains('.', FALSE) )
					singleLine[1].remove('.');
				qDebug("label %s", singleLine[1].ascii());
	

				//One of the four possible ActorShapes. Default: Triangle
				if (str.contains("Ellipse", FALSE) ) actorShape="ellipse";
				else if (str.contains("circle", FALSE) ) actorShape="circle";
				else if (str.contains("box", FALSE) ) actorShape="box";
				else if (str.contains("triangle", FALSE) ) actorShape="triangle";
				else actorShape="diamond";
				//"ic" identifies the existence of ActorColors in file.
				if (str.contains("ic",FALSE)) { 
					for (register uint c=0; c< singleLine.count(); c++) {
						if (singleLine[c] == "ic") { 
							//the colourname is at c+1
							actorColor=singleLine[c+1];
							fileContainsNodeColors=TRUE;
							break;
 						}
					}
				}
				else { 
					fileContainsNodeColors=FALSE;
					actorColor=initActorColor;
				}
				if (str.contains(".",FALSE)) { 
					for (register uint c=0; c< singleLine.count(); c++)   {
						if ( singleLine[c].contains(".", false) )  {
							coordX=singleLine[c].toDouble(&check1);
							coordY=singleLine[c+1].toDouble(&check2);
							if (check1 && check2)    {
								coordX=coordX * canvas->width();
								coordY=coordY * canvas->height();
								fileContainsNodesCoords=TRUE;
							}
							break;
						}
					}
				}
				else { 
					fileContainsNodesCoords=FALSE;
					coordX=rand()%canvas->width();
					coordY=rand()%canvas->height();
				}
				qDebug ("Creating actor numbered %i", actorNum);
				j++;  //CONTROLS REAL ACTOR OCCURENCES. DONT TOUCH!
				//FILE MISSES SOME ACTORNUMBERS. CREATE DUMMIES. DELETE THEM WHEN PAJEK LOAD FINISHES
				if ( j + miss < actorNum)  {
					qDebug ("but real actors found, including this one, are %i while this actor has actornumber %i", j, actorNum);
					for (int i=j; i< actorNum; i++) {
						qDebug( "Creating dummy actor number j = %i ", j);
						drawActor(i,initActorSize,actorColor,label, singleLine[3],coordX, coordY, actorShape);
						listDummiesPajek.append(i);  //BUG
						miss++;
					}
				}
				else if ( j > actorNum ) {
					qDebug ("SORRY. This Pajek network declares this actor with actorNumber smaller than previous actors. ABORT");
					return -1;	
				}
				drawActor(actorNum,initActorSize,actorColor, label, singleLine[3],coordX, coordY, actorShape);
			} 	//ACTORS CREATED. CREATE EDGES/ARCS NOW.
			else {
				if (j!=Actors)  {
				switch ( QMessageBox::information(this, "-SocNetV-",
					tr("The Pajek file declares ")+QString::number(Actors)+
					tr(" Vertices in Line 1, but I found ")+QString::number(j)+
					tr(" Vertices. Continue with the latter ?"), tr("Yes!"), tr("No"),0,1) )     {
						case 0:     Actors=j; break;
						case 1:    return -1; break;
					}
  				}
				if (edges_flag && !arcs_flag)   {  //EDGES
					qDebug("Reading edges...");
					fromA=  singleLine[0].toInt(&ok, 10);
					toA = singleLine[1].toInt(&ok,10);
					if (singleLine.count()>2)
						weight =  singleLine[2].toInt(&ok,10);
					else weight=1;
					if (fromA == 0 || toA == 0 ) return -1;  //ERROR
					fromA--; toA--;        //  i --> (i-1)   internally
					if (!singleLine[3].isEmpty() && !singleLine[4].isEmpty() ) {
						fileContainsLinksColors=TRUE;
						linkColor=singleLine[4];
 					}
					else  {
						fileContainsLinksColors=FALSE;  // NO COLORS
						linkColor=initLinkColor;
					}
					qDebug("Creating edge link between fromA %i to toA %i", fromA+1, toA+1);
					
					drawLink(fromA, toA, weight, linkColor, bezier);
					drawLink(toA, fromA, weight, linkColor, bezier);
				} //end if EDGES
				else if (!edges_flag && arcs_flag)   {  //ARCS
					qDebug("Reading arcs...");
					fromA=  singleLine[0].toInt(&ok, 10);
					toA = singleLine[1].toInt(&ok,10);
					if (singleLine.count()>2)
						weight =singleLine[2].toInt(&ok,10);
					else 
						weight=1;
					if (fromA == 0 || toA == 0 ) return -1;  //ERROR
					fromA--; toA--;        //  i --> (i-1)   internally
					if (!singleLine[3].isEmpty() &&  !singleLine[4].isEmpty()) {
						linkColor = singleLine[4];
						fileContainsLinksColors=TRUE;
					}
					else  {
						fileContainsLinksColors=FALSE;  // NO COLORS
						linkColor=initLinkColor;
					}
					qDebug("Creating arc link from fromA %i to toA %i with weight %i", fromA+1, toA+1, weight);
					drawLink(fromA, toA, weight, linkColor, bezier);
					if (toA>fromA && !aVector[toA]->isOutLinkedWith(fromA) )
					 	symmetricSociomatrix=FALSE;
				} //else if ARCS
			} //end if BOTH ARCS AND EDGES
		} //end if !str.isEmpty()
	} //end WHILE
	file.close();
	if (j==0) return -1;
	pajekFile=true;
	sociomatrixFile=false;
	fileLoaded=TRUE;
	qDebug("Removing all dummy Actors, if any");
	if (listDummiesPajek.count() > 0 ) {
		QMessageBox::information(this,"-SocNetV-", tr("Pajek file declared with ")+QString::number(Actors) +tr(" Actors, but ")+ QString::number(listDummiesPajek.count()) + tr(" actors were missing from file. You must save the network file to accept changes."),"OK",0);
		for ( QValueList<int>::iterator it=listDummiesPajek.begin(); it!=listDummiesPajek.end(); it++ ) {
			clickedJimNumber=*it;
			slotRemoveActor();
		}
	}
	qDebug("Clearing DumiesList from Pajek");
	listDummiesPajek.clear();
	return 1;
}




/**
	Tries to load the file as list formatted network. If not it returns -1
*/
int App::loadListNetwork(QString fileName){
	qDebug ("LoadListNetwork");
  return -1;
  QFile file ( fileName );
  if ( ! file.open(IO_ReadOnly )) return -1;
  QTextStream ts( &file );
  QString str;
  //READ FILE THEN CLOSE IT
  while ( !ts.atEnd() )   {
      str= ts.readLine() ;
      str=str.simplifyWhiteSpace();  // transforms "/t", "  ", etc to plain " ".
      if (str.isEmpty() ) continue;
      fileLines+=str;
   }
  file.close();

	fileLoaded=TRUE;
   return 1;
}




/**
	Tries to load the file as GW. If not it return -1
	TODO
*/
int App::loadGWNetwork(QString fileName) {
	return -1;
  QFile file ( fileName );
  if ( ! file.open(IO_ReadOnly )) return -1;
  QTextStream ts( &file );
  QString str;
  //READ FILE THEN CLOSE IT
  while ( !ts.atEnd() )   {
      str= ts.readLine() ;
      str=str.simplifyWhiteSpace();  // transforms "/t", "  ", etc to plain " ".
      if (str.isEmpty() ) continue;
      fileLines+=str;
   }
  file.close();
	fileLoaded=TRUE;
	return 1;
}



/**
	Tries to load the file as DL. If not it return -1
	TODO
*/
int App::loadDLNetwork(QString fileName) {
	return -1;
  QFile file ( fileName );
  if ( ! file.open(IO_ReadOnly )) return -1;
  QTextStream ts( &file );
  QString str;
  //READ FILE THEN CLOSE IT
  while ( !ts.atEnd() )   {
      str= ts.readLine() ;
      str=str.simplifyWhiteSpace();  // transforms "/t", "  ", etc to plain " ".
      if (str.isEmpty() ) continue;
      fileLines+=str;
   }
  file.close();
	fileLoaded=TRUE;
	return 1;
}





/**
	Tries to load the file as Dot (Graphviz) formatted network. If not it return -1
*/
int App::loadDotNetwork(QString fileName) {
	qDebug("loadDotNetwork");
	int fileLine=0, i, j, row=0, weight=1, sourceActor=0, targetActor=0, aNum=-1;
	int start=0, actorValue=1;
	QString linkLabel,actorColor="red", linkColor="black", actorLabel;
	QStringList actorProperties, linkProperties, property;
	QValueList<QString> actorSequence;
	bool ok;
	
	QFile file ( fileName );
	if ( ! file.open(IO_ReadOnly )) return -1;
	QTextStream ts( &file );
	QString str;
	Actors=0;
	while (!ts.atEnd() )   {
		str= ts.readLine() ;
		if (str.isEmpty() ) continue;
		qDebug ("Reading fileLine %i. Row is at %i", fileLine++, row);
		qDebug(str);
		str=str.simplifyWhiteSpace();
		str=str.stripWhiteSpace();
		//str=str.remove(' ');
		if (row==0) {
			if ( str.contains("digraph", FALSE) ) {
				symmetricSociomatrix=FALSE; 
				singleLine=QStringList::split(" ",str);
				if (singleLine[1]=="{" ) networkName="Noname";
				else networkName=singleLine[1];
				row++;
				continue; 
			}
			else if ( str.contains("graph", FALSE) ) {
				symmetricSociomatrix=TRUE; 
				singleLine=QStringList::split(" ",str);
				if (singleLine[1]=="{" ) networkName="Noname";
				else networkName=singleLine[1];
				row++;
				continue;
			}
			else return -1;  // Abort: dot format can only start with " (di)graph netname {"
			
		}
		if ( !str.contains('-',FALSE) && str.contains('[',FALSE) && !str.contains('{',FALSE)) {
			if ( str.startsWith("node",FALSE) ) { 	 //Default actor properties
				qDebug("Node properties found");
				start=str.find('[',0,FALSE);
				str=str.right(str.length()-start-1);
				str=str.remove(']');
				if (str.contains(',') )
			 		actorProperties=QStringList::split(',', str);
				else
					actorProperties=QStringList::split(' ', str);
				for (j=0; j<(int)actorProperties.count(); j++){
					actorProperties[j].remove(';');
					actorProperties[j]=actorProperties[j].stripWhiteSpace();
					qDebug("actorProp: "+actorProperties[j]);
					property=QStringList::split('=',actorProperties[j]);
					if (property[0]=="label") {
						qDebug("Found label "+property[1]);
						actorLabel=property[1];
						qDebug("Assigned actor label "+actorLabel);
					}
					else if (property[0]=="value") {
						qDebug("Found value "+property[1]);
						actorValue=property[1].toInt(&ok, 10);
						qDebug("Assigned actor value %i",actorValue); 
					}
					else if (property[0]=="color") {
						qDebug("Found color "+property[1]);
						actorColor=property[1];
						qDebug("Assigned actor color "+actorColor+"..");
					}
					else if (property[0]=="fontcolor") {
						qDebug("Found fontcolor "+property[1]);
					}
					else if (property[0]=="shape") {
						actorShape=property[1];
						qDebug("Found actor shape "+property[1]);
					}
				}				
			 	continue;
			}
			else if ( str.startsWith("edge",FALSE) ) { //Default edge properties
				qDebug("Edge properties found...");
				start=str.find('[',0,FALSE);
				str=str.right(str.length()-start-1);
				str=str.remove(']');
				if (str.contains(',') )
			 		linkProperties=QStringList::split(',', str);
				else
					linkProperties=QStringList::split(' ', str);
				for (j=0; j<(int)linkProperties.count(); j++){
					qDebug("linkProp: "+linkProperties[j]);
					linkProperties[j].remove(';');
					linkProperties[j]=linkProperties[j].stripWhiteSpace();
					property=QStringList::split('=',linkProperties[j]);
					if (property[0]=="label") {
						qDebug("Found label "+property[1]);
						linkLabel=property[1];
						qDebug("Assigned link label "+linkLabel);
					}
					else if (property[0]=="weight") {
						qDebug("Found weight "+property[1]);
						weight=property[1].toInt(&ok, 10);
						qDebug("Assigned link weight %i",weight); 
					}
					else if (property[0]=="minlen") {
						qDebug("Found minlen"+property[1]);
					}
					else if (property[0]=="color") {
						qDebug("Found color "+property[1]);
						linkColor=property[1];
						qDebug("Assigned link color "+linkColor);
					}
					else if (property[j]=="fontcolor") {
						qDebug("Found fontcolor "+property[1]);
					}
					
				}
		 		continue;
			}
			else {
			
			}
			
		}
		else if (str.contains('-',FALSE)) {  
			if (str.contains("->",FALSE))  //directed
				singleLine=QStringList::split("->", str);
			else if (str.contains('-',FALSE)) //non directed = symmetric links
				singleLine=QStringList::split('-', str);
			qDebug("Splitted. Start actor and link recognition");
			qDebug ("Found %i actors", singleLine.count() );
			for ( i=0; i<(int)singleLine.count(); i++) {
				singleLine[i]=singleLine[i].stripWhiteSpace();
				if (!singleLine[i].contains('{',FALSE) && !singleLine[i].contains('}',FALSE) && !singleLine[i].contains('[',FALSE) && !singleLine[i].contains(']',FALSE) ) {
					if (singleLine[i].contains(';') ) singleLine[i]=singleLine[i].remove(';');
					qDebug("Actor labeled :" + singleLine[i]+".");
					actorSequence.push_back(singleLine[i]);
				}
				else if ((start=singleLine[i].find('[',0,FALSE))!=-1 && singleLine[i].find('{',0,FALSE)==-1) {
					if (start>0){
						qDebug(singleLine[i] + " [ at %i",start);
						qDebug("Before "+singleLine[i].at(start)+", an Actor labeled :" + singleLine[i].left(start)+".");
						actorSequence.push_back( singleLine[i].left(start));
						singleLine[i]=singleLine[i].right(singleLine[i].length()-(start));
						qDebug("Remained string: "+singleLine[i]);
						
					}
					singleLine[i].remove('[');
					singleLine[i].remove(']');
					singleLine[i].remove(';');
					linkProperties=QStringList::split(',',singleLine[i]);
					for (j=0; j<(int)linkProperties.count(); j++){
						qDebug("linkProp: "+linkProperties[j]);
						property=QStringList::split('=',linkProperties[j]);
						if (property[0]=="label") {
							qDebug("Found label "+property[1]);
							linkLabel=property[1];
							qDebug("Assigned link label "+linkLabel);
						}
						else if (property[0]=="weight") {
							qDebug("Found weight "+property[1]);
							weight=property[1].toInt(&ok, 10);
							qDebug("Assigned link weight %i",weight); 
						}
						else if (property[0]=="minlen") {
							qDebug("Found minlen"+property[1]);
						}
						else if (property[0]=="color") {
							qDebug("Found color "+property[1]);
							linkColor=property[1];
							qDebug("Assigned link color "+linkColor);
						}
						else if (property[j]=="fontcolor") {
							qDebug("Found fontcolor "+property[1]);
						}
					
					}
						
					
				}
			}	
		}
		if (str.contains(';',FALSE) ) {
				start=str.find('[',0,FALSE);
				qDebug("Found semicolon. Ending statement, [ at %i", start);
				if ((start=str.find('[',0,FALSE))!=-1 && str.find('{',0,FALSE)==-1) {
					if (start!=-1)
						qDebug(str + " [ at %i",start);
					str.remove('[');
					str.remove(']');
					str.remove(';');
					linkProperties=QStringList::split(',',str);
					for (j=0; j<(int)linkProperties.count(); j++){
						linkProperties[j]=linkProperties[j].stripWhiteSpace();
						qDebug("linkProp: "+linkProperties[j]);
						property=QStringList::split('=',linkProperties[j]);
						if (property[0]=="label") {
							qDebug("Found label "+property[1]);
							linkLabel=property[1];
							qDebug("Assigned link label "+linkLabel);
						}
						else if (property[0]=="weight") {
							qDebug("Found weight "+property[1]);
							weight=property[1].toInt(&ok, 10);
							qDebug("Assigned link weight %i",weight); 
						}
						else if (property[0]=="minlen") {
							qDebug("Found minlen"+property[1]);
						}
						else if (property[0]=="color") {
							qDebug("Found color "+property[1]);
							linkColor=property[1];
							qDebug("Assigned link color "+linkColor);
						}
						else if (property[j]=="fontcolor") {
							qDebug("Found fontcolor "+property[1]);
						}
					
					}
						
					
				}
			for ( QValueList<QString>::iterator it=actorSequence.begin(); it!=actorSequence.end(); it++ )  {
				if  ( (aNum=actorExists( (*it) )) ==-1 ) {
					drawActor(++Actors, initActorSize, actorColor,(*it), actorColor,-1, -1, actorShape);
					qDebug("NEW Actor, Total Actors: %i", Actors);
					aNum=Actors-1;
				}
				else 	qDebug("Actor already exists. Vector num: %i ",aNum);
				targetActor=aNum;
				
				if (it!=actorSequence.begin()) {
					drawLink(sourceActor, targetActor, weight, linkColor, bezier  );
					qDebug("Drawing Link between actor %i and actor %i.",sourceActor+1,targetActor+1);
					if (symmetricSociomatrix)
						drawLink(targetActor, sourceActor, weight, linkColor, bezier  );
					
				}
				sourceActor=targetActor;	
				
			}
			actorSequence.clear();
		}
		//else continue reading next line
		
		row++;	
		qDebug("Finished reading fileLine %i ",fileLine);
		
		if (str=='}') qDebug ("EOF");
	}
  	file.close();
	fileLoaded=TRUE;
	
	return 1;

}




/**
	Returns the index of actor with label "label" inside the ActorVector.
*/
int App::actorExists( QString label){
	vector<Actor*>::iterator it;
	int i=0;
	qDebug ("checking if actor exists");
	for (it=aVector.begin(); it!=aVector.end(); it++) {
// 			if ((*it)->deleted()) continue;
			qDebug ("actor label " + (*it)->label() );
			if ( (*it)->label() == label )
				return i; 
			i++;
		}
	return -1;	
}



/**
	Returns the index of Actor with number "actorNumber" inside the ActorVector.
*/
int App::actorExists( int actorNumber){
	vector<Actor*>::iterator it;
	int i=0;
	qDebug ("Checking if actor exists inside the aVector and return its index");
	for (it=aVector.begin(); it!=aVector.end(); it++) {
// 			if ((*it)->deleted()) continue;
			qDebug ("Actor number %i" ,(*it)->actorNumber() );
			if ( (*it)->actorNumber() == actorNumber ) {
				qDebug("Actor found. Index %i", i);
				return i; 
			}
			i++;
		}
	return -1;	
}




/**
	Draws the actor with the specified number, label, color, position etc
*/


void App::drawActor(int i, int size, QString aColor, QString label, QString lColor, double x,double y, QString actorShape) {
	qDebug("drawActor()");
	if ( x<0 || y<0) {
        	x=rand()%canvas->width();
        	y=rand()%canvas->height();
	}
	//Canvas - ActorNumber - Value - shapeSize - Color - Label - LabelColor, X, Y, actorShape 
 	Actor *jim= new Actor (canvas, i, 1, size,  aColor, label, lColor, x, y, actorShape, labelDistance, numberDistance) ;
        aVector.push_back( jim);
	qDebug ("Calling addVertice");
// 	network.addVertice(i-1);

        if ( showLabelsAct->isOn() ){
                   ActorLabel *labelJim =new  ActorLabel (jim, label, canvas );
                   labelJim ->setZ (255);
                   labelJim ->move(x-labelDistance, y-labelDistance);
                   labelJim->setColor (lColor);
                   labelJim ->show();
        }
        if (  showNumbersAct->isOn()){
                   ActorNumber *numberJim =new  ActorNumber (jim, QString::number(i), canvas);
                   numberJim-> setZ(255);
                   numberJim ->move(x+numberDistance, y+numberDistance);
                   numberJim->setColor (initNumberColor);
                   numberJim -> show();
        }
}





/**
	Draws an arc from i to j actors, with weight, colour.
	Needs aVector numbers, not actor numbers
*/




void App::drawLink( int i, int j, int weight, QString color, bool bezier){
	pair<int,int> pair1;	
	qDebug (" DrawLink between actor %i and actor %i, weight %i", i+1, j+1, weight);
	Edge *A1_A2=new Edge (aVector[i], aVector[j], canvas, weight,bezier);
// 	network.addEdge(i,j);	
	totalLinks++;// ONLY ON LOAD IT IS PERMITTED TO CALCULATE TOTAL
	if (weight>0)
		A1_A2->setPen( QPen( color,lineWidth(weight), Qt::SolidLine ) );
	else
		A1_A2->setPen( QPen( color,lineWidth(weight), Qt::DashLine ) );
	A1_A2->setLinkColor(color);
        if (drawLinksArrowsAct->isOn() )   {
        	Arrow *arrow1= new Arrow(aVector[i], aVector[j], canvas);
 	        arrow1 -> setBrush(QBrush(color)); 
                arrow1 -> setZ (128);
                arrow1 -> show();
	}
	A1_A2->setZ(128);
        A1_A2->show();
    	if ( showNumbersLinksWeightsAct->isOn() ){
	 	EdgeWeight *linkWeight =new  EdgeWeight (A1_A2, QString::number(weight), canvas );
                linkWeight ->setZ (255);
		pair1=A1_A2->center();
                linkWeight ->move(pair1.first,pair1.second);
                linkWeight->setColor (color);
                linkWeight ->show();
	}
}




/**
	Draws an arc from jim1 to jim2 actors, with weight, colour.
*/

void App::drawLink(Actor* jim1, Actor *jim2, int weight, QString color, bool bezier){
	pair<int,int> pair1;	
	Edge *A1_A2=new Edge( jim1, jim2, canvas, weight,bezier);
	
	totalLinks++;// ONLY ON LOAD IT IS PERMITTED TO CALCULATE TOTAL
	if (weight>0)
		A1_A2->setPen( QPen( color,lineWidth(weight), Qt::SolidLine ) );
	else
		A1_A2->setPen( QPen( color,lineWidth(weight), Qt::DashLine ) );
	A1_A2->setLinkColor(color);
        if (drawLinksArrowsAct->isOn() )   {
        	Arrow *arrow1= new Arrow(jim1, jim2, canvas);
 	        arrow1 -> setBrush(QBrush(color)); 
                arrow1 -> setZ (128);
                arrow1 -> show();
	}
	A1_A2->setZ(128);
        A1_A2->show();
	if ( showNumbersLinksWeightsAct->isOn() ){
	 	EdgeWeight *linkWeight =new  EdgeWeight (A1_A2, QString::number(weight), canvas );
                linkWeight ->setZ (255);
		pair1=A1_A2->center();
                linkWeight ->move(pair1.first,pair1.second);
                linkWeight -> setColor (color);
                linkWeight ->show();
	}
}




/**
	Scales and returns the line width on the basis of the arc weight.
*/
int App::lineWidth(int weight){
	if (weight<0)
		return abs(weight);
	else if (weight == 0) {
		return 1; //?
	}
	else if (weight > 0 && weight<=5) {
		return weight;
	}
	else if (weight > 5 && weight<=10) {
		 return 6;
	}
	else if (weight >10 && weight<=20) {
		return 7;
	}
	else if (weight >20 && weight<=30) {
		return 8;
	}
	else return 9;
}




/**
	Imports an adjacency sociomatrix file
*/
void App::slotImportSM() {
	statusBar()->message(tr("Opening sociomatrix file..."));
	fileName = QFileDialog::getOpenFileName(0,0,this);
	if (!fileName.isEmpty()) {
		fileNameNoPath=QStringList::split ("/", fileName );
		if ( loadNetworkFile ( fileName ) == 1 ) {
			setCaption("SocNetV "+ VERSION+ " - "+fileNameNoPath.last());
			QString message=tr("Loaded sociomatrix network: ")+fileNameNoPath.last();
			statusBar()->message(message, statusBarDuration);
		}
		else statusBar()->message(tr("Error reading sociomatrix File. Abort"), statusBarDuration);
	}
	else  {
		statusBar()->message(tr("Opening aborted. Empty filename."), statusBarDuration);
	}
}



/**
	Imports an list-formatted file
	TODO
*/
void App::slotImportList(){
	statusBar()->message(tr("Opening List file..."));
	fileName = QFileDialog::getOpenFileName(0,0,this);
	if (!fileName.isEmpty()) {
		fileNameNoPath=QStringList::split ("/", fileName );
		if ( loadNetworkFile ( fileName ) == 1   ) {
			setCaption("SocNetV "+ VERSION+ " - "+fileNameNoPath.last());
			QString message=tr("Loaded List network: ")+fileNameNoPath.last();
			statusBar()->message(message, statusBarDuration);
		}
		else statusBar()->message(tr("Error reading List File. Abort"), statusBarDuration);
	}
	else  {
		statusBar()->message(tr("Opening aborted. Empty filename."), statusBarDuration);
	}
}



/**
	Imports an Pajek-formatted file
*/
void App::slotImportPajek(){
	statusBar()->message(tr("Opening Pajek file..."));
	fileName = QFileDialog::getOpenFileName(0,0,this);
	if (!fileName.isEmpty()) {
		fileNameNoPath=QStringList::split ("/", fileName );
		if ( loadNetworkFile ( fileName ) == 1   ) {
			setCaption("SocNetV "+ VERSION+ " - "+fileNameNoPath.last());
			QString message=tr("Loaded Pajek network: ")+fileNameNoPath.last();
			statusBar()->message(message, statusBarDuration);
		}
		else statusBar()->message(tr("Error reading Pajek File. Abort"), statusBarDuration);
	}
	else  {
		statusBar()->message(tr("Opening aborted. Empty filename."), statusBarDuration);
	}
}



/**
	Imports an GW-formatted file
	TODO
*/
void App::slotImportGW(){
	statusBar()->message(tr("Opening GW file..."));
	fileName = QFileDialog::getOpenFileName(0,0,this);
	if (!fileName.isEmpty()) {
		fileNameNoPath=QStringList::split ("/", fileName );
		if ( loadNetworkFile ( fileName ) == 1   ) {
			setCaption("SocNetV "+ VERSION+ " - "+fileNameNoPath.last());
			QString message=tr("Loaded GW network: ")+fileNameNoPath.last();
			statusBar()->message(message, statusBarDuration);
		}
		else statusBar()->message(tr("Error reading GW File. Abort"), statusBarDuration);
	}
	else  {
		statusBar()->message(tr("Opening aborted. Empty filename."), statusBarDuration);
	}
}




/**
	Imports an DL-formatted file
	TODO
*/
void App::slotImportDL(){
	statusBar()->message(tr("Opening DL file..."));
	fileName = QFileDialog::getOpenFileName(0,0,this);
	if (!fileName.isEmpty()) {
		fileNameNoPath=QStringList::split ("/", fileName );
		if ( loadNetworkFile ( fileName ) == 1   ) {
			setCaption("SocNetV "+ VERSION+ " - "+fileNameNoPath.last());
			QString message=tr("Loaded DL network: ")+fileNameNoPath.last();
			statusBar()->message(message, statusBarDuration);
		}
		else statusBar()->message(tr("Error reading DL File. Abort"), statusBarDuration);
	}
	else  {
		statusBar()->message(tr("Opening aborted. Empty filename."), statusBarDuration);
	}
}




/**
	Imports an Dot (GraphViz)-formatted file
*/
void App::slotImportDOT(){
	statusBar()->message(tr("Opening dot file..."));
	fileName = QFileDialog::getOpenFileName(0,0,this);
	if (!fileName.isEmpty()) {
		fileNameNoPath=QStringList::split ("/", fileName );
		if ( loadNetworkFile ( fileName ) == 1 ) {
			setCaption("SocNetV "+ VERSION+ " - "+fileNameNoPath.last());
			QString message=tr("Loaded dot network: ")+fileNameNoPath.last();
			statusBar()->message(message, statusBarDuration);
		}
		else statusBar()->message(tr("Error reading dot File. Abort"), statusBarDuration);
	}
	else  {
		statusBar()->message(tr("Opening aborted. Empty filename."), statusBarDuration);
	}
}



/**
	Exports the network to a PNG image 
	Mediocre Quality but smaller file
*/
bool App::slotExportPNG(){
	if (!fileLoaded && !networkModified )  {
		statusBar()->message(tr("Load a network file or create a new network. Then I can export it.") ,statusBarDuration);
		return false;
	}
	QString fn = QFileDialog::getSaveFileName(0, "*.png", this);
	if (fn.isEmpty())  {
		statusBar()->message(tr("Saving aborted"), statusBarDuration);
		return false;
	}	
	QStringList fnNoPath=QStringList::split ("/", fn ); 	
	QPixmap picture (canvas->width(), canvas->height(),-1);
	QPainter p;
	p.begin(&picture);
		canvas -> drawArea( canvas->rect(), &p );
		p.setFont(QFont ("Helvetica", p.font().pointSize()-2, QFont::Normal, FALSE));
		p.drawText(1,10,"SocNetV: "+fnNoPath.last());
	p.end();
	if (fn.contains("png", false) ) {
		picture.save(fn, "PNG");
		QMessageBox::information(this, "-SocNetV-",tr("Image Saved as: ")+fnNoPath.last(), "OK",0);
 	}
	else {
		picture.save(fn+".png", "PNG");
		QMessageBox::information(this, "-SocNetV-",tr("Image Saved as: ")+fnNoPath.last()+".png" , "OK",0);
	}
	
	
	statusBar()->message( tr("Exporting completed"), statusBarDuration );
	return true;   
}



/**
	Exports the network to a BMP image  
	Better Quality but larger file
*/
bool App::slotExportBMP(){
	if (!fileLoaded && !networkModified )  {
		statusBar()->message(tr("Load a network file or create a new network. Then I can export it.") ,statusBarDuration);
		return false;
	}
	QString fn = QFileDialog::getSaveFileName(0, "*.bmp", this);
	if (fn.isEmpty())  {
		statusBar()->message(tr("Saving aborted"), statusBarDuration);
		return false;
	}	
	QStringList fnNoPath=QStringList::split ("/", fn ); 	
	QPixmap picture (canvas->width(), canvas->height(),-1);
	QPainter p;
	p.begin(&picture);
		canvas -> drawArea( canvas->rect(), &p );
		p.setFont(QFont ("Helvetica", p.font().pointSize()-2, QFont::Normal, FALSE));
		p.drawText(1,10,"SocNetV: "+fnNoPath.last());
	p.end();
	if (fn.contains("BMP", false) ) {
		picture.save(fn, "BMP");
		QMessageBox::information(this, "-SocNetV-",tr("Image Saved as: ")+fnNoPath.last(), "OK",0);
 	}
	else {
		picture.save(fn+".bmp", "BMP");
		QMessageBox::information(this, "-SocNetV-",tr("Image Saved as: ")+fnNoPath.last()+".bmp" , "OK",0);
	}
	
	
	statusBar()->message( tr("Exporting completed"), statusBarDuration );
	return true;   
}




/**
	Exports the network to a Pajek-formatted file
	Preserves actor properties (positions, colours, etc)
*/
bool App::slotExportPajek(){
	if (fileName.isEmpty()) {
		statusBar()->message(tr("Saving network under new filename..."));
  		QString fn = QFileDialog::getSaveFileName(0, 0, this);
 	 	if (!fn.isEmpty())  {
			fileName=fn;
  		}
  		else  {
   		 	statusBar()->message(tr("Saving aborted"), statusBarDuration);
			return false;
 		}
	}

	QFile f( fileName );
	if ( !f.open( IO_WriteOnly ) )  {
		statusBar()->message( QString(tr("Could not write to %1")).arg(fileName), statusBarDuration );
		return false;
	}
	QTextStream t( &f );
   	t<<"*Network "<<networkName<<"\n";
	
   	t<<"*Vertices "<< activeActors() <<"\n";
   	for (vector<Actor*>::iterator it=aVector.begin(); it!=aVector.end(); it++) {
		//Actor *jim=(Actor*) (*it);
		t<<(*it)->actorNumber() <<" "<<"\""<<(*it)->label()<<"\"" ;
		t << " ic ";
		t<<  (*it)->actorColor() ;
		t << "\t\t" <<(*it)->x()/(canvas->width())<<" \t"<<(*it)->y()/(canvas->height());
		t << "\t"<<(*it)->actorShape();
		t<<"\n";
		
	}
	t<<"*Arcs \n";
	for (vector<Actor*>::iterator it=aVector.begin(); it!=aVector.end(); it++) {
		for (vector<Actor*>::iterator jt=aVector.begin(); jt!=aVector.end(); jt++) {
			if  ( (*it)->isOutLinkedWith( (*jt)->actorNumber() )  &&  !(*jt)->isOutLinkedWith( (*it)->actorNumber() ) )  {
			        t << (*it)->actorNumber() <<" "<<(*jt)->actorNumber()<< " "<<(*it)->outLinkWeight((*jt)->actorNumber());
				t<< " c "<< (*it)->outLinkColor( (*jt)->actorNumber() );
          			t <<"\n";
			}

		}
	}
	t<<"*Edges \n";
	for (vector<Actor*>::iterator it=aVector.begin(); it!=aVector.end(); it++) {
		for (vector<Actor*>::iterator jt=aVector.begin(); jt!=aVector.end(); jt++) {
			if  (  (*it)->isOutLinkedWith( (*jt)->actorNumber() )  &&  (*jt)->isOutLinkedWith( (*it)->actorNumber() ) )  {
				if ( (*it)->actorNumber()> (*jt)->actorNumber() ) continue;
			        t << (*it)->actorNumber() <<" "<<(*jt)->actorNumber()<< " "<<(*it)->outLinkWeight((*jt)->actorNumber());
				t<< " c "<< (*it)->outLinkColor( (*jt)->actorNumber() );
          			t <<"\n";
			}

		}
	}
	f.close();
	statusBar()->message( QString(tr( "File %1 saved" ) ).arg( fileNameNoPath.last() ), statusBarDuration );

	return true;
}



/**
	Exports the network to a adjacency sociomatrix-formatted file
	Does not preserve actor properties
*/
bool App::slotExportSM(){
	if (fileName.isEmpty()) {
		statusBar()->message(tr("Saving network under new filename..."));
  		QString fn = QFileDialog::getSaveFileName(0, 0, this);
 	 	if (!fn.isEmpty())  {
			fileName=fn;
  		}
  		else  {
   		 	statusBar()->message(tr("Saving aborted"), statusBarDuration);
			return false;
 		}
	}
	QFile f( fileName );
	if ( !f.open( IO_WriteOnly ) )  {
		statusBar()->message( QString(tr("Could not write to %1")).arg(fileName), statusBarDuration );
		return false;
	}
	QTextStream t( &f );
	Actors=activeActors();
	int m_actors=aVector.size();
	if (m_actors!=Actors) { 
		statusBar()->message("ERROR WHILE SAVING"); 
		return FALSE;
	}
	for (vector<Actor*>::iterator it=aVector.begin(); it!=aVector.end(); it++) {
		for (vector<Actor*>::iterator jt=aVector.begin(); jt!=aVector.end(); jt++) {
			if  (  (*it)->isOutLinkedWith( (*jt)->actorNumber() )   ) 
				t << (*it)->outLinkWeight((*jt)->actorNumber() ) << " " ;
			else t << "0 ";         	
		}
		t<<"\n";
	}
	
	f.close();
	statusBar()->message( QString( tr("Sociomatrix-formatted network saved into file %1") ).arg( fileNameNoPath.last() ), statusBarDuration );
	sociomatrixFile=true;
	pajekFile=false;

	return true;
}




/**
	Exports the network to a DL-formatted file
	TODO
*/
bool App::slotExportDL(){
	if (fileName.isEmpty()) {
		statusBar()->message(tr("Saving network under new filename..."));
  		QString fn = QFileDialog::getSaveFileName(0, 0, this);
 	 	if (!fn.isEmpty())  {
			fileName=fn;
  		}
  		else  {
   		 	statusBar()->message(tr("Saving aborted"), statusBarDuration);
			return false;
 		}
	}

return true;

}


/**
	Exports the network to a GW-formatted file
	TODO
*/
bool App::slotExportGW(){
	if (fileName.isEmpty()) {
		statusBar()->message(tr("Saving network under new filename..."));
  		QString fn = QFileDialog::getSaveFileName(0, 0, this);
 	 	if (!fn.isEmpty())  {
			fileName=fn;
  		}
  		else  {
   		 	statusBar()->message(tr("Saving aborted"), statusBarDuration);
			return false;
 		}
	}

return true;
}




/**
	Exports the network to a list-formatted file
	TODO
*/
bool App::slotExportList(){
	if (fileName.isEmpty()) {
		statusBar()->message(tr("Saving network under new filename..."));
  		QString fn = QFileDialog::getSaveFileName(0, 0, this);
 	 	if (!fn.isEmpty())  {
			fileName=fn;
  		}
  		else  {
   		 	statusBar()->message(tr("Saving aborted"), statusBarDuration);
			return false;
 		}
	}

return true;
}





/**
	Adds a little universal randomness :)
*/
void App::makeThingsLookRandom()   {
    time_t now;				/* define 'now'. time_t is probably a typedef	*/
    now = time((time_t *)NULL);		/* Get the system time and put it
   					 * into 'now' as 'calender time' the number of seconds since  1/1/1970   	*/

     srand( (unsigned int ) now);
  }




/**
	Displays the file of the loaded network.
	Network _must_ be unchanged since last save/load.
	Otherwise it will ask the user to first save the network, then view its file.
*/
void App::slotViewNetworkFile(){
	qDebug("slotViewNetworkFile()");
	if ( fileLoaded && !networkModified )    { //file network unmodified
		QFile f( fileName );
		if ( !f.open( IO_ReadOnly ) ) {
			qDebug ("Error in open!");
			return;
		}
		TextEditor *ed = new TextEditor(fileName);//OPEN A TEXT EDITOR WINDOW
		ed->setCaption(tr("-SocNetV- Text editor - ") + fileNameNoPath.last() );
		ed->show();
		statusBar()->message( tr("Loaded network text file " )+ fileNameNoPath.last() , statusBarDuration );
	}
	else if (fileName.isEmpty() && networkModified)     {  //New network + something
		QMessageBox::information (this, "-SocNetV-",
		tr("New network has not been written to a text file. Do it now, please."), "OK",0);
		slotFileSaveAs();
	}
	else if (fileLoaded && networkModified )     {   //file network + modified
		QMessageBox::information (this, "-SocNetV-",
		tr("Network has been modified from the original. Please save the updated version."), "OK",0);
		slotFileSave();
	}

	else
		statusBar()->message( tr("No network file has been loaded... "), statusBarDuration );
}




/**
	Creates the adjacency sociomatrix of the active network.
*/
void App::createSociomatrix(){
	qDebug("createSociomatrix()");
	int linkSum=0;
	SM.resize(Actors); 
	vector<Actor*>::iterator it;
	int index=0;
	int target=0;
	for ( it=aVector.begin(); it!=aVector.end(); it++) {
			for (register int i=1; i<= (*it)->countOutLinks(); i++) {
				linkSum++;
				target=(*it)->outLink(i);
				qDebug ("%d, outLinked with %d having actoraVector index %i and weight %i" ,(*it)->actorNumber(),target, actorVectorIndex( target), (*it)->outLinkWeight(target) );
				SM.setItem(index,actorVectorIndex( target), (*it)->outLinkWeight(target) );
			}
			index++;
	}
	qDebug("Found a total of %i links",linkSum);
	if ( linkSum != activeLinks() ) qDebug ("Error in link count found");

}



/**
	Displays the adjacency sociomatrix of the active network.
*/
void App::slotViewSociomatrix(){
	if ( !fileLoaded && !networkModified) {
        	statusBar()->message( tr("No network file has been loaded... "), statusBarDuration );
		return;
	}	
		
	Actors=activeActors();
	statusBar() ->  message ( QString (tr ("creating adjacency sociomatrix of %1 actors")).arg(Actors), statusBarDuration );


	if (networkModified || !sociomatrixCreated)
		createSociomatrix() ;
	//QMessageBox::information(this,"SocNetV","Finished","OK","CANCEL");

	/*
	for ( int i = 0; i < Actors; ++i ) {
		SM.setRowHeight(i,15);//adjustRow(i);
		for ( int j = 0; j < Actors; ++j ) {
			SM.setColumnWidth(j,15);//adjustColumn(j);
		}
	}
	*/
	
// 	SM.setCaption( tr( "sociomatrix" ) );
// 	SM.show();

		
	QString fn = "sociomatrix.dat";
	QFile f( fn );
	if ( !f.open( IO_WriteOnly ) )
 		return;
	QTextStream ts(&f  );
	ts << "-Social Network Visualiser- "<< VERSION << "\n";
	ts << tr("ADJACENCY SOCIOMATRIX \n");
	ts << tr("Created: ")<< actualDateTime.currentDateTime().toString ( QString ("ddd, dd.MMM.yyyy hh:mm:ss")) << "\n\n";
	if (showProgressBar) {
		actionProgress = new QProgressDialog  ( tr("Writing..."), tr("Abort"), Actors, this, "progress", TRUE );
		actionProgress->setMinimumDuration(minDuration);
	}
	qDebug ("Start writing to sociomatrix.dat");
	for (register int i=0; i< Actors; i++)  {
		for (register int j=0; j< Actors; j++)      {
			ts<< SM.item(i,j);
		}
		if (showProgressBar) {
			actionProgress->setProgress (  i ) ;
			qApp->processEvents();
		}
		ts<<endl;
	}
	if (showProgressBar) {
		actionProgress->setProgress (  Actors ) ;
		delete actionProgress;
	}
	f.close();
	TextEditor *ed = new TextEditor(fn);        //OPEN A TEXT EDITOR WINDOW
	tempFileNameNoPath=QStringList::split( "/", fn);
	ed->setCaption(tr("-SocNetV- Adjacency Sociomatrix - ") + tempFileNameNoPath.last());
	ed->show();
	
}




/**
	Creates a uniformly distributed random network.
	Link creation is controlled by a user specified possibility.
*/
void App::slotCreateUniformRandomNetwork(){
	statusBar()->message("Erasing any existing network. ", statusBarDuration);
	bool ok;
	
	initNet();  
	makeThingsLookRandom();  
	statusBar()->message("You have selected to create a random network. ", statusBarDuration);
	Actors=( QInputDialog::getInteger("-SocNetV-", tr("Number of actors:"),1, 1, 3000, 1, &ok, this ) ) ;
	if (!ok) return;
	double pos = QInputDialog::getDouble("-SocNetV-", "Enter a link probability (0, 100):", 0, 0, 100, 2, &ok, this );
	statusBar()->message(tr("Creating a uniform random network. Please wait... ") ,statusBarDuration);
	qDebug("SocNetV: Create uniform random network of %i actors and %f link probability.",Actors, pos);
	if (showProgressBar) {
		actionProgress = new QProgressDialog  ( tr("Creating network..."), tr("Abort"), Actors*Actors+Actors, this, "progress", TRUE );
		actionProgress->setMinimumDuration(minDuration);
	}
	for (register int i=0; i<Actors; i++ ) {
		qDebug("Creating actor %i", i+1);
		drawActor( i+1, initActorSize, initActorColor, QString::number(i+1),"black", -1,-1, initActorShape);  
		if (showProgressBar) {
			actionProgress->setProgress (  i ) ;
			qApp->processEvents();
		}

	}
	
	for (register int i=0;i<Actors; i++)
		for (register int j=0; j<Actors; j++)
			if (rand() %100 <(int) pos)    {
				qDebug("SocNetV: Creating Link between %i  and %i", i+1, j+1); 
				drawLink(i, j, 1, initLinkColor, bezier);
				if (showProgressBar) {
					actionProgress->setProgress (  Actors+(i+1)*(j+1) ) ;
					qApp->processEvents();
				}
			}
	if (showProgressBar) {
		actionProgress->setProgress (  Actors*Actors+Actors ) ;
		delete actionProgress;
	}			
  	fileContainsNodeColors=FALSE;
	fileContainsLinksColors=FALSE;
	fileContainsNodesCoords=FALSE;
	symmetricSociomatrix=false;
	fileLoaded=false;
	
	networkModified=TRUE;
	setCaption("New network has not been saved yet");
	statusBar()->message("Uniform random network created: "+QString::number(activeActors())+" Actors, "+QString::number( activeLinks())+" Links", statusBarDuration);

}


void App::slotCreateConnectedRandomNetwork() {
	statusBar()->message("Erasing any existing network. ", statusBarDuration);
	statusBar()->message(tr("Creating uniform random network. Please wait... ") ,statusBarDuration);
}



/**
	Creates a pseudo-random network where every actor has the same degree 
*/
void App::slotCreateSameDegreeRandomNetwork(){
	statusBar()->message("Erasing any existing network. ", statusBarDuration);
	bool ok;
	int target, degree, source, vecIdx1, vecIdx2,vecIdx3, vecIdx4;
	int coef = 10, linkS=-1, linkT=-1;
		
	initNet();  
	makeThingsLookRandom();  
	
	statusBar()->message("You have selected to create a pseudo-random network where each actor has the same degree. ", statusBarDuration);
	Actors=( QInputDialog::getInteger("-SocNetV-", tr("Number of actors N:"),3, 3, 3000, 1, &ok, this ) ) ;
	
	if (!ok) return;
	
	degree = QInputDialog::getInteger("-SocNetV-", "Enter even number d of links for each actor:", 2, 2, Actors-1, 2, &ok, this );
	if ( (degree% 2)==1 ) {
		QMessageBox::information(this, "-SocNetV-",tr(" Sorry. I cannot create such a network. Links must be even number"), "OK",0);
		return;
	}
	statusBar()->message("Creating a pseudo-random network where each actor has the same degree... ", statusBarDuration);
	qDebug("Creating random same degree network of %i actors each one having %i  links",Actors, degree);
	if (showProgressBar) {
		actionProgress = new QProgressDialog  ( tr("Creating network..."), tr("Abort"),2*Actors, this, "progress", TRUE );
		actionProgress->setMinimumDuration(minDuration);
	}
	for (register int i=0; i<Actors; i++ ) {
		qDebug("Creating actor %i", i+1);
		drawActor( i+1, initActorSize, initActorColor, QString::number(i+1),"black", -1,-1, initActorShape);  
		if (showProgressBar) {
			actionProgress->setProgress (  i ) ;
			qApp->processEvents();
		}
	}
	
	for ( source=0;source<Actors; source++) {
		for (register int j=0; j< degree/2 ; j++) {
			target = source + j+1 ; 
			if ( target > (Actors-1)) 
				target = target-Actors; 
			qDebug("Creating Link between %i  and %i", source+1, target+1);
			drawLink(source, target, 1, initLinkColor, bezier);
			drawLink(target, source, 1, initLinkColor, bezier);
			if (showProgressBar) {
				actionProgress->setProgress (  Actors+(source+1)) ;
				qApp->processEvents();
			}
		}
	}
	
	qDebug("START CHANGING LINKS");
	coef=Actors*degree/2;
	for (register int j=0; j< coef ; j++) {
		//Choose randomly 2  not linked actors, named source and target
		source=rand() %Actors; source++;
		qDebug ("source %i", source);
		target=rand() %Actors; target++;
		qDebug ("target %i", target);
		if (target == source ) {
			qDebug ("target == source . CONTINUE");
			continue;
		}
		if (aVector[source-1]->isOutLinkedWith(target)) {
			qDebug ("source outlinked with target. CONTINUE");	
			continue;
		}
		//choose their first relatives which are not linked, named linkS and linkT respectively
		linkS=aVector[source-1]->outLink(1);  //outLink returns the actornumber of first linked actor
		linkT=aVector[target-1]->outLink(1);  
		qDebug ("source %i outlinked with %i",source, linkS);
		qDebug ("target %i outlinked with %i", target, linkT);
		if (linkT == linkS ) {
			qDebug ("linkS == linkT . CONTINUE");
			continue;
		}
		if ( aVector[linkS-1]->isOutLinkedWith(linkT) ) { 
			qDebug ("linkedSource %i outlinked with linkedTarget %i. CONTINUE", linkS, linkT);
			continue;
		}
		QCanvasItemList list=canvas->allItems();
		if ( (source!= target) && !aVector[source-1]->isOutLinkedWith(target) && !aVector[linkS-1]->isOutLinkedWith(linkT) ) {
			vecIdx1=actorVectorIndex(source);
			vecIdx2=actorVectorIndex(linkS);
			vecIdx3=actorVectorIndex(target);
			vecIdx4=actorVectorIndex(linkT);
			for (QCanvasItemList::iterator it=list.begin(); it!=list.end(); it++) {
				if ( (*it)->rtti()==Link_Rtti) {
					Edge *link=(Edge*) (*it);
					if ( (link->fromActor()==source  && link->toActor()==linkS ) || (link->fromActor()==linkS  && link->toActor()==source) ){
						qDebug ("Found link between source actor %i and linkS %i with aVector indexes %i and %i ", source, linkS, vecIdx1, vecIdx2);
						if ( (aVector[vecIdx1]->deleteOutLink(link) && aVector[vecIdx2]->deleteInLink(link) ) || (aVector[vecIdx1]->deleteInLink(link) && aVector[vecIdx2]->deleteOutLink(link) )) 
							qDebug ("Deleted their out and in links");
						else { qDebug("Could not delete their in and out Links. ABORT."); return;}
						delete  link;
						qDebug("CANVAS Link deleted as well");
						continue;
					}
					if ( ( link->fromActor()==target  && link->toActor()==linkT ) || (link->fromActor()==linkT  && link->toActor()==target) ){
						qDebug ("Found link target actor %i and linkT %i with vec Indexes %i and %i ", target, linkT, vecIdx3, vecIdx4);
						if (aVector[vecIdx3]->deleteOutLink(link) && aVector[vecIdx4]->deleteInLink(link) || (aVector[vecIdx3]->deleteInLink(link) && aVector[vecIdx4]->deleteOutLink(link) ) ) 
							qDebug ("Deleted their out and in Links");
						else { qDebug("Could not delete their in and out Links. ABORT."); return;}
						delete  link;
						qDebug("CANVAS Link deleted as well");
						continue;
					}
					
				}
				
				if ( (*it)->rtti()==Arrow_Rtti) {
					Arrow *arr=(Arrow*) (*it);
					if ( (arr->fromActor() == source && arr->toActor() == linkS) || (arr->fromActor() == linkS && arr->toActor() == source))	{
						if ( (aVector[vecIdx1]->deleteOutArrow(arr) && aVector[vecIdx2]->deleteInArrow(arr) ) || (aVector[vecIdx1]->deleteInArrow(arr) && aVector[vecIdx2]->deleteOutArrow(arr)))
							qDebug("Arrows Deleted from [source, linkSource] actors reference lists");
						else qDebug ("ERROR DELETING ARROWS FROM LINK");
						delete arr;
						qDebug ("Arrows deleted from canvas");
						continue;
					}
				}
				if ( (*it)->rtti()==Arrow_Rtti) {
					Arrow *arr=(Arrow*) (*it);
					if ( (arr->fromActor() == target && arr->toActor() == linkT) || (arr->fromActor() == linkT && arr->toActor() == target))	{
						if ( (aVector[vecIdx3]->deleteOutArrow(arr) && aVector[vecIdx4]->deleteInArrow(arr)) || ( aVector[vecIdx3]->deleteInArrow(arr) && aVector[vecIdx4]->deleteOutArrow(arr)))
							qDebug("Arrows Deleted from [target, linkTarget] actors reference lists");
						else qDebug ("ERROR DELETING ARROWS FROM LINK");
						delete arr;
						qDebug ("Arrows deleted from canvas");
						continue;
					}
				}
				
			}
		}
		qDebug ("creating link between source %i and target %i", source, target);
		drawLink(source-1, target-1, 1, initLinkColor, bezier);
		qDebug ("creating link between target %i and source %i", target, source);
		drawLink(target-1, source-1, 1, initLinkColor, bezier);
		qDebug ("creating link between linkS %i and linkT %i", linkS, linkT);
		drawLink(linkS-1, linkT-1, 1, initLinkColor, bezier);
		qDebug ("creating link between linkT %i and linkS %i", linkT, linkS);
		drawLink(linkT-1, linkS-1, 1, initLinkColor, bezier);
		qDebug("OK");
	}
	if (showProgressBar) {
		actionProgress->setProgress (  2*Actors ) ;
		delete actionProgress;
	}			
  	fileContainsNodeColors=FALSE;
	fileContainsLinksColors=FALSE;
	fileContainsNodesCoords=FALSE;
	symmetricSociomatrix=true; //for it is a regular lattice
	fileLoaded=false;
	networkModified=TRUE;
	setCaption("New network has not been saved yet");
	
	//Layout the network according to degree centrality of each actor!
	layoutOutDegreeCentrality(false);

	statusBar()->message("Same degree random network created: "+QString::number(activeActors())+" Actors, "+QString::number( activeLinks())+" Links", statusBarDuration+100);

}


void App::slotCreateGaussianRandomNetwork(){
	networkModified=TRUE;

}




/**
	Creates a lattice network, i.e. a connected network where every actor
	has the same degree and is linked with its neighborhood.
*/
void App::slotCreateLatticeNetwork(){
	statusBar()->message("Erasing any existing network. ", statusBarDuration);
	bool ok;
	int target, degree;
	initNet();  
	makeThingsLookRandom();  
	statusBar()->message("You have selected to create a regular lattice network. ", statusBarDuration);
	Actors=( QInputDialog::getInteger("-SocNetV-", tr("Number of actors N:"),1, 1, 3000, 1, &ok, this ) ) ;
	
	if (!ok) return;
	
	degree = QInputDialog::getInteger("-SocNetV-", "Enter even number d of links for each actor:", 0, 0, Actors-1, 2, &ok, this );
	if ( (degree% 2)==1 ) {
		QMessageBox::information(this, "-SocNetV-",tr(" Sorry. I cannot create such a network. Links must be even number"), "OK",0);
		return;
	}
	statusBar()->message("Creating a regular lattice network. Please wait... ", statusBarDuration);
	qDebug("SocNetV: Create lattice network of %i actors each one having %i  links",Actors, degree);
	if (showProgressBar) {
		actionProgress = new QProgressDialog  ( tr("Creating network..."), tr("Abort"),2*Actors, this, "progress", TRUE );
		actionProgress->setMinimumDuration(minDuration);
	}
	for (register int i=0; i<Actors; i++ ) {
		qDebug("Creating actor %i", i+1);
		drawActor( i+1, initActorSize, initActorColor, QString::number(i+1),"black", -1,-1, initActorShape);  
		if (showProgressBar) {
			actionProgress->setProgress (  i ) ;
			qApp->processEvents();
		}
	}
	
	for (register int source=0;source<Actors; source++) {
		for (register int j=0; j< degree/2 ; j++) {
			target = source + j+1 ; 
			if ( target > (Actors-1)) 
				target = target-Actors; 
			qDebug("SocNetV: Creating Link between %i  and %i", source+1, target+1);
			drawLink(source, target, 1, initLinkColor, bezier);
			drawLink(target, source, 1, initLinkColor, bezier);
			if (showProgressBar) {
				actionProgress->setProgress (  Actors+(source+1)) ;
				qApp->processEvents();
			}
		}
	}		
	if (showProgressBar) {
		actionProgress->setProgress (  2*Actors ) ;
		delete actionProgress;
	}			
  	fileContainsNodeColors=FALSE;
	fileContainsLinksColors=FALSE;
	fileContainsNodesCoords=FALSE;
	symmetricSociomatrix=true; //for it is a regular lattice
	fileLoaded=false;
	
	networkModified=TRUE;
	setCaption("New network has not been saved yet");
	layoutOutDegreeCentrality(false);
	statusBar()->message("Lattice network created: "+QString::number(activeActors())+" Actors, "+QString::number( activeLinks())+" Links", statusBarDuration);
	
	


}



/**
	 Pows a matrix :)
*/
void App::slotMatrixPow(){
	bool ok=FALSE;
	Actors=activeActors(); //really, this is not needed in any way. Update must be done when actors change
	
	int power=QInputDialog::getInteger("-SocNetV-",tr("Enter power number :"),1, 1, Actors , 1, &ok, this );
	
	if (networkModified || !sociomatrixCreated)
		createSociomatrix();
	PM.resize(Actors);
	//PM will become the power of SM which is symmetric or not
	PM.pow(SM, power, symmetricSociomatrix);
	
	//create a table
	TPM.setNumRows(0);
	TPM.setNumCols(0);
	TPM.insertRows(TPM.numRows(),Actors);
 	TPM.insertColumns(TPM.numCols(),Actors);
	//copy product matrix elements to a table
	if (showProgressBar) {
		actionProgress = new QProgressDialog  ( tr("Writing..."), tr("Abort"), Actors, this, "progress", TRUE );
		actionProgress->setMinimumDuration(minDuration);
	}
	for (register int i=0;i<Actors;i++) {
		TPM.setRowHeight(i,20);
		TPM.setColumnWidth(i,20);
        	for (register int j=0;j<Actors;j++) 
		        TPM.setItem(i, j, new QTableItem(&TPM , QTableItem::WhenCurrent, QString::number( PM.item(i, j)  )) ) ;
			if (showProgressBar) {
				actionProgress->setProgress (  i ) ;
				qApp->processEvents();
			}
	}
	if (showProgressBar) {
		actionProgress->setProgress (  Actors ) ;
		delete actionProgress;
	}
	//show table 
 	TPM.setCaption( tr( "product sociomatrix" ) );
 	TPM.show();	
}








/**
	TODO
*/
void App::matrixVectorMult(){
}



/**
	TODO
*/
float App::matrixLargestEigen(){
return 0;
}


/**
	TODO
*/
void App::slotMatrixEigenBoundary(){
}



/**
	TODO
*/
void App::matrixInverse() {
}


/**
	TODO
*/
float App::matrixDet(){
return 0;
}



/**
	TODO
*/
void App::slotDynamicNetwork(){
}




/**
	 Finds and marks (double-sizing) an actor by its number.
*/
void App::slotFindActor(){
	if (markedActorExists) {
		markedActor->setSize(preSize);
		markedActorExists=FALSE;
		return;
	}
	if (!fileLoaded && !networkModified  )     {
		statusBar()->message( QString(tr("Load a network file first. Then you may activate context-menu by right-clicking on any node on the canvas!")) , statusBarDuration);
		return;
	}
	bool ok=FALSE;
	QString text = QInputDialog::getText("-SocNetV-", tr("Enter actor (label or number) to find:"), QLineEdit::Normal,QString::null, &ok, this );
	vector<Actor*>::iterator it;
	for (it=aVector.begin(); it!=aVector.end(); it++) {
		if ((*it)->actorNumber()==text.toInt(&ok, 10) ) {
			preSize=(*it)->width();
			(*it)->setSize(2*preSize);
			markedActorExists=TRUE;
			markedActor=(*it);
			statusBar()->message(tr("Actor found!"));
			return;
		}
		if ((*it)->label().contains (text, FALSE) ) {
			preSize=(*it)->width();
			(*it)->setSize(2*preSize);
			markedActorExists=TRUE;
			markedActor=(*it);
			statusBar()->message(tr("Actor found!"));
			return;
		}
	} 
	
}



/**
	 Popups a context menu with some options when the user right-clicks on an actor
*/
void App::openActorContextMenu(const QPoint & mPos, Actor *jim ) {
 	if (!fileLoaded && !networkModified  )     {
 		statusBar()->message( QString(tr("Load a network file first. Then you may activate context-menu by right-clicking on any node on the canvas!")) , statusBarDuration);
 		return;
 	}
	clickedJim=jim;  //clickedJim <- signal from CanvasView
	clickedJimNumber=clickedJim->actorNumber();
	mousePos=mPos;
	QPopupMenu *actorContextMenu = new QPopupMenu(this);
	Q_CHECK_PTR( actorContextMenu );  //displays "out of memory" if such a sit. occurs
	QLabel *caption = new QLabel( "<font color=darkblue><u><b>"+tr("Actor")+QString::number(clickedJimNumber)+"</b></u></font>", this );
	caption->setAlignment( Qt::AlignCenter );
	actorContextMenu->insertItem( caption );
	actorContextMenu -> insertItem( tr("Add Link") ,this, SLOT(slotAddLink() ) );
	actorContextMenu -> insertItem(tr("Remove actor"), this, SLOT(slotRemoveActor() ) );
	QPopupMenu *options=new QPopupMenu(this);
	actorContextMenu -> insertItem( tr("Options") ,options );
	options -> insertItem( tr("Change Label"), this, SLOT(slotChangeActorLabel()) );
	options -> insertItem( tr("Change Value-Size"), this, SLOT(slotChangeActorValue()) );
	options -> insertItem( tr("Change Color"), this, SLOT(slotChangeActorColor()) );
	options -> insertItem( tr("Change Shape to Box"), this, SLOT(slotChangeActorBox()) );
	options -> insertItem( tr("Change Shape to Circle"), this, SLOT(slotChangeActorCircle()) );
	options -> insertItem( tr("Change Shape to Diamond"), this, SLOT(slotChangeActorDiamond()) );
	options -> insertItem( tr("Change Shape to Ellipse"), this, SLOT(slotChangeActorEllipse()) );
	options -> insertItem( tr("Change Shape to Triangle"), this, SLOT(slotChangeActorTriangle()) );
	actorContextMenu -> exec(QCursor::pos() );
	delete  actorContextMenu;
	clickedJimNumber=-1;    //undo actor selection
}



/**
	 Popups a context menu with some options when the user right-clicks on the canvas
*/
void App::openContextMenu( const QPoint &mPos) {
	mousePos=mPos;
	QPopupMenu *contextMenu = new QPopupMenu(this);
	Q_CHECK_PTR( contextMenu );  //displays "out of memory" if such a sit. occurs
	QLabel *caption = new QLabel( "<font color=darkblue><u><b>"+
	tr("Pretty Menu")+"</b></u></font>", this );
	caption->setAlignment( Qt::AlignCenter );
	contextMenu->insertItem( caption );
	contextMenu -> insertItem( tr("Add Actor") ,this, SLOT(addActor() ) );
	QPopupMenu *options=new QPopupMenu(this);
	contextMenu -> insertItem( tr("Options") ,options );
	options -> insertItem(tr("Change Background Color"), this, SLOT(slotBackgroundColor() ) );
	options -> insertItem(tr("Change All Actors Size"), this, SLOT( slotChangeAllActorsSize()) );
	options -> insertItem(tr("Change All Actors Shape"), this, SLOT( slotChangeAllActorsShape() ) );
	options -> insertItem(tr("Change All Actors Color"), this, SLOT( slotAllActorsColor() ) );
	options -> insertItem(tr("Change All Links Color"), this, SLOT( slotAllLinksColor() ) );
	showNumbersAct->addTo(options);
	showLabelsAct->addTo(options);

	contextMenu -> exec(QCursor::pos() );
	delete  contextMenu;
	mousePos=QPoint(-1,-1);
}




/**
	 Popups a context menu with some options when the user right-clicks on a link
*/
void App::openLinkContextMenu(const QPoint & mPos, Edge *link) {
    if (!fileLoaded && !networkModified  )    {
       	statusBar()->message( QString(tr("Load a network file first. Then you may activate context-menu by right-clicking on any node on the canvas!")) , statusBarDuration);
        return;
    }
    mousePos=mPos;
    
    clickedLink=link;
    linkClicked=true;
    //make the menu
    QPopupMenu *linkContextMenu = new QPopupMenu(this);
    Q_CHECK_PTR( linkContextMenu );  //displays "out of memory" if such a sit. occurs
    QLabel *caption = new QLabel( "<font color=darkblue><u><b>" +
        tr("Link ")+QString::number(link->fromActor())+" - "+QString::number(link->toActor())+"</b></u></font>", this );
    caption->setAlignment( Qt::AlignCenter );
    linkContextMenu->insertItem( caption );
    linkContextMenu -> insertItem (tr("Remove"), this, SLOT( slotRemoveLink() ) );
    linkContextMenu -> insertItem( tr("Set weight") ,this, SLOT( slotChangeLinkWeight ()  )  );
    linkContextMenu -> insertItem( tr("Set color") ,this, SLOT(slotChangeLinkColor() ) );
    linkContextMenu -> exec(QCursor::pos() );
    delete  linkContextMenu;
    mousePos=QPoint(-1,-1);
    linkClicked=false;
}




void App::mousePosition(int x, int y) { 
	mousePos=QPoint(x,y);
}


/**
*	Adds a new actor to the canvas
*/

void App::addActor(){
	qDebug("addActor()");
	QPoint p;
	if ( mousePos.x()!=-1 && mousePos.y()!=-1 ){
		p=mousePos;
		qDebug ("p : %i, %i  and  mPos : %i, %i",p.x(),p.y(),mousePos.x(), mousePos.y() );
	}
	else {
		p.setX(rand()%canvas->width());
		p.setY(rand()%canvas->height());
	}
	if (activeActors()==0) networkModified=true;
	else if (activeActors()==-1) qDebug("problem with active actors");
	int newActor=0;
	QCanvasItemList list=canvas->allItems();
	for (QCanvasItemList::iterator it=list.begin(); it!=list.end(); it++) {
			if ( (*it) -> rtti() == Actor_Rtti ){
				Actor *jim= (Actor*) (*it);
				if ( jim->actorNumber()>=newActor) newActor=jim->actorNumber();
			}
	}
	qDebug("maximum existing Actor number is %i", newActor);
	qDebug("assigned %i to new actor", newActor+1);
	drawActor(newActor+1, initActorSize, initActorColor, QString::number(newActor+1),initLabelColor, p.x(),p.y(), actorShape) ;
	Actors=activeActors();
	if (activeActors()==-1) qDebug("problem with active actors");
	qDebug("Drawed new actor OK. Total actors now: %i", Actors);
	
	networkModified=TRUE;
}


/*
void App::addActor(){
	qDebug("addActor()");
	QPoint p;
	if ( mousePos.x()!=-1 && mousePos.y()!=-1 ){
		p=mousePos;
		qDebug ("p : %i, %i  and  mPos : %i, %i",p.x(),p.y(),mousePos.x(), mousePos.y() );
	}
	else {
		p.setX(rand()%canvas->width());
		p.setY(rand()%canvas->height());
	}
	if (activeActors()==0) networkModified=true;
	else if (activeActors()==-1) qDebug("problem with active actors");
	int newActor=0;
	QCanvasItemList list=canvas->allItems();
	for (QCanvasItemList::iterator it=list.begin(); it!=list.end(); it++) {
			if ( (*it) -> rtti() == Actor_Rtti ){
				Actor *jim= (Actor*) (*it);
				if ( jim->actorNumber()>=newActor) newActor=jim->actorNumber();
			}
	}
	qDebug("maximum existing Actor number is %i", newActor);
	qDebug("assigned %i to new actor", newActor+1);
	drawActor(newActor+1, initActorSize, initActorColor, QString::number(newActor+1),initLabelColor, p.x(),p.y(), actorShape) ;
	Actors=activeActors();
	if (activeActors()==-1) qDebug("problem with active actors");
	qDebug("Drawed new actor OK. Total actors now: %i", Actors);
	
	networkModified=TRUE;
}

*/


/**
	Deletes the actor named DoomedJim from aVector and the canvas.
	Does not delete numbers, labels, or links. 
	Use slotRemoveActor() with clickedJim instead.
*/
bool App::removeActor(int doomedJim){
	qDebug ("removeActor(DoomedJim): REMOVING ACTOR FROM VECTOR AND CANVAS");
	bool canvasActorFound=FALSE;
	int index=-1;
	QCanvasItemList list=canvas->allItems();
	for (QCanvasItemList::iterator it=list.begin(); it!=list.end(); it++) {
			if ( (*it) -> rtti() == Actor_Rtti ){
				Actor *jim= (Actor*) (*it);
				if ( jim->actorNumber()==doomedJim ) {
					if ((index=removeActorFromVector(doomedJim))!=-1) 
						qDebug ("Deleted actor from aVector");
					else {
						qDebug("Cannot find any actorNumber=doomedJim inside aVector.");
						return false;
					}
					canvasActorFound=TRUE;
					delete *it;
					qDebug("Deleted canvasActor ");
// 					SM.removeRow(index);
// 					SM.removeColumn(index);
					qDebug ("Deleted row,col %i,%i from table", index,index);
					break;
				}
			}
	}
	if (canvasActorFound) { 	networkModified=TRUE; return true; }
	else return false;
}



/**
*	Removes an actor from the actorVector only.
*/
int App::removeActorFromVector(int doomedJim){
	qDebug ("removeActorFromVector(doomedJim)");
	int aVectorIndex=0;
	bool aVectorActorFound=FALSE;
	qDebug("actorVector reports as having %i Actors", aVector.size() );
	vector<Actor*>::iterator it;
	for (it=aVector.begin(); it!=aVector.end(); it++) {
		if ((*it)->actorNumber()==doomedJim) { 
			aVectorActorFound=TRUE; 
			qDebug("Found doomedJim with aVectorIndex %i inside actorVector",aVectorIndex);
			qDebug("Now I will delete him from the aVector");
			aVector.erase(it);
			qDebug("Deleted actor %i with aVectorIndex %i", doomedJim, aVectorIndex);
			qDebug("Now actorVector reports as having %i Actors", aVector.size() );
			break;
		}
		aVectorIndex++;
	}
	if ( aVectorActorFound) {
		return aVectorIndex;	
	}
	else 
		return -1;
	
}



/**
*	Returns then index of an actor within actorVector 
*/
int App::actorVectorIndex(int actorNumber){
	bool aVectorActorFound=FALSE;
	int aVectorIndex=0;
	vector<Actor*>::iterator it;
	for (it=aVector.begin(); it!=aVector.end(); it++) {
		if ((*it)->actorNumber()==actorNumber) { 
			aVectorActorFound=TRUE; 
			break;
		}
		aVectorIndex++;
	}
	if (aVectorActorFound) {
		return aVectorIndex;	
	}
	else 
		return -1;
}




/**
*	Adds a new arc from an actor to another.
*/
void App::addLink(Actor* jim1, Actor *jim2){
	if (linkExists(jim1->actorNumber(), jim2->actorNumber() )) {
 		qDebug("Already connected. ");
		return;
	}
	drawLink(jim1, jim2, 1, initLinkColor, bezier);
	qDebug("Drawed link between %i and %i", jim1->actorNumber(), jim2->actorNumber());
	qDebug("Emitting signal to canvasView to clear clicked actor history");
	networkModified=TRUE;
	emit clearClickedActorHistory();
	
}



/** 
*	Deletes arc reference from object actorVector
*	then deletes arc item from canvas
*/
bool App::removeLink(Edge *link){
	qDebug ("REMOVING LINK BETWEEN");
	int sourceActor=link->fromActor();
	int targetActor=link->toActor();
	int vecIdx1=actorVectorIndex(sourceActor);
	int vecIdx2=actorVectorIndex(targetActor);
	qDebug ("Actor %i and actor %i with vec Indexes %i and %i ", sourceActor, targetActor, vecIdx1, vecIdx2);
	if ( vecIdx1 !=-1 && vecIdx2!=-1) {
		if ( aVector[vecIdx1]->isOutLinkedWith(targetActor) && aVector[vecIdx2]->isInLinkedWith(sourceActor) ) {
			qDebug ("Link from actor %i to actor %i with vec Indexes %i and %i ", sourceActor, targetActor, vecIdx1, vecIdx2);
			if (aVector[vecIdx1]->deleteOutLink(link) && aVector[vecIdx2]->deleteInLink(link) ) {
					qDebug ("Deleted their out and in Links");
			}
			else { qDebug("Could not delete their in and out Links. ABORT."); return false;}
		}
		else { qDebug("Actors not connected. Aborting"); return false;}
	}
	else { qDebug("Vector indexes out of range. ABORT."); return false;}
	//just for sanity. Check again if link is still there:
	if ( aVector[vecIdx1]->isOutLinkedWith(targetActor) && aVector[vecIdx2]->isInLinkedWith(sourceActor) ) {
		qDebug ("Link from actor %i to %i with vec Indexes %i and %i still exists in objects of aVectorActors", sourceActor,targetActor, vecIdx1, vecIdx2);
		qDebug("In and out Links still present! ABORT."); 
		return false;
	}
	else qDebug ("Link deletion from actorVector objects succesfull");
	delete  link;
	qDebug("CANVAS Link deleted as well");
// 	SM.clearCell(vecIdx1,vecIdx2);
	qDebug("SM item deleted as well");  //obsolete

	QCanvasItemList list=canvas->allItems();
	for (QCanvasItemList::iterator it=list.begin(); it!=list.end(); it++) 
		if ( (*it)->rtti()==Arrow_Rtti) {
			Arrow *arr=(Arrow*) (*it);
			if ( arr->fromActor() == sourceActor && arr->toActor() == targetActor )	{
				if ( aVector[vecIdx1]->deleteOutArrow(arr) && aVector[vecIdx2]->deleteInArrow(arr) )
					qDebug("Arrows Deleted from actors reference lists");
				else qDebug ("ERROR DELETING ARROWS FROM LINK");
				delete arr;
				qDebug ("Arrows deleted from canvas");
				break;
			}
			
		}
	
	networkModified=TRUE;
	statusBar()->message(tr("REMOVING A LINK THAT IS A DOUBLE LINK. DO IT TWICE!!! ") ,statusBarDuration+1000);
	return true;
	
}



/**
* 	Deletes an actor and the attached objects (links, etc).
*	It deletes clickedJim (signal from CanvasView or set by another function) 
*	or else asks for an actorNumber to remove. The actorNumber is doomedJim.
*	REMOVES LINKS CONCERNING DOOMEDJIM, I.E. REMOVE LINK REF IN ACTOR OBJECT,
*	THEN REMOVE CANVASLINK
*	REMOVES NUMBER AND LABEL
*	THEN REMOVE ACTOR CALLING removeActor(doomedJim), I.E. REMOVE ACTOR FROM VECTOR,THEN REMOVE CANVASACTOR
*/
void App::slotRemoveActor () {
	qDebug("SLOT Remove Actor");
	if (!fileLoaded && !networkModified  )
		return ;
	int doomedJim=-1, min=RAND_MAX, max=-1, linksDeleted=0,vecIdx1, vecIdx2, source, target ;

	bool ok=false; // canvasActorFound=FALSE;

	QCanvasItemList list=canvas->allItems();
	for (QCanvasItemList::iterator it=list.begin(); it!=list.end(); it++)
		if ( (*it) -> rtti() == Actor_Rtti ){
			Actor *jim = (Actor*) (*it);
			if (min>jim->actorNumber() ) min=jim->actorNumber();
			if (max<jim->actorNumber() ) max=jim->actorNumber();
		}
	if (min==-1 || max==-1 ) { qDebug("ERROR in finding min max actorNumbers. Abort"); return;}	
	doomedJim =  (clickedJimNumber >= 0 && clickedJimNumber<= max )  ?
                      clickedJimNumber :
		( QInputDialog::getInteger("-SocNetV-",tr("Choose an actor to remove between ("
		+QString::number(min)+"..."+QString::number(max)+"):"),
		min, 1, max , 1, &ok, this ) )   ;
	qDebug("I will delete actor %i from the canvas now: Links from actor objects, canvaslinks, numbers, labels and only then I will remove ActorVector and CanvasActor!", doomedJim);
	//canvasActorFound=FALSE;
	//REMOVE LINKS CONCERNING DOOMEDJIM, I.E. REMOVE LINK REF IN ACTOR OBJECT, THEN REMOVE CANVASLINK
	//REMOVE NUMBER AND LABEL
	//THEN REMOVE ACTOR, I.E. REMOVE ACTOR FROM VECTOR,THEN REMOVE CANVASACTOR
	for (QCanvasItemList::iterator it=list.begin(); it!=list.end(); it++) {
		if ( (*it)->rtti()==Link_Rtti) {
			Edge *link=(Edge*) (*it);
			source= link->fromActor();
			target=link->toActor();
			if ( source==doomedJim  || target==doomedJim ){
				qDebug("Found link concerning DoomedJim Actor");
				vecIdx1=actorVectorIndex(source);
				vecIdx2=actorVectorIndex(target);
				qDebug ("Actor %i and actor %i with vec Indexes %i and %i ", source, target, vecIdx1, vecIdx2);
				if ( vecIdx1 !=-1 && vecIdx2!=-1) {
					if ( aVector[vecIdx1]->isOutLinkedWith(target ) && aVector[vecIdx2]->isInLinkedWith(source) ) {
						qDebug ("Link from actor %i to actor %i with vec Indexes %i and %i ", source, target, vecIdx1, vecIdx2);
						if (aVector[vecIdx1]->deleteOutLink(link) && aVector[vecIdx2]->deleteInLink(link) ) {
							qDebug ("Deleted their in/out Links");
						}
						else { qDebug("Could not delete their in and out Links. ABORT!"); return;}
					}
					else { qDebug("Actors not connected. ABORT"); return;}
				}
				else { qDebug("aVector indexes out of range. ABORT"); return ;}
				//CHECK AGAIN!
				if ( aVector[vecIdx1]->isOutLinkedWith(target) && aVector[vecIdx2]->isInLinkedWith(source) ) {
					qDebug ("Link from actor %i to %i with vec Indexes %i and %i still exists in objects of aVectorActors", source,target, vecIdx1, vecIdx2);
					qDebug("In and out Links still present! ABORT!"); 
					return ;
				}
				else qDebug ("Link deletion from actorVector objects succesfull");
				delete  *it;
				qDebug("CANVAS Link deleted as well");
			// 	SM.clearCell(vecIdx1,vecIdx2);
				qDebug("SM item deleted as well");
				//if (removeLink(link) ) linksDeleted++;
				qDebug ("DELETED Link of doomedJim %i", doomedJim);
				continue;
			}
		}
		else if ( (*it)->rtti()==Number_Rtti){
			ActorNumber *jimNumber=(ActorNumber*) (*it);
			if (jimNumber->text()==QString::number(doomedJim)) {
				aVector [actorVectorIndex(doomedJim)] -> deleteNumber(jimNumber) ;
				delete *it;
				qDebug ("DELETED ActorNumber.");
				continue;
			}
		}
		else if ( (*it)->rtti()==Label_Rtti){
			ActorLabel *jimLabel=(ActorLabel*) (*it);
			if (jimLabel->text()==QString::number(doomedJim)) {
				aVector [actorVectorIndex(doomedJim)] -> deleteLabel(jimLabel) ;
				delete *it;
				qDebug ("DELETED ActorLabel. ");
				continue;
			}
		}
		else if ( (*it)->rtti()==Arrow_Rtti) {
			Arrow *arr=(Arrow*) (*it);
			source=arr->fromActor();
			target=arr->toActor();
			if ( source == doomedJim || target == doomedJim )	{
				vecIdx1=actorVectorIndex(source);
				vecIdx2=actorVectorIndex(target);
				if ( aVector[vecIdx1]->deleteOutArrow(arr) && aVector[vecIdx2]->deleteInArrow(arr) )
					qDebug("Arrows Deleted from actors reference lists");
				else qDebug ("ERROR DELETING ARROWS FROM LINK");
				delete arr;
				qDebug ("Arrows deleted from canvas");
				continue;
			}
			
		}
		
	}
	qDebug ("SLOT_Remove_Actor CALL removeActor(doomedJim)");
	if (removeActor(doomedJim)) {
		qDebug("SocNetV: Deleted actor %i from the canvas. Deleted %i links. Canvas reports:  %i Actors",doomedJim,linksDeleted, activeActors());
	}
	networkModified=TRUE;
	statusBar()->message(tr("Ready. ") ,statusBarDuration);
}




/**
*	Checks if a link (canvas item) exists
*/
bool App::linkExists(Edge * link){
	
	QCanvasItemList list=canvas->allItems();
	QCanvasItemList::iterator it = qFind( list.begin(), list.end(), link );
	if ( it != list.end() )
		return true;
	return false;
}




/**
*	Checks if a link between two actors exists
*/
bool App::linkExists(int sourceActor, int targetActor){
	QCanvasItemList list=canvas->allItems();
	for (QCanvasItemList::iterator it=list.begin(); it!= list.end() ; it++){
		if ( (*it)->rtti()==Link_Rtti) {
			Edge *link=(Edge*) (*it);
			if ( link->fromActor()==sourceActor && link->toActor()==targetActor )
				return true;	
		}
	}
	return false;
}




/**
*	Adds a new link between two actors specified by the user.
*/
void App::slotAddLink(){
	int min=0, max=0, sourceActor=-1, targetActor=-1, weight=1, aVectorIndex1=-1, aVectorIndex2=-1;
	bool ok=FALSE;
	QCanvasItemList list=canvas->allItems();
  	for (QCanvasItemList::iterator it=list.begin(); it!=list.end(); it++)
		if ( (*it) -> rtti() == Actor_Rtti ){
			Actor *jim = (Actor*) (*it);
			if (min>jim->actorNumber() ) min=jim->actorNumber();
			if (max<jim->actorNumber() ) max=jim->actorNumber();
		}
	sourceActor=QInputDialog::getInteger("-SocNetV-",tr("Choose source actor of new link ("+QString::number(min)+"..."+QString::number(max)+"):"), min, 1, max , 1, &ok, this )   ;
	targetActor=QInputDialog::getInteger("-SocNetV-", tr("Choose target actor of new link ("+QString::number(min)+"..."+QString::number(max)+"):"),min, 1, max , 1, &ok, this )     ;
	weight=QInputDialog::getInteger("-SocNetV-", tr("Choose weight of new link :"),1, 1, 10, 1, &ok, this   )   ;
	//does sourceActor and targetActor exist?
	if (linkExists(sourceActor, targetActor) ) {
		qDebug("Link exists");
		return;
	}
	if ( ( aVectorIndex1=actorExists(sourceActor)) !=-1 ) {
		if  ( (aVectorIndex2=actorExists(targetActor)) !=-1 )
			drawLink(aVectorIndex1, aVectorIndex2, weight, initLinkColor, bezier);
		else qDebug ("Cant find targetActor %i",targetActor);
	}
	else qDebug ("Cant find sourceActor %i.", sourceActor);
	networkModified=TRUE;
	statusBar()->message(tr("Ready. ") ,statusBarDuration);
}




/**
*	Erases the clicked link. Otherwise asks the user to specify one link.
*/
void App::slotRemoveLink(){ 
	int min=0, max=0, sourceActor=-1, targetActor=-1;
	bool ok=FALSE;
	bool linkDeleted=FALSE;
	QCanvasItemList list=canvas->allItems();
  	if (!linkClicked) {
		for (QCanvasItemList::iterator it=list.begin(); it!=list.end(); it++)
			if ( (*it) -> rtti() == Actor_Rtti ){
			Actor *jim = (Actor*) (*it);
			if (min>jim->actorNumber() ) min=jim->actorNumber();
			if (max<jim->actorNumber() ) max=jim->actorNumber();
		}
		sourceActor=QInputDialog::getInteger("-SocNetV-",tr("Remove link: source actor:  ("+QString::number(min)+"..."+QString::number(max)+"):"), min, 1, max , 1, &ok, this )   ;
		targetActor=QInputDialog::getInteger("-SocNetV-", tr("Remove link: target actor:  ("+QString::number(min)+"..."+QString::number(max)+"):"),min, 1, max , 1, &ok, this )   ;
	

		for (QCanvasItemList::iterator it=list.begin(); it!= list.end() ; it++){
			if ( (*it)->rtti()==Link_Rtti) {
				Edge *link=(Edge*) (*it);
				if ( link->fromActor()==sourceActor && link->toActor()==targetActor ) {
					if (removeLink(link) )  { linkDeleted=true; break; } 
					else 	statusBar()->message(tr("Could not remove link. ") ,statusBarDuration);
				}
			}
		}
	}
	else 
	if (removeLink(clickedLink) )  linkDeleted=true;
	if (linkDeleted) {
		statusBar()->message(tr("Link deleted. Ready. ") ,statusBarDuration);
		networkModified=TRUE;
	}
	else 
		statusBar()->message(tr("Could not find such link. ") ,statusBarDuration);
}




/**
*	Changes the label of the clicked actor
*/
void App::slotChangeActorLabel(){
	if (clickedJimNumber==-1) {
		statusBar()->message(tr("Error. ") ,statusBarDuration);
		return;
	}
	bool ok;
	QString text = QInputDialog::getText("-SocNetV-", "Enter new actor label:", QLineEdit::Normal,
            QString::null, &ok, this );
    	if ( ok && !text.isEmpty() ) {
		clickedJim-> setLabel (text);
        	statusBar()->message(tr("Ready. ") ,statusBarDuration);
		networkModified=TRUE;
    	} 
	else {
		statusBar()->message(tr("No label text. Abort. ") ,statusBarDuration);
	}

}




/**
*	Changes the colour of the clicked actor
*/
void App::slotChangeActorColor(){
	if (clickedJimNumber==-1) {
		statusBar()->message(tr("Error. ") ,statusBarDuration);
		return;
	}
	bool ok;
	actorColor = QInputDialog::getItem(
            "SocNetV", "Select a  color:", colorList, 1, TRUE, &ok,  this );
    	if ( ok ) {
		clickedJim-> setBrush (QColor(actorColor));
		clickedJim->setActorColor(actorColor);
		networkModified=TRUE;
		statusBar()->message(tr("Ready. ") ,statusBarDuration);
    	} 
	else {
	        // user pressed Cancel
		statusBar()->message(tr("User abort. ") ,statusBarDuration);
    	}
	
}



/**
*	Changes the value (size) of the clicked actor.  TODO
*/
void App::slotChangeActorValue(){
//I should use a scaling technique here for ActorValues to be analogous to nodeSizes...
	if (clickedJimNumber==-1) { 
		statusBar()->message(tr("Error. ") ,statusBarDuration);
		return;
	}
	bool ok=FALSE;
	int newSize =   QInputDialog::getInteger("-SocNetV-", tr("Change actor size to: (1-16)"),1, 1, 16, 1, &ok, this ) ;
	clickedJim->setSize(newSize);
	networkModified=TRUE;
	statusBar()->message (QString(tr("Ready")), statusBarDuration) ;
	return;
	
	
}



/**
*	Changes the shape of the clicked actor to box
*/
void App::slotChangeActorBox(){
	clickedJim->setShape("box");
}



/**
*	Changes the shape of the clicked actor to triangle
*/
void App::slotChangeActorTriangle(){
	clickedJim->setShape("triangle");
}



/**
*	Changes the shape of the clicked actor to circle
*/
void App::slotChangeActorCircle(){
	clickedJim->setShape("circle");
}



/**
*	Changes the shape of the clicked actor to diamond
*/
void App::slotChangeActorDiamond(){
	clickedJim->setShape("diamond");
}



/**
*	Changes the shape of the clicked actor to ellipse
*/
void App::slotChangeActorEllipse(){
	clickedJim->setShape("ellipse");
}


//TODO
void App::slotChangeLinkLabel(){
	networkModified=TRUE;
}



/**
*	Changes the colour of the clicked link. 
*	If no link is clicked, then it asks the user to specify one.
*/
void App::slotChangeLinkColor(){
	int min=0, max=0, sourceActor=-1, targetActor=-1;
	bool ok=FALSE;
	QString newColor;
	QCanvasItemList list=canvas->allItems();
  	if (!linkClicked) {
		for (QCanvasItemList::iterator it=list.begin(); it!=list.end(); it++)
			if ( (*it) -> rtti() == Actor_Rtti ){
			Actor *jim = (Actor*) (*it);
			if (min>jim->actorNumber() ) min=jim->actorNumber();
			if (max<jim->actorNumber() ) max=jim->actorNumber();
		}
		sourceActor=QInputDialog::getInteger("-SocNetV-",tr("Change Link Color - source actor:  ("+QString::number(min)+"..."+QString::number(max)+"):"), min, 1, max , 1, &ok, this )   ;
		targetActor=QInputDialog::getInteger("-SocNetV-",tr("Change Link Color - target actor:  ("+QString::number(min)+"..."+QString::number(max)+"):"),min, 1, max , 1, &ok, this )   ;
		for (QCanvasItemList::iterator it=list.begin(); it!= list.end() ; it++){
			if ( (*it)->rtti()==Link_Rtti) {
				Edge *link=(Edge*) (*it);
				if ( link->fromActor()==sourceActor && link->toActor()==targetActor ) {
					newColor = QInputDialog::getItem("SocNetV", "Select a  color:", colorList, 1, TRUE, &ok,  this );
    					if ( ok ) {
						link-> setPen (QPen (newColor, link->pen().width(),link->pen().style() ) );
						link->setLinkColor(newColor);
						networkModified=TRUE;
						statusBar()->message(tr("Ready. ") ,statusBarDuration);
						//newColor=QColorDialog::getColor(black , this, "Actor color dialog" );
						return;
    					} 
					else { // user pressed Cancel
						statusBar()->message(tr("User abort. ") ,statusBarDuration);
    					}

				}
			}
		}
	}
	else {
		newColor = QInputDialog::getItem("SocNetV", "Select a  color:", colorList, 1, TRUE, &ok,  this );
		if ( ok ) {
			clickedLink-> setPen (QPen (newColor, clickedLink->pen().width(),clickedLink->pen().style() ) );
			clickedLink->setLinkColor(newColor);
			networkModified=TRUE;
			statusBar()->message(tr("Ready. ") ,statusBarDuration);
			return;
    		} 
		else {       // user pressed Cancel
			statusBar()->message(tr("User abort. ") ,statusBarDuration);
		}
	}
}




/**
*	Changes the weight of the clicked link. 
*	If no link is clicked, then it asks the user to specify one.
*/
void App::slotChangeLinkWeight(){
	int newWeight=1, min=0, max=0, sourceActor=-1, targetActor=-1;
	bool ok=FALSE;
	if (!linkClicked) {	
		QCanvasItemList list=canvas->allItems();
		for (QCanvasItemList::iterator it=list.begin(); it!=list.end(); it++)
			if ( (*it) -> rtti() == Actor_Rtti ){
			Actor *jim = (Actor*) (*it);
			if (min>jim->actorNumber() ) min=jim->actorNumber();
			if (max<jim->actorNumber() ) max=jim->actorNumber();
		}
		sourceActor=QInputDialog::getInteger("-SocNetV-",tr("Select link: source actor:  ("+QString::number(min)+"..."+QString::number(max)+"):"), min, 1, max , 1, &ok, this )   ;
		targetActor=QInputDialog::getInteger("-SocNetV-", tr("Select link: target actor:  ("+QString::number(min)+"..."+QString::number(max)+"):"),min, 1, max , 1, &ok, this )   ;
		qDebug("source %i target %i",sourceActor, targetActor);
		for (QCanvasItemList::iterator it=list.begin(); it!= list.end() ; it++)
			if ( (*it)->rtti()==Link_Rtti) {
				Edge *link=(Edge*) (*it);
				qDebug ("Finding link");
				if ( link->fromActor()==sourceActor && link->toActor()==targetActor ) {
					qDebug("This link");
					newWeight=QInputDialog::getInteger("-SocNetV-",tr("New link Weight: "), 1, 1, 100 ,1, &ok, this ) ;
					if (ok) {
						link->setWeight(newWeight);
						if (newWeight>0)
							link->setPen( QPen(link->pen().color(), lineWidth(newWeight),Qt::SolidLine));
						else
							link->setPen( QPen(link->pen().color(), lineWidth(newWeight),Qt::DashLine));
						networkModified=TRUE;
						statusBar()->message( QString(tr("Ready.")) ,statusBarDuration);
						return;
						
					}
					else {
						statusBar()->message( QString(tr("input error. Abort.")) , statusBarDuration);
						return;
					}
				}
			}
	}
	else {  //linkClicked
		newWeight=QInputDialog::getInteger("-SocNetV-",tr("New link Weight: "), 1, -100, 100 ,1, &ok, this ) ;
		if (ok) {
			clickedLink->setWeight(newWeight);
			if (newWeight>0)
				clickedLink->setPen( QPen(clickedLink->pen().color(), lineWidth(newWeight),Qt::SolidLine));
			else 
				clickedLink->setPen( QPen(clickedLink->pen().color(), lineWidth(newWeight),Qt::DashLine));
			statusBar()->message( QString(tr("Ready.")) ,statusBarDuration);
			networkModified=TRUE;
			return;
		}
		else {
			statusBar()->message( QString(tr("input error. Abort.")) , statusBarDuration);
			return;
		}
		
	}
	
}




/**
*	Filters Actors   TODO
*	
*/
void App::slotFilterActors(){
	if (!fileLoaded && !networkModified  )  {
		statusBar()->message( QString(tr("Load a network file first. Then you may ask me to compute something!")) , statusBarDuration);
		return;
	}
}




/**
*	Filters links according to their weight w
*	All links weighted more (or less) than the specified w will be removed.
*/
void App::slotFilterLinks(){
	mapEdges.clear();
	if (!fileLoaded && !networkModified  )   {
		statusBar()->message( QString(tr("Load a network file first. Then you may ask me to compute something!")) , statusBarDuration);
		return;
	}
	bool ok=FALSE, moreWeighted=FALSE;
	int selectedWeight=0;
	switch (
             QMessageBox::information(this, "-SocNetV-",tr(" Do you want to filter out links weighted greater-equal or less-equal than a number?"), ">=","<=",0,1)
            )
	{
		case 0:  moreWeighted = TRUE;
			selectedWeight =   QInputDialog::getInteger(
			"-SocNetV-", tr("Filter all links with weight greater-equal than: "),
			0, 0, 10, 1, &ok, this ) ;
			break;
		case 1:  moreWeighted=FALSE;
			selectedWeight =   QInputDialog::getInteger(
			"-SocNetV-", tr("Filter all links with weight less-equal than: "),
			0, 0, 10, 1, &ok, this ) ;
			break;
	}
	QCanvasItemList list=canvas->allItems();
	for (QCanvasItemList::iterator it=list.begin(); it!=list.end(); it++)
		if ( (*it) -> rtti() == Link_Rtti ){
			Edge *link = (Edge*) (*it);
			if ( link->weight()>=selectedWeight && moreWeighted){
				(*it)->setVisible(false);
				mapEdges [ link->fromActor() ] = link->toActor();
				qDebug("GT: Hiding link from actor %i to actor %i",link->fromActor(),mapEdges[link->fromActor() ]);

			}
			else if ( link->weight()<=selectedWeight && !moreWeighted) {
				(*it)->setVisible(false);
				mapEdges [ link->fromActor() ] = link->toActor();
				qDebug("LT: Hiding link from actor %i to actor %i",link->fromActor(),mapEdges[link->fromActor() ]);
			}
			else {
// 				mapEdges [link->fromActor() ]= -1; 
				(*it)->setVisible(true);
			}
		}
	for (QCanvasItemList::iterator it=list.begin(); it!=list.end(); it++)
		if ( (*it) -> rtti() == Arrow_Rtti ){
			Arrow *arrow = (Arrow*) (*it);
			qDebug("Arrow from actor %i to actor %i",arrow->fromActor(),mapEdges[arrow->fromActor() ]);
			if ( mapEdges[arrow->fromActor() ]  ){
				qDebug(" Hiding arrow from actor %i to actor %i",arrow->fromActor(),mapEdges[arrow->fromActor() ]);
				arrow->setVisible(false);
			}
			else (*it)->setVisible(true);
		}

	statusBar()->message (QString(tr("Ready")), statusBarDuration) ;
}




/**
*	Transforms all actors to links
	TODO
*/
void App::slotTransformActors2Links(){

	networkModified=TRUE;
}





/**
*	Converts all arcs to edges, so that the network becomes symmetric.
*/
void App::slotSymmetriseLinks(){
	int source, target, weight;
	QCanvasItemList list=canvas->allItems();
	for (QCanvasItemList::iterator it=list.begin(); it!=list.end(); it++)
			if ( (*it)->rtti() ==   Link_Rtti ){
				Edge* link= (Edge*) (*it);
				source=link->fromActor();
				target=link->toActor();	
				weight=link->weight();
				qDebug("Arc from actor %i to actor %i", source, target);			
				if ( linkExists(target, source ) ) {
 					qDebug("Already connected. ");
					continue;
				}
				drawLink( (target-1), (source-1) , weight, initLinkColor, bezier);
				qDebug("Drawed inverse arc between %i and %i", target, source);
			}
	networkModified=TRUE;

}



/**
	TODO
*/
void App::slotColorationStrongStructural() {
}


/**
	TODO
*/
void App::slotColorationRegular() {
}


/**
	TODO
*/
void App::slotLayoutRandom(){

}


/**
	TODO
*/
void App::slotLayoutRandomCircle(){
}




/**
*	Erases all circles drawed on the canvas during layout.
*/
void App::slotClearBackgrCircles(){ 
	QCanvasItemList list=canvas->allItems();
	for (QCanvasItemList::iterator item=list.begin(); item!=list.end(); item++) 
			if ( (*item)->rtti()==BackgrCircle_Rtti) {
				delete *item;
				
			}
}




/**
*	Repositions all actors on a circular layout based on their 
*	Out-Degree Centralities. 
*	More central actors are closer to the centre
*/
void App::layoutOutDegreeCentrality (bool questions){
	qDebug("layoutOutDegreeCentrality()");
	QApplication::setOverrideCursor( QCursor(Qt::WaitCursor) );
	if (!calculatedODC || networkModified) {
		statusBar()->message(tr("Calculating centralities... ") ,statusBarDuration);
		centralityOutDegree(questions);
	}
	statusBar()->message(tr("Finished centralities. Wait as I am moving actors to new positions. ") ,statusBarDuration);
	double x0=canvas->width()/2.0;
	double y0=canvas->height()/2.0;
	double radius=canvas->height()/2.0;          //pixels
	double rad;
	double i=0, std;
	float AODC;
	int index=-1;
	qHeapSort(discreteODCs);   //sorts DCs in ascending order
	slotClearBackgrCircles();
	for (vector<Actor*>::iterator it=aVector.begin(); it!=aVector.end(); it++) {
		AODC=(*it)->AODC();
		std= (*it)->SAODC();
		radius=canvas->height()/2.0;          //max radius, reserved for lonely actors. 
		index=discreteODCs.findIndex(AODC);	
		qDebug ("Current actor %i with AODC = %f and stdODC=%f, AODC index %i",(*it)->actorNumber(), AODC, std, index+1);
		if (index!=-1) {
			radius=(classesODC-index)*radius/classesODC;
		}
		else 
			qDebug("AODC not existing in discreteODCs");
		BackgrCircle *circle=new BackgrCircle (canvas, (int) x0,(int) y0,(int) radius);
		circle->show();
		rad= (2.0* PI/ Actors);
		qDebug("Actor is at x=%f and y=%f ",(*it)->x(), (*it)->y());
		(*it)->setX(x0 + radius * cos(i * rad) );
		(*it)->setY(y0 + radius * sin(i * rad) );
		qDebug("Actor moves to x=%f and y=%f ",(*it)->x(), (*it)->y());
		i++;
	}
	statusBar()->message(tr("Actors in inner circles are more central. Ready. ") ,statusBarDuration);
	QApplication::restoreOverrideCursor();
}



/**
*	Main Menu Item
*	Calls layoutDegreeCentrality function whcih repositions all actors 
*	on a circular layout based on their Out-Degree Centralities. 
*	More central actors are closer to the centre
*/
void App::slotLayoutCircleCentralityOutDegree(){
	if (!fileLoaded && !networkModified  )  {
		statusBar()->message(tr("You must load a file first... ") ,statusBarDuration);
		return;
	}
	layoutOutDegreeCentrality(true);

}




/**
*	Repositions all actors on a circular layout based on their 
*	In-Degree Centralities. 
*	More central actors are closer to the centre
*/
void App::layoutInDegreeCentrality (bool questions){
	qDebug("layoutInDegreeCentrality()");
	QApplication::setOverrideCursor( QCursor(Qt::WaitCursor) );
	if (!calculatedIDC || networkModified) {
		statusBar()->message(tr("Calculating centralities... ") ,statusBarDuration);
		centralityInDegree(questions);
	}
	
	statusBar()->message(tr("Finished centralities. Wait as I am moving actors to new positions. ") ,statusBarDuration);
	double x0=canvas->width()/2.0;
	double y0=canvas->height()/2.0;
	double radius=canvas->height()/2.0;          //pixels
	double rad;
	double i=0, std;
	float AIDC;
	int index=-1;
	qHeapSort(discreteIDCs);   //sorts DCs in ascending order
	slotClearBackgrCircles();
	for (vector<Actor*>::iterator it=aVector.begin(); it!=aVector.end(); it++) {
		AIDC=(*it)->AIDC();
		std= (*it)->SAIDC();
		radius=canvas->height()/2.0;          //max radius, reserved for lonely actors. 
		index=discreteIDCs.findIndex(AIDC);	
		qDebug ("Current actor %i with AIDC = %f and stdIDC=%f, AIDC index %i",(*it)->actorNumber(), AIDC, std, index+1);
		if (index!=-1) {
			radius=(classesIDC-index)*radius/classesIDC;
		}
		else 
			qDebug("AODC not existing in discreteODCs");
		BackgrCircle *circle=new BackgrCircle (canvas, (int) x0,(int) y0,(int) radius);
		circle->show();
		rad= (2.0* PI/ Actors);
		(*it)->setX(x0 + radius * cos(i * rad) );
		(*it)->setY(y0 + radius * sin(i * rad) );
		qDebug("Actor moves to x=%f and y=%f ",(*it)->x(), (*it)->y());
		i++;
	}
	statusBar()->message(tr("Actors in inner circles are more central. Ready. ") ,statusBarDuration);
	QApplication::restoreOverrideCursor();
	
}



/**
*	Main Menu Item
*	Calls layoutDegreeCentrality function whcih repositions all actors 
*	on a circular layout based on their In-Degree Centralities. 
*	More central actors are closer to the centre
*/
void App::slotLayoutCircleCentralityInDegree(){
	if (!fileLoaded && !networkModified  )  {
		statusBar()->message(tr("You must load a file first... ") ,statusBarDuration);
		return;
	}
	layoutInDegreeCentrality(true);
}




/**
*	Repositions all actors on a circular layout based on their 
*	Closeness Centralities. 
*	More central actors are closer to the centre
*/
void App::slotLayoutCircleCentralityCloseness(){
	if (!fileLoaded && !networkModified  )  {
		statusBar()->message(tr("You must load a file first... ") ,statusBarDuration);
		return;
	}
	QApplication::setOverrideCursor( QCursor(Qt::WaitCursor) );
	if (!calculatedCC || networkModified) {
		statusBar()->message(tr("Calculating distances and centralities... ") ,statusBarDuration);
		centralityCloseness();
	}
	
	statusBar()->message(tr("Finished centralities. Wait as I am moving actors to new positions. ") ,statusBarDuration);
	double x0=canvas->width()/2.0;
	double y0=canvas->height()/2.0;
	double radius=canvas->height()/2.0;          //pixels
	double rad;
	double i=0, std;
	float ACC;
	int index=-1;
	qHeapSort(discreteCCs);   //sorts CCs in ascending order
	slotClearBackgrCircles();
	for (vector<Actor*>::iterator it=aVector.begin(); it!=aVector.end(); it++) {
		ACC=(*it)->ACC();
		std= (*it)->SACC();
		radius=canvas->height()/2.0;          //max radius, reserved for lonely actors. 
		index=discreteCCs.findIndex(ACC);	
		qDebug ("Current actor %i with ACC = %f and stdCC=%f, ACC index %i",(*it)->actorNumber(), ACC, std, index+1);
		if (index!=-1) {
			radius=(classesCC-index)*radius/classesCC; 	
		}
		else 
			qDebug("ACC not existing in discreteCCs");
		BackgrCircle *circle=new BackgrCircle (canvas, (int) x0,(int) y0,(int) radius);
		circle->show();
		rad= (2.0* PI/ Actors);
		(*it)->setX(x0 + radius * cos(i * rad) );
		(*it)->setY(y0 + radius * sin(i * rad) );
		qDebug("Actor moves to x=%f and y=%f ",(*it)->x(), (*it)->y());
		i++;
	}
	statusBar()->message(tr("Actors in inner circles are more central. Ready. ") ,statusBarDuration);
	QApplication::restoreOverrideCursor();
}





/**
*	Repositions all actors on a circular layout based on their 
*	Betweeness Centralities. 
*	More central actors are closer to the centre
*/
void App::slotLayoutCircleCentralityBetweeness(){
	if (!fileLoaded && !networkModified  )  {
		statusBar()->message(tr("You must load a file first... ") ,statusBarDuration);
		return;
	}
	QApplication::setOverrideCursor( QCursor(Qt::WaitCursor) );
	if (!calculatedBC || networkModified){
		statusBar()->message(tr("Calculating distances and centralities... ") ,statusBarDuration);
		centralityBetweeness();
	}
	
	statusBar()->message(tr("Finished centralities. Wait as I am moving actors to new positions. ") ,statusBarDuration);
	double x0=canvas->width()/2.0;
	double y0=canvas->height()/2.0;
	double radius=canvas->height()/2.0;          //pixels
	double rad;
	double i=0, std;
	float ABC;
	int index=-1;
	qHeapSort(discreteBCs);   //sorts BCs in ascending order
	slotClearBackgrCircles();
	for (vector<Actor*>::iterator it=aVector.begin(); it!=aVector.end(); it++) {
		ABC=(*it)->ABC();
		std= (*it)->SABC();
		radius=canvas->height()/2.0;          //max radius, reserved for lonely actors. 
		index=discreteBCs.findIndex(ABC);	
		qDebug ("Current actor %i with ABC = %f and stdBC=%f, ABC index %i",(*it)->actorNumber(), ABC, std, index+1);
		if (index!=-1) {
			radius=(classesBC-index)*radius/classesBC; 	
		}
		else 
			qDebug("ABC not existing in discreteBCs");
		BackgrCircle *circle=new BackgrCircle (canvas, (int) x0,(int) y0,(int) radius);
		circle->show();
		rad= (2.0* PI/ Actors);
		(*it)->setX(x0 + radius * cos(i * rad) );
		(*it)->setY(y0 + radius * sin(i * rad) );
		qDebug("Actor moves to x=%f and y=%f ",(*it)->x(), (*it)->y());
		i++;
	}
	statusBar()->message(tr("Actors in inner circles are more central. Ready. ") ,statusBarDuration);
	QApplication::restoreOverrideCursor();
}




/**
*	Repositions all actors on a circular layout based on their 
*	Informational Centralities. 
*	More central actors are closer to the centre
*/
void App::slotLayoutCircleCentralityInformational(){
}





/**
*	Repositions all actors on a circular layout based on their 
*	Stress Centralities. 
*	More central actors are closer to the centre
*/
void App::slotLayoutCircleCentralityStress(){
	if (!fileLoaded && !networkModified  )  {
		statusBar()->message(tr("You must load a file first... ") ,statusBarDuration);
		return;
	}
	QApplication::setOverrideCursor( QCursor(Qt::WaitCursor) );
	if (!calculatedCC || networkModified) {
		statusBar()->message(tr("Calculating distances and centralities... ") ,statusBarDuration);
		centralityStress();
	}
	statusBar()->message(tr("Finished centralities. Wait as I am moving actors to new positions. ") ,statusBarDuration);
	

	double x0=canvas->width()/2.0;
	double y0=canvas->height()/2.0;
	double radius=canvas->height()/2.0;          //pixels
	double rad;
	double i=0, std;
	float ASC;
	int index=-1;
	qHeapSort(discreteSCs);   //sorts SCs in ascending order
	slotClearBackgrCircles();
	for (vector<Actor*>::iterator it=aVector.begin(); it!=aVector.end(); it++) {
		ASC=(*it)->ASC();
		std= (*it)->SASC();
		radius=canvas->height()/2.0;          //max radius, reserved for lonely actors. 
		index=discreteSCs.findIndex(ASC);	
		qDebug ("Current actor %i with ASC = %f and stdSC=%f, ASC index %i",(*it)->actorNumber(), ASC, std, index+1);
		if (index!=-1) {
			radius=(classesSC-index)*radius/classesSC; 	
		}
		else 
			qDebug("ASC not existing in discreteSCs");
		BackgrCircle *circle=new BackgrCircle (canvas, (int) x0,(int) y0,(int) radius);
		circle->show();
		rad= (2.0* PI/ Actors);
		(*it)->setX(x0 + radius * cos(i * rad) );
		(*it)->setY(y0 + radius * sin(i * rad) );
		qDebug("Actor moves to x=%f and y=%f ",(*it)->x(), (*it)->y());
		i++;
	}
	statusBar()->message(tr("Actors in inner circles are more central. Ready. ") ,statusBarDuration);
	QApplication::restoreOverrideCursor();
}




/**
*	Repositions all actors on a circular layout based on their 
*	Graph Centralities. 
*	More central actors are closer to the centre
*/
void App::slotLayoutCircleCentralityGraph(){
	if (!fileLoaded && !networkModified  )  {
		statusBar()->message(tr("You must load a file first... ") ,statusBarDuration);
		return;
	}
	QApplication::setOverrideCursor( QCursor(Qt::WaitCursor) );
	if (!calculatedCC || networkModified) {
		statusBar()->message(tr("Calculating distances and centralities... ") ,statusBarDuration);
		centralityGraph();
	}
	
	
	double x0=canvas->width()/2.0;
	double y0=canvas->height()/2.0;
	double radius=canvas->height()/2.0;          //pixels
	double rad;
	double i=0, std;
	float AGC;
	int index=-1;
	qHeapSort(discreteGCs);   //sorts GCs in ascending order
	slotClearBackgrCircles();
	for (vector<Actor*>::iterator it=aVector.begin(); it!=aVector.end(); it++) {
		AGC=(*it)->AGC();
		std= (*it)->SAGC();
		radius=canvas->height()/2.0;          //max radius, reserved for lonely actors. 
		index=discreteGCs.findIndex(AGC);	
		qDebug ("Current actor %i with AGC = %f and stdGC=%f, AGC index %i",(*it)->actorNumber(), AGC, std, index+1);
		if (index!=-1) {
			radius=(classesGC-index)*radius/classesGC; 	
		}
		else 
			qDebug("AGC not existing in discreteGCs");
		BackgrCircle *circle=new BackgrCircle (canvas, (int) x0,(int) y0,(int) radius);
		circle->show();
		rad= (2.0* PI/ Actors);
		(*it)->setX(x0 + radius * cos(i * rad) );
		(*it)->setY(y0 + radius * sin(i * rad) );
		qDebug("Actor moves to x=%f and y=%f ",(*it)->x(), (*it)->y());
		i++;
	}
	QApplication::restoreOverrideCursor();
}




/**
	TODO
*/
void App::slotLayoutLevelCentralityDegree(){

}



/**
	TODO
*/
void App::slotLayoutLevelCentralityCloseness(){
}



/**
	TODO
*/
void App::slotLayoutLevelCentralityBetweeness(){
}


/**
	TODO
*/
void App::slotLayoutLevelCentralityInformational(){
}


/**
	TODO
*/
void App::slotLayoutSpringEmbedder(){

	if (!fileLoaded && !networkModified  )  {
		statusBar()->message(tr("You must load a file first... ") ,statusBarDuration);
		return;
	}
	QApplication::setOverrideCursor( QCursor(Qt::WaitCursor) );
	statusBar()->message(tr("Calculating.... ") ,statusBarDuration);
	createSociomatrix() ;
	

	
 	vector<double> c(2);
	vector<vector<double> >   p(Actors,c), pp(Actors,c);	//vector of original coordinates
	
// 	vector<double> pp(Actors);		//vector of final coordinates
	
	
	int i=0;
	for (vector<Actor*>::iterator it=aVector.begin(); it!=aVector.end(); it++) {
		p[i][0]= (*it)->x();
		p[i][1]= (*it)->y();
		pp[i][0]=p[i][0];
		pp[i][1]=p[i][1];
		i++;

	}

	NetLayout *net=new NetLayout();
	net->springEmbedder(p, pp, 5, SM, canvas->width(), canvas->height());			//PARAMETERS: original coords, final coords, iterations
		
	

	i=0;
	for (vector<Actor*>::iterator it=aVector.begin(); it!=aVector.end(); it++) {
		qDebug ("NEW coords of i=%i will be: X=%f, Y=%f", i+1, p[i][0], p[i][1]);
		(*it)->setX( p[i][0] );
		(*it)->setY( p[i][1]);
		i++;
	}
	QApplication::restoreOverrideCursor();
	statusBar()->message(tr("Spring-Embedder Layout. Ready. ") ,statusBarDuration);
	

}




void App::slotLayoutFR(){

	if (!fileLoaded && !networkModified  )  {
		statusBar()->message(tr("You must load a file first... ") ,statusBarDuration);
		return;
	}
	QApplication::setOverrideCursor( QCursor(Qt::WaitCursor) );
	statusBar()->message(tr("Calculating.... ") ,statusBarDuration);
	createSociomatrix() ;

 	vector<double> c(2);
	vector<vector<double> >   p(Actors,c), pp(Actors,c);	//vector of original coordinates
	
// 	vector<double> pp(Actors);		//vector of final coordinates

	int i=0;
	for (vector<Actor*>::iterator it=aVector.begin(); it!=aVector.end(); it++) {
		p[i][0]= (*it)->x();
		p[i][1]= (*it)->y();
		pp[i][0]=p[i][0];
		pp[i][1]=p[i][1];
		i++;

	}

	NetLayout *net=new NetLayout();
	net->FR(p, pp, 5, SM, canvas->width(), canvas->height());	//PARAMETERS: original coords, final coords, iterations

	i=0;
	for (vector<Actor*>::iterator it=aVector.begin(); it!=aVector.end(); it++) {
		qDebug ("NEW coords of i=%i will be: X=%f, Y=%f", i+1, p[i][0], p[i][1]);
		(*it)->setX( p[i][0] );
		(*it)->setY( p[i][1]);
		i++;
	}
	QApplication::restoreOverrideCursor();
	statusBar()->message(tr("Fructhterman-Reingold Layout. Ready. ") ,statusBarDuration);
	

}




/**
*	Displayes the amount of active links on the canvas.
*/
void App::slotActiveLinks() {
	if (activeLinks()==-1 ) {
		statusBar()->message (QString(tr("ERROR IN LINKS COUNT.")), statusBarDuration) ;
		return;
	}
	else
		QMessageBox::information(this,"-SocNetV-","Active in and out Links: "+QString::number(totalLinks), "OK",0);
	statusBar()->message (QString(tr("Ready")), statusBarDuration) ;
}




/**
*	Returns the amount of active links on the canvas.
*/
int App::activeLinks(){
	totalLinks=0;
	QCanvasItemList list=canvas->allItems();
	for (QCanvasItemList::iterator it2=list.begin();it2!=list.end(); it2++)
		if ((*it2)->rtti()==Link_Rtti)
			totalLinks++;
	return totalLinks;
}





/**
*	Displays the amount of active actors on the canvas.
*/
void App::slotActiveActors(){
	if (activeActors()==-1 ) {
		statusBar()->message (QString(tr("ERROR IN ACTORS COUNT.")), statusBarDuration) ;
		return;
	}
	else
		QMessageBox::information(this,"-SocNetV-","Active Actors: "+QString::number(Actors), "OK",0);
	statusBar()->message (QString(tr("Ready")), statusBarDuration) ;

}




/**
*	Returns the amount of active actors on the canvas.
*/
int App::activeActors(){ 
	int actorsSum=0;
	QCanvasItemList list=canvas->allItems();
	for (QCanvasItemList::iterator it2=list.begin();it2!=list.end(); it2++)
		if ( (*it2)->rtti()==Actor_Rtti)
			actorsSum++;
	Actors=actorsSum;
	return Actors;	
}




/**
*	Calculates and displays the density of the network.
*/
void App::slotNetworkDensity() {
	if (!fileLoaded && !networkModified  )   {
		statusBar()->message( QString(tr("Load a network file first. Then you may ask me to compute something!")) , statusBarDuration);
		return;
	}
	double density=0;

	if ( activeLinks() ==-1 ){
		statusBar()->message (QString(tr("ERROR in Links count")), statusBarDuration) ;
		return;
	}
	if ( activeActors() ==-1 ){
		statusBar()->message (QString(tr("ERROR in actors count")), statusBarDuration) ;
		return;
	}
	density  =   (double)totalLinks/(double)(Actors*(Actors-1));
	QMessageBox::information(this, "-SocNetV-", tr("Density = ")+QString::number(density),"OK",0);
	statusBar()->message (QString(tr("Ready")), statusBarDuration) ;
}



/**
*	Counts and returns the in and out links of an actor.
*/
QPoint App::countActorLinks ( int i) {
	int inLinks=0, outLinks=0;
	QCanvasItemList list=canvas->allItems();
	for (QCanvasItemList::iterator it=list.begin(); it!=list.end(); it++)
		if ( (*it) -> rtti() == Link_Rtti ){
			Edge * link = (Edge*) (*it);
			if ( link->fromActor() ==  i)
				outLinks++;
			else if ( link->toActor() ==  i)
				inLinks++;
		}
	return QPoint (inLinks, outLinks);
}



/**
*	When the user clicks on an actor, displays some information about it on the status bar.
*/
void App::actorInfoStatusBar ( Actor *jim) {
	clickedJim=jim;
	QPoint links = countActorLinks (clickedJim->actorNumber());
	statusBar()->message( QString(tr("(%1, %2);  Actor %3, with label %4, "
		"has %5 in-Links and %6 out-Links.")).arg( ceil( clickedJim->x() ) )
		.arg( ceil( clickedJim->y() )).arg( clickedJim->actorNumber() ).arg( clickedJim->label() )
		.arg(links.x()).arg(links.y()), statusBarDuration);

}



/**
*	When the user clicks on a link, displays some information about it on the status bar.
*/
void App::linkInfoStatusBar (Edge* link) {
	if (bezier)
		statusBar()->message( QString(tr("Link from Actor %1 to Actor %2, has weight %3.")).arg( link->fromActor() ).arg(link->toActor()).arg(link->weight()), statusBarDuration);
	else
		statusBar()->message( QString(tr("Link between Actor %1 and Actor %2, has weight %3.")).arg( link->fromActor() ).arg(link->toActor()).arg(link->weight()), statusBarDuration);
}




/**
*	Displays a message	on the status bar when you resize the window.
*/
void App::windowInfoStatusBar(int w, int h){
	statusBar()->message( QString(tr("Window resized to (%1, %2) pixels.")).arg(w).arg(h), statusBarDuration);
}




/**
*	Calculates Out-Degree Centralities from the matrix of distances, 
*	the mean and the variance
*/
void App::centralityOutDegree(bool questions){
	qDebug ("centralityOutDegree()");
	if (!fileLoaded && !networkModified  )  {
		statusBar()->message( QString(tr("Load a network file first. Then you may ask me to compute something!")) , statusBarDuration);
		return;
	}
	float AODC=0, nom=0, denom=0;
	int index=0;

	discreteODCs.clear();
	classesODC=0;
// 	mapDC.clear();

	maxODC=0;
	minODC=Actors-1;
	sumODC=0;
	bool considerWeights=FALSE;
	if (questions)
	switch( QMessageBox::information( this, "-SocNetV-",
				      tr("Do you want me to take weights into account (DEFAULT: NO)?"),
				      tr("Yes"), tr("No"),
				      0, 1 ) )
	{
		case 0:
			considerWeights=TRUE;
			break;
		case 1:
			considerWeights=FALSE;
			break;
		default: // just for sanity
			considerWeights=FALSE;
			return;
		break;
	}
	else considerWeights=TRUE;
	for (register int i=0; i < Actors;i ++)  //INITIALIZE
		aVector[i]->setAODC (0);

	QCanvasItemList list=canvas->allItems();
	for (QCanvasItemList::iterator it=list.begin(); it!=list.end(); it++)
			if ( (*it)->rtti() ==   Link_Rtti ){
				Edge* link= (Edge*) (*it);
				index=(link->fromActor())-1;
				AODC= aVector[index]->AODC();
				if (considerWeights) {
					AODC+=link->weight();
					aVector[ index ]->setAODC (AODC);		//Set Actor Out-Degree
				}
				else {
					aVector[ index ]->setAODC (++AODC);	//Set Actor Out-Degree
				}
				qDebug("Now, actor %i has ODC = %f", index+1, aVector[ index ]->AODC () );
			}
	
	for (register int i=0; i < Actors; i++) {
		AODC=aVector[i]->AODC ();
		aVector[i]->setSAODC(AODC / (Actors-1.0) );		//Set Standard Actor Degree
		qDebug ( " actor %i, ODC = %f", i+1, AODC);
		sumODC+= AODC;
		if ( discreteODCs.contains(AODC)==0){
			classesODC++; 
			qDebug("This is a new ODC class");
			discreteODCs.append(AODC);
// 			mapDC[classesODC]=AODC;
		}
		qDebug("ODC classes = %i ", classesODC);
		if (maxODC < AODC ) {
			maxODC = AODC ;
			maxActorODC=aVector[i]->actorNumber();
		}
		if (minODC > AODC ) {
			minODC = AODC ;
			minActorODC=aVector[i]->actorNumber();
		}
	}

	if (minODC == maxODC)
		maxActorODC=-1;

	meanDegree = sumODC / (float) Actors;  //BUG? WEIGHTS????
	for (register int i=0; i < Actors;i ++) {   // calculate variance and the Degree Centralisation of the network.
		AODC= aVector[i]->AODC();
		varianceDegree+=(float)pow ( (double)(AODC-meanDegree),2 );	//BUG OCCORED IN SLACKWARE 
		nom+= maxODC-AODC;
	}
	if (symmetricSociomatrix)
		denom=(Actors-1.0)*(Actors-2.0);
	else
		denom=(Actors-1.0)*(Actors-1.0);
	varianceDegree=varianceDegree/(float) Actors;
	groupODC=nom/denom;

	minODC/=(float)(Actors-1); // standardize
	maxODC/=(float)(Actors-1);
	calculatedODC=TRUE;
}




/**
*	Calculates In-Degree Centralities from the matrix of distances, 
*	the mean and the variance
*/
void App::centralityInDegree(bool questions){
	qDebug ("centralityInDegree()");
	if (!fileLoaded && !networkModified  )  {
		statusBar()->message( QString(tr("Load a network file first. Then you may ask me to compute something!")) , statusBarDuration);
		return;
	}
	float AIDC=0, nom=0, denom=0;
	int index=0;

	discreteIDCs.clear();
	classesIDC=0;
// 	mapDC.clear();
	
	maxIDC=0;
	minIDC=Actors-1;
	sumIDC=0;
	bool considerWeights=FALSE;
	if (questions)
	switch( QMessageBox::information( this, "-SocNetV-",
				      tr("Do you want me to take weights into account (DEFAULT: NO)?"),
				      tr("Yes"), tr("No"),
				      0, 1 ) )
	{
		case 0:
			considerWeights=TRUE;
			break;
		case 1:
			considerWeights=FALSE;
			break;
		default: // just for sanity
			considerWeights=FALSE;
			return;
		break;
	}
	else considerWeights=TRUE;
	for (register int i=0; i < Actors;i ++)  //INITIALIZE
		aVector[i]->setAIDC (0);

	QCanvasItemList list=canvas->allItems();
	for (QCanvasItemList::iterator it=list.begin(); it!=list.end(); it++)
			if ( (*it)->rtti() ==   Link_Rtti ){
				Edge* link= (Edge*) (*it);
				index=(link->toActor())-1;
				AIDC= aVector[index]->AIDC();
				if (considerWeights) {
					AIDC+=link->weight();
					aVector[ index ]->setAIDC (AIDC);		//Set Actor In-Degree
				}
				else {
					aVector[ index ]->setAIDC (++AIDC);	//Set Actor In-Degree
				}
				qDebug("Now, actor %i has IDC = %f", index+1, aVector[ index ]->AIDC () );
			}
	
	for (register int i=0; i < Actors; i++) {
		AIDC=aVector[i]->AIDC ();
		aVector[i]->setSAIDC(AIDC / (Actors-1.0) );		//Set Standard Actor Degree
		qDebug ( " actor %i, IDC = %f", i, AIDC);
		sumIDC+= AIDC;
		if ( discreteIDCs.contains(AIDC)==0){
			classesIDC++; 
			qDebug("This is a new IDC class");
			discreteIDCs.append(AIDC);
// 			mapDC[classesDC]=ADC;
		}
		qDebug("IDC classes = %i ", classesIDC);
		if (maxIDC < AIDC ) {
			maxIDC = AIDC ;
			maxActorIDC=aVector[i]->actorNumber();
		}
		if (minIDC > AIDC ) {
			minIDC = AIDC ;
			minActorIDC=aVector[i]->actorNumber();
		}
	}

	if (minIDC == maxIDC)
		maxActorIDC=-1;

	meanDegree = sumIDC / (float) Actors;  //BUG? WEIGHTS????
	for (register int i=0; i < Actors;i ++) {   // calculate variance and the Degree Centralisation of the network.
		AIDC= aVector[i]->AIDC();
		varianceDegree+=(float)pow ( (double)(AIDC-meanDegree),2 );	//BUG OCCORED IN SLACKWARE 
		nom+= maxIDC-AIDC;
	}
	if (symmetricSociomatrix)
		denom=(Actors-1.0)*(Actors-2.0);
	else
		denom=(Actors-1.0)*(Actors-1.0);
	varianceDegree=varianceDegree/(float) Actors;
	groupIDC=nom/denom;

	minIDC/=(float)(Actors-1); // standardize
	maxIDC/=(float)(Actors-1);
	calculatedIDC=TRUE;
}





/**
*	Calculates Closeness Centralities from the matrix of distances
*	As of ver. 0.42 this is only meaningfull for connected networks.
*/
void App::centralityCloseness(){
	qDebug("centralityCloseness()");
	if (!fileLoaded && !networkModified  )  {
		statusBar()->message( QString(tr(" Load a network file first. Then you may ask me to compute something!")) , statusBarDuration);
		return;
	}
	if (!distanceMatrixCreated || networkModified)
		createDistanceMatrix();
	if (!distanceMatrixCreated) {
		statusBar()->message(tr("Sorry!"), statusBarDuration+2000);	
		return;
	}

	float CC=0, sum_distance=0, m_dist=0;
	float nom=0,  denom=0;

	discreteCCs.clear();
	classesCC=0;
// 	mapCC.clear();
	maxActorCC=0;
	minActorCC=0;
	maxCC=0;
	minCC=RAND_MAX;
	sumCC=0;
	float maximumIndexValue=1.0/(Actors-1.0);
	for (register int i=0; i < Actors;i ++) {
		sum_distance=0;
		for (register int j=0; j < Actors;j ++) {
			if (symmetricSociomatrix && j<i)     {
				if (i!=j && (m_dist=distance(j,i))!=-1) 
					sum_distance+= m_dist;
					
			}
			else if (i!=j && (m_dist=distance(i,j))!=-1)
				sum_distance+= m_dist;
			qDebug("distance(%i,%i) = %f,",i+1,j+1,m_dist);
		}
		qDebug("sum_distance(%i) = %f",i+1,sum_distance);
		if (sum_distance!=0)
			CC =  1.0/ sum_distance;            // Cc equals min_distance
		else 
			CC=0;
		qDebug("CC = %f", CC);
		if (CC > maximumIndexValue)    {
			qDebug( " Warning: CC > maximumIndexValue");
		}
		aVector[i]->setACC ( CC);				//Set actor closeness
		aVector[i]->setSACC ( CC * (Actors-1.0)  );		//Set standard actor closeness
		sumCC+=CC;
		qDebug ( "sumCC = %f", sumCC);
		if ( discreteCCs.contains(CC)==0){
			classesCC++; 
			qDebug("This is a new CC class");
			discreteCCs.append(CC);
// 			mapCC[classesCC]=CC;
		}
		qDebug("CC classes = %i ", classesCC);
		if (CC > maxCC ) {
			maxCC=CC;
			maxActorCC=aVector[i]->actorNumber();
		}
		if (CC < minCC ) {
			minCC=CC;
			minActorCC=aVector[i]->actorNumber();
		}
	}
	maxCC= (Actors-1.0)*maxCC;  //standardize
	minCC= (Actors-1.0)*minCC;  //standardize
	for (register int i=0 ; i < Actors ; i++) {
		
		nom += maxCC- aVector[i]->SACC();
	}
	denom=  ( ( Actors-2.0) *  (Actors-1.0))/ (2.0*Actors-3.0);
	groupCC= nom/denom;
	qDebug("A total of %i CC classes were found", classesGC);
	calculatedCC=TRUE;
}




/**
*	Calculates Betweeness Centralities from the matrix of distances
*/
void App::centralityBetweeness(){
	if (!fileLoaded && !networkModified  )  {
		statusBar()->message( QString(tr(" Load a network file first. Then you may ask me to compute something!")) , statusBarDuration);
		return;
	}
	if (!distanceMatrixCreated || networkModified)
		createDistanceMatrix();
	
	if (!distanceMatrixCreated) {
		statusBar()->message(tr("Sorry!"), statusBarDuration+2000);	
		return;
	}
	
	float nom=0, denom=0, delta=0, BC=0;
	float maxIndex=( Actors-1.0) *  (Actors-2.0) / 2.0;

	
	discreteBCs.clear();
	classesBC=0;
// 	mapBC.clear();

	sumBC=0;
	maxActorBC=0;
	minActorBC=0;
	maxBC=0;
	minBC=RAND_MAX;

	 //main loop -- finds betweeness centrality of each actor:
	// CB of u = Sum of delta (s,t,u), where delta (s,t,u) = sigma(s,t,u)/sigma(s,t), 
	// where sigma(s,t,u) is the number of geodesics from s to t through u.
	// Therefore delta(s,t,u) is the ratio of all geodesics between s and t which run through u.
	for (register int u=0; u < Actors;u ++) { 
		qDebug ("Actor u = %i ", u+1);
		BC=0;
		// calculate pair dependeancy delta(s,t, through u)
		for (register int s = 0 ; s < Actors; s++)  {   //catch an actor
			if ( s == (aVector[u]->actorNumber()-1)  ) { //current actor -- skip her
				qDebug ( " s = u . Skipping s");
				continue;
			}
			else
				for (register int t = 0 ; t < Actors; t++)  { //catch another one
					qDebug("Calculating delta(s,t,u)=delta(%i, %i, %i)=sigma(s,t,u)/sigma(s,t)", s+1,t+1, u+1);
					if ( t == (aVector[u]->actorNumber()-1) || t==s)  { //current actor/first actor
						qDebug ( " t = u  or t==s. Skipping t");
						continue;
					}
					delta=0;
					qDebug ("Bellman Criterion. Check if d (s,t) < d (s,u) + d(u,t) ");
					if ( distance(s,t) < ( distance(s, u) + distance(u, t) ) ) {
						qDebug( " d (s,t) < d (s,u) + d(u,t). Then, delta (s,t, u) = 0 "); 
						delta=0;
						qDebug(" Continuing...");
						continue;
					}
					else {
						qDebug (" d (s,t) >= d (s,u) + d(u,t). Then, sigma(s,t,u)=sigma(s,u)*sigma(u,t)");
						if (symmetricSociomatrix && s>u && u>t)
							delta= TM.item(u, s) * TM.item(t, u);
						else if (symmetricSociomatrix && s<=u && u>t)
 							delta= TM.item(s, u) * TM.item(t, u);
						else if (symmetricSociomatrix && s>u && u<=t)
							delta= TM.item(u, s) * TM.item(u, t);
						else
							delta= TM.item(s, u) * TM.item(u, t);
						qDebug ( "Calculated sigma(s,t, u) = %f", delta);
					}
					qDebug(" delta(s,t,u) = sigma(s,t,u)/sigma(s,t) = %f / %i ", delta,  TM.item(s,t) );
					if ( TM.item(s,t) == 0)  {
						qDebug ( "sigma(s,t)=(%i,%i) = %i  ZERO. ", t+1, s+1, TM.item(t,s));	
						if (symmetricSociomatrix && s>t && TM.item(t,s) !=0) {
							qDebug ("symmetric network, dividing with upper triangular sigma (t,s)=(%i,%i)= %i",t+1,s+1,TM.item(t,s));
							delta /= TM.item(t,s);   // now delta is pair dependancy
							qDebug ( " new delta = %f", delta);
						}
						else{
// 							delta /= TM.item(s,t);
							qDebug ( " Not dividing. Same delta = %f", delta);
						}
					}
					else if ( TM.item(s,t) !=0)  {
						qDebug("sigma(s,t)= %i not zero. Dividing. ", TM.item(s,t));
						if (symmetricSociomatrix && s>t) {
							qDebug ("symmetric network, dividing with upper triangular sigma (t,s)=(%i,%i)= %i",t+1,s+1,TM.item(t,s));
							delta /= TM.item(t,s);   // now delta is pair dependancy
						}
						else{
							qDebug ("not symmetric network or s < t , dividing with sigma(s,t) = %i", TM.item(s,t));
							delta /= TM.item(s,t);
						}
						qDebug ( " new delta = %f", delta);
					}	
					BC += delta;
					qDebug( "New BC = %f ", BC);
		        	}
		}
		sumBC+=BC;
		qDebug ("Actor %i has betweeness centrality = %f", u+1, BC);
		aVector[u]->setABC( BC );   //STORE ACTOR BETWEENESS
		aVector[u]->setSABC( (BC/maxIndex) );   //STORE STANDARD ACTOR BETWEENESS
		if ( discreteBCs.contains(BC)==0){
			classesBC++; 
			qDebug("This is a new BC class");
			discreteBCs.append(BC);
// 			mapBC[classesBC]=BC;
		}
		qDebug("BC classes = %i ", classesBC);
		if ( BC > maxBC ) {
			maxBC=BC;
			maxActorBC=aVector[u]->actorNumber();
		}
		if ( BC < minBC ) {
			minBC=BC;
			minActorBC=aVector[u]->actorNumber();
		}
	}
	for (register int u=0; u < Actors;u ++) 
		nom +=(maxBC - aVector[u]->ABC() );
	nom*=2.0;
	denom=   ( Actors-1.0) *  (Actors-1.0) * (Actors-2.0);
	groupBC=nom/denom;
	qDebug("A total of %i BC classes were found", classesBC);
	calculatedBC=TRUE;
}




/**
*	Calculates Informational Centralities from the matrix of distances
	TODO
*/
void App::centralityInformational(){
}




/**
*	Calculates Graph Centralities from the matrix of distances
*/
void App::centralityGraph(){
	qDebug("centralityGraph()");
	if (!fileLoaded && !networkModified  )  {
		statusBar()->message( QString(tr(" Load a network file first. Then you may ask me to compute something!")) , statusBarDuration);
		return;
	}
	if (!distanceMatrixCreated || networkModified)
		createDistanceMatrix();
	if (!distanceMatrixCreated) {
		statusBar()->message(tr("Sorry!"), statusBarDuration+2000);	
		return;
	}

	float GC=0, m_dist=0, max=0;
	float stdGC=0 , nom=0,  denom=0;


	
	discreteGCs.clear();
	classesGC=0;
// 	mapGC.clear();

	maxActorGC=0;
	minActorGC=0;
	maxGC=0;
	minGC=RAND_MAX;
	sumGC=0;
	float maximumIndexValue=1.0;   // ???? BUG 
	for (register int i=0; i < Actors;i ++) {
		max=0;
		for (register int j=0; j < Actors;j ++) {
			if (symmetricSociomatrix && j<i)     {
				if (i!=j && (m_dist=distance(j,i))!=-1)  {
					if (max < m_dist)  max=m_dist; 
				}
			}
			else if (i!=j && (m_dist=distance(i,j))!=-1) {
				if (max < m_dist)  max=m_dist; 
			}
			qDebug("distance(%i,%i) = %f,",i+1,j+1,m_dist);
		}
		qDebug("max_distance = %f",max);
		if (max!=0)
			GC =  1.0/ max;            // GC equals 1 / max_distance
		else 
			GC=0;
		qDebug("GC = %f", GC);
		if (GC > maximumIndexValue)    {
			qDebug( " Warning: GC > maximumIndexValue");
		}
		aVector[i]->setAGC( GC);
		sumGC+=GC;
		qDebug ( "sumGC = %f", sumGC);
		if ( discreteGCs.contains(GC)==0){
			classesGC++; 
			qDebug("This is a new GC class");
			discreteGCs.append(GC);
// 			mapGC[classesGC]=GC;
		}
		qDebug("GC classes = %i ", classesGC);
		if (GC > maxGC ) {
			maxGC=GC;
			maxActorGC=aVector[i]->actorNumber();
		}
		if (GC < minGC ) {
			minGC=GC;
			minActorGC=aVector[i]->actorNumber();
		}
	}
	maxGC= (Actors-1.0)*maxGC;  //standardize
	minGC= (Actors-1.0)*minGC;  //standardize
	for (register int i=0 ; i < Actors ; i++) {
		stdGC =(Actors-1.0)*GC ;
		aVector[i]->setSAGC(stdGC);
		nom += maxGC-stdGC;
	}
	denom=  ( ( Actors-2.0) *  (Actors-1.0))/ (2.0*Actors-3.0);
	groupGC= nom/denom;
	qDebug("A total of %i GC classes were found", classesGC);
	calculatedCC=TRUE;
}




/**
*	Calculates Stress Centralities from the matrix of distances
*/
void App::centralityStress(){
	if (!fileLoaded && !networkModified  )  {
		statusBar()->message( QString(tr(" Load a network file first. Then you may ask me to compute something!")) , statusBarDuration);
		return;
	}
	if (!distanceMatrixCreated || networkModified)
		createDistanceMatrix();
	
	if (!distanceMatrixCreated) {
		statusBar()->message(tr("Sorry!"), statusBarDuration+2000);	
		return;
	}
	
	float nom=0, denom=0,  sigma=0, SC=0;
	float maxIndex=( Actors-1.0) *  (Actors-2.0) / 2.0;        //??????????????????

	
	discreteSCs.clear();
	classesSC=0;
// 	mapSC.clear();

	sumSC=0;
	maxActorSC=0;
	minActorSC=0;
	maxSC=0;
	minSC=RAND_MAX;

	 //main loop -- calcs stress centrality of each actor:
	// SC of u = Sum of sigma (s,t,u),
	// where sigma(s,t,u) is the number of geodesics from s to t through u.
	// Therefore SC is the sum of all geodesics between s and t which run through u.
	for (register int u=0; u < Actors;u ++) { 
		qDebug ("Actor u = %i ", u+1);
		SC=0;
		// calculate sigma(s,t,u)
		for (register int s = 0 ; s < Actors; s++)  {   //catch an actor
			
			if ( s == (aVector[u]->actorNumber()-1)  ) { //current actor -- skip her
				qDebug ( " s = u . Skipping s");
				continue;
			}
			else
				for (register int t = 0 ; t < Actors; t++)  { //catch another one
					sigma=0;
					qDebug("Calculating sigma(s,t,u)=sigma(%i, %i, %i)", s+1,t+1, u+1);
					if ( t == (aVector[u]->actorNumber()-1) || t==s)  { //current actor/first actor
						qDebug ( " t = u  or t==s. Skipping t");
						continue;
					}
					qDebug ("Bellman Criterion. Check if d (s,t) < d (s,u) + d(u,t) ");
					if ( distance(s,t) < ( distance(s, u) + distance(u, t) ) ) {
						qDebug( " d (s,t) < d (s,u) + d(u,t). Therefore, sigma (s,t, u) = 0 "); 
// 						sigma=0;
						qDebug(" Continuing...");
						continue;
					}
					else {
						qDebug (" d (s,t) >= d (s,u) + d(u,t). Then, sigma(s,t,u)=sigma(s,u)*sigma(u,t)");
						if (symmetricSociomatrix && s>u && u>t)
							sigma= TM.item(u, s) * TM.item(t, u);
						else if (symmetricSociomatrix && s<=u && u>t)
 							sigma= TM.item(s, u) * TM.item(t, u);
						else if (symmetricSociomatrix && s>u && u<=t)
							sigma= TM.item(u, s) * TM.item(u, t);
						else
							sigma= TM.item(s, u) * TM.item(u, t);
						qDebug ( "Calculated sigma(s,t, u) = %f", sigma);
					}

					
					SC += sigma;
					qDebug( "New SC = %f ", SC);
		        	}
		}
		sumSC+=SC;
		qDebug ("Actor %i has stress centrality = %f", u+1, SC);
		aVector[u]->setASC ( SC );   //STORE ACTOR CENTRALITY
		aVector[u]->setSASC ( SC/maxIndex );
		if ( discreteSCs.contains(SC)==0){
			classesSC++; 
			qDebug("This is a new SC class");
			discreteSCs.append(SC);
// 			mapSC[classesSC]=SC;
		}
		qDebug("SC classes = %i ", classesSC);
		if ( SC > maxSC ) {
			maxSC=SC;
			maxActorSC=aVector[u]->actorNumber();
		}
		if ( SC < minSC ) {
			minSC=SC;
			minActorSC=aVector[u]->actorNumber();
		}
	}
 	/**We are using non standardized bc's here, see Wasserman & Faust, pp. 191-192 */
	for (register int u=0; u < Actors;u ++) 
		nom +=(maxSC - aVector[u]->ASC() );
	nom*=2.0;
	denom=   ( Actors-1.0) *  (Actors-1.0) * (Actors-2.0);
	groupSC=nom/denom;
	
	qDebug("A total of %i SC classes were found", classesSC);
	calculatedSC=TRUE;
}



/**
*	Writes Out-Degree Centralities into a file, then displays it.
*/
void App::slotCentralityOutDegree(){
	if (!fileLoaded && !networkModified  )  {
		statusBar()->message( QString(tr(" Load a network file first. Then you may ask me to compute something!")) , statusBarDuration);
		return;
	}
	if (!calculatedODC || networkModified)
		centralityOutDegree(TRUE);
	QString fn = "c_out-Degree.dat";
	int  aIndex;
	float ODC=0, stdODC=0, maximumIndexValue=Actors-1.0;
	QFile f( fn );
	if ( !f.open( IO_WriteOnly ) )
		return;
	QTextStream ts(&f  );
	ts <<"-SocNetV- "<<VERSION<<"\n\n";
	ts <<tr("OUT-DEGREE - CENTRALITY REPORT \n");
	ts <<tr("Created: ")<< actualDateTime.currentDateTime().toString ( QString ("ddd, dd.MMM.yyyy hh:mm:ss")) << "\n\n";
	ts<< tr("ACTOR OUT-DEGREE CENTRALITY (AODC)\n");
	ts<< tr("AODC  range: 0 < C < ")<<QString::number(maximumIndexValue)<<"\n";
	ts<< tr("AODC' range: 0 < C'< 1")<<"\n\n";
	ts << "Actor"<<"\tAODC\t\tAODC'(std.)\t\tAODC\n";
	for (vector<Actor*>::iterator act=aVector.begin(); act!=aVector.end(); act++) {
		ODC=(*act)->AODC();
		stdODC =ODC/(float)(Actors-1);
		aIndex=(*act)->actorNumber();
		ts<<QString("%1\t%2\t%3\t%4 \n").arg (aIndex,-10).arg(ODC,-15).arg( stdODC,-15).arg(100*ODC/sumODC,-20);
	}
	if (symmetricSociomatrix) {
		ts << tr("Mean Nodal Degree = ")<< meanDegree<<"\n" ;
		ts << tr("Degree Variance = ")<< varianceDegree<<"\n\n";
	}
	else{
		ts <<tr( "Mean Nodal Out-Degree = ")<< meanDegree<<"\n" ;
		ts << tr("Out-Degree Variance = ")<< varianceDegree<<"\n\n";
	}
	if ( minODC == maxODC )
		ts << tr("\nAll actors have the same AODC value.\n");
	else  {
		ts << tr("\nActor ")<< maxActorODC << tr(" has the maximum AODC value (std): ") <<QString::number( maxODC ) <<"  \n";
		ts << tr("\nActor ")<< minActorODC << tr(" has the minimum AODC value (std): ") <<QString::number( minODC ) <<"  \n";
	}
	ts << tr("\nThere are ")<<QString::number(classesODC)<<tr(" different Out-Degree Centrality classes.\n");	
	ts<<tr("\nGROUP OUT-DEGREE CENTRALISATION (GODC)\n\n");
	ts<< tr("GODC = ") << groupODC<<"\n\n";
	ts<<tr("GODC range: 0 < GODC < 1\n");
	ts<<tr("GODC = 0, when all degrees equal (i.e. regular lattice).\n");
	ts<<tr("GODC = 1, when one actor completely dominates or overshadows the other actors.\n");
	ts<<"(Wasserman & Faust, formula 5.5, p. 177)\n\n";
	ts<<tr("The degree of the node is a measure of the \'activity\' of the actor it represents\n");
	ts<<"(Wasserman & Faust, p. 101)\n";
	f.close();
	TextEditor *ed = new TextEditor(fn);        //OPEN A TEXT EDITOR WINDOW
	tempFileNameNoPath=QStringList::split( "/", fn);
	ed->setCaption("-SocNetV- Out-Degree - " + tempFileNameNoPath.last());
	ed->show();
}




/**
*	Writes In-Degree Centralities into a file, then displays it.
*/
void App::slotCentralityInDegree(){
	if (!fileLoaded && !networkModified  )  {
		statusBar()->message( QString(tr(" Load a network file first. Then you may ask me to compute something!")) , statusBarDuration);
		return;
	}
	if (!calculatedIDC || networkModified)
		centralityInDegree(TRUE);
	QString fn = "c_in-Degree.dat";

	float IDC=0, stdIDC=0;
	int  aIndex;
	float maximumIndexValue=Actors-1.0;
	
	QFile f( fn );
	if ( !f.open( IO_WriteOnly ) )
		return;
	QTextStream ts(&f  );
	ts <<"-SocNetV- "<<VERSION<<"\n\n";
	ts <<tr("IN-DEGREE - CENTRALITY REPORT \n");
	ts <<tr("Created: ")<< actualDateTime.currentDateTime().toString ( QString ("ddd, dd.MMM.yyyy hh:mm:ss")) << "\n\n";
	ts<< tr("ACTOR IN-DEGREE CENTRALITY (AIDC)\n");
	ts<< tr("AIDC  range: 0 < C < ")<<QString::number(maximumIndexValue)<<"\n";
	ts<< tr("AIDC' range: 0 < C'< 1")<<"\n\n";

	ts << "Actor"<<"\tAIDC\t\tAIDC'(std.)\t\tAIDC\n";
	for (vector<Actor*>::iterator act=aVector.begin(); act!=aVector.end(); act++) {
		IDC=(*act)->AIDC();
		stdIDC =IDC/(float)(Actors-1);
		aIndex=(*act)->actorNumber();
		ts<<QString("%1\t%2\t%3\t%4 \n").arg (aIndex,-10).arg(IDC,-15).arg( stdIDC,-15).arg(100*IDC/sumIDC,-20);
	}
	if (symmetricSociomatrix) {
		ts << tr("Mean Nodal Degree = ")<< meanDegree<<"\n" ;
		ts << tr("Degree Variance = ")<< varianceDegree<<"\n\n";
	}
	else{
		ts <<tr( "Mean Nodal InDegree = ")<< meanDegree<<"\n" ;
		ts << tr("InDegree Variance = ")<< varianceDegree<<"\n\n";
	}
	if ( minIDC == maxIDC )
		ts << tr("\nAll actors have the same AIDC value.\n");
	else  {
		ts << tr("\nActor ")<< maxActorIDC << tr(" has the maximum AIDC value (std): ") <<QString::number( maxIDC ) <<"  \n";
		ts << tr("\nActor ")<< minActorIDC << tr(" has the minimum AIDC value (std): ") <<QString::number( minIDC ) <<"  \n";
	}
	ts << tr("\nThere are ")<<QString::number(classesIDC)<<tr(" different In-Degree Centrality classes.\n");	
	ts<<tr("\nGROUP IN-DEGREE CENTRALISATION (GIDC)\n\n");
	ts<< tr("GIDC = ") << groupIDC<<"\n\n";
	ts<<tr("GIDC range: 0 < GIDC < 1\n");
	ts<<tr("GIDC = 0, when all in-degrees are equal (i.e. regular lattice).\n");
	ts<<tr("GIDC = 1, when one actor is linked from every other actor.\n");
	ts<<tr("The in-degree of the node is a measure of the \'activity\' of the actor it represents\n");
	ts<<"(Wasserman & Faust, p. 101)\n";
	f.close();
	TextEditor *ed = new TextEditor(fn);        //OPEN A TEXT EDITOR WINDOW
	tempFileNameNoPath=QStringList::split( "/", fn);
	ed->setCaption("-SocNetV- In-Degree - " + tempFileNameNoPath.last());
	ed->show();
}




/**
*	Writes Closeness Centralities into a file, then displays it.
*/
void App::slotCentralityCloseness(){
	if (!fileLoaded && !networkModified  )  {
		statusBar()->message( QString(tr(" Load a network file first. Then you may ask me to compute something!")) , statusBarDuration);
		return;
	}
	if (!distanceMatrixCreated || networkModified)
		createDistanceMatrix();
	if (!distanceMatrixCreated) {
		statusBar()->message(tr("Sorry!"), statusBarDuration+2000);	
		return;
	}
	if (!calculatedCC || networkModified)
		centralityCloseness();

	float maximumIndexValue=1.0/(Actors-1.0);
	QString fn = "c_closeness.dat";

	QFile f( fn );
	if ( !f.open( IO_WriteOnly ) )
		return;
	QTextStream ts(&f  );
	ts <<"-SocNetV- "<<VERSION<<"\n\n";
	ts <<tr("CLOSENESS - CENTRALITY REPORT \n");
	ts <<tr("Created: ")<< actualDateTime.currentDateTime().toString ( QString ("ddd, dd.MMM.yyyy hh:mm:ss")) << "\n\n";
	ts<< tr("ACTOR CLOSENESS CENTRALITY (ACC)")<<"\n";
	ts<< tr("ACC(u) is the invert sum of the distances of actor u from all other actors.")<<"\n";
	ts<< tr("ACC' is the standardized ACC")<<"\n";
	
	ts<< tr("ACC  range:  0 < C < ")<<QString::number(maximumIndexValue)<<"\n";
	ts<< tr("ACC' range:  0 < C'< 1")<<"\n\n";
	ts << "Actor\tACC\t\tACC'\t\t100*ACC/sumCC\n";
	for (vector<Actor*>::iterator act=aVector.begin(); act!=aVector.end(); act++) {
		
		ts<<QString("%1\t%2\t%3\t%4 \n").arg ((*act)->actorNumber(),-10).arg((*act)->ACC(),-15).arg((*act)->SACC(),-20).arg(100*((*act)->ACC())/sumCC,-20);
	}
	qDebug ("min %f, max %f", minCC, maxCC);
	if ( minCC == maxCC )
		ts << tr("\nAll actors have the same ACC value.\n");
	else  {
		ts << tr("\nActor ")<< maxActorCC << tr(" has the maximum ACC value (std): ") <<QString::number( maxCC ) <<"  \n";
		ts << tr("\nActor ")<< minActorCC << tr(" has the minimum ACC value (std): ") <<QString::number( minCC ) <<"  \n";
	}
	
	ts << tr("\nThere are ")<<QString::number(classesCC)<<tr(" different Closeness Centrality classes.\n");	
	ts<<tr("\nGROUP CLOSENESS CENTRALISATION (GCC)\n\n");
	ts<< tr("GCC = ") << groupCC<<"\n\n";
	ts<<tr("GCC range: 0 < GCC < 1\n");
	ts<<tr("GCC = 0, when the lengths of the geodesics are all equal (i.e. a complete or a circle graph).\n");
	ts<<tr("GCC = 1, when one actor has geodesics of length 1 to all the other actors, and the other actors have geodesics of length 2 to the remaining (N-2) actors. This is exactly the situation realised by a star graph.\n");
	ts<<"(Wasserman & Faust, formula 5.9, p. 187)\n\n";
	ts<<tr("This measure focuses on how close an actor is to all\n");
	ts<<tr("the other actors in the set of actors. The idea is that an actor\n");
	ts<<tr("is central if it can quickly interact with all others\n");
	ts<<"(Wasserman & Faust, p. 181)\n";
	f.close();
	TextEditor *ed = new TextEditor(fn);        //OPEN A TEXT EDITOR WINDOW
	tempFileNameNoPath=QStringList::split( "/", fn);
	ed->setCaption("-SocNetV- Closeness - " + tempFileNameNoPath.last());
	ed->show();
}




/**
*	Writes Betweeness Centralities into a file, then displays it.
*/
void App::slotCentralityBetweeness(){
	if (!fileLoaded && !networkModified  )  {
		statusBar()->message( QString(tr(" Load a network file first. Then you may ask me to compute something!")) , statusBarDuration);
		return;
	}
	if (!calculatedBC || networkModified )
 		centralityBetweeness();
	
	float maximumIndexValue=(Actors-1.0)*(Actors-2.0)/2.0;
	QString fn = "c_betweeness.dat";
	QFile f( fn );
	if ( !f.open( IO_WriteOnly ) )
		return;
	QTextStream ts(&f  );
	
	ts <<"-SocNetV- "<<VERSION<<"\n\n";
	ts <<tr("BETWEENESS - CENTRALITY REPORT \n");
	ts <<tr("Created: ")<< actualDateTime.currentDateTime().toString ( QString ("ddd, dd.MMM.yyyy hh:mm:ss")) << "\n\n";
	ts<< tr("ACTOR BETWEENESS CENTRALITY (ABC)")<<"\n";
	ts<< tr("ABC(u) is the sum of delta (s,t,u).")<<"\n"; 
	ts<< tr(" where sigma(s,t,u) is the number of geodesics from s to t through u.")<<"\n";
	ts<< tr("Therefore, delta(s,t,u) is the ratio of all geodesics between s and t which run through u.")<<"\n";
	ts<< tr("ABC(u) reflects how often the actor u lies on the geodesics between the other actors of the network")<<"\n";
	ts<< tr("ABC' is the standardized ABC")<<"\n";
	ts<< tr("ABC  range: 0 < ABC < ")<<QString::number(maximumIndexValue)<< tr(" (Number of pairs of actors excluding i)")<<"\n";
	ts<< tr("ABC' range: 0 < ABC'< 1  (C' is 1 when the actor falls on all geodesics)\n\n");

	ts << tr("Actor\tABC\t\tABC'\t\t100*ABC/sumABC\n");
	for (vector<Actor*>::iterator act=aVector.begin(); act!=aVector.end(); act++) {
		if (sumBC!=0)
			ts<<QString("%1\t%2\t%3\t%4 \n").arg ((*act)->actorNumber(),-10).arg((*act)->ABC(),-15).arg( (*act)->SABC() ,-15).arg(100* ((*act)->ABC())/sumBC,-20);
		else 
			ts<<QString("%1\t%2\t%3\t%4 \n").arg ((*act)->actorNumber(),-10).arg((*act)->ABC(),-15).arg( (*act)->SABC() ,-15).arg(100*(*act)->ABC(),-20);
 	}
	if (minBC == maxBC)
		ts << tr("\nAll actors have the same ABC value.\n");
	else {
		ts<<tr("\n Actor ")<<QString::number(maxActorBC)<< tr(" has the maximum ABC value: ") <<QString::number( maxBC ) <<"  \n";
		ts<<tr("\n Actor ")<<QString::number(minActorBC)<< tr(" has the minimum ABC value: ") <<QString::number( minBC ) <<"  \n";
	}

	ts << tr("\nThere are ")<<QString::number(classesBC)<<tr(" different Betweeness Centrality classes.\n");	
	ts<<tr("\nGROUP BETWEENESS CENTRALISATION (GBC)\n\n");
	ts<< tr("GBC = ") << groupBC<<"\n\n";
	ts<<tr("GBC range: 0 < GBC < 1\n");
	ts<<tr("GBC = 0, when all the actors have exactly the same betweeness index.\n");
	ts<<tr("GBC = 1, when one actor falls on all other geodesics between all the remaining (N-1) actors. This is exactly the situation realised by a star graph.\n");
	ts<<"(Wasserman & Faust, formula 5.13, p. 192)\n\n";
	f.close();
	TextEditor *ed = new TextEditor(fn);        //OPEN A TEXT EDITOR WINDOW
	tempFileNameNoPath=QStringList::split( "/", fn);
	ed->setCaption("-SocNetV- Betweeness - " + tempFileNameNoPath.last());
	ed->show();
}




/**
*	Writes Informational Centralities into a file, then displays it.	
	TODO
*/
void App::slotCentralityInformational(){
}




/**
*	Writes Stress Centralities into a file, then displays it.
*/
void App::slotCentralityStress(){
	if (!fileLoaded && !networkModified  )  {
		statusBar()->message( QString(tr(" Load a network file first. Then you may ask me to compute something!")) , statusBarDuration);
		return;
	}
	if (!calculatedSC || networkModified )
   		centralityStress();
	
	float maximumIndexValue=(Actors-1.0)*(Actors-2.0)/2.0;   //When u lies on all geodesics
	
	QString fn = "c_stress.dat";
	QFile f( fn );
	if ( !f.open( IO_WriteOnly ) )
		return;
	QTextStream ts(&f  );
	ts <<"-SocNetV- "<<VERSION<<"\n\n";
	ts <<tr("STRESS CENTRALITY REPORT \n");
	ts <<tr("Created: ")<< actualDateTime.currentDateTime().toString ( QString ("ddd, dd.MMM.yyyy hh:mm:ss")) << "\n\n";

	ts<< tr("ACTOR STRESS CENTRALITY (ASC)")<<"\n";
	ts<< tr("ASC (u) is the sum of sigma (s,t,u).")<<"\n"; 
	ts<< tr(" where sigma(s,t,u) is the number of geodesics from s to t through u.")<<"\n";
	ts<< tr("ASC reflects the total number of geodesics between all other actors which run through u")<<"\n";

	ts<< tr("ASC  range: 0 < ASC < ")<<QString::number(maximumIndexValue)<<"\n";
	ts<< tr("ASC' range: 0 < ASC'< 1  (ASC'=1 when the actor falls on all geodesics)\n\n");

	ts << tr("Actor\tASC\t\tASC'\t\t100*ASC/sumASC\n");
	for (vector<Actor*>::iterator act=aVector.begin(); act!=aVector.end(); act++) {
		if (sumSC!=0)
			ts<<QString("%1\t%2\t%3\t%4 \n").arg ((*act)->actorNumber(),-10).arg((*act)->ASC(),-15).arg( (*act)->SASC(),-15).arg(100*(*act)->ASC()/sumSC,-20);
		else
			ts<<QString("%1\t%2\t%3\t%4 \n").arg ((*act)->actorNumber(),-10).arg((*act)->ASC(),-15).arg( (*act)->SASC(),-15).arg(100*(*act)->ASC(),-20);
 	}
	if (minSC == maxSC)
		ts << tr("\nAll actors have the same ASC value.\n");
	else {
		ts<<tr("\n Actor ")<<QString::number(maxActorSC)<< tr(" has the maximum ASC value: ") <<QString::number( maxSC ) <<"  \n";
		ts<<tr("\n Actor ")<<QString::number(minActorSC)<< tr(" has the minimum ASC value: ") <<QString::number( minSC ) <<"  \n";
	}

	ts << tr("\nThere are ")<<QString::number(classesSC)<<tr(" different Stress Centrality classes.\n");	

	ts<<tr("GROUP STRESS CENTRALISATION (GSC)")<<"\n";
	ts<< tr("GSC = ") << groupSC<<"\n\n";
	
	ts<<tr("GSC range: 0 < GSC < 1\n");
	ts<<tr("GSC = 0, when all the actors have exactly the same stress index.\n");
	ts<<tr("GSC = 1, when one actor falls on all other geodesics between all the remaining (N-1) actors. This is exactly the situation realised by a star graph.\n");
	f.close();
	TextEditor *ed = new TextEditor(fn);        //OPEN A TEXT EDITOR WINDOW
	tempFileNameNoPath=QStringList::split( "/", fn);
	ed->setCaption("-SocNetV- Stress - " + tempFileNameNoPath.last());
	ed->show();
}



/**
*	Writes Graph Centralities into a file, then displays it.
*/
void App::slotCentralityGraph(){
	if (!fileLoaded && !networkModified  )  {
		statusBar()->message( QString(tr(" Load a network file first. Then you may ask me to compute something!")) , statusBarDuration);
		return;
	}
 
	if (!calculatedGC || networkModified )
   		centralityGraph();
	
	float maximumIndexValue=1;
	float  GC=0;
	QString fn = "c_graph.dat";
	QFile f( fn );
	if ( !f.open( IO_WriteOnly ) )
		return;
	QTextStream ts(&f  );

	ts<<"-SocNetV- "<< VERSION<<"\n\n";
	ts<<tr("GRAPH - CENTRALITY REPORT \n" );
	ts<<tr("Created: ")<< actualDateTime.currentDateTime().toString ( QString ("ddd, dd.MMM.yyyy hh:mm:ss"))<<"\n\n"  ;
	ts<<tr("ACTOR GRAPH CENTRALITY (AGC)")<<"\n";
	ts<<tr("AGC  range: 0 < AGC < %1  (AGC=1 => distance from other actors is max 1)")<<maximumIndexValue<<"\n";
	ts<<tr("AGC' range: 0 < AGC'< 1  (AGC'=1 => directly linked with all actors)")<<"\n\n";

	ts<<QString("Actor\tAGC\t\tAGC'\t\t100*AGC/sumAGC\n");
	for (vector<Actor*>::iterator act=aVector.begin(); act!=aVector.end(); act++) {
		GC= (*act)->AGC();
		ts<<QString("%1\t%2\t%3\t%4 \n").arg ((*act)->actorNumber(),-10).arg(GC,-15).arg( GC/maximumIndexValue,-15).arg(100*GC/sumGC,-20);
 	}
	if (minGC == maxGC)
		ts << tr("\nAll actors have the same AGC value.\n");
	else {
		ts<<tr("\n Actor ")<<QString::number(maxActorGC)<< tr(" has the maximum AGC value: ") <<QString::number( maxGC ) <<"  \n";
		ts<<tr("\n Actor ")<<QString::number(minActorGC)<< tr(" has the minimum AGC value: ") <<QString::number( minGC ) <<"  \n";
	}

	ts << tr("\nThere are ")<<QString::number(classesGC)<<tr(" different Graph Centrality classes.\n");	

	ts<<tr("\nGROUP GRAPH CENTRALISATION (GGC)\n\n");

	ts<< tr("GGC = ") << groupGC<<"\n\n";

	ts<<tr("GGC range: 0 < GGC < 1\n");
	ts<<tr("GGC = 0, when all the actors have exactly the same graph index.\n");
	ts<<tr("GGC = 1, when one actor falls on all other geodesics between all the remaining (N-1) actors. This is exactly the situation realised by a star graph.\n");
	ts<<"(Wasserman & Faust, formula 5.13, p. 192)\n\n";

	f.close();

	TextEditor *ed = new TextEditor(fn);        //OPEN A TEXT EDITOR WINDOW
	tempFileNameNoPath=QStringList::split( "/", fn);
	ed->setCaption("-SocNetV- Graph - " + tempFileNameNoPath.last());
	ed->show();
}




/**
*  Displays the distance between two user-specified actors
*/
void App::slotDistance(){
	if (!fileLoaded && !networkModified  )  {
		statusBar()->message( QString(tr(" Load a network file first. Then you may ask me to compute something!")) , statusBarDuration);
		return;
	}
	bool ok=FALSE;
	int  min=1, max=1, i=-1, j=-1;
	QCanvasItemList list=canvas->allItems();
	for (QCanvasItemList::iterator it=list.begin(); it!=list.end(); it++)
		if ( (*it) -> rtti() == Actor_Rtti ){
			Actor *jim = (Actor*) (*it);
			if (min>jim->actorNumber() ) min=jim->actorNumber();
			if (max<jim->actorNumber() ) max=jim->actorNumber();
		}
	i=QInputDialog::getInteger("Distance between two actors",tr("Select source actor:  ("+QString::number(min)+"..."+QString::number(max)+"):"), min, 1, max , 1, &ok, this )   ;
	j=QInputDialog::getInteger("Distance between two actors", tr("Select target actor:  ("+QString::number(min)+"..."+QString::number(max)+"):"),min, 1, max , 1, &ok, this )   ;
	qDebug("source %i target %i",i, j);
	if (!distanceMatrixCreated || networkModified ||networkModified)
		createDistanceMatrix();
	if (!distanceMatrixCreated) {
		statusBar()->message(tr("Sorry!"), statusBarDuration+2000);	
		return;
	}

	if (symmetricSociomatrix && i>j) {
		qSwap(i,j);
	}
	QMessageBox::information(this, "-SocNetV-", tr("Distance (")+QString::number(i)+", "+QString::number(j)+") ="+QString::number(distance(i-1,j-1)),"OK",0);
}




/**
*  Invokes creation of the matrix of actors' distances, then displays it.
*/
void App::slotDistanceMatrix(){
	if (!fileLoaded && !networkModified  )  {
		statusBar()->message( QString(tr(" Load a network file first. Then you may ask me to compute something!")) , statusBarDuration);
		return;
	}
	qDebug("slotDistanceMatrix()");
	if ( networkModified || networkModified || !distanceMatrixCreated)  { 
		qDebug("New network or network changed. Creating distance matrix...");
		statusBar()->message(tr("Creating distance matrix. Please wait a while, I am not that fast..."), statusBarDuration+2000);	
		createDistanceMatrix();
		if (!distanceMatrixCreated) {
			statusBar()->message(tr("Sorry!"), statusBarDuration+2000);	
		return;
		}
	}
	
	TDM.setNumRows(0);
	TDM.setNumCols(0);
	
	TDM.insertRows(TDM.numRows(),Actors);
 	TDM.insertColumns(TDM.numCols(),Actors);
	
	if (showProgressBar) {
		actionProgress = new QProgressDialog  ( tr("Writing..."), tr("Abort"), Actors, this, "progress", TRUE );
		actionProgress->setMinimumDuration(minDuration);
	}
	for (register int i=0;i<Actors;i++) {
		TDM.setRowHeight(i,20);
		TDM.setColumnWidth(i,20);
        	for (register int j=0;j<Actors;j++) 
		        TDM.setItem(i, j, new QTableItem(&TDM , QTableItem::WhenCurrent, QString::number( DM.item(i, j)  )) ) ;
			if (showProgressBar) {
				actionProgress->setProgress (  i ) ;
				qApp->processEvents();
			}
	}
	if (showProgressBar) {
		actionProgress->setProgress (  Actors ) ;
		delete actionProgress;
	}
 	TDM.setCaption( tr( "matrix of distances" ) );
 	TDM.show();

	TPM.setNumRows(0);
	TPM.setNumCols(0);
	
	TPM.insertRows(TPM.numRows(),Actors);
	TPM.insertColumns(TPM.numCols(),Actors);
	
	for (register int i=0;i<Actors;i++) {
		TPM.setRowHeight(i,20);
		TPM.setColumnWidth(i,20);
        	for (register int j=0;j<Actors;j++) 
		        TPM.setItem(i, j, new QTableItem(&TPM , QTableItem::WhenCurrent, QString::number( TM.item(i, j)  )) ) ;
	}
	/**show table */
	TPM.setCaption( tr( "matrix of sigmas" ) );
	TPM.show();
	statusBar()->message(tr("Distance matrix created."), statusBarDuration+2000);
}


/**
*  Returns the distance between actors numbered (i-1) and (j-1)
*/
int App::distance(int i, int j){
  	return DM.item(i,j);
}



/**
*  Creates a matrix of distances between the actors 
*/
void App::createDistanceMatrix() {
	QApplication::setOverrideCursor( QCursor(Qt::WaitCursor) );
	qDebug ("createDistanceMatrix()");
	if ( networkModified || !sociomatrixCreated)  { 
		qDebug("Network Mofified. Creating sociomatrix for distances calculation");
		createSociomatrix();
		qDebug( "Sociomatrix created");
	}
		
	DM.resize(Actors); //DM(i,j) is the geodesic distance between actors i and j
	TM.resize(Actors); //TM(i,j) is the number of minimum paths between actors i and j
	netDiameter=0;
	if (activeLinks() == 0 ) 
		DM.fillMatrix(0);	
	else
		DM.distanceMatrixDijkstra(SM, TM, netDiameter, symmetricSociomatrix);
// 	DM.distanceMatrixBF(SM, TM, symmetricSociomatrix);  //SM SOCIMATRIX, TM CARRIES SIGMA's

	statusBar()->message(tr("Distance matrix and network diameter were calculated."), statusBarDuration);
	distanceMatrixCreated=TRUE;
	
	QApplication::restoreOverrideCursor();
}




/**
*  Displays the network diameter (largest geodesic)
*/
void App::slotDiameter() {
	if (!fileLoaded && !networkModified  )  {
		statusBar()->message( QString(tr(" Load a network file first. Then you may ask me to compute something!")) , statusBarDuration);
		return;
	}
	if (!distanceMatrixCreated || networkModified)
		createDistanceMatrix();
	if (!distanceMatrixCreated) {
			statusBar()->message(tr("Sorry!"), statusBarDuration+2000);	
		return;
	}
	if (netDiameter > (Actors-1) ) 
	QMessageBox::information(this, "SocNetV", "The diameter is "+ QString::number(netDiameter)+"  > (Actors-1).", "OK",0);
	else 
	QMessageBox::information(this, "SocNetV", "The diameter is " + QString::number(netDiameter), "OK",0);
	statusBar()->message(tr("Diameter calculated. Ready."), statusBarDuration);

}




/**
*  Turns on/off displaying the numbers of actors (outside ones)
*/
void App::slotShowNumbers(bool toggle) {
	if (!fileLoaded && ! networkModified) {
		statusBar()->message(tr("Load a network or create one..."), statusBarDuration);
		return;
	}
	statusBar()->message(tr("Toggle Actors Numbers..."), statusBarDuration);

	if (!toggle) 	{
		QCanvasItemList list = canvas->allItems();
		for (QCanvasItemList::iterator item=list.begin();item!=list.end(); item++) {
			if ( (*item)->rtti() == Actor_Rtti) {
				Actor *jim=(Actor*) (*item);
				jim->clearNumber();
				qDebug ("All ActorNumber references were deleted from actor memory");
			}
			if ( (*item)->rtti() == Number_Rtti )
				delete *item;
		}
		return;
	}
	else{
		QCanvasItemList list = canvas->allItems();
		for (QCanvasItemList::iterator item=list.begin();item!=list.end(); item++)
			if ( (*item)->rtti() == Actor_Rtti)
				if  ( (*item)->isVisible() ) {
					Actor* jim= (Actor*) (*item);
					ActorNumber *numberJim = new ActorNumber (jim, QString::number( jim->actorNumber() ), canvas);
					qDebug("actor is at x=%f and y=%f",jim->x(), jim->y());
					numberJim -> move (jim->x()+numberDistance,jim->y()+numberDistance);
					numberJim -> setColor(initNumberColor);
					numberJim -> setZ(255);
					numberJim -> show();
				}
	}

	statusBar()->message(tr("Numbers removed. Ready."));
}



/**
*  Turns on/off displaying the labels of the actors.
*/
void App::slotShowLabels(bool toggle){
	statusBar()->message(tr("Toggle Actors labels..."));
	if (!fileLoaded && ! networkModified) {
		statusBar()->message(tr("Load a network or create one..."), statusBarDuration);
		return;
	}
	statusBar()->message(tr("Toggle Actors labels..."), statusBarDuration);
	if (!toggle)
	{
		QCanvasItemList list = canvas->allItems();
		for (QCanvasItemList::iterator item=list.begin();item!=list.end(); item++) {
			if ( (*item)->rtti() == Actor_Rtti) {
				Actor *jim=(Actor*) (*item);
				jim->clearLabel();
				qDebug ("All ActorLabel references were deleted from actor memory");
			}
			if ( (*item)->rtti() == Label_Rtti )
				delete *item;
			// (*item)->setVisible (FALSE);
		}
		return;
	}
	else{
		QCanvasItemList list = canvas->allItems();
		for (QCanvasItemList::iterator item=list.begin();item!=list.end(); item++)
			if ( (*item)->rtti() == Actor_Rtti)
				if  ( (*item)->isVisible() ) {
					Actor* jim= (Actor*) (*item);
					ActorLabel *labelJim =new  ActorLabel (jim, jim->label(), canvas );
					labelJim ->move( jim->x()-labelDistance, jim->y()-labelDistance);
					labelJim->setColor (initLabelColor);
					labelJim ->setZ (255);
					labelJim ->show();
				}
	}
	statusBar()->message(tr("Labels removed. Ready."));
}



/**
 	Turns on/off displaying weights of links
	TODO
*/
void App::slotActorsOwnColor() {

}


/**
*   Changes the size of all actors
*/
void App::slotChangeAllActorsSize() {
	bool ok=false;
	int newSize =   QInputDialog::getInteger("-SocNetV-", tr("Change all actor value (size) to:"),1, 1, 16, 1, &ok,this);
	QCanvasItemList list=canvas->allItems();
	for (QCanvasItemList::iterator it=list.begin(); it!=list.end(); it++)
		if ( (*it) -> rtti() == Actor_Rtti ){
			Actor *jim = (Actor*) (*it);
			(*jim).setSize(newSize);
		}
	networkModified=TRUE;
	statusBar()->message (QString(tr("Ready")), statusBarDuration) ;
}



/**
*  Changes the shape of all actors. 
*/
void App::slotChangeAllActorsShape() {
	bool ok=false;
	QStringList lst;
    	lst << "box"<< "circle"<< "diamond"<< "ellipse"<< "triangle";
    	QString newShape = QInputDialog::getItem(
            "-SocNetV-", "Select a shape for all the actors from the list: ", lst, 1, TRUE, &ok,
            this );
	if ( ok ) {
	        // user selected an item and pressed OK
		QCanvasItemList list=canvas->allItems();
		for (QCanvasItemList::iterator it=list.begin(); it!=list.end(); it++)
			if ( (*it) -> rtti() == Actor_Rtti ){
				Actor *jim = (Actor*) (*it);
				(*jim).setShape(newShape);
			}
		networkModified=TRUE;
		statusBar()->message (QString(tr("All shapes have been changed. Ready")), statusBarDuration) ;
	} else {
		// user pressed Cancel
		statusBar()->message (QString(tr("Aborting")), statusBarDuration) ;
	}

}



/**
*  Change size of all actors' numbers (outside ones)
*/
void App::slotChangeNumbersSize() {
  bool ok=false;
  int newSize;
  newSize= QInputDialog::getInteger("-SocNetV-",
     tr("Choose a new font size for the numbers: "),
     7, 1, 14 , 1, &ok, this )   ;
  if (!ok) {
     statusBar()->message(tr("Change font size: Aborted."), statusBarDuration);
    return;
  }
  QCanvasItemList list=canvas->allItems();
  for (QCanvasItemList::iterator it2=list.begin();it2!=list.end(); it2++)
     if ( (*it2)->rtti()==Number_Rtti) {
       ActorNumber * number= (ActorNumber*) (*it2);
      number->setFont( QFont ("Helvetica", newSize, QFont::Normal, FALSE) );
     }

  statusBar()->message(tr("Changed numbers size. Ready."), statusBarDuration);
}


/**
*  Changes size of all actors' labels
*/
void App::slotChangeLabelsSize() {
  bool ok=false;
  int newSize;
  newSize= QInputDialog::getInteger("-SocNetV-",
     tr("Choose a new font size for the labels: "),
     7, 7, 14 , 1, &ok, this )   ;
  if (!ok) {
     statusBar()->message(tr("Change font size: Aborted."), statusBarDuration);
    return;
  }
  QCanvasItemList list=canvas->allItems();
  for (QCanvasItemList::iterator it2=list.begin();it2!=list.end(); it2++)
     if ( (*it2)->rtti()==Label_Rtti) {
       ActorLabel * number= (ActorLabel*) (*it2);
      number->setFont( QFont ("Helvetica", newSize, QFont::Normal, FALSE) );
     }

  statusBar()->message(tr("Changed labels size. Ready."), statusBarDuration);
}




/**
	Turns on/off drawing links with their own colours (if specified).
	TODO
*/
void App::slotLinksOwnColor() {

}


/**
	Turns on/off drawing links as thick as their weights.
	TODO
*/
void App::slotLinksThickWeights() {

}



/**
*  Turns on/off displaying weights of links
*/
void App::slotNumbersLinksWeights(bool toggle) {
	pair<int,int> pair1;	
	QCanvasItemList list=canvas->allItems();
	if ( toggle )   {  //draw Edge Weight Numbers
		qDebug ("toogle is TRUE. Will show weight numbers");
		for (QCanvasItemList::iterator it=list.begin(); it!=list.end(); it++)
			if ( (*it)->rtti() ==   Link_Rtti ){
				Edge* link= (Edge*) (*it);
				qDebug ("found link");
 				EdgeWeight *linkWeight =new  EdgeWeight (link, QString::number(link->weight()), canvas );
				qDebug ("will draw weight number %i",link->weight() );
				
               			linkWeight ->setZ (255);
				pair1=link->center();
                		linkWeight ->move(pair1.first,pair1.second);
                		linkWeight-> setColor (link->linkColor());
                		linkWeight ->show();
				qDebug ("show");
			}
	}
	else { //delete them
		qDebug ("toogle is FALSE. Deleting all numbers");
		for (QCanvasItemList::iterator item=list.begin();item!=list.end(); item++){
			if ( (*item)->rtti() ==   Weight_Rtti ) {
				delete *item;
			}
			else if ( (*item)->rtti() ==   Link_Rtti ) {
				Edge* link= (Edge*) (*item);
				link->clearWeightList();
				qDebug ("weight List cleared");
			}	
			
		}
		return;
	}

}



/**
*  Turns on/off the arrows of links
*/
void App::slotLinksArrows(bool toggle){
//	linksArrows=toggle;
	QString currentColor;
	int from, to;
	QCanvasItemList list=canvas->allItems();
	if ( toggle )   {  /**draw arrows*/
		for (QCanvasItemList::iterator it=list.begin(); it!=list.end(); it++)
			if ( (*it)->rtti() ==   Link_Rtti ){
				Edge* link= (Edge*) (*it);
				from = actorVectorIndex( link->fromActor());
				to = actorVectorIndex( link->toActor());
				currentColor=link->linkColor();
				Arrow *arrow1= new Arrow(aVector[from], aVector[to], canvas);
				arrow1 -> setBrush(QBrush(currentColor)); 
				arrow1 -> setZ (128);
				arrow1 -> show();
			}
	}
	else { /**delete them*/
		for (QCanvasItemList::iterator item=list.begin(); item!=list.end(); item++) 
			if ( (*item)->rtti()==Arrow_Rtti) {
				Arrow *arr=(Arrow*) (*item);
				from=actorVectorIndex( arr->fromActor() );
				to=actorVectorIndex( arr->toActor() );
				if ( aVector[from]->deleteOutArrow(arr) && aVector[to]->deleteInArrow(arr) )
					qDebug("Arrows Deleted from actors reference lists");
				else qDebug ("ERROR DELETING ARROWS FROM LINK");
				delete *item;
				qDebug ("Arrows deleted from canvas");
			}
		return;
	}


}



/**
*  OBSOLETE
*/
void App::slotLinksBezier(bool toggle){
	int from, to, weight;
	QString linkColor;
	bezier=toggle;
	if (!fileLoaded && ! networkModified) {
		statusBar()->message(tr("Load a network or create one..."), statusBarDuration);
		return;
	}
	statusBar()->message(tr("Drawing Links as bezier curves..."), statusBarDuration);
	QCanvasItemList list = canvas->allItems();
	//DELETE ALL ACTORS REFERENCES TO IN/OUT LINKS
	for (QCanvasItemList::iterator item=list.begin();item!=list.end(); item++)
		if ( (*item)->rtti() ==   Actor_Rtti )
			if ( (*item)->isVisible () ) {
				Actor* jim= (Actor*) (*item);
		              jim->deleteAllLinks();
			}
	//DRAW NEW LINKS          
	for (QCanvasItemList::iterator item=list.begin();item!=list.end(); item++)
		if ( (*item)->rtti() ==   Link_Rtti )
			if ( (*item)->isVisible () ) {
				Edge* link= (Edge*) (*item);
				if (! link->isBezier() && !toggle  ) continue;
				else  if ( link->isBezier() && toggle  ) continue;
				from = link->fromActor()-1;
				to = link->toActor()-1;
				linkColor = link->linkColor();
				weight=link->weight();
				drawLink(from, to,  weight, linkColor, bezier);
      
			}
	//NOW ERASE OLD LINES or BEZIER            
	QCanvasItemList list1 = canvas->allItems();           
	for (QCanvasItemList::iterator item=list1.begin();item!=list1.end(); item++)
		if ( (*item)->rtti() ==   Link_Rtti )
			if ( (*item)->isVisible () ) {
				Edge* link= (Edge*) (*item);
				if (! link->isBezier() && toggle )  // erase lines
					delete *item;
				else if ( link->isBezier() && !toggle )//erase beziers
					delete *item;
			}      
	statusBar()->message(tr("Ready."));
	return;
}



/**
*  Changes the background color of the canvas
*/
void App::slotBackgroundColor () {
	QColor backgrColor = QColorDialog::getColor( black, this, "Background color dialog" );
	canvas ->setBackgroundColor (backgrColor);
	statusBar()->message(tr("Ready. ") ,statusBarDuration);

}


/**
*  Changes the color of all actors
*/
void App::slotAllActorsColor(){
	bool ok=FALSE;
	actorColor = QInputDialog::getItem("SocNetV", "Select a  color:", colorList, 1, TRUE, &ok,  this );
    	if ( ok ) {
		QCanvasItemList list= canvas->allItems();
		for (QCanvasItemList::iterator it=list.begin(); it!=list.end(); it++)
			if ( (*it)->rtti() == Actor_Rtti ) 	{
				Actor *jim = (Actor *) (*it);
				jim->setBrush (QColor(actorColor));
				jim->setActorColor(actorColor);
				networkModified=TRUE;
			}
		statusBar()->message(tr("Ready. ") ,statusBarDuration);
    	} 
	else {
	        // user pressed Cancel
		statusBar()->message(tr("User abort. ") ,statusBarDuration);
    	}
}



/**
*  Changes the color of all links
*/
void App::slotAllLinksColor(){
	//QColor linkColor = QColorDialog::getColor( black, this, "Links color dialog" );
	bool ok=FALSE;
	QString linkColor = QInputDialog::getItem("SocNetV", "Select a  color:", colorList, 1, TRUE, &ok,  this );
	if ( ok ) {
		QCanvasItemList list= canvas->allItems();
		for (QCanvasItemList::iterator it=list.begin(); it!=list.end(); it++)
			if ( (*it)->rtti() == Link_Rtti ) 	{
				Edge *link = (Edge *) (*it);
				link-> setPen (QPen (linkColor, link->pen().width(),link->pen().style() ) );
				link->setLinkColor(linkColor);
				networkModified=TRUE;
			}
			statusBar()->message(tr("Ready. ") ,statusBarDuration);
	}
	else {
	        // user pressed Cancel
		statusBar()->message(tr("User abort. ") ,statusBarDuration);
    	}
}




/**
*  Changes the color of actors' numbers
*/
void App::slotNumbersColor(){
	QColor textColor = QColorDialog::getColor( black, this, "Text color dialog" );
	QCanvasItemList list= canvas->allItems();
	for (QCanvasItemList::iterator it=list.begin(); it!=list.end(); it++)
		if ( (*it)->rtti() == Number_Rtti )
		{
			ActorNumber *jimNumber = (ActorNumber *) (*it);
			jimNumber->setColor (textColor);
		}
	statusBar()->message(tr("Ready. ") ,statusBarDuration);
}



/**
*  turn progressbar on or off
*/
void App::slotShowProgressBar(bool toggle) {
	statusBar()->message(tr("Toggle progressbar..."));
	if (!toggle)  {
		showProgressBar=FALSE;
	}
	else   {
		showProgressBar=TRUE;
	}
	statusBar()->message(tr("Ready."));
}



/**
*  Turns progressbar on or off
*/
void App::slotPrintDebug(bool toggle){
	statusBar()->message(tr("Toggle debug messages to stdout..."));
	if (!toggle)   {
		printDebug=FALSE;
	}
	else  {
	printDebug=TRUE;
	}
	statusBar()->message(tr("Ready."));
}




/**
*  Turns Toolbar on or off
*/
void App::slotViewToolBar(bool toggle) {
	statusBar()->message(tr("Toggle toolbar..."));
	if (toggle== false)   {
		fileToolbar->hide();
	}
	else  {
		fileToolbar->show();
	}
	statusBar()->message(tr("Ready."));
}



/**
*  Turns Statusbar on or off
*/
void App::slotViewStatusBar(bool toggle) {
	statusBar()->message(tr("Toggle statusbar..."));

	if (toggle == false)   {
		statusBar()->hide();
	}
	else   {
		statusBar()->show();	
		statusBar()->message(tr("Ready."));
	}

}



/**
*  Displays a random tip
*/
void App::slotTips() {
	int randomTip=rand()%tipsCounter; //Pick a tip.
	QMessageBox::about( this, "-SocNetV-", "<b>DID YOU KNOW THAT:</b> <br>"  + tips[randomTip]);
}



/**
	Creates our tips.
*/
void App::createTips(){
	tips+="You can easily add a new actor by double-clicking on the canvas";	
	tips+="You can easily add a new actor by double-clicking on the canvas";	
	tips+="You can add a link between two actors, by middle-clicking (or pressing both mouse buttons simultanesously) on the first and then on the second actor";	
	tips+="You can remove an actor by right-clicking on it and selecting Remove";
	tips+="You can change background color by right-clicking on the canvas and selecting Change Back Color";
	tips+="You can select every color supported by the X.org pallette!";
	tips+="You can read some random cookies if you click on Help!";
	tips+="You can move an actor easily by drag-and-drop";
	tips+="If you want to save the positions of the actors in your current network, then save it under the Pajek format";
	tips+="You can apply layout algorithms on the network from the layout menu";
	tips+="You can change the label of actor by right-clicking on it, and selecting Change Label";
	tips+="Most operations of SocNetV are available by right-clicking on the canvas, or on an actor or on a link";
	tips+="Most operations of SocNetV are available by right-clicking on the canvas, or on an actor or on a link";
	tips+="You can see usefull info about an actor on the bottom Status bar, by left-clicking on it.";
	tips+="You can see usefull info about a link on the bottom Status bar, by left-clicking on it.";

   	tipsCounter = 12;
}




/**
	Loads the HTML Help file and displays it via HTMLViewer.
*/
void App::slotHelp(){
	//QDir d ("");
	QString helpPath;
	QDir d( QDir::currentDirPath() );
	if ( d.exists("snv.htm") ) 
  		helpPath=d.filePath("snv.htm");
	else {
		if (d.dirName()=="bin")
			d.cdUp();
		if (d.cd("./src/html") )
			if ( d.exists("snv.html") ) 
				helpPath=d.filePath("snv.html");
			else
			qDebug("help file does not exist.");
		if (d.cd("/usr/share/socnetv/html") )
			if ( d.exists("snv.html") ) 
				helpPath=d.filePath("snv.html");
			else
			qDebug("help file does not exist.");
		
		else
			qDebug("Cannot chdir to html");
	}
  
  	HTMLViewer *helpViewer = new HTMLViewer (helpPath, ".", 0, "help Viewer");
  	helpViewer -> setCaption ( "-SocNetV- "+ VERSION + tr(" Help Viewer-"));
  	if ( QApplication::desktop()->width() > 400 && QApplication::desktop()->height() > 500 )
        	helpViewer->show();
    	else
        	helpViewer->showMaximized();

}



/**
	Displays the following message!!
*/
void App::slotHelpAbout()
{
     int randomCookie=rand()%fortuneCookiesCounter;//createFortuneCookies();
     QMessageBox::about( this, "-SocNetV-",
	"<b>Soc</b>ial <b>Net</b>work <b>V</b>isualiser " +VERSION+ "  codename: <b>SNAIL</b>"
	"<p>(C) 2005, 2006 by <br><b>Dimitris B. Kalamaras</b><br>"
	"<br><b>Email:</b><br> dimitris.kalamaras@compupress.gr"
	"<p><b>Last revision: </b><br>Fri, Sep 08, 2006</p>"
	"<p><b>Fortune cookie: </b><br> \""  + fortuneCookie[randomCookie]  +"\""
	"<p><b>References:</b><br>"
	
	"Brandes, Ulrik (2001). <i>A Faster Algorithm for Betweeness Centrality.</i> Journal of Mathematical Sociology 25(2), pp.163-177.<br>"
	"<br>Brandes, Ulrik (2001). <i>Drawing on Physical Analogies.</i> In M. Kaufmann and D. Wagner (Eds.): Drawing Graphs: Methods and Models. LNCS Tutorial 2025, pp. 71-86. <br>"
	"<br>Fruchterman, T.M.J. & Reingold, E.M. (1991). <i>Graph Drawing by Force-Directed Placement.</i>Software-Practice & Experience. Vol. 21, Is. 11, pp. 1129-1164.<br>"
	"<br>Press W., Teukolsky S., Vetterling W. & Flannery B. (1992). <i>Numerical Recipes in C, the art of scientific computing.</i><br>"
	"<br>Stroustrup B. (1997). <i>The C++ Programming Language.</i> <br>"
	"<br>Scott, J. (2000). <i>Social Network Analysis, A handbook.</i> <br>"
	"<br>Wasserman S. & Faust K. (2000). <i>Social Network Analysis. Methods and Applications.</i><br>"
     
	"<p><b>License:</b><br>"
	"This program is free software; you can redistribute it and/or modify"
	"<br>it under the terms of the GNU General Public License as published by"
	"<br>the Free Software Foundation; either version 2 of the License, or"
	"<br>(at your option) any later version.</p>"

	"<p>This program is distributed in the hope that it will be useful,"
	"<br>but WITHOUT ANY WARRANTY; without even the implied warranty of"
	"<br>MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the"
	"<br>GNU General Public License for more details.</p>"

	"<p>You should have received a copy of the GNU General Public License"
	"<br>along with this program; if not, write to the Free Software"
	"<br>Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA</p>");

}



/**
	Creates the fortune cookies displayed on the above message.
*/
void App::createFortuneCookies(){
	fortuneCookie+="sic itur ad astra / sic transit gloria mundi ?";
	fortuneCookie+="losers of yesterday, the winners of tomorrow... (Brecht)";

	fortuneCookie+="No tengo nunca mas, no tengo siempre. En la arena <br>" 
			"la victoria dejo sus piers perdidos.<br>"
		   	"Soy un pobre hombre dispuesto a amar a sus semejantes.<br>"
		   	"No se quien eres. Te amo. No doy, no vendo espinas."  ;
	fortuneCookiesCounter=3;
//   return fortuneCookie.count();
}




/**
	Displays a short message about the Qt Toolbox.
*/
void App::slotAboutQt(){
	QMessageBox::aboutQt(this, "-SocNetV-"+ VERSION );
}



