/***************************************************************************
 SocNetV: Social Networks Visualiser for Linux
 version: 0.43
 Written in Qt 3.3.3 with KDevelop 3.1.0  
 
                         app.h  -  description
                             -------------------
    copyright            : (C) 2005, 2006 by Dimitris B. Kalamaras
    email                : dimitris.kalamaras@compupress.gr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef APP_H
#define APP_H

// include files for QT
#include <qapplication.h>
#include <qmainwindow.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qstatusbar.h>
#include <qwhatsthis.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qmessagebox.h>
#include <qfiledialog.h>
#include <qprinter.h>
#include <qpainter.h>


/** SocNetV specific includes*/

#include <qcanvas.h>
#include <qvaluelist.h>
#include <qprogressdialog.h>
#include <qdir.h>
#include <qaccel.h>
#include <qcolordialog.h>
#include <math.h>
#include <utility> //declares pair construct

#include "canvasview.h"
#include "actor.h"
#include "edge.h"
#include "actornumber.h"
#include "actorlabel.h"
#include "edgeweight.h"
#include "qinputdialog.h"
#include "htmlviewer.h"
#include "texteditor.h"
#include "matrix.h"
#include "arrow.h"
#include "table.h"
#include "backgrcircle.h"
#include "netlayout.h"

#include "graph.h"


/**
  * This Class is the base class. It sets up the main
  * window and provides a menubar, toolbar and statusbar.
  * For the main view, an instance of class CanvasView is
  * created which creates a canvasview.
  */
  
 using namespace std;
  
class App : public QMainWindow
{
	Q_OBJECT
  
public:
	/**PUBLIC FUNCTIONS NOT VISIBLE BY OTHER WIDGETS NOR BY SLOT/LINK MECHANISM */
	
	App(const QString &f);
	~App();
	void initActions();
	void initMenuBar();
	void initToolBar();
	void initStatusBar();
	void initNet();
	void initView();

	int loadNetworkFile( QString);
	int loadSociomatrixNetwork (QString);
	int loadPajekNetwork(QString);
	int loadListNetwork(QString);
	int loadDLNetwork(QString);
	int loadGWNetwork(QString);
	int loadDotNetwork(QString);
	int activeLinks();
	int activeActors();
	void createFortuneCookies();
	void createTips();
	void makeThingsLookRandom();
	QPoint countActorLinks(int);
	void layoutOutDegreeCentrality ( bool );
	void layoutInDegreeCentrality ( bool );
	void centralityOutDegree(bool );
	void centralityInDegree(bool );
	void centralityCloseness();
	void centralityBetweeness();
	void centralityInformational();
	void centralityGraph();
	void centralityStress();
	bool removeActor(int);
	bool removeLink(Edge *);
	int distance(int, int);
	void createSociomatrix();
	void createDistanceMatrix();
	
	
	void drawActor( int i, int size, QString aColor, QString label, QString lColor, double x, double y, QString actorShape );
	void drawLink( int from, int to, int weight, QString color, bool bezier );
	void drawLink( Actor *source , Actor*target, int weight, QString color, bool bezier );
	int lineWidth(int weight);
	int actorExists(QString label);
	int actorExists(int actorNumber);
	bool linkExists(Edge *);
	bool linkExists(int, int);
	int removeActorFromVector(int);
	int actorVectorIndex(int actorNumber);
	void openContextMenu(const QPoint & mousePos);
	void openActorContextMenu(const QPoint & mousePos,Actor *jim ) ;
	void openLinkContextMenu(const QPoint & mousePos, Edge *link) ;
	

	void matrixVectorMult();
	float matrixLargestEigen();
	void matrixInverse();
	float matrixDet();
public slots:
	//FILE MENU
	void slotCreateNew();
	void slotChooseFile();
	void slotFileSave();
	void slotFileSaveAs();
	void slotFileClose();
	void slotPrintView();
	void slotImportSM();
	void slotImportList();
	void slotImportPajek();
	void slotImportGW();
	void slotImportDL();
	void slotImportDOT();
	bool slotExportBMP();
	bool slotExportPNG();
	bool slotExportPajek();
	bool slotExportSM();
	bool slotExportDL();
	bool slotExportGW();
	bool slotExportList();
	//NETWORK MENU
	void slotViewNetworkFile();
	void slotViewSociomatrix();
	void slotCreateUniformRandomNetwork();
	void slotCreateSameDegreeRandomNetwork();
	void slotCreateConnectedRandomNetwork();
	void slotCreateGaussianRandomNetwork();
	void slotCreateLatticeNetwork();
	void slotMatrixPow();
	void slotMatrixEigenBoundary();
	void slotDynamicNetwork();
	//EDIT MENU
	void addActor();
	void slotFindActor();
	void slotAddLink();
	void slotRemoveActor();
	void slotRemoveLink();
	void slotChangeActorLabel();
	void slotChangeActorColor();
	void slotChangeActorValue();
	void slotChangeActorBox();
	void slotChangeActorCircle();
	void slotChangeActorTriangle();
	void slotChangeActorDiamond();
	void slotChangeActorEllipse();
	void slotChangeLinkLabel();
	void slotChangeLinkColor();
	void slotChangeLinkWeight();
	void slotFilterActors();
	void slotFilterLinks();
	void slotTransformActors2Links();
	void slotSymmetriseLinks();

	// LAYOUT MENU
	void slotColorationStrongStructural();
	void slotColorationRegular();
	void slotLayoutRandom();
	void slotLayoutRandomCircle();
	void slotLayoutCircleCentralityOutDegree();
	void slotLayoutCircleCentralityInDegree();
	void slotLayoutCircleCentralityCloseness();
	void slotLayoutCircleCentralityBetweeness();
	void slotLayoutCircleCentralityInformational();
	void slotLayoutCircleCentralityStress();
	void slotLayoutCircleCentralityGraph();
	void slotLayoutLevelCentralityDegree();
	void slotLayoutLevelCentralityCloseness();
	void slotLayoutLevelCentralityBetweeness();
	void slotLayoutLevelCentralityInformational();
	void slotClearBackgrCircles();

	void slotLayoutSpringEmbedder();
	void slotLayoutFR();

	//STATISTICS MENU
	void slotDistanceMatrix();
	void slotDistance();
	void slotDiameter();
	void slotActiveActors();
	void slotActiveLinks();
	void slotNetworkDensity();
	void slotCentralityOutDegree();
	void slotCentralityInDegree();
	void slotCentralityCloseness();
	void slotCentralityBetweeness();
	void slotCentralityInformational();
	void slotCentralityGraph();
	void slotCentralityStress();
	//OPTIONS MENU
	void slotShowNumbers(bool toggle);
	void slotShowLabels(bool toggle);
	void slotActorsOwnColor();
	void slotChangeAllActorsSize();
	void slotChangeAllActorsShape();
	void slotChangeNumbersSize();
	void slotChangeLabelsSize();
	void slotLinksOwnColor();
	void slotLinksThickWeights();
	void slotNumbersLinksWeights(bool toggle);
	void slotLinksArrows(bool toggle);
	void slotLinksBezier(bool toggle);
	void slotBackgroundColor ();
	void slotAllActorsColor();
	void slotAllLinksColor();
	void slotNumbersColor();
	//VIEW MENU
	void slotShowProgressBar(bool toggle);
	void slotPrintDebug(bool toggle);
	void slotViewToolBar(bool toggle);
	void slotViewStatusBar(bool toggle);
	
	//HELP MENU
	void slotTips();
	void slotHelp();
	void slotHelpAbout();
	void slotAboutQt();
	//PUBLICLY AVAILABLE SLOTS. CALLED FROM CANVASVIEW
	void actorInfoStatusBar(Actor*);
	void linkInfoStatusBar (Edge*);
	void windowInfoStatusBar(int, int);
	void addLink(Actor*, Actor*);
	void mousePosition (int, int);
	
protected:
	void resizeEvent( QResizeEvent * );
	void closeEvent( QCloseEvent* ce );
	QProgressDialog *actionProgress;
//	void myMessageOutput(QtMsgType type, const char *msg);
signals:
	void clearClickedActorHistory(); 
private:
	QCanvas *canvas;
	CanvasView *view;
	QPrinter *printer;
	QPopupMenu *fileMenu, *importSubMenu, *exportSubMenu, *editMenu, *statMenu, *viewMenu, *helpMenu;
	QPopupMenu *optionsMenu, *colorOptionsMenu, *linkOptionsMenu, *actorOptionsMenu;
	QPopupMenu *editActorMenu, *editLinkMenu, *centrlMenu, *layoutMenu;
	QPopupMenu *networkMenu, *randomNetworkMenu, *matrixAlgebraMenu, *filterMenu;
	QPopupMenu *randomLayoutMenu, *circleLayoutMenu, *levelLayoutMenu, *physicalLayoutMenu;
	QPopupMenu *colorationMenu;
	QToolBar *fileToolbar;
	QAction *fileNew, *fileOpen, *fileSave, *fileSaveAs,*fileClose, *filePrint,*fileQuit;
	QAction *importPajek, *importDL, *importGW, *importSM, *importList, *importDOT;
	QAction *exportBMP, *exportPNG, *exportPajek, *exportDL, *exportGW, *exportSM, *exportList;
	QAction *viewNetworkFileAct, *viewSociomatrixAct, *createUniformRandomNetworkAct;
	QAction *createGaussianRandomNetworkAct, *createLatticeNetworkAct, *createConnectedRandomNetworkAct,*createSameDegreeRandomNetworkAct, *powSociomatrixAct;
	QAction  *dynamicNetworkAct, *showNumbersAct, *showLabelsAct;
	QAction *findActorAct,*addActorAct, *addLinkAct, *removeActorAct, *removeLinkAct;
	QAction *changeNumbersSizeAct, *changeActorLabelAct, *changeActorColorAct, *changeActorValueAct;
	QAction *changeLabelsSizeAct, *changeAllActorsSizeAct, *changeAllActorsShapeAct;
	QAction *changeLinkLabelAct, *changeLinkColorAct, *changeLinkWeightAct;
	QAction *filterActorsAct, *filterLinksAct, *transformActors2LinksAct, *symmetriseLinksAct;
	QAction *changeBackColorAct, *changeAllActorsColorAct, *changeAllLinksColorAct, *changeNumbersColorAct;
	QAction *paintActorsOwnColorAct,*paintLinksOwnColorAct, *drawLinksWeightsAct, *showNumbersLinksWeightsAct, *drawLinksArrowsAct, *drawLinksBezier;
	QAction *viewToolBar, *viewStatusBar, *helpAboutApp, *helpAboutQt, *helpApp, *tipsApp;
	QAction *netDensity, *countActors, *countLinks,  *distanceAct, *distanceMatrixAct, *diameterAct;
	QAction *cOutDegreeAct, *cInDegreeAct, *cClosenessAct, *cBetweenessAct, *cInformationalAct, *cGraphAct, *cStressAct;
	QAction *randLayoutAct, *randCircleLayoutAct, *circleOutDegreeLayoutAct, *circleInDegreeLayoutAct, *circleClosenessLayoutAct;
	QAction *circleStressLayoutAct, *circleGraphLayoutAct,*circleClearBackgrCirclesAct;
	QAction *circleBetweenessLayoutAct, *circleInformationalLayoutAct, *levelClosenessLayoutAct;
	QAction *levelDegreeLayoutAct, *levelBetweenessLayoutAct, *levelInformationalLayoutAct;
	QAction *strongColorationAct, *regularColorationAct, *showProgressBarAct, *printDebugAct;
	QAction *springLayoutAct, *FRLayoutAct;
	QString fileName, networkName;
	QStringList fileNameNoPath, fileLines, singleLine, fortuneCookie, rgbValues;
	QStringList tempFileNameNoPath, colorList, tips;
	int statusBarDuration,  minDuration, progressCounter;
	int Actors, initActorSize, clickedJimNumber, labelDistance, numberDistance;
	int totalLinks, fortuneCookiesCounter, preSize, tipsCounter , netDiameter;
	QString VERSION;
	bool pajekFile, sociomatrixFile, symmetricSociomatrix, fileLoaded,  fileSaved;
	bool networkModified, distanceMatrixCreated, sociomatrixCreated;
	bool fileContainsNodesCoords, fileContainsNodeColors, fileContainsLinksColors;
	bool bezier,  linkClicked, markedActorExists, showProgressBar, firstTime;
//	bool linksArrows;
	QString initActorColor, initLinkColor, actorColor, actorShape, initActorShape, initLabelColor;
	QColor initNumberColor,backgroundColor ;
	QPoint mousePos;
	
	//QValueVector<Actor*> aVector;
	vector<Actor*> aVector;
	Graph network;
	Actor *clickedJim;	
	Actor *markedActor;
	Edge *clickedLink;
	Matrix  SM, TM, PM, DM;
	Table TSM, TPM, TDM;
	QDateTime actualDateTime, actualDate, actualTime;
	float sumCC, sumBC, sumODC, sumIDC, sumGC, sumSC, varianceDegree, meanDegree;
	float groupCC, groupBC, groupODC, groupIDC, groupGC, groupSC;
	float minCC, maxCC, minBC, maxBC, minODC, maxODC, minIDC, maxIDC, minGC, maxGC, minSC, maxSC ;
	int minActorODC, minActorIDC, minActorCC, minActorBC, minActorSC, minActorGC;
	int maxActorODC, maxActorIDC, maxActorCC, maxActorBC, maxActorSC, maxActorGC;
	int classesODC, classesIDC, classesCC, classesBC, classesGC, classesSC;
	QMap <int, int> mapEdges;
	
	QValueList <float> discreteCCs, discreteODCs, discreteIDCs, discreteBCs, discreteSCs, discreteGCs;
	bool calculatedCC, calculatedIC, calculatedBC, calculatedODC, calculatedIDC, calculatedGC, calculatedSC;
	QValueList<int> listDummiesPajek;
	QTime eTime;     //used  to time algorithms.
	
	
};
#endif 

