
/****************************************************************************
 SocNetV: Social Networks Visualiser for Linux
 version: 0.43
**
                            Arrow.cpp  -  description
                             -------------------
    copyright            : (C) 2005, 2006 by Dimitris B. Kalamaras
    email                : dimitris.kalamaras@compupress.gr
 
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "arrow.h"
#include "math.h"

Arrow::Arrow(Actor *from, Actor *to, QCanvas *canvas):QCanvasPolygon(canvas) {
	from->addOutArrow( this );   // outLink Arrow on fromActor
	to->addInArrow( this );       // InLink Arrow on toActor
	m_from = from ->actorNumber();
	m_to = to -> actorNumber();
	fromx=(int) from->x();
	fromy=(int)  from->y();
	tox=(int)  to->x();
	toy=(int) to->y();
	size=10;
	calculatePoints();

}


Arrow::~Arrow(){
}



void Arrow::moveBy(double, double)
{
    //nothing
}

void Arrow::setFromPoint( int x, int y ) {
	fromx=x; fromy=y;
	calculatePoints();

}

void Arrow::setToPoint( int x, int y) {
	tox=x; toy=y;
	calculatePoints();
    
}



void Arrow::calculatePoints() {
	rad = atan(((double)fromy-toy)/(double)(fromx-tox ));
	theta=qRound(rad*180.0/3.14159265);
 	theta1=theta-12;
	theta2=theta+12;
	
	if ( fromx > tox )      {
		if ( fromy < toy )   { //3rd
			rad=theta1*3.14159265/180.0;  //in rad
			tox1=qRound( cos(rad)*size  );
			toy1=qRound( sin(rad)*size   );
			rad=theta2*3.14159265/180.0;
			tox2=qRound( cos(rad)*size  );
			toy2=qRound( sin(rad)*size   );
			pa. putPoints(0, 3, tox, toy, tox+tox1, toy+toy1 , tox+ tox2, toy+toy2 );
			setPoints (pa);
		}
		else  if ( fromy > toy ) {  //2nd 
			rad=theta1*3.14159265/180.0;
			tox1=qRound( cos(rad)*size  );
			toy1=qRound( sin(rad)*size   );
			rad=theta2*3.14159265/180.0;
			tox2=qRound( cos(rad)*size  );
			toy2=qRound( sin(rad)*size   );
			pa. putPoints(0, 3, tox, toy, tox+tox1, toy+toy1 , tox+ tox2, toy+toy2 );
			setPoints (pa);
		}
		else { // fromy==toy
			rad=theta1*3.14159265/180.0;
			tox1=qRound( cos(rad)*size  );
			toy1=qRound( sin(rad)*size   );
			rad=theta2*3.14159265/180.0;
			tox2=qRound( cos(rad)*size  );
			toy2=qRound( sin(rad)*size   );
			pa. putPoints(0, 3, tox, toy, tox+tox1, toy+toy1 , tox+ tox2, toy+toy2 );
			setPoints (pa);
		}
	}
	else if ( fromx < tox ) {                  //right
		if ( fromy < toy ) {                     //4th
			rad=theta1*3.14159265/180.0;
			tox1=qRound(cos(rad)*(-size)  );
			toy1=qRound(sin(rad)*(-size)  );
			rad=theta2*3.14159265/180.0;
			tox2=qRound(cos(rad)*(-size) );
			toy2=qRound(sin(rad)*(-size)  );
			pa. putPoints(0, 3,  (tox), (toy), tox+tox1, toy+toy1 , tox+ tox2, toy+toy2 );
			setPoints (pa);
		}
		else  if ( fromy > toy ) {          // 1st
			rad=theta1*3.14159265/180.0;
			tox1=qRound(cos(rad)*(-size)  );
			toy1=qRound(sin(rad)*(-size)  );
			rad=theta2*3.14159265/180.0;
			tox2=qRound(cos(rad)*(-size) );
			toy2=qRound(sin(rad)*(-size)  );
			pa. putPoints(0, 3,  (tox), (toy), tox+tox1, toy+toy1 , tox+ tox2, toy+toy2 );
			setPoints (pa);
		}
		else       {
			rad=theta1*3.14159265/180.0;
			tox1=qRound( cos(rad)*(-size)  );
			toy1=qRound( sin(rad)*(-size)   );
			rad=theta2*3.14159265/180.0;
			tox2=qRound( cos(rad)*(-size)  );
			toy2=qRound( sin(rad)*(-size)   );
			pa. putPoints(0, 3, tox, toy, tox+tox1, toy+toy1 , tox+ tox2, toy+toy2 );
			setPoints (pa);
		}
	}
	else    {
		if ( fromy < toy )       {
			rad=80.0*3.14159265/180.0;
			tox1=qRound( cos(rad)*(-size)  );
			toy1=qRound( sin(rad)*(-size)   );
			rad=-80.0*3.14159265/180.0;
			tox2=qRound( cos(rad)*(size)  );
			toy2=qRound( sin(rad)*(size)   );
			pa. putPoints(0, 3, tox, toy, tox+tox1, toy+toy1 , tox+ tox2, toy+toy2 );
			setPoints (pa);
		}
		else  if ( fromy > toy )      {
			rad=80.0*3.14159265/180.0;
			tox1=qRound( cos(rad)*(size)  );
			toy1=qRound( sin(rad)*(size)   );
			rad=-80.0*3.14159265/180.0;
			tox2=qRound( cos(rad)*(-size)  );
			toy2=qRound( sin(rad)*(-size)   );
			pa. putPoints(0, 3, tox, toy, tox+tox1, toy+toy1 , tox+ tox2, toy+toy2 );
			setPoints (pa);
		}
		else         {
			pa.putPoints(0, 3,  (tox), (toy), tox, toy  , tox, toy);
			setPoints(pa);
		}
	}

}
