/****************************************************************************
 SocNetV: Social Networks Visualiser for Linux
 version: 0.43
 Written in Qt 3.3.3 with KDevelop 3.1.0  
**
** 
**
                            Arrow.h  -  description
                             -------------------
    copyright            : (C) 2005, 2006 by Dimitris B. Kalamaras
    email                : dimitris.kalamaras@compupress.gr

***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ARROW_H
#define ARROW_H

#include <qcanvas.h>
#include "actor.h"



static int Arrow_Rtti = 1006;


class Arrow : public QCanvasPolygon
{
public:
	Arrow(Actor*, Actor*, QCanvas *canvas);
	~Arrow();
	int fromActor () {return m_from;};
	int toActor () {return m_to;};

	void setFromPoint( int x, int y ) ;
	void setToPoint( int x, int y );
	void moveBy(double dx, double dy);
	int rtti () const { return   Arrow_Rtti; }
	void calculatePoints();
private:
	int m_from, m_to, fromx, fromy,tox,toy;
	int tox1, tox2, toy1,toy2;
	double rad, size;
	int theta, theta1, theta2;
	QPointArray pa;
    
};

#endif
