/***************************************************************************
 SocNetV: Social Networks Visualiser for Linux
 version: 0.43
 Written in Qt 3.3.3 with KDevelop 3.1.0  
 
                         backgrcircle.h  -  description
                             -------------------
    copyright            : (C) 2005, 2006 by Dimitris B. Kalamaras
    email                : dimitris.kalamaras@compupress.gr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "backgrcircle.h"
#include <math.h>


BackgrCircle::BackgrCircle(QCanvas *canvas, int x0, int y0, int radius) :QCanvasPolygonalItem(canvas) {
	points.makeArc ( x0-radius, y0-radius, 2*radius, 2*radius, 0, 5760 );
	QColor color=QColor("red");
	int size=1;
	QPen pen(color, size);
	this->setPen(pen);
	this->setZ(120);
}




QPointArray BackgrCircle::areaPoints() const{
	return points.boundingRect();
}


void BackgrCircle::drawShape( QPainter &painter){
	painter.drawLineSegments (points);
}


BackgrCircle::~BackgrCircle() {
	this->hide();
}






