/***************************************************************************
 SocNetV: Social Networks Visualiser for Linux
 version: 0.43
 Written in Qt 3.3.1 with KDevelop 3.1.0

                        canvasview.cpp  -  description
                             -------------------
    copyright            : (C) 2005, 2006 by Dimitris B. Kalamaras
    email                : dimitris.kalamaras@compupress.gr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "canvasview.h"
#include "app.h"


CanvasView::CanvasView( QCanvas& c, QWidget* parent,  const char* name, WFlags f)
:   QCanvasView(&c,parent,name,f)
{
//clear previousClicked Actor
previousActor=-1;

}

CanvasView::~CanvasView()
{
}

/*
void CanvasView::slotDocumentChanged()
{
  //TODO update the view

}
*/

void CanvasView::clear() {
	QCanvasItemList list = canvas()->allItems();
	for ( QCanvasItemList::Iterator it = list.begin();  it != list.end(); ++it)
		if ( *it )
			delete *it;
}


void CanvasView::contentsMousePressEvent(QMouseEvent* e) {
	QPoint p = inverseWorldMatrix().map(e->pos());
	QCanvasItemList itemList=canvas()->collisions(p);
	for (QCanvasItemList::Iterator it=itemList.begin(); it	!=itemList.end(); ++it)  {
	//	if ( (*it)->rtti() == imageRTTI )
	//	  {
	//	    ImageItem *item= (ImageItem*)(*it);
	//	    if ( !item->hit( p ) )
	//	      continue;
	//	  }
	//   if ((*it)->rtti() == sLine_RTTI )
	//    return;
		if ( (*it)->rtti() == Link_Rtti ){
			Edge *link = (Edge*) (*it);
			emit selectedLink  (link ) ;
		}
		if ( (*it)->rtti() == Actor_Rtti )  {
			Actor *jim2= (Actor*)(*it);
			emit selectedActor (jim2);
		      	if (e->button()==Qt::MidButton) {
				( (App*)parent() )->setCursor(Qt::PointingHandCursor);
				if (previousActor!=-1) {
					emit mouseCreateLink(jim1, jim2 );
					( (App*)parent() )->setCursor(Qt::ArrowCursor);
				}
				previousActor=jim2->actorNumber();	
				jim1=jim2;
			}
			else 
				previousActor=-1;
		}
		moving = *it;
		moving_start = p;
		return;
	}
	moving = 0;

}


void CanvasView::contentsMouseDoubleClickEvent ( QMouseEvent * e ) {
	QPoint p = inverseWorldMatrix().map(e->pos());
	QCanvasItemList itemList=canvas()->collisions(p);
	if (itemList.isEmpty() ) {
		emit mouseIsAt( p.x(), p.y() );
		emit mouseCreateActor(); 
 	}

}

/** On the event of a right-click, a context menu appears at the mouse position... */
void CanvasView::contentsContextMenuEvent(QContextMenuEvent* e) {
	bool noItem=true;
	QPoint p = inverseWorldMatrix().map(e->pos());
	QCanvasItemList l=canvas()->collisions(p);
	for (QCanvasItemList::Iterator it=l.begin(); it!=l.end(); ++it)
		if ( (*it)->rtti() == Actor_Rtti ) {
			Actor *jim=(Actor*)(*it);
			((App*)parent())->openActorContextMenu(e->pos(), jim)  ;
			noItem=false;       
			break;
		}
		else  if ( (*it)->rtti() == Link_Rtti )  {
			Edge *link = (Edge*) (*it);
			( (App*)parent())->openLinkContextMenu(e->pos(), link  )  ; 
			noItem=false;
			break; 
		}
		if (noItem) {
			( (App*)parent() )->openContextMenu(e->pos());
		}  
}



void CanvasView::contentsMouseMoveEvent(QMouseEvent* e) {
	if ( moving )      {
		QPoint p = inverseWorldMatrix().map(e->pos());
		if ( p.x() <= 0 || p.x() >= canvas()->width() ||  p.y() <= 0 || p.y() >= canvas()->height())
			return;
		moving->moveBy(p.x() - moving_start.x(), p.y() - moving_start.y());
		moving_start = p;
		canvas()->update();
	}

}



void CanvasView::mouseMoveEvent(QMouseEvent* e) {
	
/*
    QPoint p = inverseWorldMatrix().map(e->pos());
    QCanvasItemList l=CanvasView()->collisions(p);
    for (QCanvasItemList::Iterator it=l.begin(); it!=l.end(); ++it)
    {
  	    if ( (*it)->rtti() == Actor_Rtti )
	    {
  
    	  }
    }
    */
}


void CanvasView::viewportResizeEvent( QResizeEvent *e ) {
	int w=e->size().width();
	int h=e->size().height();
	int w0=e->oldSize().width();
	int h0=e->oldSize().height();
	double fX=  (double)(w)/(double)(w0);
	double fY= (double)(h)/(double)(h0);
	canvas()->resize(w, h);
	QCanvasItemList l=canvas()->allItems();
	emit windowResized(w, h);
	for (QCanvasItemList::Iterator it=l.begin(); it!=l.end(); ++it)
		if ( (*it)->rtti() == Actor_Rtti )  {
			Actor * jim= (Actor *) (*it);
// 			jim -> move ( jim->x() * fX , jim->y() * fY );
			jim->setX( floor( (float) jim->x() * fX ) );
			jim->setY( floor( (float) jim->y() * fY ) );
		}
}
