/***************************************************************************
 SocNetV: Social Networks Visualiser for Linux
 version: 0.43
 Written in Qt 3.3.1 with KDevelop 3.1.0
 
                         canvasview.h  -  description
                             -------------------
    copyright            : (C) 2005, 2006 by Dimitris B. Kalamaras
    email                : dimitris.kalamaras@compupress.gr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CANVASVIEW_H
#define CANVASVIEW_H


#include <qcanvas.h>
#include <qwmatrix.h>
#include <math.h>
#include "actor.h"
#include "edge.h"
class CanvasView : public QCanvasView
{
  Q_OBJECT
  public:
	CanvasView(QCanvas&, QWidget* parent=0, const char* name=0, WFlags f=0);
	~CanvasView();
	void  clear();
	void clearClickedActorHistory() {previousActor=-1;}
  protected:
	void contentsMousePressEvent(QMouseEvent*);
	void contentsMouseDoubleClickEvent ( QMouseEvent * e );
	void contentsMouseMoveEvent(QMouseEvent*);
	void mouseMoveEvent (QMouseEvent *);
	void viewportResizeEvent( QResizeEvent *e );
	void contentsContextMenuEvent(QContextMenuEvent* e);
  protected slots:
    //void slotDocumentChanged();
  
  
  signals:
	void windowResized(int,int);
	void selectedActor(Actor *);
	void selectedLink(Edge *);
	void mouseCreateLink(Actor*,Actor*);
	void mouseCreateActor();
	void mouseIsAt(int, int);
  private:
   QCanvasItem* moving;
   QPoint moving_start;
   int previousActor;
   Actor *jim1, *jim2;
  
  
};

#endif
