/***************************************************************************
 SNV: Social Networks Visualiser for Linux
 version: 0.38
 Written in Qt 3.0+ with KDevelop 2.1  

                        edge.cpp  -  description
                             -------------------
    copyright            : (C) 2005, 2006 by Dimitris B. Kalamaras
    email                : dimitris.kalamaras@compupress.gr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "edge.h"
#include "actor.h"
#include "edgeweight.h"

Edge::Edge( Actor *from, Actor *to, QCanvas *canvas, int weight , bool bez)
:QCanvasLine( canvas ) {
	bezier=bez;
 
	from->addOutLink( this );
	to->addInLink( this );
	m_fromActor = from->actorNumber();
	m_toActor = to->actorNumber();
	m_weight=weight;
	if ( from->isInLinkedWith( to->actorNumber() )) {
		isInLinked=TRUE;
		x1=int(from->x());
		y1=int(from->y());
		x2=int(to->x());
		y2=int(to->y() );

		cx = (int) ((x1+x2)/2.0);
		cy = (int) ((y1+y2)/2.0);
	}
	else {
		isInLinked=FALSE;
		x1=int(from->x());
		y1=int(from->y());
		x2=int(to->x());
		y2=int(to->y());
	
		cx = (int) ((x1+x2)/2.0);
		cy = (int) ((y1+y2)/2.0);		
	}
	cx=(int) (( cx+ x1)/2.0)+5;
	cy=(int) (( cy+ y1)/2.0)+5;
	setPoints( x1,y1, x2,y2 );	
}


void Edge::moveBy(double, double) { 
}


void Edge::setFromPoint( int x, int y ) {
	x2=endPoint().x();
	y2=endPoint().y();
	cx = (int) ((x+x2)/2.0);
	cy = (int) ((y+y2)/2.0);
	cx=(int) ((cx+ x)/2.0)+5;
	cy=(int) ((cy+ y)/2.0)+5;
	if (isInLinked){
		x1=x; y1=y;
	}
	else {
		x1=x; y1=y;
	}
	setPoints( x1,y1, x2,y2 );
	QPtrListIterator <EdgeWeight> it (weightList);
	EdgeWeight *canvasWeight;
	while (( canvasWeight = it.current() ))   	{
  	    ++it;
	    if (canvasWeight->isVisible())
	      canvasWeight->move( int(cx), int(cy) );
    	}

}

void Edge::setToPoint( int x, int y ) {
	x1=startPoint().x(); y1=startPoint().y();
	cx = (int) ((x1+x)/2.0);
	cy = (int) ((y1+y)/2.0);
	cx=(int) (( cx+ x1)/2.0)+5;
	cy=(int) (( cy+ y1)/2.0)+5;
	if (isInLinked){
		x2=x;	y2=y;
	}
	else {
		x2=x;	y2=y;
	}
	setPoints( x1,y1, x2,y2 );
	QPtrListIterator <EdgeWeight> it (weightList);
	EdgeWeight *canvasWeight;
	while (( canvasWeight = it.current() ))   	{
  		++it;
		if (canvasWeight->isVisible())
		canvasWeight->move( int(cx), int(cy) );
    	}
}


void Edge::setWeight( int w) {
	m_weight=w;  
	QPtrListIterator <EdgeWeight> it (weightList);
	EdgeWeight *canvasWeight;
	while (( canvasWeight = it.current() ))   	{
		++it;
		if (canvasWeight->isVisible())
		canvasWeight->setText( QString::number(w) );
	}
}

void Edge::clearWeightList(){
	this->weightList.clear();
}

Edge::~Edge(){

}






