/***************************************************************************
 SNV: Social Networks Visualiser for Linux
 version: 0.43
 Written in Qt 3.0+ with KDevelop 2.1
 
                         edge.h  -  description
                             -------------------
    copyright            : (C) 2005, 2006 by Dimitris B. Kalamaras
    email                : dimitris.kalamaras@compupress.gr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EDGE_H
#define EDGE_H

#include <qcanvas.h>
#include <qpainter.h>
#include <utility> //declares pair construct

using namespace std;

class Actor;
class EdgeWeight;

static int Link_Rtti=1002;

class Edge : public QCanvasLine
{

public:
	Edge(Actor*, Actor*, QCanvas *, int, bool);
	~Edge();
	bool isBezier() {return bezier; } //obsolete
	int rtti() const { return Link_Rtti; }
	void moveBy(double dx, double dy);
	void setFromPoint( int x, int y ) ;
	void setToPoint( int x, int y );
	int fromActor () { return m_fromActor;}
	int toActor () { return m_toActor;}
	void setWeight( int w) ;
	int weight() { return m_weight ; }
	void setLinkColor( QString str) {m_linkColor=str; }
	QString linkColor() { return m_linkColor ; }
	void addWeight (EdgeWeight* canvasWeight  )  { weightList.append ( canvasWeight ); }
	void clearWeightList();
	pair<int,int> center() {  return pair<int,int> (cx, cy); }
 

private:
	QPtrList<EdgeWeight> weightList;
	bool bezier, isInLinked;
	QString m_linkColor;
	int m_weight, m_fromActor, m_toActor;
    	int x1,x2, y1,y2,cx, cy;
};

#endif




    
    
