/***************************************************************************
 SocNetV: Social Networks Visualiser for Linux
 version: 0.43
 Written in Qt 3.3.3 with KDevelop 3.1.0  
 
                         graph.cpp  -  description
                             -------------------
    copyright            : (C) 2005, 2006 by Dimitris B. Kalamaras
    email                : dimitris.kalamaras@compupress.gr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "graph.h"


#include <qapplication.h>


void Graph::addVertice (int v1) { 	//adds a vertice named v1
	qDebug ("Pushing back vertice");
	Vertice a=Vertice(v1);
	m_graph.push_back(a);
	qDebug("Vertice name %i",m_graph.back().name()+1 );
	qDebug ("m_graph size  %i", m_graph.size() );
}
	
int Graph::findVertice (int v1) {	//finds a vertice named v1
	qDebug("find Vertice %i", v1);
	qDebug ("m_graph size  %i", m_graph.size() );
	int index=0;
	for (vector<Vertice>::iterator it=m_graph.begin(); it!=m_graph.end(); it++) {
		qDebug ("index %i ", index);
		qDebug ("vertice - name  %i", m_graph[index].name());
		if ( (*it).name() == v1) {
			qDebug ("Found vertice %i with declared name %i", index, v1);
			return index;
		}
		index++;
	}
	return -1;
}

void Graph::addEdge (int v1, int v2) {		//creates an edge from vertice named v1 to v2
	qDebug ("addEdge between %i and %i", v1,v2);
	m_graph[findVertice(v1)].addEdge(v2);
}
	
void Graph::removeEdge (int v1, int v2) {	//removes the edge from v1 to v2
	m_graph[findVertice(v1)].removeEdge(v2);
}

bool Graph::hasEdge (int v1, int v2) {		//checks if there is an edge from v1 to v2
	int i=findVertice(v1);
	return m_graph[i].edge(v2);
}

int Graph::edges (int i) {  
	return m_graph[findVertice(i)].size();
}

int Graph::vertices () { return m_graph.size();}

Graph::~Graph() {
 		m_graph.clear();
	}

