/****************************************************************************
 SocNetV: Social Networks Visualiser for Linux
 version: 0.43.1
 Written in Qt 3.3.3 with KDevelop 3.1.0  
 
** htmlviewer.h
**
**
** This class is a copy of a Qt example.
**
*****************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef HTMLVIEWER_H
#define HTMLVIEWER_H

#include <qmainwindow.h>
#include <qtextbrowser.h>
#include <qstringlist.h>
#include <qmap.h>
#include <qdir.h>

class QComboBox;
class QPopupMenu;

class HTMLViewer : public QMainWindow
{
    Q_OBJECT
public:
    HTMLViewer( const QString& home_,  const QString& path, QWidget* parent = 0, const char *name=0 );
    ~HTMLViewer();

private slots:
    void setBackwardAvailable( bool );
    void setForwardAvailable( bool );

    void sourceChanged( const QString& );
    void about();
    void aboutQt();
    void openFile();
    void newWindow();
    void print();

    void pathSelected( const QString & );
    void histChosen( int );
    void bookmChosen( int );
    void addBookmark();

private:
    void readHistory();
    void readBookmarks();

    QTextBrowser* browser;
    QComboBox *pathCombo;
    int backwardId, forwardId;
    QStringList history, bookmarks;
    QMap<int, QString> mHistory, mBookmarks;
    QPopupMenu *hist, *bookm;

};





#endif

