/***************************************************************************
 SocNetV: Social Networks Visualiser for Linux
 version: 0.43
 Written in Qt 3.3.3 with KDevelop 3.1.0  

                        matrix  -  description
                             -------------------
    copyright            : (C) 2005, 2006 by Dimitris B. Kalamaras
    email                : dimitris.kalamaras@compupress.gr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "matrix.h"

	//assigment allows sane copying b=a where b,a matrices
 Matrix& Matrix::operator =(Matrix & a) {
			if (this != &a){
				if (a.m_Actors!=m_Actors) {
					delete [] row;
					row=new Row[m_Actors=a.m_Actors];
					Q_CHECK_PTR( row );
					for (int i=0;i<m_Actors; i++) { 
						row[i].resize(m_Actors); //every Row object holds max_int=32762 actors
					}
				}

				for (int i=0;i<m_Actors; i++) row[i]=a.row[i];
			}
			return *this;
}
		
//slowing  down the process
int  Matrix::operator ()  (const int r, const int c){
			return  row[r].column(c);
}
		
//outputs matrix m to a stream
QTextStream& operator <<  (QTextStream& os, Matrix& m){
			for (register int r = 0; r < m.rows(); ++r) {
				for (register int c = 0; c < m.cols(); ++c)
					os << m(r,c) << '\t';
				os << '\n';
			}
			return os;
}
		
//takes two (ActorsXActors) matrices and returns their product as a reference to this
Matrix& Matrix::product( Matrix &a, Matrix & b, bool symmetry)  {
		   	for (register int i=0;i< rows();i++)
        			for (register int j=0;j<cols();j++) {
					
					setItem(i,j,0);
            					for (register int k=0;k<m_Actors;k++)
			 				if  ( k > j && symmetry) {
								if (a.item(i,k)!=0 && b.item(j,k)!=0)
									setItem(i,j, item(i,j)+a.item(i,k)*b.item(j,k));
									
							}
							else{
								setItem(i,j, item(i,j)+a.item(i,k)*b.item(k,j));
							}
				}
			return *this;
}
		
//takes two (AXA) matrices (symmetric) and outputs an upper triangular matrix
Matrix& Matrix::productSym( Matrix &a, Matrix & b)  {
		
		   	for (register int i=0;i<m_Actors;i++)
        			for (register int j=0;j<m_Actors;j++) {
					setItem(i,j,0);
					if (i>=j) continue;
            				for (register int k=0;k<m_Actors;k++)
			 			if  ( k > j ) {
							if (a.item(i,k)!=0 && b.item(j,k)!=0)
								setItem(i,j, item(i,j)+a.item(i,k)*b.item(j,k));
						}
						else  //k <= j  && i<j
							if ( i>k ) {
								if (a.item(k,i)!=0 && b.item(k,j)!=0)
									setItem(i,j, item(i,j)+a.item(k,i)*b.item(k,j));
							}
							else {
								if (a.item(i,k)!=0 && b.item(k,j)!=0)
									setItem(i,j, item(i,j)+a.item(i,k)*b.item(k,j));
							}
				}
			return *this;
}
	
Matrix& Matrix::pow (Matrix &a, int power, bool symmetry)  {
		Matrix t=a;
		for (register int k=1; k<power; k++){
			product(a,t, symmetry);
			t=*this;  	  //SET TempMatrix EQUAL TO ProductMatrix		  

		}
		return *this;
}
		
		
void Matrix::resize (int Actors) {
		delete [] row;
 		row = new Row [m_Actors=Actors];  
		Q_CHECK_PTR( row );
		P.clear();
		T.clear();
		V.clear();
		map.clear();
		for (int i=0;i<m_Actors; i++) { 
				row[i].resize(m_Actors); //every Row object holds max_int=32762
		}
			
}
//INPUTS:		
// a: sociomatrix
//OUTPUTS
// THIS d: matrix of distances
// s: matrix with each element (i,j) denoting the number of shortest paths from i to j
Matrix & Matrix::distanceMatrixBF(Matrix &a, Matrix &s, bool symmetry){
	int Actors=a.rows();
	
	//Start a breadth-first search 
	//INPUTS:
	//	a, the sociomatrix
	//OUTPUTS
	//	d, the distance matrix
	//	s, the matrix of the numbers of shortest paths
	//	source, the source acotr
	//	distance, the initial depth (distance) =0
	// 	cur, denotes the current actor in the BF Algorithm
	
	
	Matrix d;
	d.resize(Actors);
	vector<int> visited(Actors);  //list of size: Actors -- possible values are:
				//  0 (WHITE) = unvisited actor
				//  1 (GREY)  = discovered but has undiscovered neightbors
				//  2 (BLACK) = discovered and all neightbors discovered as well
	qDebug("Starting BF");
	
	for ( int source=0; source< Actors; source++)	{
		qDebug("Source Actor: %i", source+1);
		qDebug("Clearing History");
		for (int j=0; j<Actors; j++)	
			visited[j]=0;
		visited[source]=1;
		
		Q.clear();
		qDebug("PRECAUTION: Total Actors in Queue: %i", Q.size());
		Q.push_back(source);
		qDebug("Added source. Now total Actors in Queue: %i", Q.size());	
		levelLast=source;
		
		breadthFirst(a, Actors, d, s, source , 0, source, visited, symmetry);
	}
	*this=d;

}


void Matrix::breadthFirst(Matrix &a, int Actors, Matrix &d, Matrix &s, int source, int distance, int cur, vector<int>& visited, bool symmetry)  {
		qDebug("Inside BF - Find neighbors of current actor %i - DEPTH: %i ", cur+1, distance);
//		int neighborsOfCurrentActor=0;
		d.setItem(source, cur, distance);  //SET DISTANCE MATRIX

		qDebug ("distance(source,cur)=d(%i,%i)=%i",source+1, cur+1, distance);
		visited[cur]=2;	//SET HER VISITED AT LEAST ONCE (BUT NOT HER NEIGHBORS)
		qDebug("Current actor %i color as 2=black", cur+1);
		for (int j=0; j<Actors; j++)	{//FIND THE NEIGHBORS OF CURRENT ACTOR.
			qDebug("Current actor: %i, Possible Neighbor %i", cur+1, j+1);
			if ( j == cur || visited[j] == 2 ){ 	// IF THIS ONE IS THE CURRENT ACTOR OR HASB EEN DISCOVERED
				if ( visited[j] == 2 ) 
					qDebug("Skipping actor %i. It has been visited", j+1);
				else 
					qDebug("Skipping actor %i. Is is the current actor", j+1);
				continue;			// SKIP 
				
			}
			else if ( a.item(cur,j)!=0  ) {   //J IS A NEIGHBOR OF CURRENT
				d.setItem(cur, j, 1);
				qDebug("Actor %i IS A neighbor of the current actor %i", j+1, cur+1);
				  //SET DISTANCE MATRIX
				//qDebug("I set distance from source (%i, %i)=%i",source+1,  j+1, distance);

				Q.push_back(j);		//PUSH TO THE QUEUE
//				neighborsOfCurrentActor++;
//				qDebug("Total neighbors of current actor are %i:",neighborsOfCurrentActor);
				qDebug("I pushed neighbor %i to the Queue, Total Actors in Queue %i",j+1, Q.size());
				if ( visited[j] == 0)  {	//IS THIS THE FIRST VISIT TO CURRENT ACTOR ?
			 		visited[j]=1;	//SET HER VISITED AT LEAST ONCE (BUT NOT HER CHILDREN)
					qDebug("Actor %i was first-time visited. Set her color as 1=grey", j+1);
				}
			}
			else if (a.item(cur,j)==0) {
				qDebug("Actor %i IS NOT neighbor of the current actor", j+1);
			}
		}
	
		if (Q.front()==Q.back()) { qDebug ("END OF SEARCH FOR SOURCE ACTOR!" ); return; }
		qDebug("Check if this actor is the last of this level...Current = %i, levelLast = %i",cur+1, levelLast+1);
		if (cur==levelLast) {
			qDebug("YES!. ACTOR %i IS THE LAST OF THE CURRENT LEVEL", levelLast+1);
			levelLast=Q.back();
			++distance;
			qDebug("NEW DISTANCE %i, NEXT LEVEL'S LAST ACTOR IS %i", distance, levelLast+1);
		}
		else qDebug ("No current != levelLast");
		
		
		int next=Q.front();  //check if empty
		qDebug("First Actor in Queue is %i. Deleting him ", next+1);
		
		
		Q.pop_front();
		next=Q.front();
		qDebug("Now first Actor to call BF in Queue is %i", next+1);
		qDebug("Next level change will occur at actor %i",levelLast+1);

		
		qDebug("OK. Now lets call BF for actor %i with distance %i", next+1, distance);
		breadthFirst( a, Actors, d, s, source, distance, next  , visited, symmetry);

}


//Returns the distance matrix of sociomatrix sm
Matrix& Matrix::distanceMatrixDijkstra(Matrix &sm, Matrix &sigma, int &netDiameter, bool symmetry){
	qDebug("distanceMatrixDijkstra()");
	int temp=0, cur, Actors=sm.rows();
	bool isolated=TRUE; //  BECOMES FALSE IF AN ACTOR IS CONNECTED TO SOMEONE ELSE.
	V.clear();	
	qDebug ("Creating vertices Vector");
	for ( cur=0;cur<Actors; cur++) 
		V.push_back ( cur );
	
// 	for (QValueList<int>::iterator it=V.begin(); it!=V.end();it++) {
// 	 qDebug("V %i", (*it));
// 	}
	qDebug( "V counts %i vertices", V.count());
	
	
	/** sm is the sociomatrix
	   sigma is the matrix where (i,j) denotes s(i,j)=number of minimum paths between vertices i and j 
	   this* is the matrix of distances.
	   V is the list of all actors
	   P is the list of visited vertices.
	   T is by definition V-P
	   s denotes the source actor
	   t denotes some actor in T
	
	   l(t) is the index of t relative to P, namely the length of a minimum path
	  		between s and t via only vertices of P
	  minL(t) is the minimum of all l(t)	
	  minL(t) is actually the geodesic distance between s and t.
	  Xmin	 denotes the actor t who has the minimum l(t) from s. 
	  Xmin is the actor, which is added in P in every loop.
	   map holds the l(t) for every actor in each loop

	
	   STEP 1 
	   Initially P = {s} and T=V-P. 
	   For every t in T, set l(t)=w(s,t).
	*/
	for ( int s=0; s< Actors; s++) {
		qDebug("New source vertice s=%i", s+1);
		qDebug("Initially, l(t) = w(s,t), for every other vertice t. If t not connected with s, then l(t)=RAND_MAX.");
		minLt=RAND_MAX;
		isolated=TRUE;	
		/**Initial step: Calculate l(t)=weight(s,t) for every other actor t. */
		for ( int t=0; t< Actors; t++) {
			if ((temp=sm.item(s,t))!=0  ) {
				isolated=FALSE;
				qDebug(" s =%i and t=%i are directly connected. Setting geodesic distance = weight", s+1, t+1);
				setItem(s,t, temp); //s and t are directly connected. Set their distance 1
				qDebug(" There is only one minimum path from s to t. Setting sigma(s,t) = 1");
				sigma.setItem(s,t,1);  //and only one minimum path from s to t exists.
				map [t]=temp;
				if (temp < minLt ) { 
					minLt = temp;
					Xmin=t;
				}
			}
			else
				map [t]=RAND_MAX; 
			qDebug ("Set l(%i)=w(%i,%i)=map[%i]=%i",t+1,s+1,t+1,t+1,map[t]);
		}
		/** if s is not connected to some actor, continue*/
		if (isolated)  {
			qDebug("Current vertice s is isolated. Setting all distances zero and continuing with next s in V");
			for ( int t=0; t< Actors; t++) {
				setItem (s, t,0);
			}
			continue;
		}
		
		qDebug ("Vertice %i has the minimum l(t) = %i",Xmin+1,minLt);
		
		qDebug ("Creating T=V");
		T=V;  
		T.remove(s);
		qDebug ("Removed s= %i from T. T counts %i vertices. ", s+1, T.count());
		qDebug ("Clearing P. Adding s to P.");
		P.clear(); //clear array which holds the PATH from s to t
		P.push_back(s);
		//loop to find distance of s from every t in T
		qDebug("Looping over every t in T to calculate distances from source s = %i ", s+1);
		for ( int t=0; t<Actors ; t++) {
			qDebug("New target t = %i. Finding geodesic distance between  (s ,t) = (%i,%i)", t+1,s+1,t+1);
			//is vertice t in T ? if no, skip it, it must be in P (already visited).
			if ( T.contains(t)==0 ) {
				qDebug ("It seems that distance (s, %i) has been already calculated and t removed from T. Skipping.", t+1); 
				if (netDiameter < temp) netDiameter=temp; //???????????????? initialisation?
				qDebug("New network diameter is %i", netDiameter);
				continue;
			}
			//s=t.
			if (s==t) { setItem(s,t,0); qDebug ("Target t=s. Therefore, set d(%i,%i)=0",s+1,t+1);}
			//if s!=t and symmetric matrix, then we do not need to calculate again geodesic and sigmas
			else if (s>t && symmetry) {	
				qDebug ("Sociomatrix is symmetric. Using uppertriangular distance d(%i,%i)=%i",t+1,s+1,item( t,s ));
				setItem( s,t, item( t,s ) );
				qDebug ("Sociomatrix is symmetric. Using uppertriangular sigma(%i,%i)=%i",t+1,s+1,sigma.item( t,s ));
				sigma.setItem(s,t, sigma.item(t,s) );	
			}
			//else check if t has minimum l(t), else call dijkstra(Xmin,t)
			else {
				//if t is the one with the minimum l(t), then distance(s,t)=l(t).
				if (Xmin == t) {
					qDebug("Target t=%i has minimum l(t). Setting d(s,t)=minLt=%i ",Xmin+1,minLt);
					setItem(s,t,minLt);
					qDebug(" Calling calcSigma(%i, %i)",s+1, t+1);
					calcSigma(s,t, sm, sigma);
					
					if (netDiameter < minLt) netDiameter=minLt;
					qDebug("New network diameter is %i", netDiameter);
				}
				else {	
				//call dikstra() to calculate geodesic distance (Xmin, t)
					qDebug("Target t=%i does not have minLt. Calling dikstra() for d(Xmin,t)=(%i,%i)", t+1, Xmin+1,t+1 );
					temp=dijkstra (s, Xmin, t, sm, sigma, symmetry);
					
					if (minLt == RAND_MAX) {
						qDebug ("minLt=RANDMAX. There is no path between s and t=Xmin. Setting zero distance. ");
						setItem (s, t, 0);
					}
					else if (temp == 0 ){
						qDebug ("dikstra returned 0. There is no path between s and t=Xmin. Setting zero distance. ");
						setItem (s, t, 0);
					}
					else {
						qDebug ("There is a path between s and t=Xmin.");
						qDebug("CAUTION: Distance(s,t=Xmin) should be set l(t), already." );
// 						setItem(s,t, temp);
// 						qDebug(" Calling calcSigma(%i, %i)",s+1, t+1);
// 						calcSigma(s,t, sm, sigma);
						if (netDiameter < temp) netDiameter=temp;
						qDebug("New network diameter is %i", netDiameter);
					}
	
					qDebug("dikstra() finished OK. distance (%i,%i)=%i",s+1,t+1,item(s,t));
				}
			}
		}
	}
}

//This algorithm: Dikstra's Shortest Path Algorithm implemented from
// Liu, C.L. (2000) "Elements of Discrete Mathematics 2nd Edition", Greek Translation, pp. 183

// Returns the minimum geodesic distance between Xmin and target vertices of  sociomatrix a
int Matrix::dijkstra(int row, int x, int target, Matrix &sm, Matrix &sigma, bool symmetry){
	qDebug("Dijkstra()");
 	// STEP 1: P' = P + {x} 
	
	qDebug ( "For x (vertice having the minLt) = %i and t = %i", x+1, target+1 );
	qDebug("I must delete x from T and add it to P.");
	qDebug ("Adding x=%i to P", x+1);
	if (!P.contains(x) )  //DO NOT ADD HIM TWICE IN P
		P.push_back( x );  
	else qDebug ("x already in P");
// 	for (QValueList<int>::iterator it=P.begin(); it!=P.end();it++) {
// 	  qDebug("P' includes vertice %i", (*it)+1);
// 	}
// 	qDebug( "In total, P' counts %i vertices", P.count());
// 	for (QValueList<int>::iterator it=T.begin(); it!=T.end();it++) {
// 	  qDebug("T includes %i", (*it)+1);
// 	}
// 	qDebug( "In total,T counts %i vertices", T.count());
	
	qDebug("Removing x=%i from T", x+1);
	// T' = T-{x}
	if (T.contains(x)) {
		if (T.remove (x) !=1 ) qDebug ("Error while removing x = %i from T", x+1);
	}
	else {
		qDebug("x already deleted from T");	
	}
	//MAYBE ADDING A CHECK IF X IS NOT CONNECTED TO EVERY REMAINING t IN T, THEN  TO ABORT SETTING ZERO DISTANCE.
	qDebug( "T' counts %i vertices", T.count());
// 	for (QValueList<int>::iterator it=T.begin(); it!=T.end();it++) {
// 	  qDebug("T' includes vertice %i", (*it)+1);
// 	}
	qDebug("Calculating l(t) relative to P', for every t in T', from x=%i", x+1);
	
	// STEP 2: find vertice t of minimum l(t) relative to vertices of P. 
	// return a pair (vertice,  index), named pair1.
	pair1=minimum_lt_P(x, sm, symmetry);
	//if pair1.first > -1, pair1.first is the vertice closer to x.
	//setItem(x, pair1.first, pair1.second);
	//If pair1.first = -2, every remaining t in T is not connected with source=Xmin.
	if ( pair1.first == -2 ) {
		qDebug("It seems that none of the remaining t in T' is connected with Xmin = %i. ", Xmin+1);
		qDebug ("Returning zero distance");
		return 0;
	}
	qDebug(" Vertice t = %i has minimum l(t)=%i, among all t in T', from source s=%i",pair1.first+1, pair1.second, row+1);
	Xmin=pair1.first;
	minLt=pair1.second;
	qDebug ("Setting new Xmin = t = %i and minimum l(t) = %i ", Xmin+1, minLt);
	if (minLt == RAND_MAX) {
		//WORK
		qDebug ("minLt=RANDMAX. There is no path between s and t=Xmin. Setting zero distance. ");
		setItem (row, Xmin, 0);
		qDebug("OK, zero distance (%i,%i)=%i",row+1,Xmin+1,item(row,Xmin));
	}
	else {
		qDebug ("There is a path between s and t=Xmin. Setting distance minimum l(t)." );
		setItem (row, Xmin, minLt);
		qDebug("Calling calcSigma(row, Xmin)");
		calcSigma(row,Xmin, sm, sigma);
		qDebug("OK, distance (%i,%i)=%i",row+1,Xmin+1,item(row,Xmin));
		
	}
	
	// STEP 3: if we have arrived at target return sum_of_weights traversed as distance(xmin, target)
	if (pair1.first==target) {   
		
		qDebug("Xmin is the target, distance (source, Xmin)= %i. Removing this actor from T", item(row,Xmin));
		qDebug ( "l(t) for Xmin = map [%i]=%i", Xmin+1,map[Xmin]);
		if (T.remove (pair1.first) !=1 ) qDebug ("ERROR in removal of Xmin from T");
// 		for (QValueList<int>::iterator it=T.begin(); it!=T.end();it++) {
// 	 	 	qDebug("T %i", (*it)+1);
// 		}
		qDebug ("Returning.");
		return pair1.second;
	}
	else { //ELSE continue dijksta(x, z), where x has the min l(t)
		
		qDebug("CONTINUING dijkstra for actors (%i,%i), distance so far is %i", pair1.first+1, target+1,pair1.second);
		dijkstra (row, pair1.first, target, sm, sigma, symmetry); 
		
	}
	
}

//returns the minimum of a and b where a and b != 0
int Matrix::minimum(int a, int b){
	
	if (a==0) return b;
	if (b==0) return a;
	if (a<=b) return a;
	return b;

}

//finds l(t) for every t e T; 
//l(t): index of minimum path distance between (s, t) including only vertices of P = V-T
//returns a pair (actor,  index), where actor has the minimum l(t) over all t e T
//returns (-2, XX) when every t in T is not connected to source vertice.
pair<int,int> Matrix::minimum_lt_P(int source,  Matrix &sm, bool symmetry){
	qDebug("minimum_lt_P()");
	int minP=-2, minP_Value=RAND_MAX,  cur=0, wxt=0, lt;
	//minP remains -2 only when every remaining t in T is not connected with source=Xmin.

	qDebug("T has %i vertices:", T.count());	//also for sanity...
	for (QValueList<int>::iterator it=T.begin(); it!=T.end();it++){
		cur=(*it);
		lt=map[cur];
		qDebug("t=%i with lt = %i", cur+1, lt);
		// l'(t)=min { l(t), l(x)+w(x,t)}
		qDebug("Calculating new l'(t)=min { l(t), l(x)+w(x,t)}");
		if ( (wxt=sm.item(source,cur) )!=0 ) {
			//if (map[source]==RAND_MAX) map[source]=0;
			qDebug ("wxt!=0 , l'(t) = minimum of %i and %i", lt , map[source]+wxt);
			lt=map[cur]=minimum ( lt, map[source]+wxt) ;
			qDebug(	" l'(%i)=%i ", cur+1, lt);
			if ( lt < minP_Value) { 
				minP=cur; 
				minP_Value=lt;
				qDebug("New minimum l'(%i) =  %i", cur+1,  lt);
			}
		}
		else {//w(x,t)=inf therefore l'(t)=l(t);
			qDebug("wxt=0. Therefore l'=l.");
			if ( lt < minP_Value && lt !=RAND_MAX) { 
				minP=cur; 
				minP_Value=lt;
				qDebug("l'=l. Furthermore, new minimum l'(t) =%i",  lt);
			}
			else qDebug("l=l'. No new minimum. Continue with next t in T");
			
		}
		
	}
	qDebug ("minimum_lt_P has finished. Returning pair: (actor, value)=(%i,%i)", minP+1, minP_Value);
	return pair<int,int> (minP, minP_Value);

	
}


//Combinatorial Shortest-path counting
//New sigma(s,t)=Sum of sigma(s,u) where u neighbors of t lying on minimum path.

void Matrix::calcSigma(int s , int t,  Matrix &sm, Matrix &sigma ){
	int dum;
	qDebug("Initially, sigma(s,t)=sigma(%i,%i)=%i",s+1,t+1, sigma.item(s,t));
	if ( sm.item (s, t ) !=0 )  {
		qDebug("s=%i linked with t=%i, therefore sigma(s,t)=1 and returning.", s+1, t+1);
		return;
	}
	if ( sigma.item (s, t ) !=0 )  {
		qDebug("sigma(s,t)=sigma(%i, %i)=%i already calculated. Returning.", s+1, t+1, sigma.item(s,t));
		return;
	}
	for (QValueList<int>::iterator it=P.begin(); it!=P.end();it++) {
		qDebug("P' includes vertice u=%i", (*it)+1);
		if ( (*it) == s ) { qDebug ("which is s. Skipping"); continue;}
		if (  (dum = sm.item( (*it), t )) !=0 ) {
			qDebug("u is linked with t. Checking if u belongs in the set of predecessors of t, Ps(t)");
			qDebug("d(s,t)=(%i,%i)= %i, d(s,cur)=(%i,%i)=%i", s+1,t+1,item(s,t), s+1, (*it)+1,item(s, (*it)) );
			if ( ( item(s, (*it)) + dum ) == item(s,t)  ) {
				qDebug("d(s,t) = d(s,u)+ w(u, t)");
				qDebug(" sigma(s,u)=(%i,%i)=%i will be added to sigma(s,t)", s+1, (*it)+1, sigma.item(s,(*it)) );
				sigma.setItem(s,t, sigma.item(s,t)+sigma.item(s,(*it)) );
			} 
			else	{
				qDebug("u is not in the set of predecessors of t");
			}
			
		}
		else {
			qDebug(" %i not linked with t=%i", (*it)+1, t+1);
		}
		
	}
	qDebug("Total new sigma(%i, %i)=%i", s+1,t+1, sigma.item(s,t));
}

