/***************************************************************************
 SNV: Social Networks Visualiser for Linux
 version: 0.43
 Written in Qt 3.3.3 with KDevelop 3.1.0  
                          matrix.h  -  description
                             -------------------
    copyright            : (C) 2005, 2006 by dimitris kalamaras
    email                : dimitris.kalamaras@compupress.gr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef MATRIX_H
#define MATRIX_H
using namespace std;


#include <qglobal.h>		//used for qDebug function
#include <qtextstream.h>

#include <qvaluelist.h>


#include <qmap.h>
//#include <list>   //the problem with list is that it does not have any remove(Type X) member...
#include <utility> //declares pair construct
#include <deque>
#include <vector>



class Row {
public:
	Row (int Actors=1500) {
		cell=new  int [m_Actors=Actors];
		Q_CHECK_PTR( cell );
	}
	~Row() {delete [] cell;}
	
	Row& operator =(Row & a) {
			if (this != &a){
				if (a.m_Actors!=m_Actors) {
					delete [] cell;
					cell=new  int[m_Actors=a.m_Actors];
					Q_CHECK_PTR( cell);
				}
				for (int i=0;i<m_Actors; i++) cell[i]=a.cell[i];
			}
			return *this;
	}
	
	int column ( int c ) const {
		return cell[c];
	}
	
	void setColumn (int index, int elem) {
		cell[index]=elem;
	}
	
	void resize(int Actors) {
		delete [] cell;
		cell=new  int[m_Actors=Actors];
		Q_CHECK_PTR( cell);
		
		for (int i=0;i<m_Actors; i++) { 
			cell[i]=0;
		}
	}
	

private:
	int *cell;
	int m_Actors;
};




class Matrix {
	public:
		//default constructor  -- Not Actually used. Everything goes through resize(int)
 		Matrix (int Actors=1500 )   {
			row=new  Row[m_Actors=Actors];
		        Q_CHECK_PTR( row );
		}
		//copy constructor allows Matrix b=a  declaration
		Matrix(const Matrix &b) {
			row = new Row[m_Actors=b.m_Actors];
			for (int i=0;i<m_Actors; i++) { 
				row[i].resize(m_Actors); //every Row object holds max_int=32762
			}
			for (int i=0; i<m_Actors; i++) row[i]=b.row[i];
		}

		~Matrix() { delete [] row; }		

		//Resize function. This is the main function of the matrix implementation. 
		//Needs to be called before every operation on new matrixes. 
		void resize (int Actors) ;
		
		//equals two matrices.		
		Matrix& operator =(Matrix & a);
		
		int  operator ()  (const int r, const int c) ;
		
		friend QTextStream& operator <<  (QTextStream& os, Matrix& m);
		
		//Fulls a matrix with a value 
		void fillMatrix (int value )   {
			for (int i=0;i<m_Actors; i++) 
				for (int j=0;j<m_Actors; j++) 
					setItem(i,j, value);
		}
		
		//takes two (ActorsXActors) matrices and returns their product as a reference to this
		Matrix & product( Matrix &a, Matrix & b, bool symmetry) ;		
		
		//takes two (AXA) matrices (symmetric) and outputs an upper triangular matrix
		Matrix & productSym( Matrix &a, Matrix & b)  ;
		
		Matrix & pow (Matrix &a, int power, bool symmetry)  ;
		Matrix & distanceMatrixBF(Matrix &a, Matrix &s, bool symmetry);
		void breadthFirst(Matrix &a, int Actors, Matrix &d, Matrix &s, int source, int distance, int cur, vector<int>& visited, bool symmetry);

		Matrix & distanceMatrixDijkstra(Matrix &sm, Matrix &sigma, int &nd, bool symmetry);		
		int dijkstra (int row, int source, int target, Matrix &sm, Matrix &sigma, bool symmetry);
		pair<int,int> minimum_lt_P(int,  Matrix &sm, bool symmetry);
				
		int minimum(int,int);
		void calcSigma(int,int, Matrix &sm, Matrix &sigma);

		
		int item( int r, int c )     { 	return row[r].column(c);	}
		
		void setItem( int r, int c, int elem )   { row [ r  ].setColumn(c, elem); }
		
		void clearItem( int r, int c ) { row[r].setColumn(c,0); }
		
		int cols() {return m_Actors;}
		int rows() {return m_Actors;}

	private:
		Row *row;
    		int m_Actors, minLt, Xmin ;
		int *vec;
		pair<int,int> pair1;
		QValueList<int> P, T, V;
		QMap <int, int> map;
		deque<int> Q;	//stack containing discovered / children
		int levelLast;	
		

};





#endif
