/****************************************************************************
 SocNetV: Social Networks Visualiser for Linux
 version: 0.43
**
**  texteditor.cpp    
**
**
**
** Copied from the TrollTech ApplicationWindow example.
**
******************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/



#include "texteditor.h"


#include <qimage.h>
#include <qpixmap.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qtextedit.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qstatusbar.h>
#include <qmessagebox.h>
#include <qprinter.h>
#include <qapplication.h>
#include <qaccel.h>
#include <qtextstream.h>
#include <qpainter.h>
#include <qpaintdevicemetrics.h>
#include <qwhatsthis.h>

#include "images/filesave.xpm"
#include "images/fileopen.xpm"
#include "images/fileprint.xpm"




TextEditor::TextEditor( const QString &fileName )
    : QMainWindow( 0, "editor main window", WDestructiveClose )
{
    printer = new QPrinter;
    QPixmap openIcon, saveIcon, printIcon;

    //CREATE A TOOLBAR
    QToolBar * fileTools = new QToolBar( this, "file operations" );
    fileTools->setLabel( "File Operations" );

    openIcon = QPixmap( fileopen );
    QToolButton * fileOpen
	= new QToolButton( openIcon, "Open File", QString::null,
			   this, SLOT(choose()), fileTools, "open file" );

    saveIcon = QPixmap( filesave );
    QToolButton * fileSave
	= new QToolButton( saveIcon, "Save File", QString::null,
			   this, SLOT(save()), fileTools, "save file" );

    printIcon = QPixmap( fileprint );
    QToolButton * filePrint
	= new QToolButton( printIcon, "Print File", QString::null,
			   this, SLOT(print()), fileTools, "print file" );


    (void)QWhatsThis::whatsThisButton( fileTools );

    const char * fileOpenText = "<p><img source=\"fileopen\"> "
	         "Click this button to open a <em>new textfile</em>.<br>"
                 "You can also select the <b>Open</b> command "
                 "from the <b>File</b> menu.</p>";

    QWhatsThis::add( fileOpen, fileOpenText );

    QMimeSourceFactory::defaultFactory()->setPixmap( "fileopen", openIcon );

    const char * fileSaveText = "<p>Click this button to save the textfile you "
                 "are editing. You will be prompted for a file name.\n"
                 "You can also select the <b>Save</b> command "
                 "from the <b>File</b> menu.</p>";

    QWhatsThis::add( fileSave, fileSaveText );

    const char * filePrintText = "Click this button to print the file you "
                 "are editing.\n"
		 "You can also select the Print command "
		 "from the File menu.";

    QWhatsThis::add( filePrint, filePrintText );


    //CREATE A POPUPMENU. ADD SOME ITEMS
    QPopupMenu * file = new QPopupMenu( this );
    menuBar()->insertItem( "&File", file );
    

    int id;
    id = file->insertItem( openIcon, "&Open...",
			   this, SLOT(choose()), CTRL+Key_O );
    file->setWhatsThis( id, fileOpenText );

    id = file->insertItem( saveIcon, "&Save",
			   this, SLOT(save()), CTRL+Key_S );
    file->setWhatsThis( id, fileSaveText );

    id = file->insertItem( "Save &As...", this, SLOT(saveAs()) );
    file->setWhatsThis( id, fileSaveText );

    file->insertSeparator();

    id = file->insertItem( printIcon, "&Print...",
			   this, SLOT(print()), CTRL+Key_P );
    file->setWhatsThis( id, filePrintText );

    file->insertSeparator();

    file->insertItem( "&Close", this, SLOT(close()), CTRL+Key_W );

    file->insertItem( "&Quit", this, SLOT( close() ), CTRL+Key_Q );

    menuBar()->insertSeparator();



    QPopupMenu * help = new QPopupMenu( this );
    menuBar()->insertItem( "&Help", help );

    help->insertItem( "&About", this, SLOT(about()), Key_F1 );
    help->insertItem( "About &Qt", this, SLOT(aboutQt()) );
    help->insertSeparator();
    help->insertItem( "What's &This", this, SLOT(whatsThis()), SHIFT+Key_F1 );

    e = new QTextEdit( this, "editor" );
    e->setFocus();
    setCentralWidget( e );
    resize( 640,400  );
    e->setCaption("-SocNetV- Network Text editor"  );
    e->setWordWrap(QTextEdit::NoWrap );

	qDebug("TextEditor()");
    if (fileName)    {
        	QFile f( fileName );
          	if ( !f.open( IO_ReadOnly ) )
          	 	 return;
        	QTextStream ts( &f );
        	e->setText( ts.read() );
        	e->setModified( FALSE );
	          justFileName=QStringList::split ("/", fileName );
	   	f.close();
      }



statusBar()->message( "Ready", 2000 );



}


TextEditor::~TextEditor()
{
    delete printer;
}




void TextEditor::choose(){
    QString fn = QFileDialog::getOpenFileName( QString::null, QString::null, this);
    if ( !fn.isEmpty() )    {
    	load( fn );
      	justFileName=QStringList::split ("/", fn );
     }
    else
    	statusBar()->message( "Loading aborted", 2000 );
}


void TextEditor::load( const QString &fileName )
{
    QFile f( fileName );
    if ( !f.open( IO_ReadOnly ) )
	return;

    QTextStream ts( &f );
    e->setText( ts.read() );
    e->setModified( FALSE );

   	e->setCaption("-text editor- " + justFileName.last() ) ;

    statusBar()->message( "Loaded network text " +justFileName.last() , 2000 );
}


void TextEditor::save(){
    if ( filename.isEmpty() ) {
	saveAs();
	return;
    }
    QString text = e->text();
    QFile f( filename );
    if ( !f.open( IO_WriteOnly ) ) {
    	statusBar()->message( QString("Could not write to %1").arg(filename),
			      2000 );
	return;
    }
    QTextStream t( &f );
    t << text;
    f.close();
    e->setModified( FALSE );
    statusBar()->message( QString( "File %1 saved" ).arg( justFileName.last() ), 2000 );
}


void TextEditor::saveAs()
{
    QString fn = QFileDialog::getSaveFileName( QString::null, QString::null,
					       this );
    if ( !fn.isEmpty() ) {
	filename = fn;
	save();
    } else {
	statusBar()->message( "Saving aborted", 2000 );
    }
}


void TextEditor::print()
{
    // ###### Rewrite to use QSimpleRichText to print here as well
    const int Margin = 10;
    int pageNo = 1;

    if ( printer->setup(this) ) {		// printer dialog
	statusBar()->message( "Printing..." );
	QPainter p;
	if( !p.begin( printer ) )               // paint on printer
	    return;

	p.setFont( e->font() );
	int yPos	= 0;			// y-position for each line
	QFontMetrics fm = p.fontMetrics();
	QPaintDeviceMetrics metrics( printer ); // need width/height
						// of printer surface
	for( int i = 0 ; i < e->lines() ; i++ ) {
	    if ( Margin + yPos > metrics.height() - Margin ) {
		QString msg( "Printing (page " );
		msg += QString::number( ++pageNo );
		msg += ")...";
		statusBar()->message( msg );
		printer->newPage();		// no more room on this page
		yPos = 0;			// back to top of page
	    }
	    p.drawText( Margin, Margin + yPos,
			metrics.width(), fm.lineSpacing(),
			ExpandTabs | DontClip,
			e->text( i ) );
	    yPos = yPos + fm.lineSpacing();
	}
	p.end();				// send job to printer
	statusBar()->message( "Printing completed", 2000 );
    } else {
	statusBar()->message( "Printing aborted", 2000 );
    }
}

void TextEditor::closeEvent( QCloseEvent* ce )
{
    if ( !e->isModified() ) {
	ce->accept();
	return;
    }

    switch( QMessageBox::information( this, "-SocNetV-",
				      "Do you want to save the changes"
				      " to the text file?",
				      "Yes", "No", "Cancel",
				      0, 1 ) ) {
    case 0:
	save();
	ce->accept();
	break;
    case 1:
	ce->accept();
	break;
    case 2:
    default: // just for sanity
	ce->ignore();
	break;
    }
}


void TextEditor::about()
{
   QMessageBox::about( this, "-SocNetV-",
			"<b>S</b>ocial <b>N</b>etwork <b>V</b>isualiser version 0.43.1"
      "<p>Written by <br>Dimitris B. Kalamaras<br>"
      "<br>email: dimitris.kalamaras@compupress.gr"
      "<p>Last revision: XXII.XII.2005</p>"
      "<p>Fortune cookie:  <br>sic itur ad astra/sic transit gloria mundi?"

    "<p>Note: Large part of this text editor was <br>"
    "adapted from Trolltech's application example."

    "<p>This program is free software; you can redistribute it and/or modify"
    "<br>it under the terms of the GNU General Public License as published by"
    "<br>the Free Software Foundation; either version 2 of the License, or"
    "<br>(at your option) any later version.</p>"

    "<p>This program is distributed in the hope that it will be useful,"
    "<br>but WITHOUT ANY WARRANTY; without even the implied warranty of"
    "<br>MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the"
    "<br>GNU General Public License for more details.</p>"

    "<p>You should have received a copy of the GNU General Public License"
    "<br>along with this program; if not, write to the Free Software"
    "<br>Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA</p>");

}


void TextEditor::aboutQt()
{
    QMessageBox::aboutQt( this, "-SocNetV-" );
}


