/****************************************************************************
 SocNetV: Social Networks Visualiser for Linux
 version: 0.43
 Written in Qt 3.3.3 with KDevelop 3.1.0  
**
** snvtexteditor.h
**
** 
**
** Adapted from the ApplicationWindow example of Qt
**
*****************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TEXTEDITOR_H
#define TEXTEDITOR_H

#include <qmainwindow.h>
#include <qstringlist.h>

class QTextEdit;

class TextEditor: public QMainWindow
{
    Q_OBJECT
public:
  TextEditor(const QString &fileName );
  ~TextEditor();
protected:
    void closeEvent( QCloseEvent* );
private slots:
    void choose();
    void load( const QString &fileName );
    void save();
    void saveAs();
    void print();
    void about();
    void aboutQt();
signals:


private:
    QPrinter *printer;
    QTextEdit *e;
    QString filename;
    QStringList justFileName;
};



#endif
