/***************************************************************************
 SocNetV: Social Networks Visualiser for Linux
 version: 0.43
 Written in Qt 3.3.3 with KDevelop 3.1.0  
 
                         node.h  -  description
                             -------------------
    copyright            : (C) 2005, 2006 by Dimitris B. Kalamaras
    email                : dimitris.kalamaras@compupress.gr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VERTICE_H
#define VERTICE_H


using namespace std;

#include <vector>
#include <algorithm> //for find()
#include <qapplication.h>

//inherited by Graph Class
class Vertice {
public: 	
    	Vertice(int v1) { 
		m_name=v1; 
		edges.clear();
	}

	int name () {return m_name;}
	
	void name (int v1) {m_name=v1; }

	void addEdge (int v2) {
		edges.push_back(v2);
	}

	void removeEdge (int num) {
		vector<int>::iterator it=find(edges.begin(), edges.end(), num);
		if (it==edges.end()) return;	
		edges.erase(it);
	}

	int size() { return edges.size(); }
	
	bool edge(int num){
		vector<int>::iterator it=find(edges.begin(), edges.end(), num);
		qDebug ("? %i is linked with %i", m_name, num);
//		for (vector<int>::iterator it=edges.begin(); it!=edges.end(); it++)
			if (it!=edges.end()) return true; 
		else return false;
	}
	~Vertice() {
		edges.clear();}

protected: 	

private:	
	int m_name;
	vector<int> edges;	//Holds each actor's edges with other actors.
};

#endif
