//@line 2 "/builds/songbird/release/branch/sb_branch_fdr_release/trunk/app/preferences/songbird-prefs.js.in"
// Songbird Default Prefs.

// DON'T CHANGE THIS.  This is not "bones".
pref("toolkit.defaultChromeURI", "chrome://songbird/content/xul/songbird.xul");
pref("toolkit.defaultChromeFeatures", "chrome,modal=no,toolbar=no,popup=no,titlebar=no");

// This is only used by the MAC version
pref("browser.chromeURL", "chrome://songbird/content/xul/macCmdLineFwd.xul");

// Prevent xulrunner from launching multiple instances of Songbird.
pref("toolkit.singletonWindowType", "Songbird:Main");

pref("general.useragent.extra.songbird", "Songbird/0.5 (20080325223632)");

pref("general.skins.selectedSkin", "rubberducky/0.2");

// Dump the current ram footprint when minimized.
pref("config.trim_on_minimize", true);

// Scan for some extra plugins.
pref("plugin.scan.SunJRE", "1.3");
pref("plugin.scan.Acrobat", "5.0");
pref("plugin.scan.Quicktime", "5.0");
pref("plugin.scan.WindowsMediaPlayer", "7.0");

// Password Manager
pref("signon.rememberSignons", true);
pref("signon.expireMasterPassword", false);
pref("signon.SignonFileName", "signons.txt");

pref("browser.shell.checkDefaultBrowser", false);

pref("browser.formfill.enable", true);

pref("browser.search.update", false);
pref("browser.search.update.log", false);
pref("browser.search.updateinterval", 6);

pref("browser.sessionhistory.max_total_viewers", 0);
pref("browser.sessionhistory.max_entries", 50);

pref("browser.xul.error_pages.enabled", true);

// Download manager prefs
pref("browser.download.useDownloadDir", true);
     // 0-desktop  1-download  2-pref("browser.download.dir")
pref("browser.download.folderList", 0);
pref("browser.download.manager.showAlertOnComplete", false);
pref("browser.download.manager.showAlertInterval", 2000);
     // when downloads are removed from list 0-completion 1-shutdown 2-never
pref("browser.download.manager.retention", 3);
     // these two control whether the manager shows up, both must be true
pref("browser.download.manager.showWhenStarting", true);
pref("browser.download.manager.useWindow", true);
     // duh
pref("browser.download.manager.closeWhenDone", false);
     // how long to wait before showing dm
pref("browser.download.manager.openDelay", 0);
pref("browser.download.manager.focusWhenStarting", false);
     // flashes this many times when opened - in theory
pref("browser.download.manager.flashCount", 2);
pref("browser.download.manager.displayedHistoryDays", 7);
pref("browser.download.manager.addToRecentDocs", true);
//pref("privacy.item.downloads",  true);
pref("browser.download.show_plugins_in_list", true);
pref("browser.download.hide_plugins_without_extensions", true);

// Default to always downloading without prompting.
pref("songbird.download.music.alwaysPrompt", false);

pref("browser.link.open_external", 3);
pref("browser.link.open_newwindow", 3);
pref("browser.link.open_newwindow.restriction", 0);
//pref("browser.tabs.loadInBackground", true);
pref('browser.tabs.enabled', true);
pref("browser.tabs.loadDivertedInBackground", false);

//
// Advanced DOM JavaScript preferences
//
pref("dom.disable_window_move_resize", true);
pref("dom.disable_window_flip", true);
pref("dom.event.contextualmenu.enabled", false);
pref("dom.disable_window_open_feature.status", true);
pref("dom.disable_window_status_change", true);

// Default columns for the web playlist
pref("songbird.webplaylist.columnspec",  "http://songbirdnest.com/data/1.0#ordinal 28 a http://songbirdnest.com/data/1.0#trackName 300 http://songbirdnest.com/data/1.0#duration 38 http://songbirdnest.com/data/1.0#artistName 169 http://songbirdnest.com/data/1.0#albumName 159 http://songbirdnest.com/data/1.0#downloadButton 83");

// Dynamic Skin Switching
pref("extensions.dss.enabled", false);

// Non-dynamic switch pending after next restart
pref("extensions.dss.switchPending", false);

pref("general.autoScroll", false);
pref("general.smoothScroll", false);

// this will automatically enable inline spellchecking (if it is available) for
// editable elements in HTML
// 0 = spellcheck nothing
// 1 = check multi-line controls [default]
// 2 = check multi/single line controls
pref("layout.spellcheckDefault", 1);

pref("network.protocol-handler.external.mailto", true);
pref("network.protocol-handler.external.news", true);
pref("network.protocol-handler.external.snews", true);
pref("network.protocol-handler.external.nntp", true);

// Don't warn when opening external http urls
// This is to allow for launching _blank targeted links in the default browser
pref("network.protocol-handler.warn-external.http", false);
pref("network.protocol-handler.warn-external.https", false);

pref("network.proxy.share_proxy_settings",  false);

pref("plugin.default_plugin_disabled", true);
pref("security.warn_entering_secure.show_once", true);
pref("security.warn_leaving_secure.show_once", true);


// Prefer a window size that can handle 1024px-ish websites
// If this pref turns out to be bigger than the screen
// the window size will fall back to that specified by css
pref("songbird.window.frame_outer.w", "1157");
pref("songbird.window.frame_outer.h", "718");

// Whether or not app updates are enabled
pref("app.update.enabled", true);

// This preference turns on app.update.mode and allows automatic download and
// install to take place. We use a separate boolean toggle for this to make
// the UI easier to construct.
pref("app.update.auto", true);

// Defines how the Application Update Service notifies the user about updates:
//
// AUM Set to:        Minor Releases:     Major Releases:
// 0                  download no prompt  download no prompt
// 1                  download no prompt  download no prompt if no incompatibilities
// 2                  download no prompt  prompt
//
// See chart in nsUpdateService.js.in for more details
//
pref("app.update.mode", 1);

// If set to true, the Update Service will present no UI for any event.
pref("app.update.silent", false);

// Update service URL:
// XXXben Hardcoded 'en-US'. See bug 994.
// XXXaus Hardcoded 'Songbird' to ensure auto update support. See bug 4344.
pref("app.update.url", "https://updates.songbirdnest.com/update/1/Songbird/%VERSION%/%BUILD_ID%/%BUILD_TARGET%/en-US/%CHANNEL%/update.xml");

// URL user can browse to manually if for some reason all update installation
// attempts fail.  TODO: Change this URL
pref("app.update.url.manual", "http://www.songbirdnest.com");

// A default value for the "More information about this update" link
// supplied in the "An update is available" page of the update wizard.
pref("app.update.url.details", "http://www.songbirdnest.com");

// User-settable override to app.update.url for testing purposes.
//pref("app.update.url.override", "");

// Interval: Time between checks for a new version (in seconds)
//           default=1 day
pref("app.update.interval", 86400);

// Interval: Time before prompting the user to download a new version that
//           is available (in seconds) default=1 day
pref("app.update.nagTimer.download", 86400);

// Interval: Time before prompting the user to restart to install the latest
//           download (in seconds) default=30 minutes
pref("app.update.nagTimer.restart", 1800);

// Interval: When all registered timers should be checked (in milliseconds)
//           default=5 seconds
pref("app.update.timer", 600000);

// Whether or not we show a dialog box informing the user that the update was
// successfully applied. This is off in Firefox by default since we show a
// upgrade start page instead! Other apps may wish to show this UI, and supply
// a whatsNewURL field in their brand.properties that contains a link to a page
// which tells users what's new in this new update.
pref("app.update.showInstalledUI", false);

// 0 = suppress prompting for incompatibilities if there are updates available
//     to newer versions of installed addons that resolve them.
// 1 = suppress prompting for incompatibilities only if there are VersionInfo
//     updates available to installed addons that resolve them, not newer
//     versions.
pref("app.update.incompatible.mode", 0);

// Symmetric (can be overridden by individual extensions) update preferences.
// e.g.
//  extensions.{GUID}.update.enabled
//  extensions.{GUID}.update.url
//  extensions.{GUID}.update.interval
//  .. etc ..
//
pref("extensions.update.enabled", true);
pref("extensions.update.url", "chrome://branding/locale/brand.properties");
pref("extensions.update.interval", 86400);  // Check for updates to Extensions and
                                            // Feathers every day
// Non-symmetric (not shared by extensions) extension-specific [update] preferences
pref("extensions.getMoreExtensionsURL", "chrome://branding/locale/brand.properties");
pref("extensions.getMoreThemesURL", "chrome://branding/locale/brand.properties");

pref("extensions.blocklist.enabled", true);
pref("extensions.blocklist.interval", 86400);
pref("extensions.blocklist.url", "https://addons.songbirdnest.com/blocklist/1/%APP_ID%/%APP_VERSION%/");
pref("extensions.blocklist.detailsURL", "https://addons.songbirdnest.com/blocklist/");
pref("extensions.ignoreMTimeChanges", false);

pref("xpinstall.whitelist.add", "addons.songbirdnest.com");
pref("xpinstall.whitelist.add.103", "addons.songbirdnest.com");
//@line 131 "/builds/songbird/release/branch/sb_branch_fdr_release/trunk/app/preferences/songbird-prefs.js.in"

//@line 135 "/builds/songbird/release/branch/sb_branch_fdr_release/trunk/app/preferences/songbird-prefs.js.in"

//@line 139 "/builds/songbird/release/branch/sb_branch_fdr_release/trunk/app/preferences/songbird-prefs.js.in"
pref("browser.preferences.instantApply", true);
//@line 141 "/builds/songbird/release/branch/sb_branch_fdr_release/trunk/app/preferences/songbird-prefs.js.in"

//@line 145 "/builds/songbird/release/branch/sb_branch_fdr_release/trunk/app/preferences/songbird-prefs.js.in"
pref("browser.preferences.animateFadeIn", false);
//@line 147 "/builds/songbird/release/branch/sb_branch_fdr_release/trunk/app/preferences/songbird-prefs.js.in"

// Enable the web playlist.
// Extracts A tags and add browser context menu.
// Note that this pref is reset to "1" on every app start.
pref("songbird.webplaylist.enabled", "1");

// for tabbrowsing
pref("browser.chrome.site_icons", true);
pref("browser.chrome.favicons", true);
pref("browser.tabs.loadInBackground", false);
pref("browser.chrome.site_icons", true);
pref("browser.chrome.favicons", true);
pref("browser.chrome.image_icons.max_size", 1024);
pref("browser.tabs.forceHide", false);
pref("browser.tabs.warnOnClose", false);
pref("browser.tabs.autoHide", true);
pref("browser.tabs.selectOwnerOnClose", true);


// Override the window XPInstall opens on extension install
pref("xpinstall.dialog.progress.type.chrome", "Browser:Preferences");
pref("xpinstall.dialog.progress.type.skin", "Browser:Preferences");

pref("xpinstall.dialog.progress.chrome", "chrome://browser/content/preferences/preferences.xul");
pref("xpinstall.dialog.progress.skin", "chrome://browser/content/preferences/preferences.xul");

//
// Search Preferences
//

// Search engines URL
pref("browser.search.searchEnginesURL",      "http://addons.songbirdnest.com/search_engines");

// pointer to the default engine name
pref("browser.search.defaultenginename",      "chrome://branding/locale/brand.properties");

// disable logging for the search service by default
pref("browser.search.log", false);

// Ordering of Search Engines in the Engine list.
pref("browser.search.order.1",                "chrome://branding/locale/brand.properties");
pref("browser.search.order.2",                "chrome://branding/locale/brand.properties");
pref("browser.search.order.3",                "chrome://branding/locale/brand.properties");
pref("browser.search.order.4",                "chrome://branding/locale/brand.properties");
pref("browser.search.order.5",                "chrome://branding/locale/brand.properties");

// search bar results always open in a new tab
pref("browser.search.openintab", false);

// send ping to the server to update
pref("browser.search.update", true);

// disable logging for the search service update system by default
pref("browser.search.update.log", false);

// Check whether we need to perform engine updates every 6 hours
pref("browser.search.updateinterval", 6);

// enable search suggestions by default
pref("browser.search.suggest.enabled", true);


//@line 210 "/builds/songbird/release/branch/sb_branch_fdr_release/trunk/app/preferences/songbird-prefs.js.in"
pref("browser.urlbar.clickSelectsAll", false);
//@line 214 "/builds/songbird/release/branch/sb_branch_fdr_release/trunk/app/preferences/songbird-prefs.js.in"

//
// RemoteAPI prefs
//

// allow access to playback control/read remote api by default
pref("songbird.rapi.playback_control_disable", false);
pref("songbird.rapi.playback_read_disable", false);
pref("songbird.rapi.library_read_disable", true);
pref("songbird.rapi.library_write_disable", true);

// by default notify about everything
pref("songbird.rapi.playback_control_notify", true);
pref("songbird.rapi.playback_read_notify", true);
pref("songbird.rapi.library_read_notify", true);
pref("songbird.rapi.library_write_notify", true);

// Songbird default urls
pref("songbird.url.addons", "http://addons.songbirdnest.com/");
pref("browser.startup.homepage", "http://birdhouse.songbirdnest.com/");
pref("songbird.url.firstrun", "http://birdhouse.songbirdnest.com/firstrun/");
pref("songbird.url.bookmarks", "http://bundles.songbirdnest.com/bookmarks.xml");
pref("songbird.url.bugzilla", "http://bugzilla.songbirdnest.com/");
pref("songbird.url.bundles", "http://bundles.songbirdnest.com/getbundle/");
pref("songbird.url.metrics", "http://metrics.songbirdnest.com/post/");
pref("songbird.url.support", "http://songbirdnest.com/support/");
pref("songbird.url.support.quicktime", "http://publicsvn.songbirdnest.com/trac/wiki/SettingUpQuickTime");
pref("songbird.url.support.corefailure", "http://publicsvn.songbirdest.com/trac/wiki/CoreWrapperFailure");

// The breakpad report server to link to in about:crashes
pref("breakpad.reportURL", "http://crashreports.songbirdnest.com/report/index/");

//
// Media Core prefs
//
//@line 255 "/builds/songbird/release/branch/sb_branch_fdr_release/trunk/app/preferences/songbird-prefs.js.in"

//
// Sanitize prefs
//
pref("privacy.sanitize.promptOnSanitize", true);
pref("privacy.sanitize.sanitizeOnShutdown", false);
pref("privacy.sanitize.didShutdownSanitize", false);
pref("privacy.item.mediaHistory", true);
pref("privacy.item.history", true);
pref("privacy.item.formdata", true);
pref("privacy.item.passwords", true);
pref("privacy.item.downloads", true);
pref("privacy.item.cookies", true);
pref("privacy.item.cache", true);
pref("privacy.item.sessions", true);

// popups.policy 1=allow,2=reject
pref("privacy.popups.policy",               1);
pref("privacy.popups.usecustom",            true);
pref("privacy.popups.firstTime",            true);
pref("privacy.popups.showBrowserMessage",   true);

// Disable drag image for linux, see
// http://bugzilla.songbirdnest.com/show_bug.cgi?id=5537
// https://bugzilla.mozilla.org/show_bug.cgi?id=376238
//@line 282 "/builds/songbird/release/branch/sb_branch_fdr_release/trunk/app/preferences/songbird-prefs.js.in"
pref("nglayout.enable_drag_images", false);
//@line 285 "/builds/songbird/release/branch/sb_branch_fdr_release/trunk/app/preferences/songbird-prefs.js.in"



//
// Places support
//

// import bookmarks.html into Places bookmarks
pref("browser.places.importBookmarksHTML", true);

// if false, will add the "Smart Bookmarks" folder to the personal toolbar
pref("browser.places.createdSmartBookmarks", false);

// the (maximum) number of the recent visits to sample
// when calculating frecency
pref("places.frecency.numVisits", 10);

// Number of records to update frecency for when idle.
pref("places.frecency.numCalcOnIdle", 50);

// Number of records to update frecency for when migrating from
// a pre-frecency build.
pref("places.frecency.numCalcOnMigrate", 50);

// Perform frecency recalculation after this amount of idle, repeating.
// A value of zero disables updating of frecency on idle.
// Default is 1 minute (60000ms).
pref("places.frecency.updateIdleTime", 60000);

// buckets (in days) for frecency calculation
pref("places.frecency.firstBucketCutoff", 4);
pref("places.frecency.secondBucketCutoff", 14);
pref("places.frecency.thirdBucketCutoff", 31);
pref("places.frecency.fourthBucketCutoff", 90);

// weights for buckets for frecency calculations
pref("places.frecency.firstBucketWeight", 100);
pref("places.frecency.secondBucketWeight", 70);
pref("places.frecency.thirdBucketWeight", 50);
pref("places.frecency.fourthBucketWeight", 30);
pref("places.frecency.defaultBucketWeight", 10);

// bonus (in percent) for visit transition types for frecency calculations
pref("places.frecency.embedVisitBonus", 0);
pref("places.frecency.linkVisitBonus", 120);
pref("places.frecency.typedVisitBonus", 200);
pref("places.frecency.bookmarkVisitBonus", 140);
pref("places.frecency.downloadVisitBonus", 0);
pref("places.frecency.permRedirectVisitBonus", 0);
pref("places.frecency.tempRedirectVisitBonus", 0);
pref("places.frecency.defaultVisitBonus", 0);

// bonus (in percent) for place types for frecency calculations
pref("places.frecency.unvisitedBookmarkBonus", 140);
pref("places.frecency.unvisitedTypedBonus", 200);

pref("browser.urlbar.autoFill", false);
pref("browser.urlbar.matchOnlyTyped", false);

// the maximum number of results to show in autocomplete when doing richResults
pref("browser.urlbar.maxRichResults", 25);
// Size of "chunks" affects the number of places to process between each search
// timeout (ms). Too big and the UI will be unresponsive; too small and we'll
// be waiting on the timeout too often without many results.
pref("browser.urlbar.search.chunkSize", 1000);
pref("browser.urlbar.search.timeout", 50);

// use Thunderbird as the default external email app
pref("network.protocol-handler.app.mailto", "/usr/bin/thunderbird");

