/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2004, 2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef SONIK_AUDIO_IO_H
#define SONIK_AUDIO_IO_H

#include <sonik/plugin.h>

#include <sonik/types.h>

class QWidget;

namespace Sonik
{
  class AudioIOManager;

  class AudioIO : public Plugin
  {
    Q_OBJECT
  public:
    typedef QValueVector<uint8_t>  ChannelCaps;
    typedef QValueVector<uint32_t> SampleRateCaps;
    typedef QValueVector<uint8_t>  BitsCaps;

    static const uint8_t  kAnyChannels   = 0xFF;
    static const uint32_t kAnySampleRate = 0xFFFFFFFF;
    static const uint8_t  kAnyBits       = 0xFF;

    AudioIO(const QString& pluginName, const QString& displayName,
            QObject* parent=0, const char* name=0,
            const QStringList& args=QStringList());
    virtual ~AudioIO()                                       = 0;

    virtual const ChannelCaps    channelCaps() const               = 0;
    virtual const SampleRateCaps sampleRateCaps() const            = 0;
    virtual const BitsCaps       bitsCaps() const                  = 0;
    virtual size_t               blockSize() const                 = 0;

    virtual IOResult open(AudioIOManager* manager,
                          uint8_t  channels,
                          uint32_t sampleRate,
                          uint8_t  bits)                     = 0;
    virtual void close()                                     = 0;
    virtual void play()                                      = 0;
    virtual void record()                                    = 0;
    virtual void stop()                                      = 0;

    virtual QWidget* makeOptionsPage(QWidget* parent=0,
                                     const char *name=0)     = 0;

  protected:
    AudioIOManager* mManager;
  };
}

#endif // SONIK_AUDIO_IO_H
